const mongoose = require('mongoose');

// MongoDB connection URI - Using IP for stability
const MONGODB_URI = 'mongodb://titandrillingadminuser:mrdThsSnATwD231hbOPmnhj@168.231.113.219:27017/titan_drilling?authSource=admin';

// Connection options
const connectionOptions = {
  serverSelectionTimeoutMS: 10000,
  maxPoolSize: 10,
  socketTimeoutMS: 45000
};

// Track connection state
let isConnecting = false;
let isConnected = false;

/**
 * Get or create MongoDB connection
 * This ensures we only have ONE connection across all services
 */
const connectDB = async () => {
  // If already connected, return existing connection
  if (isConnected && mongoose.connection.readyState === 1) {
    console.log('✅ Using existing MongoDB connection');
    return mongoose.connection;
  }

  // If currently connecting, wait for it
  if (isConnecting) {
    console.log('⏳ Waiting for existing MongoDB connection...');
    while (isConnecting) {
      await new Promise(resolve => setTimeout(resolve, 100));
    }
    return mongoose.connection;
  }

  // Start new connection
  try {
    isConnecting = true;
    console.log('🔌 Connecting to MongoDB...');
    
    await mongoose.connect(MONGODB_URI, connectionOptions);
    
    isConnected = true;
    isConnecting = false;
    
    console.log('✅ MongoDB connected successfully!');
    console.log('📊 Database: titan_drilling');
    console.log('🔗 Host: api.titandrillingzm.com:27017');
    
    return mongoose.connection;
    
  } catch (err) {
    isConnecting = false;
    isConnected = false;
    console.error('❌ MongoDB connection error:', err.message);
    throw err;
  }
};

// Handle connection events
mongoose.connection.on('connected', () => {
  console.log('✅ Mongoose connected to MongoDB');
  isConnected = true;
});

mongoose.connection.on('error', (err) => {
  console.error('❌ Mongoose connection error:', err);
  isConnected = false;
});

mongoose.connection.on('disconnected', () => {
  console.log('⚠️ Mongoose disconnected from MongoDB');
  isConnected = false;
});

// Graceful shutdown
process.on('SIGINT', async () => {
  try {
    await mongoose.connection.close();
    console.log('✅ MongoDB connection closed through app termination');
    process.exit(0);
  } catch (err) {
    console.error('❌ Error closing MongoDB connection:', err);
    process.exit(1);
  }
});

// Export the connection function and mongoose instance
module.exports = {
  connectDB,
  mongoose
};

