import React, { useState, useEffect } from 'react';
import {
  View,
  Text,
  StyleSheet,
  StatusBar,
  ScrollView,
  TouchableOpacity,
  Dimensions,
} from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
import { useNavigation, useRoute, useFocusEffect } from '@react-navigation/native';
import AsyncStorage from '@react-native-async-storage/async-storage';

// Import step components for HSE-043, HSE-044, HSE-045, HSE-126
import Hsemodule43step1 from './Hsemodule43step1';
import Hsemodule43step2 from './Hsemodule43step2';
import Hsemodule43step3 from './Hsemodule43step3';

// Import step components for HSE-041, HSE-042
import HSE41_42_step2 from './HSE41_42/HSE41_42_step2';
import HSE41_42_step3 from './HSE41_42/HSE41_42_step3';

// Import step components for HSE-101, HSE-024
import HSE101_024Step2 from './HSE101_024/HSE101_024Step2';
import HSE101_024Step3 from './HSE101_024/HSE101_024Step3';

// Import step components for HSE-020
import HSE_020Step2 from './HSE_020/HSE_020Step2';
import HSE_020Step3 from './HSE_020/HSE_020Step3';

// Import step components for HSE-071
import HSE_071step2 from './HSE_071/HSE_071step2';
import HSE_071step3 from './HSE_071/HSE_071step3';

// Import step components for HSE-156
import HSE_156Step2 from './HSE_156/HSE_156Step2';
import HSE_156Step3 from './HSE_156/HSE_156Step3';

// Import step components for HSE-077_078
import HSE_077_078Step2 from './HSE_077_078/HSE_077_078Step2';
import HSE_077_078Step3 from './HSE_077_078/HSE_077_078Step3';

// Import step components for HSE-129
import HSE_129_Step2 from './HSE_129/HSE_129_Step2';
import HSE_129_Step3 from './HSE_129/HSE_129_Step3';

// Import step components for HSE-072
import HSE_072step2 from './HSE_072/HSE_072step2';
import HSE_072step3 from './HSE_072/HSE_072step3';

// Import step components for HSE-131
import HSE_131Step2 from './HSE_131/HSE_131Step2';
import HSE_131Step3 from './HSE_131/HSE_131Step3';
// Also support direct HSE-034 selection
import HSE_034Step2_direct from './HSE_034/HSE_034Step2';
import HSE_034Step3_direct from './HSE_034/HSE_034Step3';
// Import HSE-158 components
import HSE_158Step2 from './HSE_158/HSE_158Step2';
import HSE_158Step3 from './HSE_158/HSE_158Step3';

// Import HSE-051 components
import HSE_051step2 from './HSE_051/HSE_051step2';
import HSE_051step3 from './HSE_051/HSE_051step3';

// Import HSE-122 components
import HSE_122Step2 from './HSE_122/HSE_122Step2';
import HSE_122Step3 from './HSE_122/HSE_122Step3';

// Import HSE-123 components
import HSE_123Step2 from './HSE_123/HSE_123Step2';
import HSE_123Step3 from './HSE_123/HSE_123Step3';

// Import HSE-124 components
import HSE_124Step2 from './HSE_124/HSE_124Step2';
import HSE_124Step3 from './HSE_124/HSE_124Step3';

// Import HSE-125 components
import HSE_125Step2 from './HSE_125/HSE_125Step2';
import HSE_125Step3 from './HSE_125/HSE_125Step3';

// Import HSE-132 components
import HSE_132Step2 from './HSE_132/HSE_132_step2';
import HSE_132Step3 from './HSE_132/HSE_132_step3';

// Import HSE-155 components
import HSE_155_Step2 from './HSE_155/HSE_155_Step2';
import HSE_155_Step3 from './HSE_155/HSE_155_Step3';
import HSE_077_Step2 from './HSE_077/HSE_077_step2';
import HSE_077_Step3 from './HSE_077/HSE_077_step3';
// Import HSE-085 components
import HSE_085_step2 from './HSE-085/HSE_085_step2';
import HSE_085_step3 from './HSE-085/HSE_085_step3';

const { height } = Dimensions.get('window');
// Reduce header height to avoid excess top padding on small devices
const TOTAL_HEADER_HEIGHT = Math.max(100, height * 0.14);

const Hsemoduleheader43 = () => {
  const navigation = useNavigation();
  const route = useRoute();
  const [activeStep, setActiveStep] = useState(1);
  const [selectedChecklist, setSelectedChecklist] = useState(null);
  const [steps, setSteps] = useState([]);

  useEffect(() => {
    // Get selected checklist from route params or AsyncStorage
    const getSelectedChecklist = async () => {
      try {
        const savedData = await AsyncStorage.getItem('hseStep1');
        if (savedData) {
          const data = JSON.parse(savedData);
          if (data.selectedChecklist) {
            setSelectedChecklist(data.selectedChecklist);
            setupSteps(data.selectedChecklist);
          } else {
            // If no checklist data, set up default steps
            setupDefaultSteps();
          }
        } else {
          // If no saved data at all, set up default steps
          setupDefaultSteps();
        }
      } catch (error) {
        console.error('Error loading selected checklist:', error);
        // If error occurs, set up default steps
        setupDefaultSteps();
      }
    };

    getSelectedChecklist();
  }, []);

  const setupDefaultSteps = () => {
    console.log('Setting up default steps'); // Debug log
    // Default steps for HSE-043, HSE-044, HSE-045, HSE-126
    const stepsArray = [
      {
        id: 1,
        title: 'Step 1',
        subtitle: 'HSE Information',
        component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
      },
      {
        id: 2,
        title: 'Step 2',
        subtitle: 'HSE Assessment',
        component: <Hsemodule43step2 setActiveStep={setActiveStep} />,
      },
      {
        id: 3,
        title: 'Step 3',
        subtitle: 'HSE Review',
        component: (
          <View style={{ flex: 1, justifyContent: 'center', alignItems: 'center', backgroundColor: '#fff' }}>
            <Text style={{ fontSize: 20, color: '#015185' }}>Step 3 - HSE Review</Text>
            <Text style={{ fontSize: 16, color: '#666', marginTop: 10 }}>Loading review component...</Text>
            <Hsemodule43step3 setActiveStep={setActiveStep} />
          </View>
        ),
      },
    ];
    console.log('Setting default steps:', stepsArray);
    console.log('Step 3 component type:', typeof Hsemodule43step3);
    setSteps(stepsArray);
  };

  // Reload data when screen is focused
  useFocusEffect(
    React.useCallback(() => {
      const reloadData = async () => {
        try {
          const savedData = await AsyncStorage.getItem('hseStep1');
          if (savedData) {
            const data = JSON.parse(savedData);
            if (data.selectedChecklist) {
              setSelectedChecklist(data.selectedChecklist);
              setupSteps(data.selectedChecklist);
            } else {
              setupDefaultSteps();
            }
          } else {
            setupDefaultSteps();
          }
        } catch (error) {
          console.error('Error reloading data:', error);
          setupDefaultSteps();
        }
      };
      reloadData();
    }, [])
  );

  const setupSteps = (checklist) => {
    console.log('=== SETUP STEPS CALLED ===');
    console.log('Checklist parameter:', checklist);
    console.log('Checklist type:', typeof checklist);
    
    if (!checklist) {
      console.log('No checklist provided, using default steps');
      setupDefaultSteps();
      return;
    }
    
    const documentId = checklist?.document_id;
    console.log('Document ID:', documentId);
    console.log('Document ID type:', typeof documentId);
    console.log('Document ID === "HSE-077":', documentId === 'HSE-077');
    console.log('Document ID === "HSE-078":', documentId === 'HSE-078');
    
    if (documentId === 'HSE-041' || documentId === 'HSE-042') {
      console.log('Using HSE41_42 components for document ID:', documentId); // Debug log
      // For HSE-041 and HSE-042, use 3 steps with specific components
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'HSE Assessment',
          component: <HSE41_42_step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'HSE Review',
          component: <HSE41_42_step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('Setting HSE41_42 steps:', stepsArray);
      setSteps(stepsArray);
    } else if (documentId === 'HSE-101' || documentId === 'HSE-024') {
      console.log('Using HSE101_024 components for document ID:', documentId); // Debug log
      // For HSE-101 and HSE-024, use 3 steps with specific components
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Visitor Induction',
          component: <HSE101_024Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Final Summary',
          component: <HSE101_024Step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('Setting HSE101_024 steps:', stepsArray);
      setSteps(stepsArray);
    } else if (documentId === 'HSE-020') {
      console.log('Using HSE_020 components for document ID:', documentId); // Debug log
      // For HSE-020, use 3 steps with specific components
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Task Observation Details',
          component: <HSE_020Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_020Step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('Setting HSE_020 steps:', stepsArray);
      setSteps(stepsArray);
    } else if (documentId === 'HSE-071') {
      console.log('Using HSE_071 components for document ID:', documentId); // Debug log
      // For HSE-071, use 3 steps with specific components
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'DD Supervisor Shift Report',
          component: <HSE_071step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_071step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('Setting HSE_071 steps:', stepsArray);
      setSteps(stepsArray);
    } else if (documentId === 'HSE-156') {
      console.log('Using HSE_156 components for document ID:', documentId); // Debug log
      // For HSE-156, use 3 steps with specific components
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Safety Harness Inspection',
          component: <HSE_156Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_156Step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('Setting HSE_156 steps:', stepsArray);
      setSteps(stepsArray);
    // REMOVED: Conflicting routing condition that was interfering with HSE-077
    } else if (documentId === 'HSE-129') {
      console.log('Using HSE_129 components for document ID:', documentId); // Debug log
      // For HSE-129, use 3 steps with specific components
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Drill Instruction Details',
          component: <HSE_129_Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_129_Step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('Setting HSE_129 steps:', stepsArray);
      setSteps(stepsArray);
    } else if (documentId === 'HSE-072') {
      console.log('Using HSE_072 components for document ID:', documentId); // Debug log
      // For HSE-072, use 3 steps with specific components
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'RC Supervisor Shift Report',
          component: <HSE_072step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_072step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('Setting HSE_072 steps:', stepsArray);
      setSteps(stepsArray);
    } else if (documentId === 'HSE-131') {
      console.log('Using HSE_131 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Step 2',
          component: <HSE_131Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Step 3',
          component: <HSE_131Step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-034') {
      console.log('Using HSE_034 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Management of Change',
          component: <HSE_034Step2_direct setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_034Step3_direct setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-158') {
      console.log('Using HSE_158 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: "Supervisor's Fatigue Observation",
          component: <HSE_158Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_158Step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-051') {
      console.log('Using HSE_051 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'JHA Worksheet',
          component: <HSE_051step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_051step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-122') {
      console.log('Using HSE_122 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Step 2',
          component: <HSE_122Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Step 3',
          component: <HSE_122Step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-123') {
      console.log('Using HSE_123 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Workshop Truck Check Sheet',
          component: <HSE_123Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_123Step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-124') {
      console.log('Using HSE_124 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Step 2',
          component: <HSE_124Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Step 3',
          component: <HSE_124Step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-125') {
      console.log('Using HSE_125 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Step 2',
          component: <HSE_125Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Step 3',
          component: <HSE_125Step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-132') {
      console.log('Using HSE_132 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Environmental Rehabilitation Checklist',
          component: <HSE_132Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_132Step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-155') {
      console.log('Using HSE_155 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Workshop Vehicle Pre-Release',
          component: <HSE_155_Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_155_Step3 setActiveStep={setActiveStep} />,
        },
      ];
      setSteps(stepsArray);
    } else if (documentId === 'HSE-077') {
      console.log('=== HSE-077 ROUTING ACTIVATED ===');
      console.log('Using HSE_077 components for document ID:', documentId);
      console.log('HSE_077_Step2 component:', HSE_077_Step2);
      console.log('HSE_077_Step3 component:', HSE_077_Step3);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Lifting Equipment Inspection',
          component: (() => {
            console.log('=== RENDERING HSE_077_Step2 COMPONENT ===');
            console.log('Component type:', typeof HSE_077_Step2);
            console.log('Component name:', HSE_077_Step2.name || 'Anonymous');
            return <HSE_077_Step2 setActiveStep={setActiveStep} />;
          })(),
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_077_Step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('HSE-077 steps array created:', stepsArray);
      setSteps(stepsArray);
    } else if (documentId === 'HSE-078') {
      console.log('=== HSE-078 ROUTING ACTIVATED ===');
      console.log('Using HSE_077_078 components for document ID:', documentId);
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'Near Miss & Hazard Identification',
          component: <HSE_077_078Step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'Review & Submit',
          component: <HSE_077_078Step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('HSE-078 steps array created:', stepsArray);
      setSteps(stepsArray);
    } else if (documentId === 'HSE-085') {
      console.log('Using HSE_085 components for document ID:', documentId);
      const stepsArray = [
        { id: 1, title: 'Step 1', subtitle: 'HSE Information', component: <Hsemodule43step1 setActiveStep={setActiveStep} /> },
        { id: 2, title: 'Step 2', subtitle: 'Lift Plan Details', component: <HSE_085_step2 setActiveStep={setActiveStep} /> },
        { id: 3, title: 'Step 3', subtitle: 'Review & Submit', component: <HSE_085_step3 setActiveStep={setActiveStep} /> },
      ];
      setSteps(stepsArray);
    } else {
      console.log('=== FALLBACK ROUTING ===');
      console.log('Using standard HSE components for document ID:', documentId); // Debug log
      // For HSE-043, HSE-044, HSE-045, HSE-126, use 3 steps with standard components
      const stepsArray = [
        {
          id: 1,
          title: 'Step 1',
          subtitle: 'HSE Information',
          component: <Hsemodule43step1 setActiveStep={setActiveStep} />,
        },
        {
          id: 2,
          title: 'Step 2',
          subtitle: 'HSE Assessment',
          component: <Hsemodule43step2 setActiveStep={setActiveStep} />,
        },
        {
          id: 3,
          title: 'Step 3',
          subtitle: 'HSE Review',
          component: <Hsemodule43step3 setActiveStep={setActiveStep} />,
        },
      ];
      console.log('Setting standard HSE steps:', stepsArray);
      setSteps(stepsArray);
    }
  };

  // Handle checklist selection from navigation
  useEffect(() => {
    if (route.params?.selectedChecklist) {
      console.log('Received selected checklist from navigation:', route.params.selectedChecklist.document_id); // Debug log
      setSelectedChecklist(route.params.selectedChecklist);
      setupSteps(route.params.selectedChecklist);
      
      // Also save to AsyncStorage to ensure persistence
      const saveChecklistData = async () => {
        try {
          const savedHse = await AsyncStorage.getItem('hseStep1');
          let hseData = savedHse ? JSON.parse(savedHse) : {};
          hseData.selectedChecklist = route.params.selectedChecklist;
          await AsyncStorage.setItem('hseStep1', JSON.stringify(hseData));
        } catch (error) {
          console.error('Error saving checklist data:', error);
        }
      };
      
      saveChecklistData();
    }
  }, [route.params?.selectedChecklist]);

  // Monitor activeStep changes and ensure correct components are loaded
  useEffect(() => {
    console.log('Active step changed to:', activeStep);
    console.log('Selected checklist:', selectedChecklist?.document_id);
    console.log('Steps length:', steps.length);
    
    if (selectedChecklist && steps.length > 0) {
      console.log('Current steps configuration:', steps.map(s => ({ id: s.id, title: s.title })));
      console.log('Active step component:', steps.find((step) => step.id === activeStep)?.component ? 'Found' : 'Not found');
    } else if (activeStep > 1 && steps.length === 0) {
      console.log('No steps available but activeStep > 1, setting up default steps');
      setupDefaultSteps();
    }
  }, [activeStep, selectedChecklist, steps]);

  // Function to handle step changes
  const handleStepChange = async (stepId) => {
    console.log('Changing to step:', stepId, 'for document ID:', selectedChecklist?.document_id); // Debug log
    
    // If moving to step 2, reload the checklist data to ensure we have the latest
    if (stepId === 2) {
      try {
        const savedData = await AsyncStorage.getItem('hseStep1');
        if (savedData) {
          const data = JSON.parse(savedData);
          if (data.selectedChecklist && data.selectedChecklist.document_id !== selectedChecklist?.document_id) {
            console.log('Updating checklist data for step 2:', data.selectedChecklist.document_id);
            setSelectedChecklist(data.selectedChecklist);
            setupSteps(data.selectedChecklist);
          }
        }
      } catch (error) {
        console.error('Error reloading checklist data:', error);
      }
    }
    
    setActiveStep(stepId);
  };

  console.log('Rendering header with steps length:', steps.length, 'activeStep:', activeStep);

  return (
    <View style={styles.container}>
      <LinearGradient
        colors={['#3481BC', '#025383']}
        style={[styles.header, { height: TOTAL_HEADER_HEIGHT }]}
      >
        <StatusBar translucent backgroundColor="transparent" barStyle="light-content" />
        
        <ScrollView
          horizontal
          showsHorizontalScrollIndicator={false}
          contentContainerStyle={styles.stepsScrollContent}
        >
          {steps.map((step, index) => {
            const isActive = activeStep === step.id;
            const isCompleted = activeStep > step.id;
            const isClickable = step.id === 1 || step.id < activeStep; // Allow going back to previous steps
            return (
              <TouchableOpacity
                key={step.id}
                style={styles.stepWrapper}
                onPress={() => isClickable && handleStepChange(step.id)}
                disabled={!isClickable}
              >
                <View
                  style={[
                    styles.stepCircle,
                    isActive && styles.activeStepCircle,
                    isCompleted && styles.completedStepCircle,
                  ]}
                >
                  {isCompleted ? (
                    <MaterialIcons name="check" size={20} color="#fff" />
                  ) : (
                    <Text style={[styles.stepNumber, isActive && styles.activeStepNumber]}>
                      {step.id}
                    </Text>
                  )}
                </View>
                <View style={styles.stepTextContainer}>
                  <Text style={[styles.stepTitle, isActive && styles.activeStepTitle]}>
                    {step.title}
                  </Text>
                  <Text style={[styles.stepSubtitle, isActive && styles.activeStepSubtitle]}>
                    {step.subtitle}
                  </Text>
                </View>
                {index < steps.length - 1 && (
                  <View
                    style={[styles.stepConnector, isCompleted && styles.completedStepConnector]}
                  />
                )}
              </TouchableOpacity>
            );
          })}
        </ScrollView>
      </LinearGradient>
      <View style={styles.mainContent}>
        {steps.length > 0 ? (
          (() => {
            const currentStep = steps.find((step) => step.id === activeStep);
            console.log('Current step found:', currentStep ? `Step ${currentStep.id}` : 'Not found');
            console.log('Active step:', activeStep);
            console.log('Available steps:', steps.map(s => s.id));
            
            if (currentStep && currentStep.component) {
              try {
                console.log('Rendering step component:', currentStep.id);
                return currentStep.component;
              } catch (error) {
                console.error('Error rendering step component:', error);
                return (
                  <View style={styles.fallbackContainer}>
                    <Text style={styles.fallbackText}>Error loading step {activeStep}</Text>
                    <Text style={styles.debugText}>Error: {error.message}</Text>
                  </View>
                );
              }
            } else {
              console.log('Step component not found, showing fallback');
              return (
                <View style={styles.fallbackContainer}>
                  <Text style={styles.fallbackText}>Loading step {activeStep} component...</Text>
                  <Text style={styles.debugText}>Available steps: {steps.map(s => s.id).join(', ')}</Text>
                </View>
              );
            }
          })()
        ) : (
          <View style={styles.fallbackContainer}>
            <Text style={styles.fallbackText}>Loading checklist data...</Text>
          </View>
        )}
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#fff',
  },
  header: {
    width: '100%',
    paddingBottom: 6,
    paddingTop: 6,
    top:-8
  },
  stepsScrollContent: {
    paddingHorizontal: 20,
    alignItems: 'center',
  },
  stepWrapper: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingHorizontal: 5,
  },
  stepCircle: {
    width: 30,
    height: 30,
    borderRadius: 15,
    backgroundColor: '#eee',
    justifyContent: 'center',
    alignItems: 'center',
    borderWidth: 2,
    borderColor: '#ccc',
  },
  activeStepCircle: {
    borderColor: '#fff',
    backgroundColor: '#fff',
  },
  completedStepCircle: {
    backgroundColor: '#4CAF50',
    borderColor: '#4CAF50',
  },
  stepNumber: {
    color: '#888',
    fontWeight: 'bold',
  },
  activeStepNumber: {
    color: '#025383',
  },
  stepTextContainer: {
    marginHorizontal: 10,
  },
  stepTitle: {
    fontSize: 14,
    color: '#ccc',
    fontWeight: 'bold',
  },
  activeStepTitle: {
    color: '#fff',
  },
  stepSubtitle: {
    fontSize: 12,
    color: '#ccc',
  },
  activeStepSubtitle: {
    color: '#fff',
  },
  stepConnector: {
    width: 30,
    height: 2,
    backgroundColor: '#ccc',
  },
  completedStepConnector: {
    backgroundColor: '#4CAF50',
  },
  mainContent: {
    flex: 1,
  },
  fallbackContainer: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#f0f0f0', // A light background for the fallback
  },
  fallbackText: {
    fontSize: 18,
    color: '#333',
    fontStyle: 'italic',
  },
});

export default Hsemoduleheader43;