<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Firebase configuration - Updated with your actual Firebase config
$firebaseConfig = [
    'apiKey' => 'AIzaSyBUk_ddoTBctL3gcniqiEer0rRVEzTjVx0',
    'databaseURL' => 'https://titan-drilling-1f8e9-default-rtdb.firebaseio.com',
    'projectId' => 'titan-drilling-1f8e9',
    'projectNumber' => '749788854975'
];

// FCM Server Key - You need to replace this with your actual FCM Server Key
// Go to: Google Cloud Console > APIs & Services > Credentials
// OR Firebase Console > Project Settings > Cloud Messaging
$fcmServerKey = 'YOUR_FCM_SERVER_KEY'; // ← Replace with your actual FCM Server Key (starts with AAAA...)

// Check if FCM Server Key is configured
if ($fcmServerKey === 'YOUR_FCM_SERVER_KEY') {
    // If this is a POST request, return error
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'FCM Server Key not configured. Please update the PHP file with your FCM Server Key.',
            'error' => true,
            'instructions' => [
                '1. Go to Google Cloud Console: https://console.cloud.google.com/',
                '2. Select project: titan-drilling-1f8e9',
                '3. Go to APIs & Services > Credentials',
                '4. Look for API Keys or enable Cloud Messaging API',
                '5. Replace YOUR_FCM_SERVER_KEY with the actual key'
            ]
        ]);
        exit();
    }
}

// Function to get all FCM tokens from Firebase
function getAllFCMTokens($firebaseConfig) {
    $url = $firebaseConfig['databaseURL'] . '/Globalusers/admins.json';
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200 && $response) {
        $data = json_decode($response, true);
        $tokens = [];
        
        if ($data) {
            foreach ($data as $userId => $userData) {
                if (isset($userData['NotificationFCMtoken']) && !empty($userData['NotificationFCMtoken'])) {
                    $tokens[] = [
                        'token' => $userData['NotificationFCMtoken'],
                        'userId' => $userId,
                        'lastUpdate' => $userData['lastTokenUpdate'] ?? 'Unknown'
                    ];
                }
            }
        }
        
        return $tokens;
    }
    
    return [];
}

// Function to send FCM notification
function sendFCMNotification($tokens, $title, $body, $fcmServerKey) {
    $url = 'https://fcm.googleapis.com/fcm/send';
    
    $successCount = 0;
    $failureCount = 0;
    $results = [];
    
    // Send to each token individually for better error handling
    foreach ($tokens as $tokenData) {
        $token = $tokenData['token'];
        
        $data = [
            'to' => $token,
            'notification' => [
                'title' => $title,
                'body' => $body,
                'sound' => 'default',
                'badge' => '1',
                'click_action' => 'FLUTTER_NOTIFICATION_CLICK'
            ],
            'data' => [
                'title' => $title,
                'body' => $body,
                'timestamp' => date('Y-m-d H:i:s'),
                'type' => 'dynamic_notification'
            ],
            'priority' => 'high',
            'android' => [
                'priority' => 'high',
                'notification' => [
                    'channel_id' => 'default',
                    'priority' => 'high',
                    'default_sound' => true,
                    'default_vibrate_timings' => true
                ]
            ],
            'apns' => [
                'headers' => [
                    'apns-priority' => '10'
                ],
                'payload' => [
                    'aps' => [
                        'sound' => 'default',
                        'badge' => 1
                    ]
                ]
            ]
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: key=' . $fcmServerKey,
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        $result = json_decode($response, true);
        
        if ($httpCode === 200 && $result && isset($result['success']) && $result['success'] == 1) {
            $successCount++;
            $results[] = [
                'token' => substr($token, 0, 20) . '...',
                'userId' => $tokenData['userId'],
                'status' => 'success'
            ];
        } else {
            $failureCount++;
            $errorMsg = 'Unknown error';
            $fullResponse = $result;
            
            if ($result && isset($result['results'][0]['error'])) {
                $errorMsg = $result['results'][0]['error'];
            } else if ($result && isset($result['error'])) {
                $errorMsg = $result['error'];
            } else if ($result && isset($result['failure_reason'])) {
                $errorMsg = $result['failure_reason'];
            }
            
            // Log the full response for debugging
            error_log("FCM Error for token " . substr($token, 0, 20) . "...: " . json_encode($result));
            
            $results[] = [
                'token' => substr($token, 0, 20) . '...',
                'userId' => $tokenData['userId'],
                'status' => 'failed',
                'error' => $errorMsg,
                'response' => $fullResponse,
                'httpCode' => $httpCode
            ];
        }
    }
    
    return [
        'successCount' => $successCount,
        'failureCount' => $failureCount,
        'totalTokens' => count($tokens),
        'results' => $results
    ];
}

// Function to log notification to Firebase
function logNotificationToFirebase($title, $body, $senderId, $result, $firebaseConfig) {
    $url = $firebaseConfig['databaseURL'] . '/notifications.json';
    
    $notificationData = [
        'title' => $title,
        'body' => $body,
        'senderId' => $senderId,
        'timestamp' => date('Y-m-d H:i:s'),
        'type' => 'dynamic_notification',
        'result' => $result
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notificationData));
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return $httpCode === 200;
}

// Main execution
try {
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $action = $input['action'] ?? '';
    $title = $input['title'] ?? '';
    $body = $input['body'] ?? '';
    $senderId = $input['senderId'] ?? 'unknown';
    
    if ($action !== 'send_to_all' && $action !== 'send_to_token') {
        throw new Exception('Invalid action');
    }
    
    if (empty($title) || empty($body)) {
        throw new Exception('Title and body are required');
    }
    
    if ($action === 'send_to_all') {
        // Get all FCM tokens
        $tokens = getAllFCMTokens($firebaseConfig);
        
        if (empty($tokens)) {
            throw new Exception('No FCM tokens found in database');
        }
        
        // Send notifications to all
        $result = sendFCMNotification($tokens, $title, $body, $fcmServerKey);
    } else if ($action === 'send_to_token') {
        // Send to specific token
        $token = $input['token'] ?? '';
        if (empty($token)) {
            throw new Exception('Token is required for send_to_token action');
        }
        
        $tokens = [['token' => $token, 'userId' => $senderId, 'lastUpdate' => date('Y-m-d H:i:s')]];
        $result = sendFCMNotification($tokens, $title, $body, $fcmServerKey);
    }
    
    // Log notification to Firebase
    logNotificationToFirebase($title, $body, $senderId, $result, $firebaseConfig);
    
    // Return success response
    echo json_encode([
        'success' => true,
        'message' => 'Notifications sent successfully',
        'data' => [
            'totalTokens' => $result['totalTokens'],
            'successCount' => $result['successCount'],
            'failureCount' => $result['failureCount'],
            'title' => $title,
            'body' => $body,
            'timestamp' => date('Y-m-d H:i:s')
        ],
        'details' => $result['results']
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'error' => true
    ]);
}

// Additional endpoints for testing and management

// GET endpoint to check FCM tokens
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $action = $_GET['action'] ?? '';
    
    if ($action === 'check_tokens') {
        $tokens = getAllFCMTokens($firebaseConfig);
        echo json_encode([
            'success' => true,
            'totalTokens' => count($tokens),
            'tokens' => $tokens
        ]);
        exit();
    }
    
    if ($action === 'test_connection') {
        echo json_encode([
            'success' => true,
            'message' => 'PHP API is working correctly',
            'timestamp' => date('Y-m-d H:i:s'),
            'server' => $_SERVER['SERVER_NAME'],
            'firebaseConfig' => $firebaseConfig
        ]);
        exit();
    }
    
    if ($action === 'test_fcm_key') {
        $testKey = $_GET['key'] ?? '';
        if (empty($testKey)) {
            echo json_encode([
                'success' => false,
                'message' => 'No FCM key provided. Use ?action=test_fcm_key&key=YOUR_FCM_SERVER_KEY'
            ]);
            exit();
        }
        
        $testData = [
            'to' => 'test_token_123',
            'notification' => [
                'title' => 'Test Notification',
                'body' => 'This is a test notification'
            ]
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: key=' . $testKey,
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        $result = json_decode($response, true);
        
        echo json_encode([
            'success' => $httpCode === 200,
            'httpCode' => $httpCode,
            'response' => $result,
            'message' => $httpCode === 200 ? 'FCM API accessible' : 'FCM API error'
        ]);
        exit();
    }
}
?>