import React from 'react';
import { View, Text, StyleSheet, TouchableOpacity, StatusBar, Dimensions, ScrollView } from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';

const { height } = Dimensions.get('window');
const TOTAL_HEADER_HEIGHT = height * 0.2 - 36;

const IncidentReportHeader = ({ currentStep, setCurrentStep }) => {
  const renderStepIndicator = () => (
    <ScrollView
      horizontal
      showsHorizontalScrollIndicator={false}
      contentContainerStyle={styles.stepsScrollContent}
    >
      <TouchableOpacity
        style={styles.stepWrapper}
        onPress={() => currentStep > 1 && setCurrentStep(1)}
        activeOpacity={currentStep > 1 ? 0.7 : 1}
        disabled={currentStep <= 1}
      >
        <View
          style={[
            styles.stepCircle,
            currentStep > 1 ? styles.completedStepCircle : currentStep === 1 ? styles.activeStepCircle : styles.inactiveStepCircle,
          ]}
        >
          {currentStep > 1 ? (
            <MaterialIcons name="check" size={20} color="#fff" />
          ) : (
            <Text
              style={[
                styles.stepNumber,
                currentStep === 1 ? styles.activeStepNumber : styles.inactiveStepNumber,
              ]}
            >
              1
            </Text>
          )}
        </View>
        <View style={styles.stepTextContainer}>
          <Text style={[styles.stepTitle, currentStep >= 1 && styles.activeStepTitle]}>Step 1</Text>
          <Text style={[styles.stepSubtitle, currentStep >= 1 && styles.activeStepSubtitle]}>Incident Information</Text>
        </View>
        <View style={[styles.stepConnector, currentStep >= 2 && styles.completedStepConnector]} />
      </TouchableOpacity>

      <TouchableOpacity
        style={styles.stepWrapper}
        onPress={() => currentStep > 2 && setCurrentStep(2)}
        activeOpacity={currentStep > 2 ? 0.7 : 1}
        disabled={currentStep <= 2}
      >
        <View
          style={[
            styles.stepCircle,
            currentStep > 2 ? styles.completedStepCircle : currentStep === 2 ? styles.activeStepCircle : styles.inactiveStepCircle,
          ]}
        >
          {currentStep > 2 ? (
            <MaterialIcons name="check" size={20} color="#fff" />
          ) : (
            <Text
              style={[
                styles.stepNumber,
                currentStep === 2 ? styles.activeStepNumber : styles.inactiveStepNumber,
              ]}
            >
              2
            </Text>
          )}
        </View>
        <View style={styles.stepTextContainer}>
          <Text style={[styles.stepTitle, currentStep >= 2 && styles.activeStepTitle]}>Step 2</Text>
          <Text style={[styles.stepSubtitle, currentStep >= 2 && styles.activeStepSubtitle]}>Click Images</Text>
        </View>
        <View style={[styles.stepConnector, currentStep >= 3 && styles.completedStepConnector]} />
      </TouchableOpacity>

      <View style={styles.stepWrapper}>
        <View
          style={[
            styles.stepCircle,
            currentStep > 3 ? styles.completedStepCircle : currentStep === 3 ? styles.activeStepCircle : styles.inactiveStepCircle,
          ]}
        >
          <Text
            style={[
              styles.stepNumber,
              currentStep === 3 ? styles.activeStepNumber : styles.inactiveStepNumber,
            ]}
          >
            3
          </Text>
        </View>
        <View style={styles.stepTextContainer}>
          <Text style={[styles.stepTitle, currentStep >= 3 && styles.activeStepTitle]}>Step 3</Text>
          <Text style={[styles.stepSubtitle, currentStep >= 3 && styles.activeStepSubtitle]}>Summary</Text>
        </View>
      </View>
    </ScrollView>
  );

  return (
    <LinearGradient
      colors={['#3481BC', '#025383']}
      style={[styles.header, { height: TOTAL_HEADER_HEIGHT }]}
    >
      <StatusBar translucent backgroundColor="transparent" barStyle="light-content" />
      {renderStepIndicator()}
    </LinearGradient>
  );
};

const styles = StyleSheet.create({
  header: {
    width: '100%',
    paddingBottom: 15,
  },
  stepsScrollContent: {
    paddingHorizontal: 20,
    alignItems: 'center',
    marginTop: '12%',
  },
  stepWrapper: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingHorizontal: 5,
  },
  stepCircle: {
    width: 30,
    height: 30,
    borderRadius: 15,
    backgroundColor: '#eee',
    justifyContent: 'center',
    alignItems: 'center',
    borderWidth: 2,
    borderColor: '#ccc',
  },
  activeStepCircle: {
    borderColor: '#fff',
    backgroundColor: '#fff',
  },
  completedStepCircle: {
    backgroundColor: '#4CAF50',
    borderColor: '#4CAF50',
  },
  inactiveStepCircle: {
    backgroundColor: '#eee',
    borderColor: '#ccc',
  },
  stepConnector: {
    width: 30,
    height: 2,
    backgroundColor: '#ccc',
  },
  completedStepConnector: {
    backgroundColor: '#4CAF50',
  },
  stepTextContainer: {
    marginHorizontal: 10,
  },
  stepTitle: {
    fontSize: 14,
    color: '#ccc',
    fontWeight: 'bold',
  },
  activeStepTitle: {
    color: '#fff',
  },
  stepSubtitle: {
    fontSize: 12,
    color: '#ccc',
  },
  activeStepSubtitle: {
    color: '#fff',
  },
  stepNumber: {
    color: '#888',
    fontWeight: 'bold',
  },
  activeStepNumber: {
    color: '#025383',
  },
  inactiveStepNumber: {
    color: '#888',
  },
});

export default IncidentReportHeader;