import { View, Text, TextInput, TouchableOpacity, Image, StyleSheet, Platform } from 'react-native';
import React, { useState } from 'react';
import CheckBox from '@react-native-community/checkbox';
import { useNavigation } from '@react-navigation/native';
import LinearGradient from 'react-native-linear-gradient';
import { SafeAreaView } from 'react-native-safe-area-context';

const OTP_Verification = () => {
    const navigation = useNavigation();
    
    const [email, setEmail] = useState('');
    const handleOTP = () => {
        navigation.navigate('OTP_Verification');
    };

    return (
        <View style={styles.container}>
    <LinearGradient
        colors={['#015185', '#3481BC']}
        style={styles.gradient}
        start={{ x: 0, y: 0 }}
        end={{ x: 1, y: 0 }}
    >
        <SafeAreaView edges={['top']} style={styles.headerSafeArea}>
            <View style={styles.headerContent}>
                <TouchableOpacity onPress={() => navigation.goBack()} style={styles.backButton}>
                    <Image
                        source={require('../../../Images/adminlogin/back.png')}
                        style={styles.backIcon}
                    />
                </TouchableOpacity>
                <View style={styles.headerTextContainer}>
                    <Text style={styles.welcomeText}>Forgot Your Password?</Text>
                    <Text style={styles.subHeaderText}>Please enter your registered Phone Number & we
                        sent an OTP Verification code to reset your password.</Text>
                </View>
            </View>
        </SafeAreaView>
    </LinearGradient>

    <SafeAreaView edges={['bottom']} style={styles.contentSafeArea}>
        <View style={styles.formContainer}>
            <View style={styles.inputContainer}>
                <Text style={styles.inputLabel}>Phone Number</Text>
                <View style={styles.inputWrapper}>
                    <Image
                        source={require('../../../Images/adminlogin/mdi_call.png')}
                        style={styles.inputIcon}
                    />
                    <TextInput
                        style={styles.inputWithIcon}
                        placeholder="Enter Phone Number"
                        value={email}
                        onChangeText={setEmail}
                        keyboardType="email-address"
                        autoCapitalize="none"
                        placeholderTextColor="#999"
                    />
                </View>
            </View>
        </View>

        {/* Button placed at the bottom */}
        <View style={styles.buttonContainer}>
            <LinearGradient
                colors={['#015185', '#3481BC']}
                start={{ x: 0, y: 0 }}
                end={{ x: 1, y: 0 }}
                style={styles.googleButtonGradient}
            >
                <TouchableOpacity
                    style={styles.googleButton}
                    onPress={handleOTP}
                >
                    <Text style={styles.googleButtonText}>Proceed</Text>
                </TouchableOpacity>
            </LinearGradient>
        </View>
    </SafeAreaView>
</View>

    );
};

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: '#fff',
    },
    gradient: {
        width: '100%',
    },
    headerSafeArea: {
        paddingTop: Platform.OS === 'ios' ? 0 : 30,
    },
    headerContent: {
        paddingHorizontal: 30,
        paddingBottom: 15,
    },
    backButton: {
        marginTop: 10,
        marginBottom: 20,
    },
    backIcon: {
        width: 24,
        height: 24,
        tintColor: '#fff',
    },
    welcomeText: {
        fontSize: 24,
        fontWeight: 'bold',
        color: '#fff',
        marginBottom: 5,
    },
    subHeaderText: {
        fontSize: 16,
        color: '#fff',
    },
    contentSafeArea: {
        flex: 1,
        paddingHorizontal: 30,
        paddingTop: 30,
        justifyContent: 'space-between', // Pushes content up
    },
    formContainer: {
        width: '100%',
    },
    inputContainer: {
        marginBottom: 15,
        marginHorizontal: 10,
    },
    inputWrapper: {
        position: 'relative',
    },
    inputLabel: {
        fontSize: 22,
        color: '#015185',
        marginBottom: 5,
        fontWeight: '500',
    },
    inputWithIcon: {
        height: 50,
        borderWidth: 1,
        borderColor: '#ddd',
        borderRadius: 8,
        paddingHorizontal: 15,
        paddingLeft: 45,
        fontSize: 16,
        color: '#333',
        width: '100%',
    },
    inputIcon: {
        width: 24,
        height: 24,
        position: 'absolute',
        left: 10,
        top: '50%',
        transform: [{ translateY: -12 }],
        tintColor: '#015185',
    },
    buttonContainer: {
        width: '100%',
        paddingBottom: 30, // Ensures button sticks to bottom
    },
    googleButtonGradient: {
        borderRadius: 8,
        marginHorizontal: 10,
    },
    googleButton: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'center',
        height: 50,
        borderRadius: 8,
        paddingHorizontal: 15,
    },
    googleButtonText: {
        color: '#fff',
        fontSize: 16,
        fontWeight: 'bold',
    }
});


export default OTP_Verification;