import { View, Text, TextInput, TouchableOpacity, Image, StyleSheet, Platform, Modal,Animated } from 'react-native';
import React, { useState, useEffect, useRef } from 'react';
import { useNavigation } from '@react-navigation/native';
import LinearGradient from 'react-native-linear-gradient';
import { SafeAreaView } from 'react-native-safe-area-context';

export default function Resetpassword() {
  const navigation = useNavigation();

  const [password, setPassword] = useState('');
  const [confirmPassword, setConfirmPassword] = useState('');
  const [showPassword, setShowPassword] = useState(false);
  const [errorMessage, setErrorMessage] = useState('');
  const [modalVisible, setModalVisible] = useState(false);
  const rotateAnim = useRef(new Animated.Value(0)).current;

  const toggleShowPassword = () => {
    setShowPassword(!showPassword);
  };

  const handleProceed = () => {
    if (!password || !confirmPassword) {
        setErrorMessage('Please fill in both fields.');
        return;
      }
    if (password !== confirmPassword) {
      setErrorMessage('Passwords do not match');
      return;
    }
    setErrorMessage('');
    setModalVisible(true);
    // Start rotating animation
    Animated.loop(
        Animated.timing(rotateAnim, {
          toValue: 1,
          duration: 2000, // Rotate in 2 seconds
          useNativeDriver: true,
        })
      ).start();
  
      // After 5 seconds, navigate to Home
      setTimeout(() => {
        setModalVisible(false);
        navigation.navigate('Home'); // Redirect to Home
      }, 5000);
  };

  const rotateInterpolate = rotateAnim.interpolate({
    inputRange: [0, 1],
    outputRange: ['0deg', '360deg'],
  });

  return (
    <View style={styles.container}>
  <LinearGradient
    colors={['#015185', '#3481BC']}
    style={styles.gradient}
    start={{ x: 0, y: 0 }}
    end={{ x: 1, y: 0 }}
  >
    <SafeAreaView edges={['top']} style={styles.headerSafeArea}>
      <View style={styles.headerContent}>
        <TouchableOpacity onPress={() => navigation.goBack()} style={styles.backButton}>
          <Image
            source={require('../../../Images/adminlogin/back.png')}
            style={styles.backIcon}
          />
        </TouchableOpacity>
        <View style={styles.headerTextContainer}>
          <Text style={styles.welcomeText}>Reset Your Password</Text>
          <Text style={styles.subHeaderText}>Please enter your new password</Text>
        </View>
      </View>
    </SafeAreaView>
  </LinearGradient>

  <SafeAreaView edges={['bottom']} style={styles.contentSafeArea}>
    <View style={styles.formContainer}>
      <View style={styles.passwordContainer}>
        <Text style={styles.inputLabel}>New Password</Text>
        <View style={styles.inputWrapper}>
          <Image
            source={require('../../../Images/adminlogin/lock.png')}
            style={styles.inputIcon}
          />
          <TextInput
            style={styles.passwordInput}
            placeholder="Enter Password"
            value={password}
            onChangeText={setPassword}
            secureTextEntry={!showPassword}
            placeholderTextColor="#999"
          />
          <TouchableOpacity style={styles.eyeButton} onPress={toggleShowPassword}>
            <Image
              source={
                showPassword
                  ? require('../../../Images/adminlogin/mdi_eye.png')
                  : require('../../../Images/adminlogin/mdi_hide.png')
              }
              style={styles.eyeIcon}
            />
          </TouchableOpacity>
        </View>

        <Text style={[styles.inputLabel, { marginTop: 15 }]}>Confirm Password</Text>
        <View style={styles.inputWrapper}>
          <Image
            source={require('../../../Images/adminlogin/lock.png')}
            style={styles.inputIcon}
          />
          <TextInput
            style={styles.passwordInput}
            placeholder="Enter Confirm Password"
            value={confirmPassword}
            onChangeText={setConfirmPassword}
            secureTextEntry={!showPassword}
            placeholderTextColor="#999"
          />
          <TouchableOpacity style={styles.eyeButton} onPress={toggleShowPassword}>
            <Image
              source={
                showPassword
                  ? require('../../../Images/adminlogin/mdi_eye.png')
                  : require('../../../Images/adminlogin/mdi_hide.png')
              }
              style={styles.eyeIcon}
            />
          </TouchableOpacity>
        </View>

        {/* Error message */}
        {errorMessage ? <Text style={styles.errorText}>{errorMessage}</Text> : null}

        <Text style={styles.NOTE}>
          *NOTE: Choose a password that is distinctive & you can easily remember.
        </Text>
      </View>
    </View>
  </SafeAreaView>

  {/* Proceed button at the bottom */}
  <SafeAreaView edges={['bottom']} style={styles.buttonContainer}>
          <LinearGradient
              colors={['#015185', '#3481BC']}
              start={{ x: 0, y: 0 }}
              end={{ x: 1, y: 0 }}
              style={styles.googleButtonGradient}
          >
              <TouchableOpacity style={styles.googleButton} onPress={handleProceed} >
                  <Text style={styles.googleButtonText}>Proceed</Text>
              </TouchableOpacity>
          </LinearGradient>
      </SafeAreaView>

      {/* Success Modal */}
      <Modal visible={modalVisible} transparent animationType="slide">
        <View style={styles.modalContainer}>
          <View style={styles.modalContent}>
            <Image
              source={require('../../../Images/adminlogin/password_reset.png')}
              style={styles.successIcon}
            />
            <Text style={styles.modalTitle}>Reset Password Successful !</Text>
            <Text style={[styles.modalText, { marginBottom: 1}]}>Please wait...</Text>
<          Text style={styles.backHome}>You will be directed to the homepage soon.</Text>

{/* <Image
              source={require('../../../Images/adminlogin/sync.png')}
              style={styles.syncIcon}
            /> */}
            <Animated.Image
              source={require('../../../Images/adminlogin/sync.png')}
              style={[styles.syncIcon, { transform: [{ rotate: rotateInterpolate }] }]}
            />
          </View>
        </View>
      </Modal>
</View>

  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#fff',
  },
  buttonContainer: {
    position: 'absolute',
    bottom: 30,
    left: 0,
    right: 0,
    alignItems: 'center',
},
googleButtonGradient: {
    borderRadius: 8,
    width: '80%',
},
  
  
  gradient: {
    width: '100%',
  },
  headerSafeArea: {
    paddingTop: Platform.OS === 'ios' ? 0 : 30,
  },
  headerContent: {
    paddingHorizontal: 30,
    paddingBottom: 15,
  },
  backButton: {
    marginTop: 10,
    marginBottom: 20,
  },
  backIcon: {
    width: 24,
    height: 24,
    tintColor: '#fff',
  },
  welcomeText: {
    fontSize: 24,
    fontWeight: 'bold',
    color: '#fff',
    marginBottom: 5,
  },
  subHeaderText: {
    fontSize: 16,
    color: '#fff',
  },
  contentSafeArea: {
    flex: 1,
    paddingHorizontal: 30,
    paddingTop: 30,
  },
  formContainer: {
    width: '100%',
  },
  passwordContainer: {
    marginBottom: 15,
    marginHorizontal: 10,
  },
  inputWrapper: {
    position: 'relative',
  },
  inputLabel: {
    fontSize: 22,
    color: '#015185',
    marginBottom: 5,
    fontWeight: '500',
  },
  passwordInput: {
    height: 50,
    borderWidth: 1,
    borderColor: '#ddd',
    borderRadius: 8,
    paddingHorizontal: 15,
    paddingLeft: 45,
    paddingRight: 45,
    fontSize: 16,
    color: '#333',
    width: '100%',
  },
  inputIcon: {
    width: 20,
    height: 20,
    position: 'absolute',
    left: 10,
    top: '50%',
    transform: [{ translateY: -12 }],
    tintColor: '#015185',
  },
  eyeButton: {
    position: 'absolute',
    right: 10,
    top: '50%',
    transform: [{ translateY: -12 }],
  },
  eyeIcon: {
    width: 20,
    height: 20,
    tintColor: '#015185',
  },
  errorText: {
    color: 'red',
    fontSize: 14,
    marginTop: 5,
    textAlign: 'left',
    marginHorizontal: 10,
  },
  googleButton: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    height: 50,
    borderRadius: 8,
    paddingHorizontal: 15,
  },
  googleButtonText: {
    color: '#fff',
    fontSize: 16,
    fontWeight: 'bold',
  },
  NOTE : {
    marginTop: 12
  },
  modalContainer: {
    flex: 1,
    backgroundColor: 'rgba(0,0,0,0.5)',
    justifyContent: 'center',
    alignItems: 'center',
  },
  modalContent: {
    width: 300,
    backgroundColor: 'white',
    borderRadius: 10,
    padding: 20,
    alignItems: 'center',
  },
  successIcon: {
    width: 60,
    height: 60,
    marginBottom: 10,
  },
  modalTitle: {
    fontSize: 20,
    fontWeight: 'bold',
    color: '#015185',
    marginBottom: 5,
    textAlign: 'center', // Center the text horizontally
  },
  backHome: {
    textAlign: 'center', // Center the text horizontally
    marginTop: 0,
    marginBottom:12,
    fontSize: 14,
    color: '#59606E'
  },
  
  modalText: {
    fontSize: 14,
    textAlign: 'center',
    marginBottom: 15,
    marginTop: 5,
    color: '#59606E'
  },
  modalButton: {
    backgroundColor: '#015185',
    paddingVertical: 10,
    paddingHorizontal: 20,
    borderRadius: 5,
  },
  modalButtonText: {
    color: '#fff',
    fontSize: 16,
    fontWeight: 'bold',
  },
});
