// Splash_screen.js
import React, { useEffect } from 'react';
import { View, Image, StyleSheet } from 'react-native';
import { useNavigation } from '@react-navigation/native';

const SplashScreen = () => {
  const navigation = useNavigation();

  useEffect(() => {
    // Set a timeout to navigate to Login screen after 2 seconds
    const timer = setTimeout(() => {
      navigation.replace('LoginScreens');
      // navigation.replace('MainApp');
    }, 2000); // 2000ms = 2 seconds

    // Cleanup timer on component unmount
    return () => clearTimeout(timer);
  }, [navigation]);

  return (
    <View style={styles.container}>
      <Image
        source={require('../Images/logo/Titan_logo.jpg')}
        style={styles.logo}
        resizeMode="contain"
      />
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#fff', // You can change the background color
  },
  logo: {
    width: 300, // Adjust width as needed
    height: 300, // Adjust height as needed
  },
});

export default SplashScreen;