<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class DynamicPageController extends Controller
{
    public function loadPage(Request $request)
    {
        $page = $request->input('page');
        
        // Validate the page parameter
        $allowedPages = [
            'dashboard' => 'dashboard.dashboard',
            'inspection_report' => 'inspection.inspection_report',
            'operator_daily_reporting' => 'inspection.operator_daily_reporting',
            'incident_report' => 'inspection.incident_report',
            'incident_checklist' => 'inspection.incident_checklist',
            'reminder' => 'inspection.reminder',
            'inspection2' => 'inspection.inspection2',
            'do_inspection' => 'inspection.do_inspection',
            'back_to_incident_report' => 'inspection.back_to_incident_report',
            'job_card' => 'inspection.job_card',
            'dvir_dot_inspection' => 'vehicles.dvir_dot_inspection',
            'workorder' => 'maintenance.workorder',
            'request_maintenance' => 'maintenance.request',
            'service_schedule' => 'maintenance.service_schedule',
            'parts_inventory' => 'maintenance.parts_inventory',
            'labor_codes' => 'maintenance.labor_codes',
            'task_master' => 'maintenance.task_master',
            'fuel_logger' => 'fuel.logger',
            'fuel_bunker' => 'fuel.bunker',
            'vehicles_inventory' => 'vehicles.inventory',
            'vehicles_overview' => 'vehicles.overview',
            'team_management' => 'master_data.team',
            'documents' => 'master_data.documents',
            'account' => 'master_data.account',
            'subscription' => 'master_data.subscription',
            'excel_report' => 'dashboard.excel_report',
            'inspection_kpi' => 'dashboard.inspection_kpi',
            'maintenance_kpi' => 'dashboard.maintenance_kpi',
            'fuel_management_kpi' => 'dashboard.fuel_management_kpi',
        ];
        
        if (!isset($allowedPages[$page])) {
            return response()->json(['error' => 'Page not found'], 404);
        }
        
        try {
            // Get the route name
            $routeName = $allowedPages[$page];
            
            // Get the route URL
            $url = route($routeName);
            
            // For now, we'll return a simple response
            // In a real implementation, you might want to render the actual view
            $content = $this->getPageContent($page);
            
            return response()->json([
                'success' => true,
                'content' => $content,
                'title' => $this->getPageTitle($page),
                'url' => $url
            ]);
            
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to load page'], 500);
        }
    }
    
    private function getPageContent($page)
    {
        try {
            // Render the actual view for each page
            switch ($page) {
                case 'dashboard':
                    return view('dashboard.dashboard')->render();
                    
                case 'inspection_report':
                    return view('inspection.inspection')->render();
                    
                case 'operator_daily_reporting':
                    return view('inspection.operator_daily_reporting')->render();
                    
                case 'incident_report':
                    return view('inspection.incident_report')->render();
                    
                case 'incident_checklist':
                    return view('inspection.incident_checklist')->render();
                    
                case 'reminder':
                    return view('inspection.reminder')->render();
                    
                case 'inspection2':
                    return view('inspection.inspection2')->render();
                    
                case 'do_inspection':
                    return view('inspection.do_inspection')->render();
                    
                case 'back_to_incident_report':
                    return view('inspection.back_to_incident_report')->render();
                    
                case 'job_card':
                    return view('inspection.job_card')->render();
                    
                case 'dvir_dot_inspection':
                    return view('vehicles.dvir_dot_inspection')->render();
                    
                case 'workorder':
                    return view('maintenance.workorder')->render();
                    
                case 'request_maintenance':
                    return view('maintenance.request')->render();
                    
                case 'service_schedule':
                    return view('maintenance.service_schedule')->render();
                    
                case 'parts_inventory':
                    return view('maintenance.parts_inventory')->render();
                    
                case 'labor_codes':
                    return view('maintenance.labor_codes')->render();
                    
                case 'task_master':
                    return view('maintenance.task_master')->render();
                    
                case 'fuel_logger':
                    return view('fuel.logger')->render();
                    
                case 'fuel_bunker':
                    return view('fuel.bunker')->render();
                    
                case 'vehicles_inventory':
                    return view('vehicles.inventory')->render();
                    
                case 'vehicles_overview':
                    return view('vehicles.overview')->render();
                    
                case 'team_management':
                    return view('master_data.team')->render();
                    
                case 'documents':
                    return view('master_data.documents')->render();
                    
                case 'account':
                    return view('master_data.account')->render();
                    
                case 'subscription':
                    return view('master_data.subscription')->render();
                    
                case 'excel_report':
                    return view('dashboard.excel_report')->render();
                    
                case 'inspection_kpi':
                    return view('dashboard.inspection_kpi')->render();
                    
                case 'maintenance_kpi':
                    return view('dashboard.maintenance_kpi')->render();
                    
                case 'fuel_management_kpi':
                    return view('dashboard.fuel_management_kpi')->render();
                    
                default:
                    return '<div class="container-fluid">
                        <div class="row">
                            <div class="col-12">
                                <h1>' . ucfirst(str_replace('_', ' ', $page)) . '</h1>
                                <p>This is the ' . $page . ' page content.</p>
                            </div>
                        </div>
                    </div>';
            }
        } catch (\Exception $e) {
            // Fallback content if view doesn't exist
            return '<div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <h1>' . ucfirst(str_replace('_', ' ', $page)) . '</h1>
                        <p>This is the ' . $page . ' page content.</p>
                        <p class="text-muted">Note: Full content loading...</p>
                    </div>
                </div>
            </div>';
        }
    }
    
    private function getPageTitle($page)
    {
        $titles = [
            'dashboard' => 'Dashboard',
            'inspection_report' => 'Inspection Report',
            'operator_daily_reporting' => 'Operator Daily Reporting',
            'incident_report' => 'Incident Report',
            'incident_checklist' => 'Inspection Checklist',
            'reminder' => 'Reminder',
            'inspection2' => 'Inspection 2',
            'do_inspection' => 'Do Inspection',
            'back_to_incident_report' => 'Back to Incident Report',
            'job_card' => 'Job Card',
            'dvir_dot_inspection' => 'DVIR & DOT Inspection',
            'workorder' => 'Workorder',
            'request_maintenance' => 'Request Maintenance',
            'service_schedule' => 'Service Schedule',
            'parts_inventory' => 'Parts Inventory',
            'labor_codes' => 'Labor Codes',
            'task_master' => 'Task Master',
            'fuel_logger' => 'Fuel Logger',
            'fuel_bunker' => 'Fuel Bunker',
            'vehicles_inventory' => 'Vehicles',
            'vehicles_overview' => 'Vehicles Overview',
            'team_management' => 'Team Management',
            'documents' => 'Documents',
            'account' => 'Account',
            'subscription' => 'Subscription',
            'excel_report' => 'Excel Report',
            'inspection_kpi' => 'Inspection KPI',
            'maintenance_kpi' => 'Maintenance KPI',
            'fuel_management_kpi' => 'Fuel Management KPI',
        ];
        
        return $titles[$page] ?? ucfirst(str_replace('_', ' ', $page));
    }
}
