<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Firebase API Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Import Google Fonts for better typography */
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8fafc;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }
        
        .test-section {
            margin: 20px 0;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
            background: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        .result-box {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-top: 10px;
            white-space: pre-wrap;
            font-family: 'Courier New', monospace;
            max-height: 400px;
            overflow-y: auto;
            border: 1px solid #e9ecef;
            font-size: 14px;
            line-height: 1.4;
        }
        
        .loading {
            color: #0055A5;
            font-weight: 600;
        }
        
        .error {
            color: #dc3545;
            font-weight: 600;
        }
        
        .success {
            color: #198754;
            font-weight: 600;
        }
        
        h1 {
            color: #1e293b;
            font-weight: 700;
            margin-bottom: 2rem;
        }
        
        h3 {
            color: #374151;
            font-weight: 600;
            margin-bottom: 1rem;
        }
        
        .btn {
            font-weight: 600;
            padding: 12px 24px;
            border-radius: 6px;
            transition: all 0.2s ease;
            border: none;
            cursor: pointer;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
            color: white;
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(59, 130, 246, 0.3);
        }
        
        .btn-success {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
        }
        
        .btn-success:hover {
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(16, 185, 129, 0.3);
        }
        
        /* ===== RESPONSIVE DESIGN ===== */
        @media (max-width: 1200px) {
            .container {
                max-width: 100%;
                padding: 0 20px;
            }
            
            .test-section {
                margin: 16px 0;
                padding: 18px;
            }
            
            .result-box {
                max-height: 350px;
                font-size: 13px;
            }
        }
        
        @media (max-width: 992px) {
            .container {
                padding: 0 16px;
            }
            
            h1 {
                font-size: 2rem;
                margin-bottom: 1.5rem;
            }
            
            h3 {
                font-size: 1.25rem;
            }
            
            .test-section {
                margin: 14px 0;
                padding: 16px;
            }
            
            .btn {
                padding: 10px 20px;
                font-size: 14px;
            }
            
            .result-box {
                padding: 12px;
                max-height: 300px;
                font-size: 12px;
            }
        }
        
        @media (max-width: 768px) {
            .container {
                padding: 0 12px;
            }
            
            h1 {
                font-size: 1.75rem;
                margin-bottom: 1.25rem;
            }
            
            h3 {
                font-size: 1.125rem;
            }
            
            .test-section {
                margin: 12px 0;
                padding: 14px;
            }
            
            .btn {
                width: 100%;
                padding: 12px 16px;
                font-size: 14px;
                margin-bottom: 8px;
            }
            
            .result-box {
                padding: 10px;
                max-height: 250px;
                font-size: 11px;
                line-height: 1.3;
            }
        }
        
        @media (max-width: 576px) {
            .container {
                padding: 0 8px;
            }
            
            h1 {
                font-size: 1.5rem;
                margin-bottom: 1rem;
            }
            
            h3 {
                font-size: 1rem;
            }
            
            .test-section {
                margin: 10px 0;
                padding: 12px;
            }
            
            .btn {
                width: 100%;
                padding: 10px 14px;
                font-size: 13px;
                margin-bottom: 6px;
            }
            
            .result-box {
                padding: 8px;
                max-height: 200px;
                font-size: 10px;
                line-height: 1.2;
            }
        }
        
        @media (max-width: 480px) {
            .container {
                padding: 0 6px;
            }
            
            h1 {
                font-size: 1.25rem;
                margin-bottom: 0.75rem;
            }
            
            h3 {
                font-size: 0.9rem;
            }
            
            .test-section {
                margin: 8px 0;
                padding: 10px;
            }
            
            .btn {
                width: 100%;
                padding: 8px 12px;
                font-size: 12px;
                margin-bottom: 4px;
            }
            
            .result-box {
                padding: 6px;
                max-height: 150px;
                font-size: 9px;
                line-height: 1.1;
            }
        }
        
        /* ===== LANDSCAPE ORIENTATION ===== */
        @media (max-width: 768px) and (orientation: landscape) {
            .container {
                padding: 0 8px;
            }
            
            .test-section {
                margin: 8px 0;
                padding: 10px;
            }
            
            .result-box {
                max-height: 180px;
            }
        }
        
        /* ===== TOUCH DEVICES ===== */
        @media (hover: none) and (pointer: coarse) {
            .btn {
                min-height: 44px;
                padding: 12px 16px;
            }
        }
        
        /* ===== ACCESSIBILITY ===== */
        @media (prefers-reduced-motion: reduce) {
            * {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }
        
        /* ===== FOCUS STYLES ===== */
        .btn:focus-visible {
            outline: 2px solid #3b82f6;
            outline-offset: 2px;
        }
        
        /* ===== PRINT STYLES ===== */
        @media print {
            .btn {
                display: none;
            }
            
            .test-section {
                border: 1px solid #000;
                break-inside: avoid;
            }
            
            .result-box {
                max-height: none;
                overflow: visible;
            }
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h1 class="mb-4">Firebase API Test</h1>
        
        <div class="test-section">
            <h3>Test Equipment API</h3>
            <button class="btn btn-primary" onclick="testEquipmentAPI()">Test Equipment Fetch</button>
            <div id="equipment-result" class="result-box mt-3"></div>
        </div>
        
        <div class="test-section">
            <h3>Test Checklist API</h3>
            <button class="btn btn-primary" onclick="testChecklistAPI()">Test Checklist Fetch</button>
            <div id="checklist-result" class="result-box mt-3"></div>
        </div>
        
        <div class="test-section">
            <h3>Test Both APIs</h3>
            <button class="btn btn-success" onclick="testBothAPIs()">Test Both APIs</button>
            <div id="both-result" class="result-box mt-3"></div>
        </div>
    </div>

    <script>
        async function testEquipmentAPI() {
            const resultDiv = document.getElementById('equipment-result');
            resultDiv.innerHTML = '<span class="loading">Testing Equipment API...</span>';
            
            try {
                const response = await fetch('/api/fetch-equipment-from-firebase');
                const data = await response.json();
                
                if (data.success) {
                    resultDiv.innerHTML = `<span class="success">✅ Equipment API Success!</span>\n\nData: ${JSON.stringify(data, null, 2)}`;
                } else {
                    resultDiv.innerHTML = `<span class="error">❌ Equipment API Failed</span>\n\nError: ${data.message}`;
                }
            } catch (error) {
                resultDiv.innerHTML = `<span class="error">❌ Equipment API Error</span>\n\nError: ${error.message}`;
            }
        }
        
        async function testChecklistAPI() {
            const resultDiv = document.getElementById('checklist-result');
            resultDiv.innerHTML = '<span class="loading">Testing Checklist API...</span>';
            
            try {
                const response = await fetch('/api/fetch-checklists-from-firebase');
                const data = await response.json();
                
                if (data.success) {
                    resultDiv.innerHTML = `<span class="success">✅ Checklist API Success!</span>\n\nData: ${JSON.stringify(data, null, 2)}`;
                } else {
                    resultDiv.innerHTML = `<span class="error">❌ Checklist API Failed</span>\n\nError: ${data.message}`;
                }
            } catch (error) {
                resultDiv.innerHTML = `<span class="error">❌ Checklist API Error</span>\n\nError: ${error.message}`;
            }
        }
        
        async function testBothAPIs() {
            const resultDiv = document.getElementById('both-result');
            resultDiv.innerHTML = '<span class="loading">Testing Both APIs...</span>';
            
            try {
                const [equipmentResponse, checklistResponse] = await Promise.all([
                    fetch('/api/fetch-equipment-from-firebase'),
                    fetch('/api/fetch-checklists-from-firebase')
                ]);
                
                const equipmentData = await equipmentResponse.json();
                const checklistData = await checklistResponse.json();
                
                let result = '';
                
                if (equipmentData.success) {
                    result += `✅ Equipment API: Success (${equipmentData.count} items)\n`;
                } else {
                    result += `❌ Equipment API: ${equipmentData.message}\n`;
                }
                
                if (checklistData.success) {
                    result += `✅ Checklist API: Success (${checklistData.count} items)\n`;
                } else {
                    result += `❌ Checklist API: ${checklistData.message}\n`;
                }
                
                resultDiv.innerHTML = `<span class="success">${result}</span>`;
                
            } catch (error) {
                resultDiv.innerHTML = `<span class="error">❌ Error testing APIs: ${error.message}</span>`;
            }
        }
    </script>
</body>
</html> 