import { View, Text, TouchableOpacity, StyleSheet } from 'react-native'
import React from 'react'
import { useNavigation } from '@react-navigation/native'

export default function FirebaseFCMNotificaion() {
const navigation = useNavigation()

  const sayHelloWorld = () => {
    console.log('👋 Hello World from FirebaseFCMNotificaion!')
    alert('👋 Hello World!')
  }

  return (
    <View style={styles.container}>
      <Text style={styles.title}>Firebase FCM Notification</Text>
      
      <View style={styles.content}>
        <Text style={styles.description}>
          This is a simple component with basic functionality.
        </Text>
        
        <TouchableOpacity 
          style={styles.helloButton} 
          onPress={sayHelloWorld}
        >
          <Text style={styles.buttonText}>👋 Say Hello World</Text>
        </TouchableOpacity>
        
        <TouchableOpacity 
          style={styles.navButton} 
          onPress={() => navigation.navigate('TestLoginCredFCM')}
        >
          <Text style={styles.buttonText}>🧪 Go to Test FCM</Text>
        </TouchableOpacity>

        <TouchableOpacity 
          style={[styles.navButton, { backgroundColor: '#6c757d', marginTop: 10 }]} 
          onPress={() => navigation.goBack()}
        >
          <Text style={styles.buttonText}>⬅️ Go Back</Text>
        </TouchableOpacity>
      </View>
      </View>
  )
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    padding: 20,
    backgroundColor: '#f5f5f5',
    justifyContent: 'center',
    alignItems: 'center',
  },
  title: {
    fontSize: 24,
    fontWeight: 'bold',
    textAlign: 'center',
    marginBottom: 30,
    color: '#333',
  },
  content: {
    backgroundColor: 'white',
    padding: 30,
    borderRadius: 15,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.1,
    shadowRadius: 3.84,
    elevation: 5,
    alignItems: 'center',
    minWidth: 300,
  },
  description: {
    fontSize: 16,
    color: '#666',
    textAlign: 'center',
    marginBottom: 30,
    lineHeight: 24,
  },
  helloButton: {
    backgroundColor: '#007AFF',
    paddingVertical: 15,
    paddingHorizontal: 30,
    borderRadius: 10,
    marginBottom: 20,
    minWidth: 200,
  },
  navButton: {
    backgroundColor: '#34C759',
    paddingVertical: 15,
    paddingHorizontal: 30,
    borderRadius: 10,
    minWidth: 200,
  },
  buttonText: {
    color: 'white',
    fontSize: 18,
    fontWeight: '600',
    textAlign: 'center',
  },
})