<?php
/**
 * Test FCM Configuration
 * Upload this to your server and access it via browser to test FCM setup
 */

header('Content-Type: text/html; charset=utf-8');

// Firebase configuration (update with your actual values)
$firebaseConfig = [
    'apiKey' => 'AIzaSyDhcCn--qmGMyWSzwpLvYIaXKELFp5sCZY',
    'databaseURL' => 'https://titan-drilling-1f8e9-default-rtdb.firebaseio.com',
    'projectId' => 'titan-drilling-1f8e9'
];

// FCM Server Key (you need to add this)
$fcmServerKey = 'YOUR_FCM_SERVER_KEY'; // Replace with your actual FCM server key

echo "<h1>FCM Configuration Test</h1>";

// Test 1: Check if we can access Firebase database
echo "<h2>Test 1: Firebase Database Access</h2>";
$url = $firebaseConfig['databaseURL'] . '/Globalusers/admins.json';
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    echo "<p style='color: green;'>✅ Firebase database accessible</p>";
    $data = json_decode($response, true);
    if ($data) {
        $tokenCount = 0;
        foreach ($data as $userId => $userData) {
            if (isset($userData['NotificationFCMtoken'])) {
                $tokenCount++;
            }
        }
        echo "<p>Found {$tokenCount} FCM tokens in database</p>";
    } else {
        echo "<p>No data found in database</p>";
    }
} else {
    echo "<p style='color: red;'>❌ Cannot access Firebase database (HTTP {$httpCode})</p>";
}

// Test 2: Check FCM Server Key
echo "<h2>Test 2: FCM Server Key</h2>";
if ($fcmServerKey === 'YOUR_FCM_SERVER_KEY') {
    echo "<p style='color: red;'>❌ FCM Server Key not configured</p>";
    echo "<p>Please update the FCM Server Key in the PHP file</p>";
} else {
    echo "<p style='color: green;'>✅ FCM Server Key configured</p>";
}

// Test 3: Test FCM API
echo "<h2>Test 3: FCM API Test</h2>";
if ($fcmServerKey !== 'YOUR_FCM_SERVER_KEY') {
    $testData = [
        'to' => 'test_token_123',
        'notification' => [
            'title' => 'Test',
            'body' => 'Test notification'
        ]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: key=' . $fcmServerKey,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $result = json_decode($response, true);
        if ($result && isset($result['failure']) && $result['failure'] == 1) {
            echo "<p style='color: orange;'>⚠️ FCM API accessible but test token invalid (expected)</p>";
        } else {
            echo "<p style='color: green;'>✅ FCM API working</p>";
        }
    } else {
        echo "<p style='color: red;'>❌ FCM API error (HTTP {$httpCode})</p>";
    }
} else {
    echo "<p style='color: gray;'>⏭️ Skipped (FCM Server Key not configured)</p>";
}

// Test 4: Check PHP extensions
echo "<h2>Test 4: PHP Extensions</h2>";
if (extension_loaded('curl')) {
    echo "<p style='color: green;'>✅ cURL extension loaded</p>";
} else {
    echo "<p style='color: red;'>❌ cURL extension not loaded</p>";
}

if (extension_loaded('json')) {
    echo "<p style='color: green;'>✅ JSON extension loaded</p>";
} else {
    echo "<p style='color: red;'>❌ JSON extension not loaded</p>";
}

// Instructions
echo "<h2>Next Steps</h2>";
echo "<ol>";
echo "<li>Get your FCM Server Key from Firebase Console > Project Settings > Cloud Messaging</li>";
echo "<li>Update the FCM Server Key in titanNotificationsFCM.php</li>";
echo "<li>Generate FCM tokens in your app</li>";
echo "<li>Test sending notifications</li>";
echo "</ol>";

echo "<h2>How to Get FCM Server Key</h2>";
echo "<ol>";
echo "<li>Go to <a href='https://console.firebase.google.com/' target='_blank'>Firebase Console</a></li>";
echo "<li>Select your project: <strong>titan-drilling-1f8e9</strong></li>";
echo "<li>Click the gear icon (Project Settings)</li>";
echo "<li>Go to 'Cloud Messaging' tab</li>";
echo "<li>Copy the 'Server Key' (starts with AAAA...)</li>";
echo "<li>Replace 'YOUR_FCM_SERVER_KEY' in titanNotificationsFCM.php</li>";
echo "</ol>";
?> 