import React from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  StatusBar,
  Dimensions,
  Platform,
} from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
import { useNavigation } from '@react-navigation/native';

const { width } = Dimensions.get('window');
const TOTAL_HEADER_HEIGHT = width * 0.25;

const HRReportingHome = () => {
  const navigation = useNavigation();

  // Button press handlers (replace with your navigation/actions)
  const handlePress = (label) => {
    // navigation.navigate('SomeScreen');
    alert(label);
  };

  return (
    <View style={styles.container}>
      <StatusBar
        translucent
        backgroundColor="transparent"
        barStyle="light-content"
      />
      
      <LinearGradient
        colors={['#3481BC', '#025383']}
        style={[styles.header, { height: TOTAL_HEADER_HEIGHT }]}
      >
        <View style={styles.headerContent}>
          <TouchableOpacity 
            onPress={() => navigation.goBack()} 
            style={styles.backButton}
            activeOpacity={0.8}
          >
            <MaterialIcons name="arrow-back" size={24} color="white" />
          </TouchableOpacity>
          
          <Text style={styles.headerTitle}>HR Reporting</Text>
          
          <View style={styles.headerRightIcons}>
            <TouchableOpacity 
              onPress={() => alert('Cloud sync pressed')} 
              style={styles.headerIconButton}
              activeOpacity={0.8}
            >
              <MaterialIcons name="cloud" size={24} color="white" />
            </TouchableOpacity>
            <TouchableOpacity 
              onPress={() => alert('Menu pressed')} 
              style={styles.headerIconButton}
              activeOpacity={0.8}
            >
              <MaterialIcons name="menu" size={24} color="white" />
            </TouchableOpacity>
          </View>
        </View>
      </LinearGradient>

      <View style={styles.body}>
        <Text style={styles.sectionTitle}>Inspections Completed by</Text>
        <View style={styles.topButtonRow}>
          <TouchableOpacity style={styles.bigButton} onPress={() => navigation.navigate("SupervisorKpi")}>
            <Text style={styles.bigButtonText}>Supervisor</Text>
          </TouchableOpacity>
          <TouchableOpacity style={styles.bigButton} onPress={() => navigation.navigate("SitesKpi")}>
            <Text style={styles.bigButtonText}>Sites</Text>
          </TouchableOpacity>
        </View>
        <View style={styles.singleButtonRow}>
          <TouchableOpacity style={styles.singleButton} onPress={() => navigation.navigate("EmployeesKpi")}>
            <Text style={styles.bigButtonText}>Employees</Text>
          </TouchableOpacity>
        </View>


        <View style={styles.divider} />

        <View style={styles.gridRow}>
          <TouchableOpacity style={styles.gridButton} onPress={() => navigation.navigate("InspectionsClosed")}>
            <Text style={styles.gridButtonText}>Inspections Closed in a{"\n"}Given Period</Text>
          </TouchableOpacity>
          <TouchableOpacity style={styles.gridButton} onPress={() => navigation.navigate("InspectionsOpened")}>
            <Text style={styles.gridButtonText}>Inspections Opened in a{"\n"}Given Period</Text>
          </TouchableOpacity>
        </View>
        <View style={styles.gridRow}>
          <TouchableOpacity style={styles.gridButton} onPress={() => navigation.navigate("EmployeesPaticipated")}>
            <Text style={styles.gridButtonText}>Employees Who Participated{"\n"}in Jobs in a Given Period</Text>
          </TouchableOpacity>
          <TouchableOpacity style={styles.gridButton} onPress={() => navigation.navigate("EmployeesClosed")}>
            <Text style={styles.gridButtonText}>Employees Who Closed Jobs{"\n"}in a Given Period</Text>
          </TouchableOpacity>
        </View>
        <View style={styles.gridRow}>
          <TouchableOpacity style={styles.gridButton} onPress={() => navigation.navigate("EquipmentstatusKpiHome")}>
            <Text style={styles.gridButtonText}>Equipment Status{"\n"}KPI</Text>
          </TouchableOpacity>
        </View>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#fff',
  },
  header: {
    width: '100%',
    justifyContent: 'center',
    elevation: 4,
    shadowColor: '#000',
    shadowOpacity: 0.1,
    shadowRadius: 8,
    shadowOffset: { width: 0, height: 4 },
  },
  headerContent: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    paddingHorizontal: 16,
    paddingTop: Platform.OS === 'ios' ? 32 : 16,
    height: '100%',
    top: 7,
  },
  backButton: {
    position: 'absolute',
    left: 16,
    padding: 8,
  },
  headerTitle: {
    fontSize: 20,
    fontWeight: 'bold',
    color: 'white',
  },
  headerRightIcons: {
    position: 'absolute',
    right: 16,
    flexDirection: 'row',
    alignItems: 'center',
  },
  headerIconButton: {
    marginLeft: 8,
    padding: 8,
  },
  body: {
    flex: 1,
    paddingHorizontal: width * 0.01,
    paddingTop: width * 0.06,
  },
  sectionTitle: {
    fontSize: width * 0.05,
    color: '#025383',
    fontWeight: '700',
    textAlign: 'center',
    marginBottom: width * 0.05,
  },
  topButtonRow: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginBottom: width * 0.04,
  },
  bigButton: {
    flex: 1,
    backgroundColor: '#015185',
    borderRadius: 6,
    marginHorizontal: width * 0.02,
    paddingVertical: width * 0.05,
    alignItems: 'center',
    justifyContent: 'center',
    elevation: 4,
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.2,
    shadowRadius: 3,
  },
  singleButtonRow: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginBottom: width * 0.05,
  },
  singleButton: {
    width: '96%', // Match the total width of the two buttons above
    backgroundColor: '#015185',
    borderRadius: 6,
    paddingVertical: width * 0.05,
    alignItems: 'center',
    justifyContent: 'center',
    elevation: 4,
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.2,
    shadowRadius: 3,
  },
  bigButtonText: {
    color: '#fff',
    fontSize: width * 0.045,
    fontWeight: '600',
    textAlign: 'center',
  },
  divider: {
    height: 1.5,
    backgroundColor: '#d1d5db',
    marginVertical: width * 0.05,
    width: '100%',
    alignSelf: 'center',
  },
  gridRow: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginBottom: width * 0.04,
  },
  gridButton: {
    flex: 1,
    backgroundColor: '#015185',
    borderRadius: 6,
    marginHorizontal: width * 0.01,
    paddingVertical: width * 0.05,
    paddingHorizontal: width * 0.02,
    alignItems: 'center',
    justifyContent: 'center',
    elevation: 4,
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.2,
    shadowRadius: 3,
  },
  gridButtonText: {
    color: '#fff',
    fontSize: width * 0.035,
    fontWeight: '600',
    textAlign: 'center',
    lineHeight: width * 0.05, // Improve readability for multiline text
  },
});

export default HRReportingHome;