/**
 * Filters equipment array by user permissions, country, and createdBy.
 * @param {Array} equipmentArr - Array of equipment objects
 * @param {Object} userInfoObj - User info object with permissions, countries, userUid
 * @returns {Array} Filtered equipment array
 */
export function filterEquipmentByPermission(equipmentArr, userInfoObj) {
  if (!equipmentArr || !userInfoObj) return [];

  if (userInfoObj.equipmentPermissions?.includes('onlyMineView')) {
    const creatorIdentifier = userInfoObj.userUid;
    return equipmentArr
      .filter(
        (item) =>
          (item.createdBy === creatorIdentifier || !item.createdBy) &&
          userInfoObj.countries.includes(item.country)
      )
      .map((item) => ({
        ...item,
        createdBy: item.createdBy || userInfoObj.userUid,
        equipmentName: item.equipmentName
          ? item.equipmentName.charAt(0).toUpperCase() + item.equipmentName.slice(1).toLowerCase()
          : item.equipmentName,
      }));
  } else if (userInfoObj.equipmentPermissions?.includes('view')) {
    return equipmentArr
      .filter((item) => userInfoObj.countries.includes(item.country))
      .map((item) => ({
        ...item,
        equipmentName: item.equipmentName
          ? item.equipmentName.charAt(0).toUpperCase() + item.equipmentName.slice(1).toLowerCase()
          : item.equipmentName,
      }));
  } else {
    return [];
  }
} 