import { View, Text, TextInput, TouchableOpacity, Image, StyleSheet, Platform } from 'react-native';
import React, { useState, useRef } from 'react';
import { useNavigation } from '@react-navigation/native';
import LinearGradient from 'react-native-linear-gradient';
import { SafeAreaView } from 'react-native-safe-area-context';

const OTP_Verification = () => {
    const navigation = useNavigation();
    const [otp, setOtp] = useState(['', '', '', '', '', '']);
    // Create refs for OTP inputs
    const otpRefs = useRef(otp.map(() => React.createRef()));

    const handleOTP = () => {
        navigation.navigate('Resetpassword');
    };

    const handleResendOtp = () => {
        console.log('handleResendOtp');
    }

    const handleOtpChange = (text, index) => {
        const newOtp = [...otp];
        newOtp[index] = text;
        setOtp(newOtp);

        // Auto-focus logic
        if (text && index < 5) {
            otpRefs.current[index + 1].current.focus();
        }
        if (!text && index > 0) {
            otpRefs.current[index - 1].current.focus();
        }
    };

    return (
        <View style={styles.container}>
    <LinearGradient
        colors={['#015185', '#3481BC']}
        style={styles.gradient}
        start={{ x: 0, y: 0 }}
        end={{ x: 1, y: 0 }}
    >
        <SafeAreaView edges={['top']} style={styles.headerSafeArea}>
            <View style={styles.headerContent}>
                <TouchableOpacity onPress={() => navigation.goBack()} style={styles.backButton}>
                    <Image
                        source={require('../../../Images/adminlogin/back.png')}
                        style={styles.backIcon}
                    />
                </TouchableOpacity>
                <View style={styles.headerTextContainer}>
                    <Text style={styles.welcomeText}>OTP Verification</Text>
                    <Text style={styles.subHeaderText}>
                        Please enter the 6-digit verification code sent on +1(544)-*********-5222.
                    </Text>
                </View>
            </View>
        </SafeAreaView>
    </LinearGradient>

    {/* OTP Input Centered */}
    <View style={styles.centerContainer}>
        <View style={styles.otpContainer}>
            {otp.map((digit, index) => (
                <TextInput
                    key={index}
                    ref={otpRefs.current[index]}
                    style={styles.otpInput}
                    value={digit}
                    onChangeText={(text) => handleOtpChange(text, index)}
                    keyboardType="numeric"
                    maxLength={1}
                    placeholder="0"
                    placeholderTextColor="#999"
                />
            ))}
        </View>
        
        {/* Resend OTP Text */}
        <TouchableOpacity onPress={handleResendOtp}>
            <Text style={styles.resendText}>Don't receive the OTP? <Text style={styles.resendNow}>Resend now</Text></Text>
        </TouchableOpacity>
    </View>

    {/* Proceed Button Fixed at Bottom */}
    <SafeAreaView edges={['bottom']} style={styles.buttonContainer}>
        <LinearGradient
            colors={['#015185', '#3481BC']}
            start={{ x: 0, y: 0 }}
            end={{ x: 1, y: 0 }}
            style={styles.googleButtonGradient}
        >
            <TouchableOpacity style={styles.googleButton} onPress={handleOTP}>
                <Text style={styles.googleButtonText}>Proceed</Text>
            </TouchableOpacity>
        </LinearGradient>
    </SafeAreaView>
</View>

    
    );
};

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: '#fff',
        justifyContent: 'space-between', 
    },
    gradient: {
        width: '100%',
    },
    headerSafeArea: {
        paddingTop: Platform.OS === 'ios' ? 0 : 30,
    },
    headerContent: {
        paddingHorizontal: 30,
        paddingBottom: 15,
    },
    backButton: {
        marginTop: 10,
        marginBottom: 20,
    },
    backIcon: {
        width: 24,
        height: 24,
        tintColor: '#fff',
    },
    welcomeText: {
        fontSize: 24,
        fontWeight: 'bold',
        color: '#fff',
        marginBottom: 5,
    },
    subHeaderText: {
        fontSize: 16,
        color: '#fff',
    },
    centerContainer: {
        flex: 1, 
        justifyContent: 'center', 
        alignItems: 'center',
    },
    otpContainer: {
        flexDirection: 'row',
        justifyContent: 'center',
        marginBottom: 15,
    },
    otpInput: {
        width: 50,
        height: 50,
        borderWidth: 1,
        borderColor: '#ddd',
        borderRadius: 8,
        textAlign: 'center',
        fontSize: 20,
        color: '#333',
        marginHorizontal: 5,
    },
    resendText: {
        fontSize: 14,
        color: '#666',
        marginTop: 10,
    },
    resendNow: {
        fontWeight: 'bold',
        color: '#015185',
    },
    buttonContainer: {
        position: 'absolute',
        bottom: 30,
        left: 0,
        right: 0,
        alignItems: 'center',
    },
    googleButtonGradient: {
        borderRadius: 8,
        width: '80%',
    },
    googleButton: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'center',
        height: 50,
        borderRadius: 8,
        paddingHorizontal: 15,
    },
    googleButtonText: {
        color: '#fff',
        fontSize: 16,
        fontWeight: 'bold',
    }
});



export default OTP_Verification;