import React from 'react';
import {
  View,
  Text,
  StyleSheet,
  StatusBar,
  TouchableOpacity,
  Image,
} from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';

const TeamMainheader = ({ navigation }) => {
  const TOTAL_HEADER_HEIGHT = 90; // Total height including status bar

  return (
    <View style={styles.container}>
      {/* Single Gradient for Status Bar and Header */}
      <LinearGradient
        colors={['#3481BC', '#025383']} // Single gradient across entire header
        style={[styles.header, { height: TOTAL_HEADER_HEIGHT }]}>
        {/* Status Bar */}
        <StatusBar
          translucent
          backgroundColor="transparent" // Transparent to show gradient
          barStyle="light-content" // White icons/text for contrast
        />

        {/* Header Content */}
        <View style={styles.headerContent}>
          {/* Left: Logo */}
          <TouchableOpacity  onPress={() => navigation.toggleDrawer()}>
            <Image
              source={require('../../Images/adminhome/homeheadlogo.png')} // Replace with your logo path
              style={styles.logo} 
            />
          </TouchableOpacity>

          {/* Right: Bell Icon and Menu Icon */}
          <View style={styles.rightContainer}>
            <TouchableOpacity onPress={() => alert('Bell clicked')}>
              <MaterialIcons name="notifications" size={24} color="white" style={styles.icon} />
            </TouchableOpacity>
            <TouchableOpacity onPress={() => navigation.toggleDrawer()}>
              {/* <MaterialIcons name="menu" size={24} color="white" style={styles.icon} /> */}

              <Image
              source={require('../../Images/adminhome/menuicon.png')} // Replace with your logo path
              style={styles.logomenu} 
            />
            </TouchableOpacity>
          </View>
        </View>
      </LinearGradient>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    width: '100%',
  },
  header: {
    width: '100%',
  },
  headerContent: {
    flex: 1, // Takes up the full height minus status bar padding
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 15,
    paddingTop: StatusBar.currentHeight || 44, // Ensures content starts below status bar
  },
  logo: {
    width: 100,
    height: 80,
    resizeMode: 'contain',
  },
  rightContainer: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  icon: {
    marginLeft: 15, // Space between bell and menu icons
  },

  logomenu:{
    width: 20,
    height: 30,
    resizeMode: 'contain',
    marginLeft:20
  }
});

export default TeamMainheader;