@extends('welcome')

@section('title', 'Incident Report')

@section('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
@endsection

@section('content')
<div class="incident-container abc" role="main">
    <!-- Header -->
    <div class="header-gradient">
        <div class="header-content">
            <div class="header-left">
                <a href="javascript:history.back()" class="back-button">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h1 class="header-title">Incident Report</h1>
            </div>
            <div class="header-right">
                <div class="search-container">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="search-icon">
                        <circle cx="11" cy="11" r="8"/>
                        <path d="M21 21l-4.35-4.35"/>
                    </svg>
                    <input type="text" class="search-input" placeholder="Search incidents..." id="searchInput">
                </div>
                <a href="/inspection/create-incident-report" class="create-btn">
                    <i class="fas fa-plus"></i>
                    Create Incident
                </a>
            </div>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <section class="table-section" role="region" aria-label="Incident reports table">
            <div class="table-container">
                <div id="tableLoader" class="table-loader" aria-live="polite" aria-busy="true" style="display: none;">
                    <div class="table-loader-content">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <p class="loader-text">Fetching incident reports...</p>
                    </div>
                </div>
                <table class="incident-table" id="incidentTable" role="table" aria-label="Incident reports">
                    <thead>
                        <tr role="row">
                            <th scope="col" role="columnheader">S.No</th>
                            <th scope="col" role="columnheader">Action</th>
                            <th scope="col" role="columnheader">Incident Number</th>
                            <th scope="col" role="columnheader">Incident Date</th>
                            <th scope="col" role="columnheader">Incident Time</th>
                            <th scope="col" role="columnheader">Project</th>
                            <th scope="col" role="columnheader">Category</th>
                            <th scope="col" role="columnheader">Severity</th>
                            <th scope="col" role="columnheader">Vehicle</th>
                            <th scope="col" role="columnheader">Location</th>
                            <th scope="col" role="columnheader">Reported By</th>
                        </tr>
                    </thead>
                    <tbody id="incidentTableBody" role="rowgroup">
                        <!-- Data will be populated dynamically -->
                    </tbody>
                </table>
            </div>

            <div id="pdfViewerModal" class="pdf-modal" role="dialog" aria-modal="true" aria-labelledby="pdfModalTitle" style="display: none;">
                <div class="pdf-modal-content">
                    <div class="pdf-modal-header">
                        <h3 id="pdfModalTitle">Incident Report PDF</h3>
                        <button type="button" class="pdf-close-btn" aria-label="Close PDF preview" onclick="closeIncidentPdfModal()">&times;</button>
                    </div>
                    <div class="pdf-modal-body">
                        <iframe id="pdfIframe" title="Incident report PDF preview"></iframe>
                    </div>
                    <div class="pdf-modal-footer">
                        <button type="button" id="pdfDownloadBtn" class="btn-download-pdf">
                            <i class="fas fa-download"></i>
                            <span id="pdfDownloadLabel">Download PDF</span>
                        </button>
                        <button type="button" class="btn-close-pdf" onclick="closeIncidentPdfModal()">Close</button>
                    </div>
                </div>
            </div>

        <!-- Pagination Section -->
        <div class="pagination-section" id="paginationSection" style="display: none;">
            <div class="pagination-container">
                <div class="pagination-info">
                    <span id="paginationInfo">Showing 1-10 of 0 entries</span>
                </div>
                <div class="pagination-controls">
                    <button class="pagination-btn pagination-first" onclick="goToPage(1)" title="First Page">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M11 17l-5-5 5-5"></path>
                            <path d="M18 17l-5-5 5-5"></path>
                        </svg>
                    </button>
                    <button class="pagination-btn pagination-prev" onclick="goToPage(paginationState.currentPage - 1)" title="Previous Page">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15 18l-6-6 6-6"></path>
                        </svg>
                    </button>

                    <div class="pagination-pages" id="paginationPages">
                        <!-- Page numbers will be inserted here -->
                    </div>

                    <button class="pagination-btn pagination-next" onclick="goToPage(paginationState.currentPage + 1)" title="Next Page">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M9 18l6-6-6-6"></path>
                        </svg>
                    </button>
                    <button class="pagination-btn pagination-last" onclick="goToPage(paginationState.totalPages)" title="Last Page">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M13 17l5-5-5-5"></path>
                            <path d="M6 17l5-5-5-5"></path>
                        </svg>
                    </button>
                </div>
            </div>
            </div>
        </section>
    </div>

<!-- Sorting Modal -->
<div class="modal fade" id="sortingModal" tabindex="-1" aria-labelledby="sortingModalLabel" aria-hidden="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sortingModalLabel">Sorting Options</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close modal"></button>
            </div>
            <div class="modal-body">
                <form id="sortingForm" role="form" novalidate>
                    <div class="sort-section">
                        <h6 class="section-title">Sort Order</h6>
                        <div class="radio-group">
                            <div class="radio-item">
                                <input type="radio" id="ascending" name="sortOrder" value="ascending" checked>
                                <label for="ascending">
                                    <span class="radio-custom"></span>
                                    Ascending
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="descending" name="sortOrder" value="descending">
                                <label for="descending">
                                    <span class="radio-custom"></span>
                                    Descending
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="sort-section">
                        <h6 class="section-title">Sort By</h6>
                        <div class="radio-group">
                            <div class="radio-item">
                                <input type="radio" id="serialNumber" name="sortBy" value="serialNumber" checked>
                                <label for="serialNumber">
                                    <span class="radio-custom"></span>
                                    S.No
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="incidentNumber" name="sortBy" value="incidentNumber">
                                <label for="incidentNumber">
                                    <span class="radio-custom"></span>
                                    Incident Number
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="incidentDate" name="sortBy" value="incidentDate">
                                <label for="incidentDate">
                                    <span class="radio-custom"></span>
                                    Incident Date
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="project" name="sortBy" value="project">
                                <label for="project">
                                    <span class="radio-custom"></span>
                                    Project
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="incidentCategory" name="sortBy" value="incidentCategory">
                                <label for="incidentCategory">
                                    <span class="radio-custom"></span>
                                    Category
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="severity" name="sortBy" value="severity">
                                <label for="severity">
                                    <span class="radio-custom"></span>
                                    Severity
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="vehicleNumber" name="sortBy" value="vehicleNumber">
                                <label for="vehicleNumber">
                                    <span class="radio-custom"></span>
                                    Vehicle Number
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="vehicleName" name="sortBy" value="vehicleName">
                                <label for="vehicleName">
                                    <span class="radio-custom"></span>
                                    Vehicle Name
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="location" name="sortBy" value="location">
                                <label for="location">
                                    <span class="radio-custom"></span>
                                    Location
                                </label>
                            </div>
                            <div class="radio-item">
                                <input type="radio" id="reportedBy" name="sortBy" value="reportedBy">
                                <label for="reportedBy">
                                    <span class="radio-custom"></span>
                                    Reported By
                                </label>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn-reset" onclick="resetSorting()">Reset</button>
                <button type="button" class="btn-apply" onclick="applySorting()">Apply</button>
            </div>
        </div>
    </div>
</div>

<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* CSS Variables for consistent theming */
:root {
    --primary-color: #0055a5;
    --primary-hover: #003d7a;
    --secondary-color: #3b82f6;
    --secondary-hover: #2563eb;
    --success-color: #10b981;
    --success-hover: #059669;
    --warning-color: #f59e0b;
    --warning-hover: #d97706;
    --info-color: #ffd205;
    --info-hover: #fbbf24;
    --text-primary: #0f172a;
    --text-secondary: #374151;
    --text-muted: #64748b;
    --text-light: #9ca3af;
    --bg-primary: #f8fafc;
    --bg-secondary: #f1f5f9;
    --bg-white: #ffffff;
    --bg-hover: rgba(59, 130, 246, 0.05);
    --border-color: #e2e8f0;
    --border-light: #d1d5db;
    --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    --shadow-md: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    --shadow-lg: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    --radius-sm: 0;
    --radius-md: 0;
    --radius-lg: 0;
    --transition-base: all 0.2s ease;
    --transition-slow: all 0.3s ease;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    --z-index-modal: 1050;
    --z-index-notification: 10000;
}

/* Main Container */
.incident-container {
    min-height: 100vh;
}

/* Header Styles */
.header-gradient {
    background: #0055a5;
    padding: 20px 0;
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.3);
}

.header-content {
    width: 100%;
    padding: 0 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 15px;
}

.back-button {
    color: white;
    font-size: 20px;
    text-decoration: none;
    padding: 8px;
    border-radius: 50%;
    transition: var(--transition-base);
}

.back-button:hover {
    background-color: rgba(255, 255, 255, 0.1);
    color: white;
}

.header-title {
    color: white;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.create-btn {
    background: white;
    color: var(--primary-color);
    border: none;
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-sm);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.create-btn:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
    color: var(--primary-color);
    text-decoration: none;
}

/* Search Container */
.search-container {
    position: relative;
    display: flex;
    align-items: center;
}

.search-icon {
    position: absolute;
    left: 12px;
    color: #9ca3af;
    z-index: 1;
}

.search-input {
    padding: 10px 12px 10px 40px;
    border: 1px solid #d1d5db;
    border-radius: var(--radius-md);
    font-size: 14px;
    font-weight: 400;
    color: #374151;
    background: white;
    width: 300px;
    transition: all 0.2s ease;
}

.search-input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.search-input::placeholder {
    color: #9ca3af;
}

/* Main Content */
.main-content {
    width: 100%;
    padding: 30px 20px;
    padding-bottom: 300px;
}

/* Action Buttons */
.action-buttons {
    display: flex;
    gap: 12px;
    align-items: center;
}

/* Base Button Styles */
.btn-primary, .btn-secondary, .btn-success, .btn-info {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: var(--radius-sm);
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    transition: var(--transition-base);
    cursor: pointer;
    box-shadow: var(--shadow-sm);
}

.btn-primary {
    background: var(--primary-color);
    color: var(--bg-white);
}

.btn-primary:hover {
    background: var(--primary-hover);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
    color: var(--bg-white);
}

.btn-secondary {
    background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
    color: var(--bg-white);
}

.btn-secondary:hover {
    background: linear-gradient(135deg, #4b5563 0%, #374151 100%);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
    color: var(--bg-white);
}

.btn-success {
    background: var(--success-color);
    color: var(--bg-white);
}

.btn-success:hover {
    background: var(--success-hover);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
    color: var(--bg-white);
}

.btn-info {
    background: var(--info-color);
    color: var(--bg-white);
}

.btn-info:hover {
    background: var(--info-hover);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
    color: var(--bg-white);
}

.btn-warning {
    background: #f59e0b;
    color: var(--bg-white);
    border: 1px solid #d97706;
}

.btn-warning:hover {
    background: #d97706;
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
    color: var(--bg-white);
}

/* Table Section */
.table-section {
    background: white;
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-md);
    border: 1px solid var(--border-light);
    overflow: hidden;
    margin-bottom: 24px;
}

.table-container {
    overflow-x: auto;
    overflow-y: auto;
    border-radius: var(--radius-md);
    border: 1px solid var(--border-light);
    position: relative;
    padding-bottom: 400px;
}

.incident-table {
    width: 100%;
    min-width: 1100px;
    border-collapse: collapse;
    font-size: 14px;
    background: white;
}

.incident-table thead {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
}

.incident-table th {
    padding: 16px 12px;
    text-align: left;
    font-weight: 600;
    color: #374151;
    border-bottom: 1px solid #e2e8f0;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    white-space: nowrap;
}

.incident-table td {
    padding: 16px 12px;
    border-bottom: 1px solid #f1f5f9;
    vertical-align: middle;
    white-space: nowrap;
}

.table-row:hover {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
}

/* Action Buttons in Table */
.action-buttons {
    display: flex;
    gap: 8px;
    align-items: center;
}

.dropdown .action-btn {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 12px;
    background: var(--primary-color);
    color: white;
    border: none;
    border-radius: var(--radius-sm);
    font-size: 12px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-sm);
}

.dropdown .action-btn svg {
    pointer-events: none;
}

.dropdown .action-btn:hover {
    background: rgba(0, 85, 165, 0.85);
    transform: translateY(-1px);
    box-shadow: var(--shadow-sm);
    color: white;
}

.dropdown-menu {
    background: white;
    border: 1px solid var(--border-color);
    box-shadow: var(--shadow-md);
    border-radius: var(--radius-sm);
    padding: 8px 0;
    min-width: 200px;
    z-index: 1000;
}

.dropdown-item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 16px;
    color: var(--text-primary);
    text-decoration: none;
    font-size: 13px;
    font-weight: 400;
    transition: var(--transition-base);
    border-radius: var(--radius-sm);
}

.dropdown-item:hover {
    background: var(--bg-light);
    color: var(--text-primary);
    transform: translateX(4px);
}

.dropdown-item.danger {
    color: #dc2626;
}

.dropdown-item.danger:hover {
    background: #fef2f2;
    color: #b91c1c;
}

.dropdown-divider {
    height: 1px;
    background: var(--border-color);
    margin: 8px 0;
}

/* Table Cell Styling */
.serial-number {
    font-weight: 600;
    color: #1e293b;
    font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
    font-size: 13px;
    text-align: center;
}

.serial-cell {
    text-align: center;
    width: 60px;
}

.incident-id {
    font-weight: 600;
    color: #1e293b;
    font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
    font-size: 13px;
}

/* New column styles */
.project-cell {
    max-width: 120px;
}

.project-name {
    font-weight: 500;
    color: #1e293b;
    font-size: 13px;
}

.category-cell {
    max-width: 100px;
}

.incident-category {
    font-weight: 500;
    color: #374151;
    font-size: 12px;
}

.severity-cell {
    max-width: 80px;
}

.severity-badge {
    display: inline-block;
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.severity-high {
    background: #fef2f2;
    color: #dc2626;
    border: 1px solid #fecaca;
}

.severity-medium {
    background: #fffbeb;
    color: #d97706;
    border: 1px solid #fed7aa;
}

.severity-low {
    background: #f0fdf4;
    color: #16a34a;
    border: 1px solid #bbf7d0;
}

.severity-critical {
    background: #7f1d1d;
    color: #ffffff;
    border: 1px solid #991b1b;
}

.severity-undefined {
    background: #f3f4f6;
    color: #6b7280;
    border: 1px solid #d1d5db;
}

.vehicle-info {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.vehicle-number {
    font-weight: 600;
    color: #1e293b;
    font-size: 14px;
}

.vehicle-name {
    font-size: 12px;
    color: #64748b;
    font-weight: 400;
}

.download-btn {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    text-decoration: none;
    border-radius: 0;
    font-size: 12px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.download-btn:hover {
    background: linear-gradient(135deg, #059669 0%, #047857 100%);
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    color: white;
}

.no-pdf {
    color: #64748b;
    font-weight: 400;
    font-size: 13px;
}

/* No Data Styling */
.no-data-cell {
    padding: 64px 24px !important;
    text-align: center;
}

.no-data-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 16px;
}

.no-data-content svg {
    color: #9ca3af;
}

.table-loader {
    position: absolute;
    inset: 0;
    background: rgba(255, 255, 255, 0.9);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10;
    flex-direction: column;
    gap: 12px;
}

.table-loader-content {
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
}

.loader-text {
    margin: 0;
    font-size: 14px;
    color: var(--text-secondary);
}

.table-loading-state {
    opacity: 0.4;
    pointer-events: none;
}

.spinner-border {
    width: 3rem;
    height: 3rem;
    color: var(--primary-color);
}

.pdf-modal {
    display: none;
    position: fixed;
    z-index: 10000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.8);
    justify-content: center;
    align-items: flex-start;
    padding-top: 30px;
    animation: fadeIn 0.3s ease;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

.pdf-modal-content {
    background-color: #fff;
    width: 90%;
    height: 90%;
    max-width: 1200px;
    max-height: 90vh;
    border-radius: 12px;
    display: flex;
    flex-direction: column;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
    animation: slideUp 0.3s ease;
}

@keyframes slideUp {
    from {
        transform: translateY(50px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

.pdf-modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px 24px;
    background: linear-gradient(135deg, #0055a5, #003d7a);
    color: white;
    border-radius: 12px 12px 0 0;
}

.pdf-modal-header h3 {
    margin: 0;
    font-size: 1.3rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 10px;
}

.pdf-close-btn {
    background: rgba(255, 255, 255, 0.2);
    border: none;
    color: white;
    font-size: 2rem;
    cursor: pointer;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    line-height: 1;
}

.pdf-close-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: rotate(90deg);
}

.pdf-modal-body {
    flex: 1;
    padding: 0;
    overflow: hidden;
    background-color: #f5f5f5;
}

.pdf-modal-body iframe {
    width: 100%;
    height: 100%;
    border: none;
}

.pdf-modal-footer {
    display: flex;
    justify-content: center;
    gap: 15px;
    padding: 20px;
    background-color: #f8f9fa;
    border-radius: 0 0 12px 12px;
    border-top: 1px solid #e0e0e0;
}

.btn-download-pdf,
.btn-close-pdf {
    padding: 12px 30px;
    font-size: 1rem;
    font-weight: 600;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-download-pdf {
    background: linear-gradient(135deg, #00B894, #00A082);
    color: white;
}

.btn-download-pdf:hover {
    background: linear-gradient(135deg, #00A082, #008f72);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 184, 148, 0.3);
}

.btn-close-pdf {
    background: #545d6b;
    color: white;
}

.btn-close-pdf:hover {
    background: #3d444f;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(84, 93, 107, 0.3);
}

@media (max-width: 768px) {
    .pdf-modal {
        padding-top: 60px;
    }
    
    .pdf-modal-content {
        width: 95%;
        height: 95%;
    }
    
    .pdf-modal-header h3 {
        font-size: 1.1rem;
    }
    
    .pdf-modal-footer {
        flex-direction: column;
    }
    
    .btn-download-pdf,
    .btn-close-pdf {
        width: 100%;
        justify-content: center;
    }
}

.no-data-content h3 {
    color: #374151;
    font-weight: 600;
    font-size: 18px;
    margin: 0;
}

.no-data-content p {
    color: #6b7280;
    font-weight: 400;
    font-size: 14px;
    margin: 0;
    max-width: 400px;
}

/* Modal Styling */
.modal-content {
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    z-index: 1000222;
}

.modal-header {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border-bottom: 1px solid #e2e8f0;
    padding: 20px 24px;
}

.modal-title {
    color: #0f172a;
    font-weight: 600;
    font-size: 18px;
    margin: 0;
}

.btn-close {
    background: none;
    border: none;
    font-size: 24px;
    color: #64748b;
    opacity: 1;
    transition: all 0.2s ease;
}

.btn-close:hover {
    color: #374151;
    transform: scale(1.1);
}

.modal-body {
    padding: 24px;
}

.sort-section {
    margin-bottom: 24px;
}

.section-title {
    color: #374151;
    font-weight: 600;
    font-size: 14px;
    margin-bottom: 12px;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.radio-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.radio-item {
    display: flex;
    align-items: center;
    gap: 12px;
}

.radio-item input[type="radio"] {
    display: none;
}

.radio-item label {
    display: flex;
    align-items: center;
    gap: 12px;
    cursor: pointer;
    font-size: 14px;
    font-weight: 400;
    color: #374151;
    transition: all 0.2s ease;
}

.radio-custom {
    width: 18px;
    height: 18px;
    border: 2px solid #d1d5db;
    border-radius: 50%;
    position: relative;
    transition: all 0.2s ease;
}

.radio-item input[type="radio"]:checked + label .radio-custom {
    border-color: #3b82f6;
    background: #3b82f6;
}

.radio-item input[type="radio"]:checked + label .radio-custom::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 6px;
    height: 6px;
    background: white;
    border-radius: 50%;
}

.radio-item label:hover {
    color: #1e293b;
}

.radio-item label:hover .radio-custom {
    border-color: #3b82f6;
}

.modal-footer {
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
    padding: 16px 24px;
    display: flex;
    gap: 12px;
    justify-content: flex-end;
}

.btn-cancel, .btn-reset, .btn-apply {
    padding: 10px 20px;
    border: none;
    border-radius: 0;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-cancel {
    background: #f3f4f6;
    color: #374151;
}

.btn-cancel:hover {
    background: #e5e7eb;
    color: #1f2937;
}

.btn-reset {
    background: #fef3c7;
    color: #92400e;
}

.btn-reset:hover {
    background: #fde68a;
    color: #78350f;
}

.btn-apply {
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: white;
}

.btn-apply:hover {
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* Pagination Styles */
.pagination-section {
    background: var(--bg-white);
    border: 1px solid var(--border-color);
    border-top: none;
    border-radius: 0 0 var(--radius-sm) var(--radius-sm);
    padding: 16px 24px;
}

.pagination-container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 16px;
}

.pagination-info {
    color: var(--text-secondary);
    font-size: 14px;
    font-weight: 400;
}

.pagination-controls {
    display: flex;
    align-items: center;
    gap: 4px;
}

.pagination-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
    border: 1px solid var(--border-light);
    background: var(--bg-white);
    color: var(--text-secondary);
    border-radius: var(--radius-sm);
    cursor: pointer;
    transition: var(--transition-base);
    font-size: 14px;
    font-weight: 500;
}

.pagination-btn:hover:not(:disabled) {
    background: var(--bg-hover);
    border-color: var(--secondary-color);
    color: var(--secondary-color);
}

.pagination-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
    background: var(--bg-secondary);
}

.pagination-btn svg {
    width: 16px;
    height: 16px;
}

.pagination-pages {
    display: flex;
    align-items: center;
    gap: 2px;
    margin: 0 8px;
}

.pagination-page {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 36px;
    height: 36px;
    padding: 0 8px;
    border: 1px solid var(--border-light);
    background: var(--bg-white);
    color: var(--text-secondary);
    border-radius: var(--radius-sm);
    cursor: pointer;
    transition: var(--transition-base);
    font-size: 14px;
    font-weight: 500;
}

.pagination-page:hover {
    background: var(--bg-hover);
    border-color: var(--secondary-color);
    color: var(--secondary-color);
}

.pagination-page.active {
    background: var(--secondary-color);
    border-color: var(--secondary-color);
    color: var(--bg-white);
}

.pagination-ellipsis {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
    color: var(--text-muted);
    font-size: 14px;
    user-select: none;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .main-content {
        padding: 20px;
    }
    
    .header-content {
        padding: 0 15px;
    }
    
    .header-title {
        font-size: 24px;
    }
    
    .search-input {
        width: 250px;
    }
}

@media (max-width: 768px) {
    .header-content {
        padding: 0 15px;
        flex-direction: column;
        gap: 15px;
        align-items: stretch;
    }
    
    .header-left {
        justify-content: center;
    }
    
    .header-right {
        justify-content: center;
        flex-direction: column;
        gap: 10px;
    }
    
    .search-input {
        width: 100%;
        max-width: 400px;
    }
    
    .create-btn {
        width: 100%;
        justify-content: center;
    }
    
    .main-content {
        padding: 15px;
    }
}

@media (max-width: 992px) {
    .incident-container {
        padding: 16px;
    }
    
    .header-content {
        padding: 20px;
        flex-direction: column;
        align-items: stretch;
        gap: 20px;
    }
    
    .page-title h1 {
        font-size: 28px;
    }
    
    .page-title p {
        font-size: 15px;
    }
    
    .header-actions {
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 16px;
    }
    
    .search-input {
        width: 100%;
        max-width: 300px;
    }
    
    .action-buttons {
        flex-wrap: wrap;
    }
    
    .btn-primary, .btn-secondary, .btn-success, .btn-info, .btn-warning {
        padding: 11px 18px;
        font-size: 14px;
    }
    
    .table-section {
        margin-bottom: 18px;
    }
    
    .incident-table {
        font-size: 13px;
    }
    
    .serial-cell {
        width: 50px;
        min-width: 50px;
        padding: 14px 8px !important;
    }

    .serial-cell {
        width: 50px;
        min-width: 50px;
        padding: 14px 8px !important;
    }

    .project-cell {
        max-width: 100px;
        padding: 14px 6px !important;
    }

    .category-cell {
        max-width: 80px;
        padding: 14px 4px !important;
    }

    .severity-cell {
        max-width: 70px;
        padding: 14px 4px !important;
    }

    .incident-table th,
    .incident-table td {
        padding: 14px 10px;
    }
    
    .modal-dialog {
        margin: 1rem;
        max-width: calc(100% - 2rem);
    }
    
    .modal-body {
        padding: 20px;
    }
    
    .modal-footer {
        padding: 16px 20px;
        flex-direction: column;
        gap: 8px;
    }
    
    .btn-cancel, .btn-reset, .btn-apply {
        width: 100%;
        justify-content: center;
    }
}

@media (max-width: 768px) {
    .incident-container {
        padding: 0;
    }
    
    .incident-header {
        margin: 0 16px 16px 16px;
    }
    
    .header-content {
        padding: 16px;
        gap: 16px;
    }
    
    .page-title h1 {
        font-size: 24px;
        margin-bottom: 6px;
    }
    
    .page-title p {
        font-size: 14px;
    }
    
    .header-actions {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
    }
    
    .search-container {
        width: 100%;
    }
    
    .search-input {
        width: 100%;
        padding: 12px 16px 12px 44px;
        font-size: 16px;
        min-height: 48px;
    }
    
    .action-buttons {
        justify-content: center;
        flex-wrap: wrap;
        gap: 8px;
    }
    
    .btn-primary, .btn-secondary, .btn-success, .btn-info, .btn-warning {
        flex: 1;
        justify-content: center;
        min-width: 140px;
        padding: 12px 16px;
        font-size: 14px;
        min-height: 48px;
    }
    
    .table-section {
        margin: 0 16px 16px 16px;
    }
    
    .table-container {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        border: 1px solid #e2e8f0;
    }
    
    .incident-table {
        min-width: 1200px;
        font-size: 12px;
    }
    
    .serial-cell {
        width: 45px;
        min-width: 45px;
        padding: 12px 6px !important;
    }

    .project-cell {
        max-width: 80px;
        padding: 12px 4px !important;
    }

    .category-cell {
        max-width: 70px;
        padding: 12px 3px !important;
    }

    .severity-cell {
        max-width: 60px;
        padding: 12px 3px !important;
    }

    .incident-table th,
    .incident-table td {
        padding: 12px 8px;
        white-space: nowrap;
    }
    
    .incident-table th {
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        background-color: #f8fafc;
    }
    
    .action-buttons {
        gap: 6px;
    }
    
    .action-btn {
        padding: 8px;
        min-width: 36px;
        min-height: 36px;
    }
    
    .action-btn svg {
        width: 12px;
        height: 12px;
    }
    
    .vehicle-info {
        gap: 2px;
    }
    
    .vehicle-number {
        font-size: 13px;
    }
    
    .vehicle-name {
        font-size: 11px;
    }
    
    .download-btn {
        padding: 4px 8px;
        font-size: 11px;
        min-height: 32px;
    }
    
    .download-btn svg {
        width: 12px;
        height: 12px;
    }
    
    .no-pdf {
        font-size: 11px;
    }
    
    .loading-cell {
        padding: 48px 16px !important;
    }
    
    .spinner {
        width: 28px;
        height: 28px;
        border-width: 2px;
    }
    
    .loading-content span {
        font-size: 13px;
    }
    
    .no-data-cell {
        padding: 48px 16px !important;
    }
    
    .no-data-content svg {
        width: 40px;
        height: 40px;
    }
    
    .no-data-content h3 {
        font-size: 16px;
    }
    
    .no-data-content p {
        font-size: 13px;
        max-width: 300px;
    }
    
    .modal-dialog {
        margin: 0.5rem;
        max-width: calc(100% - 1rem);
    }
    
    .modal-header {
        padding: 16px;
    }
    
    .modal-title {
        font-size: 16px;
    }
    
    .modal-body {
        padding: 16px;
    }
    
    .sort-section {
        margin-bottom: 20px;
    }
    
    .section-title {
        font-size: 13px;
        margin-bottom: 10px;
    }
    
    .radio-group {
        gap: 6px;
    }
    
    .radio-item {
        gap: 10px;
    }
    
    .radio-item label {
        font-size: 13px;
    }
    
    .radio-custom {
        width: 16px;
        height: 16px;
    }
    
    .radio-item input[type="radio"]:checked + label .radio-custom::after {
        width: 5px;
        height: 5px;
    }
    
    .modal-footer {
        padding: 12px 16px;
        flex-direction: column;
        gap: 8px;
    }
    
    .btn-cancel, .btn-reset, .btn-apply {
        width: 100%;
        justify-content: center;
        padding: 12px 16px;
        font-size: 14px;
        min-height: 48px;
    }

}

@media (max-width: 576px) {
    .incident-container {
        padding: 0;
    }
    
    .incident-header {
        margin: 0 12px 12px 12px;
    }
    
    .header-content {
        padding: 12px;
        gap: 12px;
    }
    
    .page-title h1 {
        font-size: 20px;
        margin-bottom: 4px;
    }
    
    .page-title p {
        font-size: 13px;
    }
    
    .search-input {
        padding: 10px 14px 10px 40px;
        font-size: 16px;
        min-height: 44px;
    }
    
    .search-icon {
        left: 14px;
        width: 14px;
        height: 14px;
    }
    
    .action-buttons {
        gap: 6px;
    }
    
    .btn-primary, .btn-secondary, .btn-success, .btn-info, .btn-warning {
        padding: 10px 12px;
        font-size: 13px;
        min-height: 44px;
        min-width: 120px;
    }
    
    .table-section {
        margin: 0 12px 12px 12px;
    }
    
    .incident-table {
        min-width: 1000px;
        font-size: 11px;
    }
    
    .serial-cell {
        width: 40px;
        min-width: 40px;
        padding: 10px 4px !important;
    }

    .project-cell {
        max-width: 70px;
        padding: 10px 3px !important;
    }

    .category-cell {
        max-width: 60px;
        padding: 10px 2px !important;
    }

    .severity-cell {
        max-width: 50px;
        padding: 10px 2px !important;
    }

    .incident-table th,
    .incident-table td {
        padding: 10px 6px;
    }
    
    .incident-table th {
        font-size: 10px;
    }
    
    .action-btn {
        padding: 6px;
        min-width: 32px;
        min-height: 32px;
    }
    
    .action-btn svg {
        width: 10px;
        height: 10px;
    }
    
    .vehicle-number {
        font-size: 12px;
    }
    
    .vehicle-name {
        font-size: 10px;
    }
    
    .download-btn {
        padding: 3px 6px;
        font-size: 10px;
        min-height: 28px;
    }
    
    .download-btn svg {
        width: 10px;
        height: 10px;
    }
    
    .no-pdf {
        font-size: 10px;
    }
    
    .loading-cell {
        padding: 40px 12px !important;
    }
    
    .spinner {
        width: 24px;
        height: 24px;
    }
    
    .loading-content span {
        font-size: 12px;
    }
    
    .no-data-cell {
        padding: 40px 12px !important;
    }
    
    .no-data-content svg {
        width: 36px;
        height: 36px;
    }
    
    .no-data-content h3 {
        font-size: 15px;
    }
    
    .no-data-content p {
        font-size: 12px;
        max-width: 250px;
    }
    
    .modal-dialog {
        margin: 0.25rem;
        max-width: calc(100% - 0.5rem);
    }
    
    .modal-header {
        padding: 12px;
    }
    
    .modal-title {
        font-size: 15px;
    }
    
    .modal-body {
        padding: 12px;
    }
    
    .sort-section {
        margin-bottom: 16px;
    }
    
    .section-title {
        font-size: 12px;
        margin-bottom: 8px;
    }
    
    .radio-group {
        gap: 4px;
    }
    
    .radio-item {
        gap: 8px;
    }
    
    .radio-item label {
        font-size: 12px;
    }
    
    .radio-custom {
        width: 14px;
        height: 14px;
    }
    
    .radio-item input[type="radio"]:checked + label .radio-custom::after {
        width: 4px;
        height: 4px;
    }
    
    .modal-footer {
        padding: 10px 12px;
    }
    
    .btn-cancel, .btn-reset, .btn-apply {
        padding: 10px 12px;
        font-size: 13px;
        min-height: 44px;
    }
}

@media (max-width: 480px) {
    .incident-header {
        margin: 0 8px 8px 8px;
    }
    
    .header-content {
        padding: 10px;
        gap: 10px;
    }
    
    .page-title h1 {
        font-size: 18px;
        margin-bottom: 3px;
    }
    
    .page-title p {
        font-size: 12px;
    }
    
    .search-input {
        padding: 8px 12px 8px 36px;
        font-size: 16px;
        min-height: 40px;
    }
    
    .search-icon {
        left: 12px;
        width: 12px;
        height: 12px;
    }
    
    .action-buttons {
        gap: 4px;
    }
    
    .btn-primary, .btn-secondary, .btn-success, .btn-info, .btn-warning {
        padding: 8px 10px;
        font-size: 12px;
        min-height: 40px;
        min-width: 100px;
    }
    
    .table-section {
        margin: 0 8px 8px 8px;
    }
    
    .incident-table {
        min-width: 900px;
        font-size: 10px;
    }
    
    .serial-cell {
        width: 35px;
        min-width: 35px;
        padding: 8px 3px !important;
    }

    .project-cell {
        max-width: 60px;
        padding: 8px 2px !important;
    }

    .category-cell {
        max-width: 50px;
        padding: 8px 2px !important;
    }

    .severity-cell {
        max-width: 45px;
        padding: 8px 2px !important;
    }

    .incident-table th,
    .incident-table td {
        padding: 8px 4px;
    }
    
    .incident-table th {
        font-size: 9px;
    }
    
    .action-btn {
        padding: 4px;
        min-width: 28px;
        min-height: 28px;
    }
    
    .action-btn svg {
        width: 8px;
        height: 8px;
    }
    
    .vehicle-number {
        font-size: 11px;
    }
    
    .vehicle-name {
        font-size: 9px;
    }
    
    .download-btn {
        padding: 2px 4px;
        font-size: 9px;
        min-height: 24px;
    }
    
    .download-btn svg {
        width: 8px;
        height: 8px;
    }
    
    .no-pdf {
        font-size: 9px;
    }
    
    .loading-cell {
        padding: 32px 8px !important;
    }
    
    .spinner {
        width: 20px;
        height: 20px;
    }
    
    .loading-content span {
        font-size: 11px;
    }
    
    .no-data-cell {
        padding: 32px 8px !important;
    }
    
    .no-data-content svg {
        width: 32px;
        height: 32px;
    }
    
    .no-data-content h3 {
        font-size: 14px;
    }
    
    .no-data-content p {
        font-size: 11px;
        max-width: 200px;
    }
    
    .modal-dialog {
        margin: 0.125rem;
        max-width: calc(100% - 0.25rem);
    }
    
    .modal-header {
        padding: 10px;
    }
    
    .modal-title {
        font-size: 14px;
    }
    
    .modal-body {
        padding: 10px;
    }
    
    .sort-section {
        margin-bottom: 12px;
    }
    
    .section-title {
        font-size: 11px;
        margin-bottom: 6px;
    }
    
    .radio-group {
        gap: 3px;
    }
    
    .radio-item {
        gap: 6px;
    }
    
    .radio-item label {
        font-size: 11px;
    }
    
    .radio-custom {
        width: 12px;
        height: 12px;
    }
    
    .radio-item input[type="radio"]:checked + label .radio-custom::after {
        width: 3px;
        height: 3px;
    }
    
    .modal-footer {
        padding: 8px 10px;
    }
    
    .btn-cancel, .btn-reset, .btn-apply {
        padding: 8px 10px;
        font-size: 12px;
        min-height: 40px;
    }
}

@media (max-width: 360px) {
    .incident-header {
        margin: 0 6px 6px 6px;
    }
    
    .header-content {
        padding: 8px;
        gap: 8px;
    }
    
    .page-title h1 {
        font-size: 16px;
        margin-bottom: 2px;
    }
    
    .page-title p {
        font-size: 11px;
    }
    
    .search-input {
        padding: 6px 10px 6px 32px;
        font-size: 16px;
        min-height: 36px;
    }
    
    .search-icon {
        left: 10px;
        width: 10px;
        height: 10px;
    }
    
    .action-buttons {
        gap: 3px;
    }
    
    .btn-primary, .btn-secondary, .btn-success, .btn-info, .btn-warning {
        padding: 6px 8px;
        font-size: 11px;
        min-height: 36px;
        min-width: 80px;
    }
    
    .table-section {
        margin: 0 6px 6px 6px;
    }
    
    .incident-table {
        min-width: 800px;
        font-size: 9px;
    }
    
    .serial-cell {
        width: 30px;
        min-width: 30px;
        padding: 6px 2px !important;
    }

    .project-cell {
        max-width: 50px;
        padding: 6px 2px !important;
    }

    .category-cell {
        max-width: 40px;
        padding: 6px 1px !important;
    }

    .severity-cell {
        max-width: 35px;
        padding: 6px 1px !important;
    }

    .incident-table th,
    .incident-table td {
        padding: 6px 3px;
    }
    
    .incident-table th {
        font-size: 8px;
    }
    
    .action-btn {
        padding: 3px;
        min-width: 24px;
        min-height: 24px;
    }
    
    .action-btn svg {
        width: 6px;
        height: 6px;
    }
    
    .vehicle-number {
        font-size: 10px;
    }
    
    .vehicle-name {
        font-size: 8px;
    }
    
    .download-btn {
        padding: 1px 3px;
        font-size: 8px;
        min-height: 20px;
    }
    
    .download-btn svg {
        width: 6px;
        height: 6px;
    }
    
    .no-pdf {
        font-size: 8px;
    }
    
    .loading-cell {
        padding: 24px 6px !important;
    }
    
    .spinner {
        width: 16px;
        height: 16px;
    }
    
    .loading-content span {
        font-size: 10px;
    }
    
    .no-data-cell {
        padding: 24px 6px !important;
    }
    
    .no-data-content svg {
        width: 28px;
        height: 28px;
    }
    
    .no-data-content h3 {
        font-size: 13px;
    }
    
    .no-data-content p {
        font-size: 10px;
        max-width: 150px;
    }
    
    .modal-dialog {
        margin: 0.0625rem;
        max-width: calc(100% - 0.125rem);
    }
    
    .modal-header {
        padding: 8px;
    }
    
    .modal-title {
        font-size: 13px;
    }
    
    .modal-body {
        padding: 8px;
    }
    
    .sort-section {
        margin-bottom: 10px;
    }
    
    .section-title {
        font-size: 10px;
        margin-bottom: 4px;
    }
    
    .radio-group {
        gap: 2px;
    }
    
    .radio-item {
        gap: 4px;
    }
    
    .radio-item label {
        font-size: 10px;
    }
    
    .radio-custom {
        width: 10px;
        height: 10px;
    }
    
    .radio-item input[type="radio"]:checked + label .radio-custom::after {
        width: 2px;
        height: 2px;
    }
    
    .modal-footer {
        padding: 6px 8px;
    }
    
    .btn-cancel, .btn-reset, .btn-apply {
        padding: 6px 8px;
        font-size: 11px;
        min-height: 36px;
    }
}

/* Accessibility and Focus Styles */
@media (prefers-reduced-motion: reduce) {
    * {
        transition: none !important;
        animation: none !important;
    }
}

.btn-primary:focus,
.btn-secondary:focus,
.btn-success:focus,
.btn-info:focus,
.btn-warning:focus,
.search-input:focus,
.action-btn:focus,
.btn-cancel:focus,
.btn-reset:focus,
.btn-apply:focus {
    outline: 2px solid var(--secondary-color);
    outline-offset: 2px;
}

/* Smooth animations */
* {
    transition: var(--transition-base);
}

/* Icon improvements */
.btn-primary svg,
.btn-secondary svg,
.btn-success svg,
.btn-info svg,
.action-btn svg {
    flex-shrink: 0;
}

/* Print styles */
@media print {
    .incident-container {
        background: white !important;
        padding: 0 !important;
    }
    
    .incident-header,
    .table-section {
        box-shadow: none !important;
        border: 1px solid #000 !important;
    }
    
    .btn-primary,
    .btn-secondary,
    .btn-success,
    .btn-info,
    .btn-warning,
    .action-btn {
        display: none !important;
    }
}

</style>

<script>
(function() {
    'use strict';
    
    // Configuration object
    const CONFIG = {
        selectors: {
            searchInput: '#searchInput',
            incidentTableBody: '#incidentTableBody',
            sortingModal: '#sortingModal',
            sortingForm: '#sortingForm',
            tableLoader: '#tableLoader',
            incidentTable: '#incidentTable'
        },
        messages: {
            loading: 'Loading incident reports...',
            noData: 'No Data Available',
            noDataDescription: 'No incident reports found. Start by creating a new incident report.',
            errorLoading: 'Error loading incident reports:',
            failedLoading: 'Failed to load incident reports',
            tryAgain: 'Please try again later',
            sortingApplied: 'Sorting applied successfully!',
            sortingReset: 'Sorting options reset!',
            dataRefreshed: 'Data refreshed successfully!',
            noDataExport: 'No data to export',
            exportCompleted: 'Excel export completed!'
        },
        timing: {
            notificationTimeout: 3000
        },
        endpoints: {
            getIncidents: '/inspection/get-incident-reports',
            viewIncident: '/inspection/view-incident'
        }
    };
    const DEFAULT_COUNTRY_SELECTION = ['DRC', 'Zambia'];
    
    // State management
    let incidentData = [];
    let filteredData = [];
    let selectedCountries = getInitialCountrySelection();
    let currentSearchTerm = '';
    let dataReady = false;
    let paginationState = {
        currentPage: 1,
        perPage: 10,
        total: 0,
        totalPages: 0
    };
    
    // DOM elements cache
    let elements = {};
    
    // Initialize DOM elements
    function initElements() {
        elements = {
            searchInput: document.querySelector(CONFIG.selectors.searchInput),
            incidentTableBody: document.querySelector(CONFIG.selectors.incidentTableBody),
            sortingModal: document.querySelector(CONFIG.selectors.sortingModal),
            sortingForm: document.querySelector(CONFIG.selectors.sortingForm),
            tableLoader: document.querySelector(CONFIG.selectors.tableLoader),
            incidentTable: document.querySelector(CONFIG.selectors.incidentTable)
        };
    }

    function getInitialCountrySelection() {
        if (typeof window.getCountryFilterSelection === 'function') {
            const selection = window.getCountryFilterSelection();
            if (Array.isArray(selection) && selection.length > 0) {
                return selection;
            }
        }
        return [...DEFAULT_COUNTRY_SELECTION];
    }

    function normalizeCountry(value) {
        if (!value) return '';
        const stringValue = value.toString().trim();
        if (!stringValue) return '';
        const dashTrimmed = stringValue.includes('-') ? stringValue.split('-')[0] : stringValue;
        const commaTrimmed = dashTrimmed.includes(',') ? dashTrimmed.split(',')[0] : dashTrimmed;
        const normalized = commaTrimmed.trim().toLowerCase();

        if (normalized === 'democratic republic of congo' || normalized === 'republic of congo' || normalized === 'rdc' || normalized === 'congo (drc)') {
            return 'drc';
        }

        if (normalized === 'zambia' || normalized === 'zam') {
            return 'zambia';
        }

        return normalized;
    }

    function extractIncidentCountry(incident) {
        const possibleFields = [
            incident.country,
            incident.incidentCountry,
            incident.locationCountry,
            incident.projectCountry,
            incident.countryName
        ];

        for (const field of possibleFields) {
            if (typeof field === 'string' && field.trim() !== '') {
                return field.trim();
            }
        }

        if (typeof incident.incidentArea === 'string' && incident.incidentArea.trim() !== '') {
            return incident.incidentArea.trim();
        }

        if (typeof incident.project === 'string' && incident.project.trim() !== '') {
            return incident.project.trim();
        }

        return '';
    }

    function matchesSearchTerm(incident, term) {
        if (!term || !term.trim()) {
            return true;
        }

        const loweredTerm = term.toLowerCase();
        const searchFields = [
            incident.incidentNumber,
            incident.id,
            incident._id,
            incident.project,
            incident.incidentCategory,
            incident.severity,
            incident.vehicleId,
            incident.vehicleName,
            incident.country,
            incident.incidentArea,
            incident.personInvolved
        ];

        const directMatch = searchFields.some(field =>
            field && field.toString().toLowerCase().includes(loweredTerm)
        );

        if (directMatch) {
            return true;
        }

        if (incident.selectedIncidents && typeof incident.selectedIncidents === 'object') {
            return Object.keys(incident.selectedIncidents).some(key =>
                key.toLowerCase().includes(loweredTerm) && incident.selectedIncidents[key] === true
            );
        }

        return false;
    }

    function applyFilters({ resetPage = false } = {}) {
        const normalizedSelected = selectedCountries.map(normalizeCountry).filter(Boolean);

        let data = incidentData.filter(incident => {
            const incidentCountry = normalizeCountry(extractIncidentCountry(incident));

            const matchesCountry = normalizedSelected.length === 0
                ? true
                : incidentCountry
                    ? normalizedSelected.some(selected => incidentCountry === selected)
                    : false;

            if (!matchesCountry) {
                return false;
            }

            return matchesSearchTerm(incident, currentSearchTerm);
        });

        filteredData = data;

        if (resetPage) {
            paginationState.currentPage = 1;
        }

        paginationState.total = filteredData.length;
        paginationState.totalPages = filteredData.length === 0
            ? 0
            : Math.ceil(filteredData.length / paginationState.perPage);

        if (paginationState.totalPages === 0) {
            paginationState.currentPage = 1;
        } else if (paginationState.currentPage > paginationState.totalPages) {
            paginationState.currentPage = paginationState.totalPages;
        }

        displayIncidents(filteredData);
        updatePaginationInfo();
    }
    
    // Initialize search functionality
    function initSearch() {
        if (elements.searchInput) {
            elements.searchInput.addEventListener('input', function() {
                filterIncidents(this.value);
            });
        }
    }

    function showLoading() {
        if (elements.tableLoader) {
            elements.tableLoader.style.display = 'flex';
        }
        if (elements.incidentTable) {
            elements.incidentTable.classList.add('table-loading-state');
        }
    }

    function hideLoading() {
        if (elements.tableLoader) {
            elements.tableLoader.style.display = 'none';
        }
        if (elements.incidentTable) {
            elements.incidentTable.classList.remove('table-loading-state');
        }
    }
    
    // Initialize page
    function init() {
        initElements();
        initSearch();
        loadIncidentReports();
    }
    
    // Event listeners
    document.addEventListener('DOMContentLoaded', init);

    window.addEventListener('countryFilterChanged', function(event) {
        const detail = event && event.detail ? event.detail : {};
        const countries = Array.isArray(detail.selectedCountries) ? detail.selectedCountries : [];
        selectedCountries = countries.length > 0 ? countries : [...DEFAULT_COUNTRY_SELECTION];
        if (dataReady) {
            applyFilters({ resetPage: true });
        }
    });

    // Load incident reports from MongoDB
    async function loadIncidentReports() {
        if (!elements.incidentTableBody) return;

        // Show loading state
        showLoading();

        console.log('🔄 Loading incident reports from MongoDB...');

        try {
            // Fetch all incident reports from MongoDB API
            const response = await fetch('https://api.titandrillingzm.com:6007/incident-reports');
            
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            
            const result = await response.json();
            console.log('MongoDB API Response:', result);
            
            if (result.success && Array.isArray(result.data)) {
                const allIncidents = result.data;
                
                console.log(`Found ${allIncidents.length} total incident reports`);
                
                // Sort by createdAt (newest first)
                allIncidents.sort((a, b) => {
                    const dateA = new Date(a.createdAt || a.incidentDate || 0);
                    const dateB = new Date(b.createdAt || b.incidentDate || 0);
                    return dateB.getTime() - dateA.getTime();
                });
                
                incidentData = allIncidents;
                dataReady = true;

                // Update pagination state defaults before applying filters
                paginationState = {
                    currentPage: 1,
                    perPage: 10,
                    total: allIncidents.length,
                    totalPages: Math.ceil(allIncidents.length / 10)
                };

                applyFilters({ resetPage: true });
                
                console.log('✅ Incident reports loaded successfully:', {
                    count: allIncidents.length,
                    sample: allIncidents.length > 0 ? allIncidents[0] : 'No data'
                });
                
                if (allIncidents.length > 0) {
                    showNotification(`Loaded ${allIncidents.length} incident reports successfully`, 'success');
                } else {
                    showNotification('No incident reports found', 'info');
                }
            } else {
                console.log('No data found in MongoDB');
                incidentData = [];
                filteredData = [];
                dataReady = true;
                displayIncidents([]);
                updatePaginationInfo();
                hideLoading();
                showNotification('No incident reports found', 'info');
            }
        } catch (error) {
            console.error('❌ Error loading incident reports:', error);
            
            let errorMessage = CONFIG.messages.failedLoading;
            if (error.message) {
                errorMessage += ': ' + error.message;
            }
            
            dataReady = true;
            hideLoading();
            showErrorState(errorMessage);
            showNotification(errorMessage, 'error');
        }
    }
    
    // Show error state
    function showErrorState(message) {
        if (!elements.incidentTableBody) return;

        elements.incidentTableBody.innerHTML = `
            <tr>
                <td colspan="11" class="text-center py-4 text-muted">
                    <i class="fas fa-exclamation-triangle fa-2x mb-2 text-warning"></i>
                    <p class="mb-0">Error loading data</p>
                    <small class="text-muted">${message}</small>
                </td>
            </tr>
        `;
    }

function displayIncidents(incidents) {
    const tableBody = document.getElementById('incidentTableBody');
    hideLoading();
    
    if (!incidents || incidents.length === 0) {
        tableBody.innerHTML = `
            <tr class="no-data-row">
                <td colspan="11" class="no-data-cell">
                    <div class="no-data-content">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"></circle>
                            <line x1="12" y1="8" x2="12" y2="12"></line>
                            <line x1="12" y1="16" x2="12.01" y2="16"></line>
                        </svg>
                        <h3>No Data Available</h3>
                        <p>No incident reports found. Start by creating a new incident report.</p>
                    </div>
                </td>
            </tr>
        `;
        return;
    }

    // Helper function to get selected incident types
    const getSelectedIncidentTypes = (selectedIncidents) => {
        if (!selectedIncidents) return 'N/A';

        // Handle array format (like in Firebase data)
        if (Array.isArray(selectedIncidents)) {
            return selectedIncidents.length > 0 ? selectedIncidents.join(', ') : 'N/A';
        }

        // Handle object format (boolean values)
        if (typeof selectedIncidents === 'object') {
            const selectedTypes = Object.entries(selectedIncidents)
                .filter(([key, value]) => value === true)
                .map(([key, value]) => key);
            return selectedTypes.length > 0 ? selectedTypes.join(', ') : 'N/A';
        }

        return 'N/A';
    };

    // Helper function to safely parse dates
    function safeParseDate(dateString, source = 'unknown') {
        if (!dateString) return null;
        
        try {
            let date;
            
            if (typeof dateString === 'string') {
                if (/^\d+$/.test(dateString)) {
                    date = new Date(parseInt(dateString));
                } else {
                    date = new Date(dateString);
                }
            } else if (typeof dateString === 'number') {
                date = new Date(dateString);
            } else {
                return null;
            }
            
            if (isNaN(date.getTime()) || date.getTime() <= 0) {
                console.warn(`Invalid date from ${source}:`, dateString);
                return null;
            }
            
            return date;
        } catch (error) {
            console.error(`Error parsing date from ${source}:`, error, dateString);
            return null;
        }
    }

    // Add index to each incident for S.No
    const rows = incidents.map((incident, index) => {
        // Try multiple date sources
        let dateToFormat = null;
        let dateSource = 'none';
        
        if (incident.incidentDate) {
            dateToFormat = safeParseDate(incident.incidentDate, 'incidentDate');
            dateSource = 'incidentDate';
        } else if (incident.createdAt) {
            dateToFormat = safeParseDate(incident.createdAt, 'createdAt');
            dateSource = 'createdAt';
        } else if (incident.timestamp) {
            dateToFormat = safeParseDate(incident.timestamp, 'timestamp');
            dateSource = 'timestamp';
        }
        
        // Format the date using day/month/year format with time
        let formattedDate = 'N/A';
        let formattedTime = 'N/A';
        
        if (dateToFormat) {
            try {
                // Format as DD/MM/YYYY
                const day = dateToFormat.getDate().toString().padStart(2, '0');
                const month = (dateToFormat.getMonth() + 1).toString().padStart(2, '0');
                const year = dateToFormat.getFullYear();
                formattedDate = `${day}/${month}/${year}`;
                
                // Format time as HH:MM
                const hours = dateToFormat.getHours().toString().padStart(2, '0');
                const minutes = dateToFormat.getMinutes().toString().padStart(2, '0');
                formattedTime = `${hours}:${minutes}`;
            } catch (error) {
                console.error(`Error formatting date from ${dateSource}:`, error, dateToFormat);
                formattedDate = 'Invalid Date';
                formattedTime = 'Invalid Time';
            }
        }
        
        const serialNumber = index + 1; // Start from 1

        // Extract incident data from MongoDB structure
        const incidentNumber = incident.incidentNumber || incident.id || incident._id || 'N/A';
        const incidentId = incident._id || incident.id || incidentNumber; // Use _id for deletion
        const safeIncidentNumber = String(incidentNumber).replace(/'/g, "\\'");
        const adminUid = incident.adminUid || 'unknown';
        const project = incident.project || 'N/A';
        const incidentCategory = incident.incidentCategory || 'N/A';
        const severity = incident.severity || 'N/A';
        
        // Extract vehicle information
        const vehicleNumber = incident.vehicleId || incident.vehicleNumber || 'N/A';
        const vehicleName = incident.vehicleName || '';
        
        // Extract location information
        let location = 'N/A';
        if (incident.country && incident.project) {
            location = `${incident.country} - ${incident.project}`;
        } else if (incident.incidentArea) {
            location = incident.incidentArea;
        }
        
        // Extract reporter information
        const reportedBy = incident.personInvolved || 'N/A';

        // Get selected incident types
        const selectedTypes = getSelectedIncidentTypes(incident.selectedIncidents);
        
        // Escape quotes for onclick attributes to prevent breaking
        const safeIncidentId = String(incidentId).replace(/'/g, "\\'");
        const safeAdminUid = String(adminUid).replace(/'/g, "\\'");

        return `
            <tr class="table-row">
                <td class="serial-cell" role="cell">
                    <span class="serial-number">${serialNumber}</span>
                </td>
                <td class="action-cell" role="cell">
                    <div class="dropdown">
                        <button class="action-btn" type="button" id="actionDropdown${serialNumber}" data-bs-toggle="dropdown" aria-expanded="false" aria-label="Actions for incident ${safeIncidentNumber}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="3"></circle>
                                <path d="M12 1v6m0 6v6m11-7h-6m-6 0H1"></path>
                            </svg>
                            Actions
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="actionDropdown${serialNumber}">
                            <li>
                                <a class="dropdown-item" href="javascript:void(0)" onclick="event.preventDefault(); viewIncident('${safeIncidentNumber}'); return false;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                        <circle cx="12" cy="12" r="3"></circle>
                                    </svg>
                                    View Report
                                </a>
                            </li>
                            <li class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item danger" href="javascript:void(0)" onclick="event.preventDefault(); deleteIncident('${safeIncidentId}', '${safeAdminUid}'); return false;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <polyline points="3,6 5,6 21,6"></polyline>
                                        <path d="M19,6v14a2,2,0,0,1-2,2H7a2,2,0,0,1-2-2V6M8,6V4a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V6"></path>
                                    </svg>
                                    Delete
                                </a>
                            </li>
                        </ul>
                    </div>
                </td>
                <td class="incident-number" role="cell">
                    <span class="incident-id">${incidentNumber}</span>
                </td>
                <td class="date-cell" role="cell">${formattedDate}</td>
                <td class="time-cell" role="cell">${formattedTime}</td>
                <td class="project-cell" role="cell">
                    <span class="project-name">${project}</span>
                </td>
                <td class="category-cell" role="cell">
                    <span class="incident-category">${incidentCategory}</span>
                </td>
                <td class="severity-cell" role="cell">
                    <span class="severity-badge severity-${severity.toLowerCase()}">${severity}</span>
                </td>
                <td class="vehicle-cell" role="cell">
                    <div class="vehicle-info">
                        <span class="vehicle-number">${vehicleNumber}</span>
                        <span class="vehicle-name">${vehicleName}</span>
                    </div>
                </td>
                <td class="location-cell" role="cell">${location}</td>
                <td class="reporter-cell" role="cell">${reportedBy}</td>
            </tr>
        `;
    }).join('');

    tableBody.innerHTML = rows;
}

function filterIncidents(searchTerm) {
    currentSearchTerm = searchTerm || '';
    applyFilters({ resetPage: true });
}

function applySorting() {
    const sortOrder = document.querySelector('input[name="sortOrder"]:checked').value;
    const sortBy = document.querySelector('input[name="sortBy"]:checked').value;
    
    filteredData.sort((a, b) => {
        let aValue, bValue;

        // Handle serial number sorting (maintain current order)
        if (sortBy === 'serialNumber') {
            const aIndex = incidentData.indexOf(a);
            const bIndex = incidentData.indexOf(b);
            aValue = aIndex;
            bValue = bIndex;
        } else {
            aValue = a[sortBy];
            bValue = b[sortBy];
        }

        // Handle date sorting
        if (sortBy === 'incidentDate') {
            aValue = a.incidentDate ? new Date(a.incidentDate) : new Date(0);
            bValue = b.incidentDate ? new Date(b.incidentDate) : new Date(0);
        }

        // Handle numeric sorting
        if (typeof aValue === 'number' && typeof bValue === 'number') {
            return sortOrder === 'ascending' ? aValue - bValue : bValue - aValue;
        }

        // Handle string sorting
        if (typeof aValue === 'string' && typeof bValue === 'string') {
            const comparison = aValue.localeCompare(bValue);
            return sortOrder === 'ascending' ? comparison : -comparison;
        }

        // Handle date sorting
        if (aValue instanceof Date && bValue instanceof Date) {
            return sortOrder === 'ascending' ? aValue - bValue : bValue - aValue;
        }

        return 0;
    });
    
    displayIncidents(filteredData);
    
    const modal = bootstrap.Modal.getInstance(document.getElementById('sortingModal'));
    modal.hide();
    
    showNotification('Sorting applied successfully!', 'success');
}

function resetSorting() {
    document.getElementById('sortingForm').reset();
    document.getElementById('ascending').checked = true;
    document.getElementById('serialNumber').checked = true;

    applyFilters();

    showNotification('Sorting options reset!', 'info');
}

function refreshData() {
    loadIncidentReports();
    showNotification('Data refreshed successfully!', 'success');
}

// Pagination functions
function goToPage(page) {
    if (page < 1 || page > paginationState.totalPages) {
        return;
    }

    paginationState.currentPage = page;
    loadIncidentReports();
}

function updatePaginationInfo() {
    const paginationSection = document.getElementById('paginationSection');
    const paginationInfo = document.getElementById('paginationInfo');
    const paginationPages = document.getElementById('paginationPages');

    if (paginationState.total === 0) {
        paginationSection.style.display = 'none';
        return;
    }

    paginationSection.style.display = 'block';

    // Update pagination info text
    const from = ((paginationState.currentPage - 1) * paginationState.perPage) + 1;
    const to = Math.min(paginationState.currentPage * paginationState.perPage, paginationState.total);
    paginationInfo.textContent = `Showing ${from}-${to} of ${paginationState.total} entries`;

    // Update page buttons
    const firstBtn = paginationSection.querySelector('.pagination-first');
    const prevBtn = paginationSection.querySelector('.pagination-prev');
    const nextBtn = paginationSection.querySelector('.pagination-next');
    const lastBtn = paginationSection.querySelector('.pagination-last');

    firstBtn.disabled = paginationState.currentPage === 1;
    prevBtn.disabled = paginationState.currentPage === 1;
    nextBtn.disabled = paginationState.currentPage === paginationState.totalPages;
    lastBtn.disabled = paginationState.currentPage === paginationState.totalPages;

    // Update page numbers display
    paginationPages.innerHTML = generatePageNumbers();
}

function generatePageNumbers() {
    const { currentPage, totalPages } = paginationState;
    const pages = [];

    if (totalPages <= 7) {
        // Show all pages if 7 or fewer
        for (let i = 1; i <= totalPages; i++) {
            pages.push(createPageButton(i));
        }
    } else {
        // Always show first page
        pages.push(createPageButton(1));

        if (currentPage > 4) {
            pages.push('<span class="pagination-ellipsis">...</span>');
        }

        // Show current page and surrounding pages
        const start = Math.max(2, currentPage - 1);
        const end = Math.min(totalPages - 1, currentPage + 1);

        for (let i = start; i <= end; i++) {
            pages.push(createPageButton(i));
        }

        if (currentPage < totalPages - 3) {
            pages.push('<span class="pagination-ellipsis">...</span>');
        }

        // Always show last page
        if (totalPages > 1) {
            pages.push(createPageButton(totalPages));
        }
    }

    return pages.join('');
}

function createPageButton(page) {
    const isActive = page === paginationState.currentPage;
    return `<button class="pagination-page ${isActive ? 'active' : ''}" onclick="goToPage(${page})">${page}</button>`;
}

// Removed Firebase debug function - not needed with MongoDB

function exportToExcel() {
    if (filteredData.length === 0) {
        showNotification('No data to export', 'warning');
        return;
    }
    
    // Create CSV content
    const headers = ['S.No', 'Incident Number', 'Incident Date', 'Incident Time', 'Project', 'Category', 'Severity', 'Vehicle Number', 'Vehicle Name', 'Location', 'Reported By'];
    const csvContent = [
        headers.join(','),
        ...filteredData.map((incident, index) => {
            const incidentDate = incident.incidentDate ? new Date(incident.incidentDate) : '';
            const formattedDate = incidentDate ? incidentDate.toLocaleDateString() : '';
            const formattedTime = incidentDate ? incidentDate.toLocaleTimeString() : '';
            const serialNumber = index + 1;

            return [
                serialNumber,
                incident.incidentNumber || '',
                formattedDate,
                formattedTime,
                incident.project || '',
                incident.incidentCategory || '',
                incident.severity || '',
                incident.vehicleNumber || '',
                incident.vehicleName || '',
                incident.country || incident.location || incident.incidentArea || '',
                incident.reportedBy || ''
            ].join(',');
        })
    ].join('\n');
    
    // Download CSV file
    const blob = new Blob([csvContent], { type: 'text/csv' });
    const url = window.URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = `incident_reports_${new Date().toISOString().split('T')[0]}.csv`;
    a.click();
    window.URL.revokeObjectURL(url);
    
    showNotification('Excel export completed!', 'success');
}

function viewIncident(incidentIdentifier) {
    const incident = incidentData.find(item => 
        (item._id && item._id === incidentIdentifier) ||
        (item.id && item.id === incidentIdentifier) ||
        (item.incidentNumber && item.incidentNumber === incidentIdentifier)
    );

    if (!incident) {
        showSimpleAlert('Incident not found. Please refresh and try again.', 'error');
        return;
    }

    const pdfUrl = incident.pdfDownloadUrl || incident.step2?.pdfDownloadUrl || null;

    if (!pdfUrl) {
        showSimpleAlert('PDF not available for this incident yet.', 'warning');
        return;
    }

    openIncidentPdfModal(pdfUrl, incident.incidentNumber || incidentIdentifier);
}

function editIncident(incidentNumber) {
    // Navigate to incident edit form
    window.location.href = `/edit-incident/${incidentNumber}`;
}

function openIncidentPdfModal(pdfUrl, incidentLabel) {
    const modal = document.getElementById('pdfViewerModal');
    const iframe = document.getElementById('pdfIframe');
    const downloadBtn = document.getElementById('pdfDownloadBtn');
    const downloadLabel = document.getElementById('pdfDownloadLabel');
    const title = document.getElementById('pdfModalTitle');

    if (!modal || !iframe || !downloadBtn) {
        console.error('PDF modal elements not found.');
        showSimpleAlert('Unable to open PDF viewer.', 'error');
        return;
    }

    title.textContent = `Incident Report PDF - ${incidentLabel || ''}`;
    downloadLabel.textContent = 'Download PDF';

    iframe.src = pdfUrl;
    downloadBtn.onclick = () => window.open(pdfUrl, '_blank');

    modal.style.display = 'flex';
    document.body.style.overflow = 'hidden';
}

function closeIncidentPdfModal() {
    const modal = document.getElementById('pdfViewerModal');
    const iframe = document.getElementById('pdfIframe');
    if (modal) {
        modal.style.display = 'none';
    }
    if (iframe) {
        iframe.src = '';
    }
    document.body.style.overflow = 'auto';
}

    // Notification system
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type === 'error' ? 'danger' : type} alert-dismissible fade show position-fixed`;
        notification.style.cssText = `top: 20px; right: 20px; z-index: 10001; min-width: 300px;`;
        notification.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        
        document.body.appendChild(notification);
        
        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 3000);
    }
    
    // Delete incident
    async function deleteIncident(incidentId, adminUid) {
        try {
            console.log('🗑️ Deleting incident ID:', incidentId);
            console.log('   Admin UID:', adminUid);
            
            // Use custom confirmation dialog with callback
            showDeleteConfirmation(incidentId, adminUid);
            
        } catch (error) {
            console.error('❌ Error in deleteIncident:', error);
            console.error('   Error stack:', error.stack);
            showSimpleAlert(`Error: ${error.message}`, 'error');
        }
    }
    
    // Show delete confirmation modal
    function showDeleteConfirmation(incidentId, adminUid) {
        // Create modal overlay
        const overlay = document.createElement('div');
        overlay.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.6);
            z-index: 100000;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(4px);
        `;
        
        // Create modal
        const modal = document.createElement('div');
        modal.style.cssText = `
            background: white;
            border-radius: 12px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
            max-width: 450px;
            width: 90%;
            overflow: hidden;
        `;
        
        modal.innerHTML = `
            <div style="background: linear-gradient(135deg, #ef4444, #dc2626); color: white; padding: 24px; text-align: center;">
                <div style="font-size: 48px; margin-bottom: 12px;">⚠️</div>
                <h3 style="margin: 0; font-size: 20px; font-weight: 600;">Delete Incident</h3>
            </div>
            <div style="padding: 24px;">
                <p style="margin: 0 0 16px 0; color: #374151; font-size: 15px; line-height: 1.6;">
                    Are you sure you want to <strong style="color: #dc2626;">DELETE</strong> this incident?
                </p>
                <div style="background: #fef2f2; border: 1px solid #fecaca; border-radius: 8px; padding: 12px; margin-bottom: 20px;">
                    <p style="margin: 0; color: #991b1b; font-size: 13px; font-weight: 500;">
                        ⚠️ This action CANNOT be undone!
                    </p>
                    <p style="margin: 8px 0 0 0; color: #7f1d1d; font-size: 12px;">
                        Incident ID: <code style="background: white; padding: 2px 6px; border-radius: 4px; font-family: monospace;">${incidentId}</code>
                    </p>
                </div>
                <div style="display: flex; gap: 12px; justify-content: flex-end;">
                    <button id="cancelDeleteBtn" style="
                        padding: 10px 20px;
                        border: 1px solid #d1d5db;
                        background: white;
                        color: #374151;
                        border-radius: 8px;
                        font-size: 14px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s ease;
                    ">Cancel</button>
                    <button id="confirmDeleteBtn" style="
                        padding: 10px 20px;
                        border: none;
                        background: linear-gradient(135deg, #ef4444, #dc2626);
                        color: white;
                        border-radius: 8px;
                        font-size: 14px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s ease;
                    ">Delete Incident</button>
                </div>
            </div>
        `;
        
        overlay.appendChild(modal);
        document.body.appendChild(overlay);
        
        // Add button hover effects
        const cancelBtn = document.getElementById('cancelDeleteBtn');
        const confirmBtn = document.getElementById('confirmDeleteBtn');
        
        cancelBtn.onmouseover = () => {
            cancelBtn.style.background = '#f3f4f6';
            cancelBtn.style.borderColor = '#9ca3af';
        };
        cancelBtn.onmouseout = () => {
            cancelBtn.style.background = 'white';
            cancelBtn.style.borderColor = '#d1d5db';
        };
        
        confirmBtn.onmouseover = () => {
            confirmBtn.style.transform = 'translateY(-1px)';
            confirmBtn.style.boxShadow = '0 4px 12px rgba(239, 68, 68, 0.3)';
        };
        confirmBtn.onmouseout = () => {
            confirmBtn.style.transform = 'translateY(0)';
            confirmBtn.style.boxShadow = 'none';
        };
        
        // Cancel button - close modal
        cancelBtn.onclick = () => {
            console.log('❌ Delete cancelled by user');
            document.body.removeChild(overlay);
        };
        
        // Confirm button - proceed with deletion
        confirmBtn.onclick = async () => {
            console.log('✅ Delete confirmed by user, proceeding...');
            document.body.removeChild(overlay);
            
            // Show loading notification
            const loadingMsg = document.createElement('div');
            loadingMsg.style.cssText = 'position: fixed; top: 20px; right: 20px; background: #f59e0b; color: white; padding: 12px 20px; border-radius: 8px; z-index: 100001; box-shadow: 0 4px 12px rgba(0,0,0,0.15);';
            loadingMsg.textContent = 'Deleting incident...';
            document.body.appendChild(loadingMsg);
            
            try {
                // Call MongoDB API to delete the incident
                console.log(`🌐 DELETE Request: https://api.titandrillingzm.com:6007/incident-reports/${adminUid}/${incidentId}`);
                
                const response = await fetch(`https://api.titandrillingzm.com:6007/incident-reports/${adminUid}/${incidentId}`, {
                    method: 'DELETE',
                    headers: {
                        'Content-Type': 'application/json'
                    }
                });
                
                console.log('   Response status:', response.status);
                
                const result = await response.json();
                console.log('   Response data:', result);
                
                // Remove loading message
                if (loadingMsg.parentNode) {
                    loadingMsg.parentNode.removeChild(loadingMsg);
                }
                
                if (result.success) {
                    // Success notification
                    showSimpleAlert('✅ Incident deleted successfully!', 'success');
                    
                    // Reload incidents to reflect changes
                    console.log('🔄 Reloading incident reports...');
                    setTimeout(() => {
                        loadIncidentReports();
                    }, 1000);
                } else {
                    console.error('❌ Delete failed:', result.error);
                    showSimpleAlert(`Failed to delete incident: ${result.error || 'Unknown error'}`, 'error');
                }
            } catch (error) {
                console.error('❌ Error deleting incident:', error);
                
                // Remove loading message
                if (loadingMsg.parentNode) {
                    loadingMsg.parentNode.removeChild(loadingMsg);
                }
                
                showSimpleAlert(`Error deleting incident: ${error.message}`, 'error');
            }
        };
        
        // Close on overlay click
        overlay.onclick = (e) => {
            if (e.target === overlay) {
                console.log('❌ Delete cancelled by clicking overlay');
                document.body.removeChild(overlay);
            }
        };
    }
    
    // Simple alert notification (doesn't interfere with overridden alert)
    function showSimpleAlert(message, type = 'info') {
        const colors = {
            success: '#10b981',
            error: '#ef4444',
            warning: '#f59e0b',
            info: '#3b82f6'
        };
        
        const alertMsg = document.createElement('div');
        alertMsg.style.cssText = `
            position: fixed;
            top: 20px;
            right: 20px;
            background: ${colors[type] || colors.info};
            color: white;
            padding: 12px 20px;
            border-radius: 8px;
            z-index: 100001;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            max-width: 400px;
            animation: slideIn 0.3s ease;
        `;
        alertMsg.textContent = message;
        document.body.appendChild(alertMsg);
        
        setTimeout(() => {
            if (alertMsg.parentNode) {
                alertMsg.style.opacity = '0';
                alertMsg.style.transform = 'translateX(100px)';
                alertMsg.style.transition = 'all 0.3s ease';
                setTimeout(() => {
                    if (alertMsg.parentNode) alertMsg.parentNode.removeChild(alertMsg);
                }, 300);
            }
        }, 3000);
    }
    
    // Make functions globally accessible
    window.loadIncidentReports = loadIncidentReports;
    window.filterIncidents = filterIncidents;
    window.applySorting = applySorting;
    window.resetSorting = resetSorting;
    window.refreshData = refreshData;
    window.exportToExcel = exportToExcel;
    window.viewIncident = viewIncident;
    window.editIncident = editIncident;
    window.showNotification = showNotification;
    window.goToPage = goToPage;
    window.updatePaginationInfo = updatePaginationInfo;
    window.deleteIncident = deleteIncident;
    window.closeIncidentPdfModal = closeIncidentPdfModal;
    
})();
</script>
@endsection