@extends('welcome')

@section('title', 'Inspection2')

@section('styles')
<link rel="stylesheet" href="{{ asset('style-css/Inspection2.css') }}">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
@endsection

@section('content')
<div class="inspection2-container">
    <!-- Header Section -->
    <div class="inspection2-header">
        <div class="header-content">
            <div class="back-section">
                <a href="{{ url('/inspection') }}" class="back-link">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M19 12H5M12 19l-7-7 7-7"/>
                    </svg>
                    Back to Inspection Report
                </a>
            </div>
            <div class="page-title">
                <h1>Vehicle Inspection</h1>
                <p>Complete your vehicle inspection in three simple steps</p>
            </div>
        </div>
    </div>


    <!-- Step 1 Form -->
    <div class="form-section" id="step1-form">
        <div class="form-header">
            <h2>1. Inspection Information</h2>
            <p>Fill in the basic information for your vehicle inspection</p>
        </div>
        
        <form id="inspection-form">
            @csrf
            <div class="form-grid">
                <!-- Left Column: Inspection Info -->
                <div class="form-column">
                    <div class="form-group">
                        <label for="reportNumber" class="form-label">Request Number</label>
                        <input type="text" class="form-control" id="reportNumber" name="reportNumber" placeholder="Select country and project first" readonly>
                    </div>
                    <div class="form-group">
                        <label for="country" class="form-label required">Country</label>
                        <select class="form-control" id="country" name="country" required onchange="updateProjects()">
                            <option value="">Select Country</option>
                            <option value="Zambia">Zambia</option>
                            <option value="DRC">DRC</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="project" class="form-label required">Project</label>
                        <select class="form-control" id="project" name="project" required disabled onchange="generateRequestNumber()">
                            <option value="">Select Project</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="inspector" class="form-label required">Inspector</label>
                        <input type="text" class="form-control" id="inspector" name="inspector" placeholder="Enter Inspector Name" required>
                    </div>
                </div>
                
                <!-- Right Column: Equipment and Checklist -->
                <div class="form-column">
                    <div class="form-group">
                        <label class="form-label required">Equipment</label>
                        <div class="input-with-button">
                            <input type="text" class="form-control" id="equipmentDisplay" name="equipmentDisplay" placeholder="Select Equipment" readonly required>
                            <button type="button" class="btn-select" onclick="openEquipmentModal()" title="Select Equipment">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/>
                                    <polyline points="3.27,6.96 12,12.01 20.73,6.96"/>
                                    <line x1="12" y1="22.08" x2="12" y2="12"/>
                                </svg>
                            </button>
                        </div>
                        <input type="hidden" id="vehicleNumber" name="vehicleNumber" required>
                        <input type="hidden" id="vehicleName" name="vehicleName" required>
                        <input type="hidden" id="vinNumber" name="vinNumber" required>
                    </div>
                    <div class="form-group">
                        <label for="meterReading" class="form-label required">Meter Reading</label>
                        <div class="meter-reading-group">
                            <input type="text" class="form-control" id="meter-Reading-input" name="meterReading" placeholder="Enter new meter reading" required>
                            <select class="form-control" id="meterReading" name="meterUnit" required>
                                <option value="">Select Unit</option>
                                <option value="Miles">Miles</option>
                                <option value="Kilometers">Kilometers</option>
                                <option value="Hours">Hours</option>
                            </select>
                        </div>
                        <div class="meter-info">
                            <span class="meter-label">Current Reading:</span>
                            <span class="meter-value" id="currentMeterValue">Not selected</span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label required">Checklist</label>
                        <div class="input-with-button">
                            <input type="text" class="form-control" id="checklistDisplay" name="checklistDisplay" placeholder="Select Checklist" readonly required>
                            <button type="button" class="btn-select" onclick="openChecklistModal()" title="Select Checklist">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M9 11H5a2 2 0 0 0-2 2v3c0 1.1.9 2 2 2h4m0-7v7m0-7h10a2 2 0 0 1 2 2v3c0 1.1-.9 2-2 2H9m0-7V9a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v2"/>
                                </svg>
                            </button>
                        </div>
                        <input type="hidden" id="inspectionChecklist" name="inspectionChecklist" required>
                    </div>
                </div>
            </div>
            
            <!-- GPS Location Section -->
            <div class="gps-section">
                <div class="form-group">
                    <label class="form-label">GPS Location</label>
                    <div class="gps-controls">
                        <button type="button" class="btn-gps" onclick="handleGetLocation()">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"/>
                                <circle cx="12" cy="10" r="3"/>
                            </svg>
                            Get Location
                        </button>
                    </div>
                    <div class="gps-details" id="gpsDetailsBox" style="display: none;">
                        <div class="gps-info-grid">
                            <div class="gps-info-item">
                                <span class="gps-label">Coordinates:</span>
                                <span class="gps-value" id="coordinates">Not available</span>
                            </div>
                            <div class="gps-info-item">
                                <span class="gps-label">GPS Address:</span>
                                <span class="gps-value" id="gpsAddress">Not available</span>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" id="coordinatesInput" name="coordinates">
                    <input type="hidden" id="gpsAddressInput" name="gpsAddress">
                </div>
            </div>
            
            <div class="form-actions">
                <button type="button" class="btn-next" onclick="goToStep2()">
                    <span>Next Step</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M5 12h14M12 5l7 7-7 7"/>
                    </svg>
                </button>
                
            </div>
        </form>
    </div>
</div>

<!-- Step 2: Do Inspection -->
<div class="form-section" id="do-inspection-container" style="display: none;">
    <div class="form-header">
        <h2>2. Do Inspection</h2>
        <p>Complete the inspection checklist for your selected equipment</p>
    </div>

    <form id="inspection-checklist-form">
        @csrf
        <!-- Header Information Section -->
        <div class="form-grid">
            <!-- Left Column: Equipment Details -->
            <div class="form-column">
                <div class="form-group">
                    <label for="model" class="form-label required">Model *</label>
                    <input type="text" class="form-control" id="model" name="model" placeholder="Enter model" required>
                </div>
                <div class="form-group">
                    <label for="fleetNo" class="form-label required">Fleet No *</label>
                    <input type="text" class="form-control" id="fleetNo" name="fleetNo" value="LV10" required>
                </div>
                <div class="form-group">
                    <label for="shift" class="form-label required">Shift *</label>
                    <input type="text" class="form-control" id="shift" name="shift" placeholder="Enter shift" required>
                </div>
            </div>
            
            <!-- Right Column: Inspection Details -->
            <div class="form-column">
                <div class="form-group">
                    <label for="inspectionDate" class="form-label required">Inspection Date *</label>
                    <input type="date" class="form-control" id="inspectionDate" name="inspectionDate" required>
                </div>
                <div class="form-group">
                    <label for="inspectionTime" class="form-label required">Inspection Time *</label>
                    <input type="time" class="form-control" id="inspectionTime" name="inspectionTime" required>
                </div>
                <div class="form-group">
                    <label for="weatherCondition" class="form-label">Weather Condition</label>
                    <select class="form-control" id="weatherCondition" name="weatherCondition">
                        <option value="">Select Weather</option>
                        <option value="Sunny">Sunny</option>
                        <option value="Cloudy">Cloudy</option>
                        <option value="Rainy">Rainy</option>
                        <option value="Foggy">Foggy</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Inspection Checklist Section -->
        <div class="inspection-checklist-section">
            <div class="checklist-header">
                <h3>HSE-FOR-8.1.1 Water Pump Prestart Check</h3>
                <!-- <div class="checklist-summary">
                    <span class="summary-item">
                        <span class="summary-label">Total Items:</span>
                        <span class="summary-value" id="totalItems">22</span>
                    </span>
                    <span class="summary-item">
                        <span class="summary-label">Completed:</span>
                        <span class="summary-value" id="completedItems">0</span>
                    </span>
                    <span class="summary-item">
                        <span class="summary-label">Progress:</span>
                        <span class="summary-value" id="progressPercentage">0%</span>
                    </span>
                </div> -->
            </div>
        
            <!-- Section A -->
            <div class="inspection-section">
                <div class="section-header" onclick="toggleSection('sectionA')">
                    <div class="section-title">
                        <span class="section-icon">▲</span>
                        <h4>Section A - Safety & Environmental</h4>
                    </div>
                    <div class="section-progress">
                        <span class="progress-text"><span id="sectionA-count">0</span>/6 selected</span>
                        <div class="progress-bar">
                            <div class="progress-fill" id="sectionA-progress" style="width: 0%"></div>
                        </div>
                    </div>
                </div>

                <div class="inspection-items" id="sectionA" style="display: none;">
                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">1</span>
                                <div class="item-details">
                                    <h5 class="item-title">Drip Tray / Bunding</h5>
                                    <p class="item-description">Check for proper containment and bunding around equipment</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('drip-tray', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('drip-tray', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('drip-tray', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('drip-tray')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('drip-tray')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">2</span>
                                <div class="item-details">
                                    <h5 class="item-title">5 Meter Away from Water Source</h5>
                                    <p class="item-description">Ensure equipment is positioned at safe distance from water source</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('water-source', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('water-source', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('water-source', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('water-source')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('water-source')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">3</span>
                                <div class="item-details">
                                    <h5 class="item-title">Fire Extinguisher & Signage</h5>
                                    <p class="item-description">Verify fire extinguisher is present and properly signed</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('fire-extinguisher', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('fire-extinguisher', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('fire-extinguisher', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('fire-extinguisher')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('fire-extinguisher')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">4</span>
                                <div class="item-details">
                                    <h5 class="item-title">Engine Oil Level</h5>
                                    <p class="item-description">Check engine oil level is within acceptable range</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('engine-oil-level', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('engine-oil-level', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('engine-oil-level', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('engine-oil-level')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('engine-oil-level')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">5</span>
                                <div class="item-details">
                                    <h5 class="item-title">Radiator Coolant (If Applicable)</h5>
                                    <p class="item-description">Verify radiator coolant level and condition</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('radiator-coolant', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('radiator-coolant', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('radiator-coolant', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('radiator-coolant')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('radiator-coolant')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">6</span>
                                <div class="item-details">
                                    <h5 class="item-title">Pressure Relief Valve</h5>
                                    <p class="item-description">Check pressure relief valve is functioning properly</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('pressure-relief-valve', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('pressure-relief-valve', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('pressure-relief-valve', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('pressure-relief-valve')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('pressure-relief-valve')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>

            <!-- Section B -->
            <div class="inspection-section">
                <div class="section-header" onclick="toggleSection('sectionB')">
                    <div class="section-title">
                        <span class="section-icon">▲</span>
                        <h4>Section B - Engine & Fuel System</h4>
                    </div>
                    <div class="section-progress">
                        <span class="progress-text"><span id="sectionB-count">0</span>/3 selected</span>
                        <div class="progress-bar">
                            <div class="progress-fill" id="sectionB-progress" style="width: 0%"></div>
                        </div>
                    </div>
                </div>

                <div class="inspection-items" id="sectionB" style="display: none;">
                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">1</span>
                                <div class="item-details">
                                    <h5 class="item-title">Fuel Leaks</h5>
                                    <p class="item-description">Inspect for any fuel leaks or seepage around fuel system</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('fuel-leaks', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('fuel-leaks', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('fuel-leaks', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('fuel-leaks')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('fuel-leaks')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">2</span>
                                <div class="item-details">
                                    <h5 class="item-title">Engine Guard in Place</h5>
                                    <p class="item-description">Verify engine guard is properly installed and secure</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('engine-guard', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('engine-guard', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('engine-guard', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('engine-guard')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('engine-guard')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">3</span>
                                <div class="item-details">
                                    <h5 class="item-title">Oil Leaks</h5>
                                    <p class="item-description">Check for any oil leaks or seepage around engine</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('oil-leaks', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('oil-leaks', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('oil-leaks', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('oil-leaks')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('oil-leaks')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>

            <!-- Section C -->
            <div class="inspection-section">
                <div class="section-header" onclick="toggleSection('sectionC')">
                    <div class="section-title">
                        <span class="section-icon">▲</span>
                        <h4>Section C - Mechanical Components</h4>
                    </div>
                    <div class="section-progress">
                        <span class="progress-text"><span id="sectionC-count">0</span>/13 selected</span>
                        <div class="progress-bar">
                            <div class="progress-fill" id="sectionC-progress" style="width: 0%"></div>
                        </div>
                    </div>
                </div>

                <div class="inspection-items" id="sectionC" style="display: none;">
                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">1</span>
                                <div class="item-details">
                                    <h5 class="item-title">V-Belts</h5>
                                    <p class="item-description">Inspect V-belt condition, tension, and alignment</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('v-belts', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('v-belts', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('v-belts', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('v-belts')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('v-belts')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">2</span>
                                <div class="item-details">
                                    <h5 class="item-title">Fuel Tank Cap</h5>
                                    <p class="item-description">Check fuel tank cap is secure and properly sealed</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('fuel-tank-cap', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('fuel-tank-cap', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('fuel-tank-cap', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('fuel-tank-cap')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('fuel-tank-cap')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">3</span>
                                <div class="item-details">
                                    <h5 class="item-title">Exhaust Bracket and Silencer</h5>
                                    <p class="item-description">Verify exhaust bracket is secure and silencer is functioning</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('exhaust-bracket', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('exhaust-bracket', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('exhaust-bracket', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('exhaust-bracket')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('exhaust-bracket')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">4</span>
                                <div class="item-details">
                                    <h5 class="item-title">Gauges Working</h5>
                                    <p class="item-description">Test all gauges for proper functionality and accuracy</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('gauges-working', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('gauges-working', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('gauges-working', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('gauges-working')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('gauges-working')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">5</span>
                                <div class="item-details">
                                    <h5 class="item-title">Engine Mountings</h5>
                                    <p class="item-description">Check engine mountings for proper installation and condition</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('engine-mountings', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('engine-mountings', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('engine-mountings', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('engine-mountings')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('engine-mountings')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">6</span>
                                <div class="item-details">
                                    <h5 class="item-title">Working Light</h5>
                                    <p class="item-description">Test working light functionality and visibility</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('working-light', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('working-light', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('working-light', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('working-light')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('working-light')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">7</span>
                                <div class="item-details">
                                    <h5 class="item-title">Battery Water / Terminals & Clamp</h5>
                                    <p class="item-description">Check battery water level, terminal condition, and clamp security</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('battery-water', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('battery-water', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('battery-water', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('battery-water')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('battery-water')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">8</span>
                                <div class="item-details">
                                    <h5 class="item-title">Water Leaks</h5>
                                    <p class="item-description">Inspect for any water leaks in the system</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('water-leaks', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('water-leaks', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('water-leaks', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('water-leaks')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('water-leaks')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">9</span>
                                <div class="item-details">
                                    <h5 class="item-title">Pulley Condition</h5>
                                    <p class="item-description">Check pulley condition, alignment, and wear</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('pulley-condition', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('pulley-condition', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('pulley-condition', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('pulley-condition')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('pulley-condition')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">10</span>
                                <div class="item-details">
                                    <h5 class="item-title">Belt Condition</h5>
                                    <p class="item-description">Inspect belt condition, tension, and wear patterns</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('belt-condition', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('belt-condition', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('belt-condition', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('belt-condition')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('belt-condition')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">11</span>
                                <div class="item-details">
                                    <h5 class="item-title">Mounting Bolts</h5>
                                    <p class="item-description">Check mounting bolts for proper torque and condition</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('mounting-bolts', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('mounting-bolts', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('mounting-bolts', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('mounting-bolts')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('mounting-bolts')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">12</span>
                                <div class="item-details">
                                    <h5 class="item-title">Clutch & Lever</h5>
                                    <p class="item-description">Test clutch operation and lever functionality</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('clutch-lever', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('clutch-lever', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('clutch-lever', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('clutch-lever')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('clutch-lever')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="inspection-item">
                        <div class="item-content">
                            <div class="item-info">
                                <span class="item-number">13</span>
                                <div class="item-details">
                                    <h5 class="item-title">Adaptor Coupling</h5>
                                    <p class="item-description">Check adaptor coupling condition and proper connection</p>
                                </div>
                            </div>
                            <div class="item-actions">
                                <div class="option-buttons">
                                    <button type="button" class="btn-option btn-ok" data-option="ok" onclick="selectOption('adaptor-coupling', 'ok')">
                                        <i class="fas fa-check"></i>
                                        <span>OK</span>
                                    </button>
                                    <button type="button" class="btn-option btn-reject" data-option="reject" onclick="selectOption('adaptor-coupling', 'reject')">
                                        <i class="fas fa-times"></i>
                                        <span>Reject</span>
                                    </button>
                                    <button type="button" class="btn-option btn-na" data-option="na" onclick="selectOption('adaptor-coupling', 'na')">
                                        <i class="fas fa-minus"></i>
                                        <span>N/A</span>
                                    </button>
                                </div>
                                <div class="item-tools">
                                    <button type="button" class="btn-tool" onclick="openNotes('adaptor-coupling')" title="Add Notes">
                                        <i class="fas fa-sticky-note"></i>
                                    </button>
                                    <button type="button" class="btn-tool" onclick="takePhoto('adaptor-coupling')" title="Take Photo">
                                        <i class="fas fa-camera"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
        
        <!-- Form Actions -->
        <div class="form-actions">
            <button type="button" class="btn-cancel" onclick="goToStep1()">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M19 12H5M12 19l-7-7 7-7"/>
                </svg>
                <span>Back to Step 1</span>
            </button>
            <button type="button" class="btn-complete" onclick="completeInspection()">
                <span>Complete Inspection</span>
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M9 12l2 2 4-4"/>
                    <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                    <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                    <path d="M13 12h3"/>
                    <path d="M8 12H5"/>
                </svg>
            </button>
        </div>
    </form>
</div>

<!-- Equipment Selection Modal -->
<div id="equipmentModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-header">
            <h3>Select Equipment</h3>
            <button type="button" class="close-btn" onclick="closeEquipmentModal()">&times;</button>
        </div>
        <div class="custom-modal-body">
            <div class="search-container">
                <input type="text" id="equipmentSearch" class="search-input" placeholder="Search equipment..." onkeyup="filterEquipment()">
                <button type="button" class="search-btn" onclick="filterEquipment()">
                    <i class="fas fa-search"></i>
                </button>
            </div>
            <div class="equipment-list" id="equipmentList">
                <!-- Equipment items will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Checklist Selection Modal -->
<div id="checklistModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-header">
            <h3>Select Checklist</h3>
            <button type="button" class="close-btn" onclick="closeChecklistModal()">&times;</button>
        </div>
        <div class="custom-modal-body">
            <div class="search-container">
                <input type="text" id="checklistSearch" class="search-input" placeholder="Search checklists..." onkeyup="filterChecklist()">
                <button type="button" class="search-btn" onclick="filterChecklist()">
                    <i class="fas fa-search"></i>
                </button>
            </div>
            <div class="checklist-list" id="checklistList">
                <!-- Checklist items will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Modal Popup -->
<div id="inspectionModal" class="do-inspections-popup">
    <div class="do-inspections-popup-content">
        <div class="do-inspections-popup-header">
            <h2>Inspection Item</h2>
        </div>

        <div class="do-inspections-popup-body">
            <div class="popup-air-text-sebhed text-center">
                <p>AIR, ELECTRICAL, HYDRAULIC LINES</p>
            </div>
            <div class="do-inspections-popup-condition-section">
                <label>CONDITION *:</label>
                <div class="do-inspections-popup-condition-options">
                    <label><input type="radio" name="condition" class="do-inspections-popup-condition-good" value="good"> Good</label>
                    <label><input type="radio" name="condition" class="do-inspections-popup-condition-repair" value="repair"> Repair</label>
                    <label><input type="radio" name="condition" class="do-inspections-popup-condition-replace" value="replace"> Replace</label>
                    <label><input type="radio" name="condition" class="do-inspections-popup-condition-na" value="na"> N/A</label>
                </div>
            </div>
            <div class="do-inspections-popup-inspection-note">
                <label>INSPECTION NOTE *:</label>
                <textarea placeholder="Enter your notes here..."></textarea>
            </div>
            <div class="do-inspections-popup-upload-image">
                <label>UPLOAD IMAGE:</label>
                <div class="do-inspections-popup-image-preview">
                    <img id="imagePreview" src="https://via.placeholder.com/400x80" alt="Uploaded Image">
                </div>
                <input type="file" id="imageUpload" accept="image/*">
                <button class="do-inspections-popup-upload-btn" onclick="document.getElementById('imageUpload').click()">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                        <path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v9m-5 0H5a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-2M8 9l4-5l4 5m1 8h.01" />
                    </svg>
                    Upload</button>
            </div>
        </div>
        <div class="do-inspections-popup-footer">
            <button class="do-inspections-popup-done-btn" onclick="closeModal()">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                    <path fill="#fff" fill-rule="evenodd" d="M23 12c0 6.075-4.925 11-11 11S1 18.075 1 12S5.925 1 12 1s11 4.925 11 11M7 13l1.5-1.5l2 2l5-5L17 10l-6.5 6.5z" clip-rule="evenodd" />
                </svg>
                Done</button>
            <button class="do-inspections-popup-cancel-btn" onclick="closeModal()">
                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24">
                    <path fill="#fff" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                </svg>
                Cancel</button>
        </div>
    </div>
</div>

<!-- Step 3: Inspection Summary -->
<div id="Inspection-Summary-main" style="display: none;">
    <h5 class="mb-3 inspection-info-hd">3. Inspection Summary</h5>
    
    <!-- Faulty Items Count -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="faulty-items-container">
                <div class="faulty-items-row">
                    <span class="faulty-items-label">Faulty Items:</span>
                    <span class="faulty-items-count" id="faultyItemsCount">0</span>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <!-- Overall Condition -->
            <div class="mb-3 d-flex align-items-center justify-content-end" style="gap:50px;">
                <label for="overallCondition" class="form-label">Overall Condition: <span class="required-asterisk">*</span></label>
                <select class="form-select" id="overallCondition-select" name="overallCondition" required>
                    <option value="">Select</option>
                    <option value="Good Condition">Good Condition</option>
                    <option value="Minor Repair required">Minor Repair required</option>
                    <option value="Major Repair required">Major Repair required</option>
                    <option value="Cannot determine">Cannot determine</option>
                    <option value="Not Applicable">Not Applicable</option>
                </select>
            </div>
            <div id="overallConditionError" class="error-text" style="display: none;">Overall Condition is required</div>

            <!-- Equipment Status -->
            <div class="mb-3 d-flex align-items-center justify-content-end" style="gap:50px;">
                <label class="form-label">Equipment Status: <span class="required-asterisk">*</span></label>
                <div class="status-options-container">
                    <button type="button" class="status-option-btn" data-status="Available" onclick="handleStatusSelect('Available')">
                        Available
                    </button>
                    <button type="button" class="status-option-btn" data-status="Maintenance Required" onclick="handleStatusSelect('Maintenance Required')">
                        Maintenance Required
                    </button>
                    <button type="button" class="status-option-btn" data-status="Breakdown" onclick="handleStatusSelect('Breakdown')">
                        Breakdown
                    </button>
                    </div>
                    </div>
            <div id="equipmentStatusError" class="error-text" style="display: none;">Equipment Status is required</div>

            <!-- Priority (shown only when Maintenance Required or Breakdown) -->
            <div id="priorityContainer" class="mb-3 d-flex align-items-center justify-content-end" style="gap:50px; display: none;">
                <label class="form-label">Priority:</label>
                <div class="priority-options-container">
                    <div class="priority-item">
                        <button type="button" class="priority-btn" data-priority="Low" onclick="handlePrioritySelect('Low')">
                            <img src="https://via.placeholder.com/24x24/28a745/ffffff?text=1" alt="Low Priority" class="priority-icon">
                            <span>Low</span>
                        </button>
                </div>
                    <div class="priority-item">
                        <button type="button" class="priority-btn" data-priority="Medium" onclick="handlePrioritySelect('Medium')">
                            <img src="https://via.placeholder.com/24x24/ffc107/ffffff?text=2" alt="Medium Priority" class="priority-icon">
                            <span>Medium</span>
                        </button>
            </div>
                    <div class="priority-item">
                        <button type="button" class="priority-btn" data-priority="High" onclick="handlePrioritySelect('High')">
                            <img src="https://via.placeholder.com/24x24/fd7e14/ffffff?text=3" alt="High Priority" class="priority-icon">
                            <span>High</span>
                        </button>
                    </div>
                    <div class="priority-item">
                        <button type="button" class="priority-btn" data-priority="Emergency" onclick="handlePrioritySelect('Emergency')">
                            <img src="https://via.placeholder.com/24x24/dc3545/ffffff?text=4" alt="Emergency Priority" class="priority-icon">
                            <span>Emergency</span>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Equipment Safe to Use -->
            <div class="mb-3 d-flex align-items-center justify-content-end" style="gap:50px;">
                <label class="form-label">Equipment Safe to Use: <span class="required-asterisk">*</span></label>
                <div class="safe-options-container">
                    <button type="button" class="safe-option-btn" data-safe="Yes" onclick="handleSafeSelect('Yes')">
                        Yes
                    </button>
                    <button type="button" class="safe-option-btn" data-safe="No" onclick="handleSafeSelect('No')">
                        No
                    </button>
                </div>
            </div>
            <div id="safeToUseError" class="error-text" style="display: none;">Equipment Safe to Use is required</div>

            <!-- Additional Note -->
            <div class="mb-3 d-flex justify-content-end" style="gap:50px;">
                <label for="additionalNote" class="form-label">Additional Note:</label>
                <div class="note-input-container">
                    <textarea class="form-control" id="additionalNote" name="additionalNote" rows="3" placeholder="Enter additional notes..."></textarea>
                    <button type="button" class="voice-input-btn" onclick="handleVoiceInput()" title="Voice Input">
                        <i class="fas fa-microphone"></i>
                    </button>
            </div>
        </div>
        </div>

        <div class="col-md-6">
            <!-- Signature Information -->
            <div class="signature-section">
                <h6 class="signature-section-title">Signature Information</h6>
                
                <!-- Signature Type Selection -->
                <div class="signature-type-container mb-3">
                    <label class="form-label">Signature Type: <span class="required-asterisk">*</span></label>
                    <button type="button" class="signature-type-btn" onclick="openSignatureTypeModal()">
                        <span id="selectedSignatureTypeText">Select Signature Type</span>
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    </div>

                <!-- Dynamic Signature Fields -->
                <div id="signatureFieldsContainer">
                    <!-- Signature fields will be dynamically loaded here -->
                    </div>

                <!-- Signature Errors -->
                <div id="signatureErrorsContainer">
                    <!-- Signature errors will be displayed here -->
                </div>
            </div>
            </div>
        </div>

    <!-- Generate Report Button -->
    <div class="text-center mt-4">
        <button type="button" class="generate-report-btn" id="generateReportBtn" onclick="handleGenerateReport()">
            <i class="fas fa-file-pdf me-2"></i>
            <span id="generateReportText">Generate Report</span>
    </button>
    </div>
    
    <!-- Back Button -->
    <div class="d-flex justify-content-center mt-4">
        <button type="button" class="inspection2-main-back-link" onclick="goToStep2()">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                <path fill="#0055A5" d="M12.727 3.687a1 1 0 1 0-1.454-1.374l-8.5 9a1 1 0 0 0 0 1.374l8.5 9.001a1 1 0 1 0 1.454-1.373L4.875 12z" />
            </svg>
            Back to Do Inspection
        </button>
    </div>
</div>

<!-- Signature Type Selection Modal -->
<div id="signatureTypeModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-header">
            <h3>Select Signature Type <span class="required-asterisk">*</span></h3>
            <button type="button" class="close-btn" onclick="closeSignatureTypeModal()">&times;</button>
        </div>
        <div class="custom-modal-body">
            <div id="signatureTypeOptions">
                <!-- Signature type options will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="doneSignatureTypeBtn" onclick="confirmSignatureTypeSelection()" disabled>
                    Done (<span id="selectedCount">0</span> selected)
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Signature Modal -->
<div id="signatureModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-header">
            <h3 id="signatureModalTitle">Signature</h3>
            <button type="button" class="close-btn" onclick="closeSignatureModal()">&times;</button>
        </div>
        <div class="custom-modal-body">
            <div class="signature-canvas-container">
                <canvas id="signatureCanvas" width="400" height="200"></canvas>
            </div>
            <div class="signature-controls">
                <button type="button" class="btn btn-secondary" onclick="clearSignature()">Clear</button>
                <button type="button" class="btn btn-primary" onclick="confirmSignature()">Confirm</button>
            </div>
        </div>
    </div>
</div>

<!-- Success Modal -->
<div id="successModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-header">
            <h3>Success</h3>
        </div>
        <div class="custom-modal-body text-center">
            <i class="fas fa-check-circle text-success" style="font-size: 48px; margin-bottom: 20px;"></i>
            <h5>Inspection Report Generated and Saved</h5>
            <div id="notificationStatus" class="notification-status" style="display: none;"></div>
            <div id="emailStatus" class="email-status" style="display: none;"></div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" onclick="closeSuccessModal()">Back</button>
            <button type="button" class="btn btn-primary" onclick="viewPDF()">View PDF</button>
        </div>
    </div>
</div>

<!-- Error Modal -->
<div id="errorModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-header" style="background-color: #dc3545;">
            <h3>Error</h3>
        </div>
        <div class="custom-modal-body text-center">
            <i class="fas fa-exclamation-triangle text-danger" style="font-size: 48px; margin-bottom: 20px;"></i>
            <h5 id="errorModalTitle">An Error Occurred</h5>
            <p id="errorModalMessage">Please try again or contact support if the problem persists.</p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" onclick="closeErrorModal()">Close</button>
        </div>
    </div>
</div>

<!-- Sync Modal -->
<div id="syncModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-body text-center">
            <div class="sync-spinner">
                <i class="fas fa-sync-alt fa-spin" style="font-size: 48px; color: #0055A5;"></i>
            </div>
            <h5>Please Wait</h5>
            <p>Generating Report</p>
        </div>
    </div>
</div>

<!-- Voice Recognition Modal -->
<div id="voiceModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-body text-center">
            <i class="fas fa-microphone" style="font-size: 48px; color: #0055A5; margin-bottom: 20px;"></i>
            <h5>Listening...</h5>
            <button type="button" class="btn btn-danger" onclick="stopVoiceInput()">Stop</button>
        </div>
    </div>
</div>

<!-- Note Modal -->
<div id="noteModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-header">
            <h3>Add Note</h3>
            <button type="button" class="close-btn" onclick="closeNoteModal()">&times;</button>
        </div>
        <div class="custom-modal-body">
            <div class="mb-3">
                <label for="noteText" class="form-label">Note Text:</label>
                <textarea class="form-control" id="noteText" rows="4" placeholder="Enter your note here..."></textarea>
            </div>
            <div class="d-flex justify-content-end gap-2">
                <button type="button" class="btn btn-secondary" onclick="closeNoteModal()">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="saveNote()">Save Note</button>
            </div>
        </div>
    </div>
</div>

<!-- Image Selection Modal -->
<div id="imageModal" class="custom-modal">
    <div class="custom-modal-content">
        <div class="custom-modal-header">
            <h3>Select Image</h3>
            <button type="button" class="close-btn" onclick="closeImageModal()">&times;</button>
        </div>
        <div class="custom-modal-body">
            <div class="mb-3">
                <label class="form-label">Choose an option:</label>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-outline-primary" onclick="takePicture()">
                        <i class="fas fa-camera"></i> Take Picture
                    </button>
                    <button type="button" class="btn btn-outline-secondary" onclick="chooseFromGallery()">
                        <i class="fas fa-images"></i> Choose from Gallery
                    </button>
                </div>
            </div>
            <div id="imagePreviewContainer" class="mb-3" style="display: none;">
                <label class="form-label">Image Preview:</label>
                <div class="text-center">
                    <img id="imagePreview" src="" alt="Preview" class="img-fluid" style="max-width: 100%; max-height: 200px; border: 1px solid #ddd; border-radius: 5px;">
                </div>
            </div>
            <div class="d-flex justify-content-end gap-2">
                <button type="button" class="btn btn-secondary" onclick="closeImageModal()">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="saveImage()" id="saveImageBtn" style="display: none;">Save Image</button>
            </div>
        </div>
    </div>
</div>

<!-- Hidden file input for image selection -->
<input type="file" id="imageFileInput" accept="image/*" style="display: none;" onchange="handleImageFileSelect(event)">
@endsection

<style>
/* Additional styling for better form experience */
.inspection2-main-form-control:focus,
.inspection2-main-form-select:focus {
    border-color: #0055A5;
    box-shadow: 0 0 0 0.2rem rgba(0, 85, 165, 0.25);
}

.inspection-checklist-section{
    padding: 32px;
    display: flex;
    justify-content: center;
    flex-direction: column;
    gap: 25px;
}

.inspection-section {
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    overflow: hidden;
}

.section-header {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    padding: 20px 24px;
    cursor: pointer;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #dee2e6;
    transition: all 0.3s ease;
}

.section-header:hover {
    background: linear-gradient(135deg, #e9ecef 0%, #dee2e6 100%);
}

.section-title {
    display: flex;
    align-items: center;
    gap: 12px;
}

.section-title h4 {
    margin: 0;
    font-size: 18px;
    font-weight: 600;
    color: #2c3e50;
}

.section-icon {
    font-size: 16px;
    color: #007bff;
    transition: transform 0.3s ease;
}

.section-header.active .section-icon {
    transform: rotate(180deg);
}

.section-progress {
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    gap: 8px;
}

.progress-text {
    font-size: 14px;
    font-weight: 500;
    color: #6c757d;
}

.progress-bar {
    width: 120px;
    height: 6px;
    background: #e9ecef;
    border-radius: 3px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #28a745 0%, #20c997 100%);
    transition: width 0.3s ease;
}

.inspection-items {
    padding: 0;
}

.inspection-item {
    border-bottom: 1px solid #f1f3f4;
    padding: 24px;
    transition: all 0.3s ease;
}

.inspection-item:hover {
    background: #f8f9fa;
}

.inspection-item:last-child {
    border-bottom: none;
}

.item-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 20px;
}

.item-info {
    display: flex;
    align-items: center;
    gap: 16px;
    flex: 1;
}

.item-number {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 32px;
    height: 32px;
    background: #0055a5;
    color: white;
    border-radius: 50%;
    font-weight: 600;
    font-size: 14px;
    flex-shrink: 0;
}

.item-details {
    flex: 1;
}

.item-title {
    margin: 0 0 4px 0;
    font-size: 16px;
    font-weight: 600;
    color: #2c3e50;
    line-height: 1.4;
}

.item-description {
    margin: 0;
    font-size: 14px;
    color: #6c757d;
    line-height: 1.5;
}

.item-actions {
    display: flex;
    align-items: center;
    gap: 16px;
}

.option-buttons {
    display: flex;
    gap: 8px;
}

.btn-option {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 8px 16px;
    border: 2px solid #dee2e6;
    background: white;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    min-width: 80px;
    justify-content: center;
}

.btn-option:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

.btn-ok {
    color: #28a745;
    border-color: #28a745;
}

.btn-ok:hover,
.btn-ok.selected {
    background: #28a745;
    color:  black;
}

.btn-reject {
    color: #dc3545;
    border-color: #dc3545;
}

.btn-reject:hover,
.btn-reject.selected {
    background: #dc3545;
    color: black;
}

.btn-na {
    color: #6c757d;
    border-color: #6c757d;
}

.btn-na:hover,
.btn-na.selected {
    background: #6c757d;
    color: black;
}

.item-tools {
    display: flex;
    gap: 8px;
}

.btn-tool {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
    border: 1px solid #dee2e6;
    background: white;
    border-radius: 8px;
    color: #6c757d;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-tool:hover {
    background: #f8f9fa;
    border-color: #007bff;
    color: #007bff;
    transform: translateY(-1px);
}

.checklist-header {
    background: #0055a5;
    color: white;
    padding: 24px;
    /* border-radius: 12px 12px 0 0; */
    margin-bottom: 0;
}

.checklist-header h3 {
    margin: 0px;
    font-size: 20px;
    font-weight: 600;
    display: flex;
    align-items: center;
}

.checklist-summary {
    display: flex;
    gap: 24px;
    flex-wrap: wrap;
}

.summary-item {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.summary-label {
    font-size: 12px;
    opacity: 0.9;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.summary-value {
    font-size: 18px;
    font-weight: 700;
}

.is-invalid {
    border-color: #dc3545 !important;
    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
}

.inspection-form-lbl-input.focused label {
    color: #0055A5;
    font-weight: 600;
}

.spinner-border-sm {
    width: 1rem;
    height: 1rem;
}

/* Responsive improvements */
@media (max-width: 768px) {
    .inspection2-main-step-indicator {
        flex-direction: column;
        gap: 1rem;
    }
    
    .inspection2-main .Step-1-Ins-Info {
        font-size: 0.875rem;
        padding: 0.75rem;
    }
}

/* Do Inspection Styles */
.do-inspection-container h3 {
    font-family: Arial;
    font-size: 20px;
    font-weight: 400;
    color: black;
    margin-bottom: 20px;
}

/* Consistent form spacing across all steps */
#do-inspection-container,
#Inspection-Summary-main {
    margin-top: 0;
    width: 97.3%;
    margin: 0 auto;
}

#do-inspection-container .table,
#Inspection-Summary-main form {
    margin-top: 0;
}

.table th,
.table td {
    vertical-align: middle;
}

.table th {
    background-color: #ECF2FF;
    font-weight: bold;
}

.table .do-inspection-expandable-row {
    cursor: pointer;
    background-color: #f8f9fa;
}

thead.do-inspection-table-head th {
    border: none;
}

thead.do-inspection-table-head tr {
    border: none;
}

thead.do-inspection-table-head th {
    font-family: Arial;
    font-size: 20px;
    font-weight: 400;
}

.table .do-inspection-expandable-row:hover {
    background-color: #e9ecef;
}

.table .do-inspection-nested-row {
    background-color: #fff;
}

.do-inspection-inspect-button {
    background: #0055A5;
    border: none;
    border-radius: 6px;
    color: white;
    font-size: 15px;
    font-family: Arial, sans-serif;
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 3px 9px;
    margin: auto;
    cursor: pointer;
}

.do-inspection-inspect-button:hover {
    background-color: #003f7d;
}

td.do-inspection-icon-cell {
    text-align: center;
}

tbody.do-inspection-table-body td {
    border: none;
}

.do-inspection-toggle-icon {
    margin-right: 8px;
    font-size: 1rem;
}

.do-inspection-expandable-row td {
    font-family: Arial;
    font-size: 18px;
    font-weight: 500;
}

.do-inspection-btn-main button {
    background: #0055A5;
    padding: 8px 15px;
    border: none;
    border-radius: 7px;
    color: white;
    font-size: 18px;
    font-family: Arial Light;
    display: flex;
    align-items: center;
    gap: 8px;
    margin: auto;
}

/* Modal Styles */
.do-inspections-popup {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    justify-content: center;
    align-items: center;
    z-index: 1000;
}

.do-inspections-popup-content {
    background-color: white;
    border-radius: 8px;
    width: 800px;
    max-width: 90%;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    overflow: hidden;
}

.do-inspections-popup-header {
    background-color: #0055A5;
    color: white;
    padding: 12px 16px;
    text-align: center;
}

.do-inspections-popup-header h2 {
    margin: 0;
    font-size: 30px;
    font-weight: 400;
}

.do-inspections-popup-body {
    padding: 27px 90px;
}

.do-inspections-popup-condition-section label {
    display: block;
    font-size: 14px;
    margin-bottom: 8px;
}

.do-inspections-popup-condition-options {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
}

.do-inspections-popup-condition-options label {
    display: flex;
    align-items: center;
    gap: 4px;
    font-size: 14px;
}

.do-inspections-popup-condition-options input {
    width: 20px;
    height: 20px;
    margin: 0;
    cursor: pointer;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    border-radius: 4px;
    position: relative;
}

.do-inspections-popup-condition-good {
    border: 1px solid #00c4b4;
}

.do-inspections-popup-condition-repair {
    border: 1px solid #ff9800;
}

.do-inspections-popup-condition-replace {
    border: 1px solid #f44336;
}

.do-inspections-popup-condition-na {
    border: 1px solid #e0e0e0;
}

.do-inspections-popup-condition-options input:checked {
    border: 2px solid #000;
}

.do-inspections-popup-condition-options input:checked::before {
    content: '✔';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-size: 12px;
    color: #000;
}

.do-inspections-popup-inspection-note label {
    display: block;
    font-size: 14px;
    margin: 16px 0 8px;
}

.do-inspections-popup-inspection-note textarea {
    width: 70%;
    height: 60px;
    border: 1px solid #e0e0e0;
    border-radius: 4px;
    padding: 8px;
    font-size: 14px;
    resize: none;
}

.do-inspections-popup-upload-image label {
    display: block;
    font-size: 14px;
    margin: 16px 0 8px;
}

.do-inspections-popup-upload-image .do-inspections-popup-image-preview {
    width: 55%;
    height: 80px;
    background-color: #f0f0f0;
    border-radius: 4px;
    overflow: hidden;
}

.do-inspections-popup-upload-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.do-inspections-popup-upload-btn {
    margin-top: 8px;
    padding: 8px 16px;
    background-color: #0055A5;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-size: 15px;
    font-family: Arial Light;
}

.do-inspections-popup-upload-btn:hover {
    background-color: #0056b3;
}

.do-inspections-popup-footer {
    padding: 16px;
    display: flex;
    gap: 8px;
    justify-content: center;
}

.do-inspections-popup-done-btn,
.do-inspections-popup-cancel-btn {
    padding: 8px 16px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-size: 14px;
}

.do-inspections-popup-done-btn {
    background-color: #0055A5;
    color: white;
    padding: 9px 18px;
    font-size: 22px;
    font-family: Arial;
    font-weight: bold;
    display: flex;
    align-items: center;
    gap: 5px;
}

.do-inspections-popup-done-btn:hover {
    background-color: #0056b3;
}

.do-inspections-popup-cancel-btn {
    background-color: #0055A5;
    color: white;
    padding: 9px 18px;
    font-size: 22px;
    font-family: Arial;
    font-weight: bold;
    display: flex;
    align-items: center;
    gap: 5px;
}

.do-inspections-popup-cancel-btn:hover {
    background-color: #0056b3;
}

.popup-air-text-sebhed p {
    font-size: 24px;
    font-weight: 500;
}

.do-inspections-popup-condition-section {
    display: flex;
    align-items: center;
    gap: 20px;
}

.do-inspections-popup-condition-section label,
.do-inspections-popup-upload-image label {
    font-size: 18px;
    font-family: Arial Light;
    font-weight: 400;
}

.do-inspections-popup-condition-options label {
    gap: 10px;
}

.do-inspections-popup-inspection-note {
    display: flex;
    gap: 10px;
    margin-top: 20px;
}

.do-inspections-popup-upload-image {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-top: 20px;
}

input#imageUpload {
    display: none;
}

/* Inspection Summary Styles */
.required-asterisk {
    color: #FF0000;
    font-weight: bold;
}

/* Faulty Items Container */
.faulty-items-container {
    background-color: #F2F2F2;
    border-radius: 5px;
    padding: 15px;
    text-align: center;
}

.faulty-items-row {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 20px;
}

.faulty-items-label {
    font-size: 18px;
    font-weight: 600;
    color: #015185;
}

.faulty-items-count {
    font-size: 24px;
    font-weight: bold;
    color: #FF0000;
    background-color: #fff;
    padding: 8px 16px;
    border-radius: 20px;
    min-width: 60px;
}

/* Status Options */
.status-options-container {
    display: flex;
    gap: 10px;
    width: 60%;
}

.status-option-btn {
    flex: 1;
    padding: 10px 15px;
    border: 2px solid #ECF0F3;
    border-radius: 5px;
    background-color: #ECF0F3;
    color: #333;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s;
}

.status-option-btn:hover {
    background-color: #D1D5DB;
    transform: translateY(-1px);
}

.status-option-btn.selected {
    background-color: #015185;
    color: #fff;
    border-color: #015185;
}

/* Priority Options */
.priority-options-container {
    display: flex;
    gap: 8px;
    width: 60%;
}

.priority-item {
    flex: 1;
}

.priority-btn {
    width: 100%;
    padding: 8px 12px;
    border: 2px solid #015185;
    border-radius: 5px;
    background-color: #fff;
    color: #015185;
    font-size: 12px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 5px;
}

.priority-btn:hover {
    background-color: #f8f9fa;
    transform: translateY(-1px);
}

.priority-btn.selected {
    background-color: #015185;
    color: #fff;
}

.priority-icon {
    width: 24px;
    height: 24px;
    border-radius: 50%;
}

/* Safe Options */
.safe-options-container {
    display: flex;
    gap: 20px;
    width: 60%;
}

.safe-option-btn {
    flex: 1;
    padding: 10px 20px;
    border: 2px solid #ECF0F3;
    border-radius: 5px;
    background-color: #ECF0F3;
    color: #333;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s;
}

.safe-option-btn:hover {
    background-color: #D1D5DB;
    transform: translateY(-1px);
}

.safe-option-btn.selected {
    background-color: #015185;
    color: #fff;
    border-color: #015185;
}

/* Note Input Container */
.note-input-container {
    position: relative;
    width: 60%;
}

.note-input-container textarea {
    width: 100%;
    background-color: #ECF2FF;
    border: 1px solid #ccc;
    border-radius: 5px;
    padding: 10px;
    resize: vertical;
}

.voice-input-btn {
    position: absolute;
    right: 10px;
    bottom: 10px;
    background-color: #015185;
    color: #fff;
    border: none;
    border-radius: 50%;
    width: 35px;
    height: 35px;
    cursor: pointer;
    transition: all 0.2s;
}

.voice-input-btn:hover {
    background-color: #003f7d;
    transform: scale(1.1);
}

/* Signature Section */
.signature-section {
    background-color: #ECF0F3;
    border-radius: 5px;
    padding: 20px;
}

.signature-section-title {
    font-size: 18px;
    font-weight: 600;
    color: #015185;
    margin-bottom: 20px;
    text-align: center;
}

.signature-type-container {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.signature-type-btn {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 15px;
    border: 2px solid #ccc;
    border-radius: 5px;
    background-color: #fff;
    color: #333;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s;
}

.signature-type-btn:hover {
    border-color: #015185;
    background-color: #f8f9fa;
}

/* Signature Fields */
.signature-field {
    background-color: #fff;
    border-radius: 5px;
    padding: 15px;
    margin-bottom: 15px;
    border: 1px solid #e9ecef;
}

.signature-field-label {
    font-size: 14px;
    font-weight: 600;
    color: #015185;
    margin-bottom: 8px;
}

.signature-input {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid #ccc;
    border-radius: 4px;
    margin-bottom: 10px;
}

.signature-box {
    border: 2px dashed #ccc;
    border-radius: 5px;
    padding: 20px;
    text-align: center;
    cursor: pointer;
    transition: all 0.2s;
    background-color: #f8f9fa;
}

.signature-box:hover {
    border-color: #015185;
    background-color: #e3f2fd;
}

.signature-box.has-signature {
    border-color: #28a745;
    background-color: #d4edda;
}

.signature-preview {
    max-width: 100%;
    max-height: 100px;
    border-radius: 4px;
}

/* Signature Type Selection Modal */
.signature-type-option {
    cursor: pointer;
    padding: 10px;
    border-radius: 5px;
    transition: background-color 0.2s;
}

.signature-type-option:hover {
    background-color: #f8f9fa;
}

.signature-type-label {
    display: flex;
    justify-content: space-between;
    align-items: center;
    cursor: pointer;
    padding: 8px 0;
}

.signature-type-text {
    font-size: 14px;
    color: #333;
}

.signature-type-checkbox {
    width: 20px;
    height: 20px;
    border: 2px solid #ccc;
    border-radius: 4px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s;
}

.signature-type-checkbox i {
    color: transparent;
    font-size: 12px;
    transition: color 0.2s;
}

.signature-type-label.selected .signature-type-checkbox {
    border-color: #015185;
    background-color: #015185;
}

.signature-type-label.selected .signature-type-checkbox i {
    color: #fff;
}

/* Generate Report Button */
.generate-report-btn {
    background: linear-gradient(135deg, #0055A5 0%, #003f7d 100%);
    border: none;
    border-radius: 8px;
    padding: 15px 30px;
    font-size: 18px;
    font-weight: 600;
    color: white;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 85, 165, 0.3);
    display: inline-flex;
    align-items: center;
    gap: 10px;
}

.generate-report-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 85, 165, 0.4);
}

.generate-report-btn:active {
    transform: translateY(0);
}

.generate-report-btn:disabled {
    background: #ccc;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

/* Error Text */
.error-text {
    color: #FF0000;
    font-size: 12px;
    margin-top: 5px;
    display: none;
}

/* Error Modal Styles */
#errorModal .custom-modal-header {
    background-color: #dc3545 !important;
}

#errorModal .fas.fa-exclamation-triangle {
    color: #dc3545;
}

/* Loading Spinner for Generate Report Button */
.generate-report-btn:disabled {
    opacity: 0.7;
    cursor: not-allowed;
}

.generate-report-btn .fa-spinner {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Modal Footer */
.modal-footer {
    margin-top: 20px;
    text-align: center;
}

/* Notification Status */
.notification-status {
    background-color: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 10px;
    margin: 10px 0;
    display: flex;
    align-items: center;
    gap: 8px;
}

.notification-status.success {
    background-color: #d4edda;
    border-color: #c3e6cb;
    color: #155724;
}

.notification-status.error {
    background-color: #f8d7da;
    border-color: #f5c6cb;
    color: #721c24;
}

.notification-status.info {
    background-color: #d1ecf1;
    border-color: #bee5eb;
    color: #0c5460;
}

/* Email Status */
.email-status {
    background-color: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 10px;
    margin: 10px 0;
    display: flex;
    align-items: center;
    gap: 8px;
}

.email-status.success {
    background-color: #d4edda;
    border-color: #c3e6cb;
    color: #155724;
}

.email-status.error {
    background-color: #f8d7da;
    border-color: #f5c6cb;
    color: #721c24;
}

.email-status.info {
    background-color: #d1ecf1;
    border-color: #bee5eb;
    color: #0c5460;
}

/* Signature Canvas */
.signature-canvas-container {
    text-align: center;
    margin-bottom: 20px;
}

#signatureCanvas {
    border: 1px solid #ddd;
    border-radius: 5px;
    cursor: crosshair;
}

.signature-controls {
    display: flex;
    justify-content: center;
    gap: 10px;
}

/* Sync Modal */
.sync-spinner {
    margin-bottom: 20px;
}

/* Voice Modal */
#voiceModal .custom-modal-body {
    text-align: center;
}

#voiceModal .fas.fa-microphone {
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .status-options-container,
    .priority-options-container,
    .safe-options-container {
        width: 100%;
        flex-direction: column;
    }
    
    .note-input-container {
        width: 100%;
    }
    
    .faulty-items-row {
        flex-direction: column;
        gap: 10px;
    }
    
    .signature-type-btn {
        font-size: 12px;
        padding: 10px 12px;
    }
}

/* Form Label Styles */
#Inspection-Summary-main .form-label {
    font-size: 18px;
    font-family: Arial, sans-serif;
    font-weight: 400;
    color: #333;
    margin-bottom: 8px;
}

/* Select Styles */
#overallCondition-select {
    background-color: #ECF2FF;
    background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 1024 1024"><path fill="%238C8C8C" d="M831.872 340.864L512 652.672L192.128 340.864a30.59 30.59 0 0 0-42.752 0a29.12 29.12 0 0 0 0 41.6L489.664 714.24a32 32 0 0 0 44.672 0l340.288-331.712a29.12 29.12 0 0 0 0-41.728a30.59 30.59 0 0 0-42.752 0z"/></svg>');
    background-repeat: no-repeat;
    background-position: right 0.75rem center;
    background-size: 24px 24px;
    padding-right: 2.5rem;
    appearance: none;
    -webkit-appearance: none;
    -moz-appearance: none;
    width: 60%;
    border: 1px solid #ccc;
    border-radius: 5px;
    padding: 8px 12px;
    font-size: 14px;
}

/* Ensure consistent spacing for all step headers */
.inspection-info-hd {
    margin-bottom: 1rem !important;
    margin-top: 0 !important;
    color: #0055A5;
    font-size: 24px;
    font-weight: 600;
    text-align: center;
    border-bottom: 2px solid #e9ecef;
    padding-bottom: 15px;
}

/* Custom Modal Styles */
.custom-modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: -25px;
    width: 100vw;
    height: 120%;
    background-color: rgba(0, 0, 0, 0.5);
}

.custom-modal-content {
    background-color: #fefefe;
    margin: 0 auto;
    padding: 0;
    border: 1px solid #888;
    width: 80%;
    max-width: 600px;
    border-radius: 8px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);

    position:sticky;
    top: 20vh;
    left: 0;
    right: 0;
    bottom: 0;
    z-index: 1000;
}

.custom-modal-header {
    background-color: #0055A5;
    color: white;
    padding: 15px 20px;
    border-radius: 8px 8px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.custom-modal-header h3 {
    margin: 0;
    font-size: 18px;
    font-weight: 500;
}

.close-btn {
    color: white;
    font-size: 28px;
    font-weight: bold;
    background: none;
    border: none;
    cursor: pointer;
    padding: 0;
    line-height: 1;
}

.close-btn:hover {
    opacity: 0.7;
}

.custom-modal-body {
    padding: 20px;
}

.search-container {
    display: flex;
    gap: 10px;
    margin-bottom: 20px;
}

.search-input {
    flex: 1;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 14px;
}

.search-btn {
    padding: 10px 15px;
    background-color: #0055A5;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
}

.search-btn:hover {
    background-color: #003f7d;
}

.equipment-list, .checklist-list {
    max-height: 400px;
    overflow-y: auto;
    border: 1px solid #eee;
    border-radius: 4px;
}

.equipment-item, .checklist-item {
    padding: 15px;
    border-bottom: 1px solid #eee;
    cursor: pointer;
    transition: background-color 0.2s;
}

.equipment-item:hover, .checklist-item:hover {
    background-color: #f8f9fa;
}

.equipment-item:last-child, .checklist-item:last-child {
    border-bottom: none;
}

.equipment-name {
    font-weight: 600;
    color: #0055A5;
    margin-bottom: 5px;
}

.equipment-details, .checklist-details {
    font-size: 14px;
    color: #666;
    line-height: 1.4;
}

.checklist-title {
    font-weight: 600;
    color: #0055A5;
    margin-bottom: 5px;
}

/* Loading spinner styles */
.spinner-border {
    display: inline-block;
    width: 2rem;
    height: 2rem;
    vertical-align: text-bottom;
    border: 0.25em solid currentColor;
    border-right-color: transparent;
    border-radius: 50%;
    animation: spinner-border .75s linear infinite;
}

.spinner-border-sm {
    width: 1rem;
    height: 1rem;
    border-width: 0.2em;
}

@keyframes spinner-border {
    to { transform: rotate(360deg); }
}

.text-primary {
    color: #0055A5 !important;
}

.text-center {
    text-align: center;
}

.p-3 {
    padding: 1rem !important;
}

.mt-2 {
    margin-top: 0.5rem !important;
}

/* Responsive improvements for modals */
@media (max-width: 768px) {
    .custom-modal-content {
        width: 95%;
        margin: 10% auto;
    }
    
    .search-container {
        flex-direction: column;
    }
    
    .equipment-list, .checklist-list {
        max-height: 300px;
    }
}

/* Back Button Styles */
.inspection2-main-back-link {
    background: none;
    border: none;
    color: #0055A5;
    font-size: 16px;
    font-family: Arial;
    display: flex;
    align-items: center;
    gap: 8px;
    cursor: pointer;
    text-decoration: none;
    padding: 0;
}

.inspection2-main-back-link:hover {
    color: #003f7d;
    text-decoration: underline;
}

/* Step Indicator Styles - Matching the image design */
.inspection2-main-step-indicator {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 20px;
    margin: 30px 0;
    position: relative;
    padding: 20px 0;
}

.step-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
    cursor: pointer;
}

.step-icon {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    position: relative;
}

.step-item.active .step-icon {
    background-color: #0055a5;
    color: white;
    transform: scale(1.1);
    box-shadow: 0 4px 15px rgba(0, 85, 165, 0.3);
    border-radius: 50%;
}

.step-item:not(.active) .step-icon {
    background-color: #f8f9fa;
    color: #6c757d;
    border: 2px solid #e9ecef;
    border-radius: 50%;
}

.step-text {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
}

.step-title {
    font-size: 16px;
    font-weight: 500;
    color: #495057;
}

.step-item.active .step-title {
    color: #0055A5;
    font-weight: 700;
}

.step-connector {
    width: 100px;
    height: 2px;
    background: linear-gradient(to right, #e9ecef 50%, #e9ecef 50%);
    transition: all 0.5s ease;
    position: relative;
}

.step-connector.active {
    background: linear-gradient(to right, #0055A5 50%, #e9ecef 50%);
}

.step-connector.completed {
    background: linear-gradient(to right, #0055A5 100%, #0055A5 100%);
}

.btn-cancel{
    display: inline-flex;
    align-items: center;
    gap: 12px;
    padding: 16px 32px;
    border: none;
    border-radius: 0;
    background: #0055a5;
    color: white;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

.btn-cancel:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black !important;
}

.btn-complete{
    display: inline-flex;
    align-items: center;
    gap: 12px;
    padding: 16px 32px;
    border: none;
    border-radius: 0;
    background: #00B894;
    color: white;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

.btn-complete:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black !important;
}

/* Loading spinner styles */
.spinner-border {
    display: inline-block;
    width: 2rem;
    height: 2rem;
    vertical-align: text-bottom;
    border: 0.25em solid currentColor;
    border-right-color: transparent;
    border-radius: 50%;
    animation: spinner-border .75s linear infinite;
}

.spinner-border-sm {
    width: 1rem;
    height: 1rem;
    border-width: 0.2em;
}

@keyframes spinner-border {
    to { transform: rotate(360deg); }
}

.text-primary {
    color: #0055A5 !important;
}

.text-center {
    text-align: center;
}

.p-3 {
    padding: 1rem !important;
}

.mt-2 {
    margin-top: 0.5rem !important;
}

/* Responsive improvements for modals */
@media (max-width: 768px) {
    .custom-modal-content {
        width: 95%;
        margin: 10% auto;
    }
    
    .search-container {
        flex-direction: column;
    }
    
    .equipment-list, .checklist-list {
        max-height: 300px;
    }
}

/* Meter Reading Styles */
.meter-reading-input-select {
    display: flex;
    gap: 10px;
    align-items: center;
}

.meter-reading-input-select .inspection2-main-form-control {
    flex: 1;
}

.meter-reading-input-select .inspection2-main-form-select {
    min-width: 120px;
}

.current-meter-info {
    margin-top: 8px;
    padding: 8px 12px;
    background-color: #f8f9fa;
    border-radius: 4px;
    border-left: 3px solid #0055A5;
}

.current-meter-info .currentMeterValue {
    font-weight: 600;
    color: #0055A5;
}

/* Equipment Details Box Improvements */
.equipmentDetailsBox {
    background-color: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 20px;
    margin: 15px 0;
}

.vehicleEquipmentRow {
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 1px solid #dee2e6;
}

.vehicleEquipmentText {
    font-size: 16px;
    color: #495057;
    font-weight: 500;
}

.meterReadingContainer {
    background-color: #fff;
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 15px;
}

.labelRow {
    margin-bottom: 10px;
}

.meterReadingLabel {
    font-size: 14px;
    color: #495057;
    font-weight: 600;
}

.inputRow {
    display: flex;
    align-items: center;
    background-color: #fff;
    border: 1px solid #ced4da;
    border-radius: 4px;
    padding: 8px 12px;
    margin-bottom: 10px;
}

.meterReadingInput {
    flex: 1;
    border: none;
    outline: none;
    font-size: 16px;
    color: #495057;
}

.meterUnit {
    color: #6c757d;
    font-size: 14px;
    font-weight: 500;
    margin-left: 10px;
    min-width: 60px;
}

.currentMeterRow {
    display: flex;
    align-items: center;
    justify-content: space-between;
    background-color: #e3f2fd;
    padding: 10px 12px;
    border-radius: 4px;
    border: 1px solid #bbdefb;
}

.currentMeterLabel {
    font-size: 14px;
    color: #1976d2;
    font-weight: 500;
}

.currentMeterValue {
    font-size: 14px;
    color: #1976d2;
    font-weight: 600;
}

.required {
    color: #dc3545;
    font-weight: bold;
}

/* GPS Location Styles */
.gps-details-box {
    background-color: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 15px;
    margin-top: 10px;
}

.gps-info-row {
    display: flex;
    align-items: center;
    margin-bottom: 10px;
    padding: 8px 0;
}

.gps-label {
    font-weight: 600;
    color: #495057;
    min-width: 120px;
    margin-right: 10px;
}

.gps-value {
    color: #0055A5;
    font-weight: 500;
    flex: 1;
}

/* Form Improvements */
.inspection-form-lbl-input {
    margin-bottom: 1.5rem;
}

.inspection2-main-form-label {
    font-weight: 600;
    color: #495057;
    margin-bottom: 0.5rem;
    display: block;
}

.inspection2-main-form-control,
.inspection2-main-form-select {
    border: 1px solid #ced4da;
    border-radius: 6px;
    padding: 12px 15px;
    font-size: 14px;
    transition: all 0.3s ease;
    background-color: #fff;
}

.inspection2-main-form-control:focus,
.inspection2-main-form-select:focus {
    border-color: #0055A5;
    box-shadow: 0 0 0 0.2rem rgba(0, 85, 165, 0.25);
    outline: none;
}

.inspection2-main-form-control:disabled {
    background-color: #e9ecef;
    cursor: not-allowed;
}

.inspection2-main-required::after {
    content: " *";
    color: #dc3545;
    font-weight: bold;
}

/* Button Styles */
.btn-outline-primary {
    color: #0055A5;
    border-color: #0055A5;
    background-color: transparent;
    transition: all 0.3s ease;
}

.btn-outline-primary:hover {
    color: #fff;
    background-color: #0055A5;
    border-color: #0055A5;
}

.btn-outline-secondary {
    color: #6c757d;
    border-color: #6c757d;
    background-color: transparent;
    transition: all 0.3s ease;
}

.btn-outline-secondary:hover {
    color: #fff;
    background-color: #6c757d;
    border-color: #6c757d;
}

/* Equipment Selection Button */
.equipment-selection-btn {
    background-color: #0055A5;
    color: white;
    border: none;
    border-radius: 6px;
    padding: 8px 16px;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.equipment-selection-btn:hover {
    background-color: #003f7d;
    transform: translateY(-1px);
}

/* Responsive improvements */
@media (max-width: 768px) {
    .meter-reading-input-select {
        flex-direction: column;
        gap: 8px;
    }
    
    .gps-info-row {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .gps-label {
        min-width: auto;
        margin-bottom: 5px;
    }
}

/* Final Form Styling Improvements */
.inspection2-main {
    background-color: #fff;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.inspection-info-hd {
    color: #0055A5;
    font-size: 24px;
    font-weight: 600;
    text-align: center;
    margin-bottom: 30px;
    border-bottom: 2px solid #e9ecef;
    padding-bottom: 15px;
}

/* Form Section Styling */
.form-section {
    background-color: #f8f9fa;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
    border: 1px solid #e9ecef;
}

.form-section-title {
    color: #495057;
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 1px solid #dee2e6;
}

/* Equipment Details Styling */
.equipment-details-section {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 1px solid #dee2e6;
    border-radius: 8px;
    padding: 20px;
    margin: 15px 0;
}

.equipment-info-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 0;
    border-bottom: 1px solid #dee2e6;
}

.equipment-info-row:last-child {
    border-bottom: none;
}

.equipment-label {
    font-weight: 600;
    color: #495057;
    min-width: 150px;
}

.equipment-value {
    color: #0055A5;
    font-weight: 500;
    text-align: right;
}

/* Meter Reading Section */
.meter-reading-section {
    background-color: #fff;
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 15px;
    margin-top: 15px;
}

.meter-reading-header {
    display: flex;
    align-items: center;
    margin-bottom: 15px;
}

.meter-reading-icon {
    color: #0055A5;
    margin-right: 10px;
    font-size: 18px;
}

.meter-reading-title {
    font-weight: 600;
    color: #495057;
    font-size: 16px;
}

/* GPS Location Button */
.gps-location-btn {
    background: linear-gradient(135deg, #0055A5 0%, #003f7d 100%);
    color: white;
    border: none;
    border-radius: 8px;
    padding: 12px 24px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 85, 165, 0.3);
}

.gps-location-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 85, 165, 0.4);
}

.gps-location-btn:active {
    transform: translateY(0);
}

/* Next Button Styling */
.inspection2-main-btn-next {
    background: linear-gradient(135deg, #0055A5 0%, #003f7d 100%);
    border: none;
    border-radius: 8px;
    padding: 15px 30px;
    font-size: 18px;
    font-weight: 600;
    color: white;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 85, 165, 0.3);
    display: flex;
    align-items: center;
    gap: 10px;
}

.inspection2-main-btn-next:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 85, 165, 0.4);
}

.inspection2-main-btn-next:active {
    transform: translateY(0);
}

/* Error and Success States */
.form-control.is-invalid {
    border-color: #dc3545;
    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
}

.form-control.is-valid {
    border-color: #28a745;
    box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
}

.invalid-feedback {
    display: block;
    width: 100%;
    margin-top: 0.25rem;
    font-size: 0.875em;
    color: #dc3545;
}

/* Loading States */
.loading-spinner {
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 3px solid #f3f3f3;
    border-top: 3px solid #0055A5;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Step 2: Do Inspection Styles */
.checklist-title-display {
    background-color: #F2F2F2;
    padding: 15px;
    border-radius: 5px;
    text-align: center;
}

.checklist-title-display h6 {
    margin: 0;
    font-size: 18px;
    font-weight: 600;
    color: #015185;
}

.header-inputs-container {
    background-color: #F2F2F2;
    border-radius: 5px;
    padding: 15px;
}

.header-inputs-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}

.header-inputs-title {
    font-size: 18px;
    font-weight: 600;
    color: #333;
    margin: 0;
    flex: 1;
    margin-right: 10px;
}

.required-text {
    color: #e74c3c;
    font-weight: 600;
}

.input-field-container {
    margin-bottom: 15px;
}

.input-label {
    font-size: 14px;
    color: #555;
    margin-bottom: 5px;
    display: block;
}

.header-input-field {
    height: 40px;
    border: 1px solid #ccc;
    border-radius: 5px;
    padding: 8px 12px;
    font-size: 14px;
    color: #333;
    width: 100%;
}

.disabled-input {
    background-color: #E0E0E0;
    cursor: not-allowed;
}

.error-text {
    color: #FF4B2B;
    font-size: 12px;
    margin-top: 5px;
    display: none;
}

/* .inspection-sections-container {
    margin-top: 0;
} */

.heading-container {
    padding: 10px 0;
    margin: 0 5%;
}

.heading-text {
    font-size: 20px;
    font-weight: 500;
    color: #015185;
    margin: 0;
}

.inspection-section {
    margin-bottom: 15px;
}

.section-header {
    cursor: pointer;
    user-select: none;
}

.section-header-content {
    display: flex;
    align-items: center;
    background-color: #F2F2F2;
    padding: 10px 15px;
    border-radius: 5px;
    transition: background-color 0.2s;
}

.section-header-content:hover {
    background-color: #E9E9E9;
}

.section-toggle-icon {
    margin-right: 10px;
    color: #333;
    transition: transform 0.2s;
}

.section-header-text-container {
    display: flex;
    align-items: center;
    flex: 1;
}

.section-header-text {
    font-size: 16px;
    font-weight: 600;
    color: #333;
    margin-right: 10px;
}

.section-item-count {
    font-size: 14px;
    color: #666;
}

.section-content {
    background-color: #fff;
    padding: 15px;
    border: 1px solid #E9E9E9;
    border-top: none;
    border-radius: 0 0 5px 5px;
}

.inspection-item {
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 1px solid #eee;
}

.inspection-item:last-child {
    border-bottom: none;
}

.item-container {
    padding-bottom: 10px;
}

.item-text {
    font-size: 16px;
    font-weight: 500;
    color: #333;
    margin-bottom: 8px;
}

.detail-text {
    font-size: 14px;
    color: #666;
    margin-bottom: 4px;
}

.item-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-top: 10px;
}

.options-container {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    flex: 1;
    margin-right: 15px;
}

.option-button {
    padding: 8px 16px;
    border: 1px solid #ECF0F3;
    border-radius: 5px;
    background-color: #ECF0F3;
    color: #333;
    font-size: 14px;
    min-width: 60px;
    transition: all 0.2s;
    font-weight: 500;
}

.option-button:hover {
    background-color: #D1D5DB;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.selected-option-button {
    background-color: #333;
    color: #fff;
    border-color: #333;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}

.ok-button {
    background-color: #015185;
    color: #fff;
    border-color: #015185;
}

.ok-button:hover {
    background-color: #003f7d;
    border-color: #003f7d;
}

.reject-button {
    background-color: #FF4B2B;
    color: #fff;
    border-color: #FF4B2B;
}

.reject-button:hover {
    background-color: #e6390c;
    border-color: #e6390c;
}

.na-button {
    background-color: #2193b0;
    color: #fff;
    border-color: #2193b0;
}

.na-button:hover {
    background-color: #1c7a94;
    border-color: #1c7a94;
}

.custom-option-button {
    background-color: #6c757d;
    color: #fff;
    border-color: #6c757d;
}

.custom-option-button:hover {
    background-color: #5a6268;
    border-color: #5a6268;
}

.icons-container {
    display: flex;
    gap: 8px;
}

.inspection-action-btn {
    padding: 8px 12px;
    border-radius: 6px;
    transition: all 0.2s;
    border-width: 2px;
}

.inspection-action-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.inspection-action-btn i {
    font-size: 14px;
}

.note-display {
    background-color: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 5px;
    padding: 10px;
    margin-top: 10px;
    font-size: 14px;
    color: #495057;
    border-left: 3px solid #007bff;
}

.image-display {
    margin-top: 10px;
    text-align: center;
}

.inspection-image {
    max-width: 100%;
    max-height: 150px;
    border: 1px solid #dee2e6;
    border-radius: 5px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.empty-section-text {
    font-size: 16px;
    color: #888;
    text-align: center;
    padding: 20px;
    font-style: italic;
}

/* Responsive improvements for Step 2 */
@media (max-width: 768px) {
    .header-inputs-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    
    .item-row {
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    
    .options-container {
        margin-right: 0;
        width: 100%;
    }
    
    .icons-container {
        align-self: flex-end;
    }
    
    .option-button {
        min-width: 50px;
        padding: 6px 12px;
        font-size: 13px;
    }
}
</style>

<script>
// Add form field focus effects
document.querySelectorAll('.inspection2-main-form-control, .inspection2-main-form-select').forEach(field => {
    field.addEventListener('focus', function() {
        this.parentElement.classList.add('focused');
    });
    
    field.addEventListener('blur', function() {
        this.parentElement.classList.remove('focused');
    });
});

// Country and Project dependency
function updateProjects() {
    const country = document.getElementById('country').value;
    const projectSelect = document.getElementById('project');
    
    // Clear current projects
    projectSelect.innerHTML = '<option value="">Select Project</option>';
    projectSelect.disabled = true;
    
    if (country === 'Zambia') {
        const projects = ['Kobold', 'Kalumbila', 'Kansanshi', 'Kimiteto', 'Mimosa'];
        projects.forEach(project => {
            const option = document.createElement('option');
            option.value = project;
            option.textContent = project;
            projectSelect.appendChild(option);
        });
        projectSelect.disabled = false;
    } else if (country === 'DRC') {
        const projects = ['Musompo', 'IME'];
        projects.forEach(project => {
            const option = document.createElement('option');
            option.value = project;
            option.textContent = project;
            projectSelect.appendChild(option);
        });
        projectSelect.disabled = false;
    }
    
    // Clear project selection when country changes
    projectSelect.value = '';
    
    // Generate request number
    generateRequestNumber();
}

// Generate request number in format: country-project-IR-number
function generateRequestNumber() {
    const country = document.getElementById('country').value;
    const project = document.getElementById('project').value;
    const reportNumberInput = document.getElementById('reportNumber');
    
    if (!country || !project) {
        reportNumberInput.value = '';
        reportNumberInput.placeholder = 'Select country and project first';
        return;
    }
    
    // Generate country and project codes
    const countryCode = country === 'Zambia' ? 'ZAM' : country === 'DRC' ? 'DRC' : 'XXX';
    const projectCode = project ? project.slice(0, 3).toUpperCase() || 'XXX' : 'XXX';
    
    // Generate a random 3-digit number for now (you can implement a counter system later)
    const randomNumber = Math.floor(Math.random() * 900) + 100; // 100-999
    
    const newRequestNumber = `${countryCode}-${projectCode}-IR-${randomNumber}`;
    reportNumberInput.value = newRequestNumber;
    reportNumberInput.placeholder = '';
}

// GPS Location functionality
function handleGetLocation() {
    if (navigator.geolocation) {
        const gpsDetailsBox = document.getElementById('gpsDetailsBox');
        gpsDetailsBox.style.display = 'block';
        
        // Show loading state
        document.getElementById('coordinates').textContent = 'Getting location...';
        document.getElementById('gpsAddress').textContent = 'Getting address...';
        
        navigator.geolocation.getCurrentPosition(
            function(position) {
                const latitude = position.coords.latitude;
                const longitude = position.coords.longitude;
                const coordinates = `${latitude}, ${longitude}`;
                
                // Update coordinates display
                document.getElementById('coordinates').textContent = coordinates;
                document.getElementById('coordinatesInput').value = coordinates;
                
                // Try to get address from coordinates
                fetchAddressFromCoordinates(latitude, longitude);
            },
            function(error) {
                console.error('Error getting location:', error);
                document.getElementById('coordinates').textContent = 'Location access denied';
                document.getElementById('gpsAddress').textContent = 'Address unavailable';
            },
            {
                enableHighAccuracy: true,
                timeout: 15000,
                maximumAge: 10000
            }
        );
    } else {
        showErrorAlert('Geolocation Error', 'Geolocation is not supported by this browser.');
    }
}

async function fetchAddressFromCoordinates(latitude, longitude) {
    try {
        // Using a free reverse geocoding service (you may want to use Google Maps API with your own key)
        const response = await fetch(`https://nominatim.openstreetmap.org/reverse?format=json&lat=${latitude}&lon=${longitude}&zoom=18&addressdetails=1`);
        const data = await response.json();
        
        if (data.display_name) {
            const address = data.display_name;
            document.getElementById('gpsAddress').textContent = address;
            document.getElementById('gpsAddressInput').value = address;
        } else {
            document.getElementById('gpsAddress').textContent = 'Address not found';
        }
    } catch (error) {
        console.error('Error fetching address:', error);
        document.getElementById('gpsAddress').textContent = 'Address fetch failed';
    }
}

// Meter reading validation
function validateMeterReading() {
    const meterInput = document.getElementById('meter-Reading-input');
    const currentMeterValue = document.querySelector('.currentMeterValue');
    
    if (!meterInput.value || !currentMeterValue.textContent || currentMeterValue.textContent === 'Not selected') {
        return true; // Skip validation if no equipment selected or no current reading
    }
    
    const newReading = parseFloat(meterInput.value);
    const currentReadingText = currentMeterValue.textContent;
    const currentReading = parseFloat(currentReadingText.replace(/[^\d.]/g, ''));
    
    // Check for invalid or extremely large numbers
    if (isNaN(newReading) || isNaN(currentReading)) {
        return true; // Skip validation if parsing fails
    }
    
    // Check for extremely large numbers (scientific notation with very large exponents)
    if (newReading > 1e15 || currentReading > 1e15) {
        return true; // Skip validation for extremely large numbers
    }
    
    if (newReading <= currentReading) {
        // Show error message
        showMeterReadingError(`New meter reading (${newReading}) must be greater than current reading (${currentReading})`);
        return false;
    }
    
    // Clear any previous error
    clearMeterReadingError();
    return true;
}

function showMeterReadingError(message) {
    // Remove any existing error
    clearMeterReadingError();
    
    const meterInput = document.getElementById('meter-Reading-input');
    const errorDiv = document.createElement('div');
    errorDiv.className = 'meter-reading-error';
    errorDiv.style.color = '#dc3545';
    errorDiv.style.fontSize = '12px';
    errorDiv.style.marginTop = '5px';
    errorDiv.textContent = message;
    
    meterInput.parentElement.appendChild(errorDiv);
    meterInput.classList.add('is-invalid');
}

function clearMeterReadingError() {
    const existingError = document.querySelector('.meter-reading-error');
    if (existingError) {
        existingError.remove();
    }
    
    const meterInput = document.getElementById('meter-Reading-input');
    meterInput.classList.remove('is-invalid');
}

// Add meter reading validation on input change
document.addEventListener('DOMContentLoaded', function() {
    const meterInput = document.getElementById('meter-Reading-input');
    if (meterInput) {
        meterInput.addEventListener('input', function() {
            if (this.value) {
                validateMeterReading();
            } else {
                clearMeterReadingError();
            }
        });
        
        meterInput.addEventListener('blur', function() {
            if (this.value) {
                validateMeterReading();
            }
        });
    }
});

// Do Inspection Functions
function openInspectionModal() {
    openModal('inspectionModal');
}

function closeInspectionModal() {
    closeModal('inspectionModal');
}

// Handle image upload and preview
document.addEventListener('DOMContentLoaded', function() {
    const imageUpload = document.getElementById('imageUpload');
    if (imageUpload) {
        imageUpload.addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const imagePreview = document.getElementById('imagePreview');
                    if (imagePreview) {
                        imagePreview.src = e.target.result;
                    }
                };
                reader.readAsDataURL(file);
            }
        });
    }

    // Initialize do inspection expandable rows
    const expandableRows = document.querySelectorAll('.do-inspection-expandable-row');
    expandableRows.forEach(row => {
        row.addEventListener('click', function() {
            const icon = this.querySelector('.do-inspection-toggle-icon');
            if (icon) {
                const isExpanded = this.getAttribute('aria-expanded') === 'true';
                icon.classList.toggle('bi-chevron-down', !isExpanded);
                icon.classList.toggle('bi-chevron-up', isExpanded);
            }
        });
    });
    
    
    // Load initial data
    loadEquipmentData();
    loadChecklistData();
});

// Step 3: Inspection Summary Functions

// Global variables for Step 3
let step3Data = {
    overallCondition: '',
    equipmentStatus: '',
    priority: '',
    safeToUse: '',
    additionalNote: '',
    signatureFields: [],
    selectedSignatureTypes: [],
    signatureValues: {},
    individualSignatures: {},
    individualSignatureStatus: {}
};

let currentSignatureField = null;
let currentSignatureType = null;
let signatureCanvas = null;
let isDrawing = false;
let lastX = 0;
let lastY = 0;

// Load faulty items count from Step 2
function loadFaultyItemsCount() {
    try {
        const selections = inspectionSelections || {};
        let faultyCount = 0;
        
        Object.values(selections).forEach(selection => {
            if (selection === 'Faulty' || selection === 'Reject' || selection === 'Not Ok') {
                faultyCount++;
            }
        });
        
        document.getElementById('faultyItemsCount').textContent = faultyCount;
        return faultyCount;
    } catch (error) {
        console.error('Error loading faulty items count:', error);
        return 0;
    }
}

// Handle status selection
function handleStatusSelect(status) {
    step3Data.equipmentStatus = status;
    
    // Update button states
    document.querySelectorAll('.status-option-btn').forEach(btn => {
        btn.classList.remove('selected');
        if (btn.dataset.status === status) {
            btn.classList.add('selected');
        }
    });
    
    // Show/hide priority container
    const priorityContainer = document.getElementById('priorityContainer');
    if (status === 'Maintenance Required' || status === 'Breakdown') {
        priorityContainer.style.display = 'flex';
    } else {
        priorityContainer.style.display = 'none';
        step3Data.priority = '';
        // Clear priority button selections
        document.querySelectorAll('.priority-btn').forEach(btn => {
            btn.classList.remove('selected');
        });
    }
    
    // Clear error
    document.getElementById('equipmentStatusError').style.display = 'none';
}

// Handle priority selection
function handlePrioritySelect(priority) {
    step3Data.priority = priority;
    
    // Update button states
    document.querySelectorAll('.priority-btn').forEach(btn => {
        btn.classList.remove('selected');
        if (btn.dataset.priority === priority) {
            btn.classList.add('selected');
        }
    });
}

// Handle safe selection
function handleSafeSelect(safe) {
    step3Data.safeToUse = safe;
    
    // Update button states
    document.querySelectorAll('.safe-option-btn').forEach(btn => {
        btn.classList.remove('selected');
        if (btn.dataset.safe === safe) {
            btn.classList.add('selected');
        }
    });
    
    // Clear error
    document.getElementById('safeToUseError').style.display = 'none';
}

// Handle overall condition change
document.addEventListener('DOMContentLoaded', function() {
    const overallConditionSelect = document.getElementById('overallCondition-select');
    if (overallConditionSelect) {
        overallConditionSelect.addEventListener('change', function() {
            step3Data.overallCondition = this.value;
            document.getElementById('overallConditionError').style.display = 'none';
        });
    }
    
    // Handle additional note change
    const additionalNoteTextarea = document.getElementById('additionalNote');
    if (additionalNoteTextarea) {
        additionalNoteTextarea.addEventListener('input', function() {
            step3Data.additionalNote = this.value;
        });
    }
});

// Voice input functionality
function handleVoiceInput() {
    if ('webkitSpeechRecognition' in window || 'SpeechRecognition' in window) {
        const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
        const recognition = new SpeechRecognition();
        
        recognition.continuous = false;
        recognition.interimResults = false;
        recognition.lang = 'en-US';
        
        // Show voice modal
        openModal('voiceModal');
        
        recognition.onstart = function() {
            console.log('Voice recognition started');
        };
        
        recognition.onresult = function(event) {
            const transcript = event.results[0][0].transcript;
            const additionalNoteTextarea = document.getElementById('additionalNote');
            if (additionalNoteTextarea) {
                additionalNoteTextarea.value = transcript;
                step3Data.additionalNote = transcript;
            }
        };
        
        recognition.onerror = function(event) {
            console.error('Voice recognition error:', event.error);
            showErrorAlert('Voice Recognition Error', 'Voice recognition error: ' + event.error);
            closeVoiceModal();
        };
        
        recognition.onend = function() {
            closeVoiceModal();
        };
        
        recognition.start();
    } else {
        alert('Speech recognition is not supported in this browser.');
    }
}

function stopVoiceInput() {
    closeVoiceModal();
}

function closeVoiceModal() {
    closeModal('voiceModal');
}

// Signature functionality
function openSignatureTypeModal() {
    // Load signature type options from checklist
    loadSignatureTypeOptions();
    openModal('signatureTypeModal');
}

function closeSignatureTypeModal() {
    closeModal('signatureTypeModal');
}

function loadSignatureTypeOptions() {
    const container = document.getElementById('signatureTypeOptions');
    
    // Default signature types (you can load these from checklist data)
    const defaultSignatureTypes = [
        { key: 'driller', label: 'Driller Signature', required: true },
        { key: 'mechanic', label: 'Mechanic Signature', required: true },
        { key: 'supervisor', label: 'Supervisor Signature', required: true },
        { key: 'operator', label: 'Operator Signature', required: true },
        { key: 'inspector', label: 'Inspector Signature', required: true },
        { key: 'engineer', label: 'Engineer Signature', required: true },
        { key: 'technician', label: 'Technician Signature', required: true },
        { key: 'manager', label: 'Manager Signature', required: true }
    ];
    
    const html = defaultSignatureTypes.map(type => `
        <div class="signature-type-option" onclick="toggleSignatureTypeSelection('${type.key}')">
            <input type="checkbox" id="signature_${type.key}" data-key="${type.key}" style="display: none;">
            <label for="signature_${type.key}" class="signature-type-label">
                <span class="signature-type-text">${type.label}</span>
                <span class="signature-type-checkbox">
                    <i class="fas fa-check"></i>
                </span>
            </label>
        </div>
    `).join('');
    
    container.innerHTML = html;
}

function toggleSignatureTypeSelection(key) {
    const checkbox = document.getElementById(`signature_${key}`);
    const label = checkbox.nextElementSibling;
    
    if (checkbox.checked) {
            checkbox.checked = false;
        label.classList.remove('selected');
        step3Data.selectedSignatureTypes = step3Data.selectedSignatureTypes.filter(k => k !== key);
    } else {
        checkbox.checked = true;
        label.classList.add('selected');
        step3Data.selectedSignatureTypes.push(key);
    }
    
    updateSignatureTypeSelectionUI();
}

function updateSignatureTypeSelectionUI() {
    const selectedCount = step3Data.selectedSignatureTypes.length;
    const doneBtn = document.getElementById('doneSignatureTypeBtn');
    const selectedCountSpan = document.getElementById('selectedCount');
    
    selectedCountSpan.textContent = selectedCount;
    doneBtn.disabled = selectedCount === 0;
}

function confirmSignatureTypeSelection() {
    if (step3Data.selectedSignatureTypes.length === 0) {
        alert('Please select at least one signature type.');
        return;
    }
    
    // Generate signature fields based on selection
    generateSignatureFields();
    
    closeSignatureTypeModal();
}

function generateSignatureFields() {
    const container = document.getElementById('signatureFieldsContainer');
    
    const html = step3Data.selectedSignatureTypes.map(type => {
        const signatureType = getSignatureTypeLabel(type);
        return `
            <div class="signature-field">
                <label class="signature-field-label">${signatureType} Name:</label>
                <input type="text" class="signature-input" 
                       placeholder="Enter ${signatureType.toLowerCase()} name"
                       onchange="updateSignatureValue('${type}_name', this.value)">
                
                <label class="signature-field-label">${signatureType} Signature:</label>
                <div class="signature-box" onclick="openSignatureModal('${type}')" id="signature_box_${type}">
                    <div id="signature_content_${type}">
                        <i class="fas fa-plus" style="font-size: 24px; color: #ccc;"></i>
                        <p style="margin: 5px 0; color: #666;">Tap to add signature</p>
                    </div>
                </div>
            </div>
        `;
    }).join('');
    
    container.innerHTML = html;
    
    // Update signature type text
    const selectedText = step3Data.selectedSignatureTypes.map(type => getSignatureTypeLabel(type)).join(' & ');
    document.getElementById('selectedSignatureTypeText').textContent = selectedText;
}

function getSignatureTypeLabel(key) {
    const labels = {
        'driller': 'Driller',
        'mechanic': 'Mechanic',
        'supervisor': 'Supervisor',
        'operator': 'Operator',
        'inspector': 'Inspector',
        'engineer': 'Engineer',
        'technician': 'Technician',
        'manager': 'Manager'
    };
    return labels[key] || key;
}

function updateSignatureValue(key, value) {
    step3Data.signatureValues[key] = value;
}

function openSignatureModal(type) {
    currentSignatureField = type;
    currentSignatureType = getSignatureTypeLabel(type);
    document.getElementById('signatureModalTitle').textContent = `${currentSignatureType} Signature`;
    openModal('signatureModal');
    
    // Initialize signature canvas
    initSignatureCanvas();
}

function closeSignatureModal() {
    closeModal('signatureModal');
    currentSignatureField = null;
    currentSignatureType = null;
}

function initSignatureCanvas() {
    const canvas = document.getElementById('signatureCanvas');
    const ctx = canvas.getContext('2d');
    
    // Set canvas size
    canvas.width = 400;
    canvas.height = 200;
    
    // Set canvas style
    ctx.strokeStyle = '#000';
    ctx.lineWidth = 2;
    ctx.lineCap = 'round';
    
    // Clear canvas
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    
    // Event listeners
    canvas.addEventListener('mousedown', startDrawing);
    canvas.addEventListener('mousemove', draw);
    canvas.addEventListener('mouseup', stopDrawing);
    canvas.addEventListener('mouseout', stopDrawing);
    
    // Touch events for mobile
    canvas.addEventListener('touchstart', handleTouch);
    canvas.addEventListener('touchmove', handleTouch);
    canvas.addEventListener('touchend', stopDrawing);
    
    signatureCanvas = { canvas, ctx };
}

function startDrawing(e) {
    isDrawing = true;
    const rect = signatureCanvas.canvas.getBoundingClientRect();
    lastX = e.clientX - rect.left;
    lastY = e.clientY - rect.top;
}

function draw(e) {
    if (!isDrawing) return;
    
    const rect = signatureCanvas.canvas.getBoundingClientRect();
    const currentX = e.clientX - rect.left;
    const currentY = e.clientY - rect.top;
    
    signatureCanvas.ctx.beginPath();
    signatureCanvas.ctx.moveTo(lastX, lastY);
    signatureCanvas.ctx.lineTo(currentX, currentY);
    signatureCanvas.ctx.stroke();
    
    lastX = currentX;
    lastY = currentY;
}

function stopDrawing() {
    isDrawing = false;
}

function handleTouch(e) {
    e.preventDefault();
    const touch = e.touches[0];
    const mouseEvent = new MouseEvent(e.type === 'touchstart' ? 'mousedown' : 
                                    e.type === 'touchmove' ? 'mousemove' : 'mouseup', {
        clientX: touch.clientX,
        clientY: touch.clientY
    });
    signatureCanvas.canvas.dispatchEvent(mouseEvent);
}

function clearSignature() {
    if (signatureCanvas) {
        signatureCanvas.ctx.clearRect(0, 0, signatureCanvas.canvas.width, signatureCanvas.canvas.height);
    }
}

function confirmSignature() {
    if (!currentSignatureField) return;
    
    // Convert canvas to data URL
    const signatureData = signatureCanvas.canvas.toDataURL();
    
    // Store signature
    step3Data.individualSignatures[currentSignatureField] = signatureData;
    step3Data.individualSignatureStatus[currentSignatureField] = true;
    
    // Update UI
    updateSignatureBox(currentSignatureField, signatureData);
    
    closeSignatureModal();
}

function updateSignatureBox(type, signatureData) {
    const signatureBox = document.getElementById(`signature_box_${type}`);
    const signatureContent = document.getElementById(`signature_content_${type}`);
    
    if (signatureBox && signatureContent) {
        signatureBox.classList.add('has-signature');
        signatureContent.innerHTML = `
            <img src="${signatureData}" alt="Signature" class="signature-preview">
            <p style="margin: 5px 0; color: #28a745; font-size: 12px;">Signature Done</p>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="openSignatureModal('${type}')">
                Upload again
            </button>
        `;
    }
}

// Validation functions
function validateStep3() {
    let isValid = true;
    
    // Validate overall condition
    if (!step3Data.overallCondition) {
        document.getElementById('overallConditionError').style.display = 'block';
        isValid = false;
    }
    
    // Validate equipment status
    if (!step3Data.equipmentStatus) {
        document.getElementById('equipmentStatusError').style.display = 'block';
        isValid = false;
    }
    
    // Validate safe to use
    if (!step3Data.safeToUse) {
        document.getElementById('safeToUseError').style.display = 'block';
        isValid = false;
    }
    
    // Validate signatures
    if (!validateSignatures()) {
        isValid = false;
    }
    
    return isValid;
}

function validateSignatures() {
    if (step3Data.selectedSignatureTypes.length === 0) {
        alert('Please select at least one signature type.');
        return false;
    }
    
    let isValid = true;
    
    step3Data.selectedSignatureTypes.forEach(type => {
        const nameKey = `${type}_name`;
        const hasName = step3Data.signatureValues[nameKey] && step3Data.signatureValues[nameKey].trim() !== '';
        const hasSignature = step3Data.individualSignatureStatus[type];
        
        if (!hasName || !hasSignature) {
            isValid = false;
        }
    });
    
    if (!isValid) {
        alert('Please complete all signature fields (name and signature).');
    }
    
    return isValid;
}

// Generate report
async function handleGenerateReport() {
    if (!validateStep3()) {
        return;
    }
    
    // Disable button and show loading state
    const generateBtn = document.getElementById('generateReportBtn');
    const generateText = document.getElementById('generateReportText');
    const originalText = generateText.textContent;
    
    generateBtn.disabled = true;
    generateText.textContent = 'Generating Report...';
    generateBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i><span id="generateReportText">Generating Report...</span>';
    
    // Show sync modal
    openModal('syncModal');
    
    try {
        // Collect all data from all steps
        const inspectionData = collectAllStepsData();
        
        // Save to database
        const result = await saveInspectionToDatabase(inspectionData);
        
        if (result.success) {
            document.getElementById('syncModal').style.display = 'none';
            showSuccessModal(result.data);
        } else {
            throw new Error(result.message || 'Failed to save inspection data');
        }
    } catch (error) {
        console.error('Error generating report:', error);
        document.getElementById('syncModal').style.display = 'none';
        
        // Show error in a more user-friendly way
        showErrorModal('Error generating report: ' + error.message);
    } finally {
        // Reset button state
        generateBtn.disabled = false;
        generateText.textContent = originalText;
        generateBtn.innerHTML = '<i class="fas fa-file-pdf me-2"></i><span id="generateReportText">' + originalText + '</span>';
    }
}

// Collect data from all steps
function collectAllStepsData() {
    try {
        // Step 1: Inspection Info
        const step1Data = {
            reportNumber: document.getElementById('reportNumber').value,
            country: document.getElementById('country').value,
            project: document.getElementById('project').value,
            inspector: document.getElementById('inspector').value,
            equipment: {
                vehicleNumber: document.getElementById('vehicleNumber').value,
                vehicleName: document.getElementById('vehicleName').value,
                vinNumber: document.getElementById('vinNumber').value,
                meterReading: document.getElementById('meter-Reading-input').value,
                meterUnit: document.getElementById('meterReading').value,
                currentMeterReading: document.querySelector('.currentMeterValue')?.textContent || 'Not selected'
            },
            checklist: {
                id: document.getElementById('inspectionChecklist').value,
                display: document.getElementById('checklistDisplay').value
            },
            gpsLocation: {
                coordinates: document.getElementById('coordinatesInput').value || '',
                address: document.getElementById('gpsAddressInput').value || ''
            },
            timestamp: new Date().toISOString()
        };
        
        // Step 2: Do Inspection
        const step2Data = {
            checklist: currentChecklist || {},
            sections: currentSections || [],
            selections: inspectionSelections || {},
            headerInputs: headerInputValues || {},
            notes: inspectionNotes || {},
            images: inspectionImages || {},
            faultyItemsCount: loadFaultyItemsCount()
        };
        
        // Step 3: Inspection Summary
        const step3SummaryData = {
            overallCondition: step3Data.overallCondition || '',
            equipmentStatus: step3Data.equipmentStatus || '',
            priority: step3Data.priority || '',
            safeToUse: step3Data.safeToUse || '',
            additionalNote: step3Data.additionalNote || '',
            signatureFields: step3Data.selectedSignatureTypes || [],
            signatureValues: step3Data.signatureValues || {},
            individualSignatures: step3Data.individualSignatures || {},
            individualSignatureStatus: step3Data.individualSignatureStatus || {}
        };
        
        // Validate required data
        if (!validateCollectedData(step1Data, step2Data, step3SummaryData)) {
            throw new Error('Required data is missing. Please complete all steps before generating the report.');
        }
        
        return {
            requestNumber: step1Data.reportNumber,
            step1: step1Data,
            step2: step2Data,
            step3: step3SummaryData,
            status: 'completed',
            createdAt: new Date().toISOString(),
            updatedAt: new Date().toISOString()
        };
    } catch (error) {
        console.error('Error collecting data:', error);
        throw error;
    }
}

// Validate collected data
function validateCollectedData(step1Data, step2Data, step3Data) {
    // Validate Step 1
    if (!step1Data.reportNumber || !step1Data.country || !step1Data.project || 
        !step1Data.inspector || !step1Data.equipment.vehicleNumber || 
        !step1Data.equipment.vehicleName || !step1Data.equipment.meterReading) {
        console.error('Step 1 validation failed:', step1Data);
        return false;
    }
    
    // Validate Step 2
    if (!step2Data.checklist || Object.keys(step2Data.selections).length === 0) {
        console.error('Step 2 validation failed:', step2Data);
        return false;
    }
    
    // Validate Step 3
    if (!step3Data.overallCondition || !step3Data.equipmentStatus || 
        !step3Data.safeToUse || step3Data.signatureFields.length === 0) {
        console.error('Step 3 validation failed:', step3Data);
        return false;
    }
    
    return true;
}


// Save inspection data to database
async function saveInspectionToDatabase(inspectionData) {
    try {
        const response = await fetch('/api/save-inspection-report', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
            },
            body: JSON.stringify(inspectionData)
        });
        
        const result = await response.json();
        return result;
    } catch (error) {
        console.error('Error saving to database:', error);
        throw new Error('Failed to save inspection data to database');
    }
}

function showSuccessModal(savedData) {
    // Show notification statuses
    const notificationStatus = document.getElementById('notificationStatus');
    const emailStatus = document.getElementById('emailStatus');
    
    notificationStatus.innerHTML = `
        <i class="fas fa-bell text-success"></i>
        <span>Push notification sent successfully</span>
    `;
    notificationStatus.className = 'notification-status success';
    notificationStatus.style.display = 'flex';
    
    emailStatus.innerHTML = `
        <i class="fas fa-envelope text-success"></i>
        <span>Email notification sent successfully</span>
    `;
    emailStatus.className = 'email-status success';
    emailStatus.style.display = 'flex';
    
    // Store the saved data for PDF generation
    window.savedInspectionData = savedData;
    
    openModal('successModal');
}

function showErrorModal(message, title = 'An Error Occurred') {
    document.getElementById('errorModalTitle').textContent = title;
    document.getElementById('errorModalMessage').textContent = message;
    openModal('errorModal');
}

function closeErrorModal() {
    closeModal('errorModal');
}

function closeSuccessModal() {
    closeModal('successModal');
    // Reset form and go back to step 1
    resetStep3Form();
    goToStep1();
}

function viewPDF() {
    if (window.savedInspectionData) {
        // Generate PDF with the saved data
        generateInspectionPDF(window.savedInspectionData);
    } else {
        alert('No inspection data available for PDF generation.');
    }
}

// Generate inspection PDF
async function generateInspectionPDF(inspectionData) {
    try {
        const response = await fetch('/api/generate-inspection-pdf', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
            },
            body: JSON.stringify(inspectionData)
        });
        
        if (response.ok) {
            const blob = await response.blob();
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = `Inspection_Report_${inspectionData.requestNumber}.pdf`;
            document.body.appendChild(a);
            a.click();
            window.URL.revokeObjectURL(url);
            document.body.removeChild(a);
        } else {
            throw new Error('Failed to generate PDF');
        }
    } catch (error) {
        console.error('Error generating PDF:', error);
        alert('Error generating PDF: ' + error.message);
    }
}

function resetStep3Form() {
    step3Data = {
        overallCondition: '',
        equipmentStatus: '',
        priority: '',
        safeToUse: '',
        additionalNote: '',
        signatureFields: [],
        selectedSignatureTypes: [],
        signatureValues: {},
        individualSignatures: {},
        individualSignatureStatus: {}
    };
    
    // Reset UI
    document.getElementById('overallCondition-select').value = '';
    document.getElementById('additionalNote').value = '';
    document.getElementById('signatureFieldsContainer').innerHTML = '';
    document.getElementById('selectedSignatureTypeText').textContent = 'Select Signature Type';
    
    // Clear button selections
    document.querySelectorAll('.status-option-btn, .priority-btn, .safe-option-btn').forEach(btn => {
        btn.classList.remove('selected');
    });
    
    // Hide priority container
    document.getElementById('priorityContainer').style.display = 'none';
    
    // Clear errors
    document.querySelectorAll('.error-text').forEach(error => {
        error.style.display = 'none';
    });
}

// Form Navigation Functions
function goToStep1() {
    document.getElementById('step1-form').style.display = 'block';
    document.getElementById('do-inspection-container').style.display = 'none';
    document.getElementById('Inspection-Summary-main').style.display = 'none';
}

function goToStep2() {
    console.log('goToStep2() called');
    
    // Clear any invalid meter reading values first
    clearInvalidMeterReading();
    
    // Validate step 1 form if coming from step 1
    if (document.getElementById('step1-form').style.display !== 'none') {
        console.log('Validating step 1...');
        if (!validateStep1()) {
            console.log('Step 1 validation failed');
            return;
        }
        console.log('Step 1 validation passed');
    }
    
    // Proceed to step 2
    console.log('Hiding step 1 and showing step 2...');
    document.getElementById('step1-form').style.display = 'none';
    document.getElementById('do-inspection-container').style.display = 'block';
    document.getElementById('Inspection-Summary-main').style.display = 'none';
    
    
    // Load checklist data for Step 2
    console.log('Loading checklist data...');
    loadChecklistDataForStep2();
    
    console.log('Step 2 should now be visible');
}


// Toggle section function for collapsible checklist sections
function toggleSection(sectionId) {
    const section = document.getElementById(sectionId);
    const header = section.previousElementSibling;
    
    if (section.classList.contains('expanded')) {
        section.classList.remove('expanded');
        header.classList.remove('expanded');
    } else {
        section.classList.add('expanded');
        header.classList.add('expanded');
    }
}

// Function to clear invalid meter reading values
function clearInvalidMeterReading() {
    const meterInput = document.getElementById('meter-Reading-input');
    if (meterInput && meterInput.value) {
        const value = parseFloat(meterInput.value);
        // If the value is extremely large (scientific notation with large exponent), clear it
        if (value > 1e15 || isNaN(value)) {
            console.log('Clearing invalid meter reading value:', meterInput.value);
            meterInput.value = '';
        }
    }
}


function goToStep3() {
    // Validate step 2 if coming from step 2
    if (document.getElementById('do-inspection-container').style.display !== 'none') {
        if (!validateStep2()) {
            return;
        }
    }
    
    document.getElementById('step1-form').style.display = 'none';
    document.getElementById('do-inspection-container').style.display = 'none';
    document.getElementById('Inspection-Summary-main').style.display = 'block';
    
    // Load faulty items count and initialize step 3
    loadFaultyItemsCount();
    initializeStep3();
}

function validateStep2() {
    // Check if at least one inspection item has been completed
    const selections = inspectionSelections || {};
    const hasSelections = Object.keys(selections).length > 0;
    
    if (!hasSelections) {
        alert('Please complete at least one inspection item before proceeding to the summary.');
        return false;
    }
    
    // Check if header inputs are filled (if any exist)
    if (Object.keys(headerInputs).length > 0) {
        const headerInputKeys = Object.keys(headerInputs);
        const hasHeaderInputs = headerInputKeys.some(key => 
            headerInputValues[key] && headerInputValues[key].trim() !== ''
        );
        
        if (!hasHeaderInputs) {
            alert('Please fill in the required header information before proceeding.');
            return false;
        }
    }
    
    return true;
}

function initializeStep3() {
    // Reset step 3 data
    resetStep3Form();
    
    // Load faulty items count
    loadFaultyItemsCount();
    
    // Initialize signature canvas if needed
    if (signatureCanvas) {
        signatureCanvas.ctx.clearRect(0, 0, signatureCanvas.canvas.width, signatureCanvas.canvas.height);
    }
}

function validateStep1() {
    console.log('=== VALIDATING STEP 1 ===');
    
    // Only validate visible required fields
    const requiredFields = ['country', 'project', 'inspector', 'meter-Reading-input', 'meterReading', 'inspectionChecklist'];
    let isValid = true;
    
    // Clear previous errors
    requiredFields.forEach(fieldId => {
        const field = document.getElementById(fieldId);
        if (field) {
            field.classList.remove('is-invalid');
        }
    });
    
    // Validate required fields
    requiredFields.forEach(fieldId => {
        const field = document.getElementById(fieldId);
        console.log(`Checking field ${fieldId}:`, field ? field.value : 'NOT FOUND');
        if (field && !field.value.trim()) {
            field.classList.add('is-invalid');
            isValid = false;
            console.log(`Field ${fieldId} is empty`);
        }
    });
    
    // Skip meter reading validation for now to test step navigation
    console.log('Skipping meter reading validation for testing');
    
    if (!isValid) {
        console.log('Validation failed - showing warning');
        showWarningAlert('Validation Error', 'Please fill in all required fields.');
    } else {
        console.log('Validation passed!');
    }
    
    return isValid;
}



// Global variables for data
let equipmentData = [];
let checklistData = [];

// Standardized Modal functions
function openModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) {
        // Add show class for consistent styling
        modal.classList.add('show');
        modal.style.display = 'flex';
        
        // Lock body scroll
        document.body.classList.add('modal-open');
        
        // Add click outside to close
        modal.onclick = function(event) {
            if (event.target === modal) {
                closeModal(modalId);
            }
        };
        
        // Add escape key to close
        const handleEscape = function(event) {
            if (event.key === 'Escape') {
                closeModal(modalId);
                document.removeEventListener('keydown', handleEscape);
            }
        };
        document.addEventListener('keydown', handleEscape);
    }
}

function closeModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) {
        // Remove show class and hide modal
        modal.classList.remove('show');
        modal.style.display = 'none';
        
        // Unlock body scroll
        document.body.classList.remove('modal-open');
    }
}

// Modal functions
function openEquipmentModal() {
    openModal('equipmentModal');
    loadEquipmentData();
}

function closeEquipmentModal() {
    closeModal('equipmentModal');
}

function openChecklistModal() {
    openModal('checklistModal');
    loadChecklistData();
}

function closeChecklistModal() {
    closeModal('checklistModal');
}

// Load equipment data from Firebase
async function loadEquipmentData() {
    try {
        // Show loading state
        const equipmentList = document.getElementById('equipmentList');
        equipmentList.innerHTML = '<div class="text-center p-3"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Loading equipment...</p></div>';
        
        // Fetch from the specified Firebase path
        const response = await fetch('/api/fetch-equipment-from-firebase');
        const data = await response.json();
        
        if (data.success) {
            equipmentData = data.equipment || [];
            renderEquipmentList(equipmentData);
        } else {
            console.error('Failed to load equipment:', data.message);
            equipmentList.innerHTML = '<p class="text-center text-muted p-3">Failed to load equipment data: ' + data.message + '</p>';
        }
    } catch (error) {
        console.error('Error loading equipment:', error);
        const equipmentList = document.getElementById('equipmentList');
        equipmentList.innerHTML = '<p class="text-center text-muted p-3">Error loading equipment data. Please try again.</p>';
    }
}

// Load checklist data from Firebase
async function loadChecklistData() {
    try {
        // Show loading state
        const checklistList = document.getElementById('checklistList');
        checklistList.innerHTML = '<div class="text-center p-3"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Loading checklists...</p></div>';
        
        // Fetch from the specified Firebase path
        const response = await fetch('/api/fetch-checklists-from-firebase');
        const data = await response.json();
        
        if (data.success) {
            checklistData = data.checklists || [];
            renderChecklistList(checklistData);
        } else {
            console.error('Failed to load checklists:', data.message);
            checklistList.innerHTML = '<p class="text-center text-muted p-3">Failed to load checklist data: ' + data.message + '</p>';
        }
    } catch (error) {
        console.error('Error loading checklists:', error);
        const checklistList = document.getElementById('checklistList');
        checklistList.innerHTML = '<p class="text-center text-muted p-3">Error loading checklist data. Please try again.</p>';
    }
}

// Render equipment list
function renderEquipmentList(equipment) {
    const container = document.getElementById('equipmentList');
    
    if (!equipment || equipment.length === 0) {
        container.innerHTML = '<p class="text-center text-muted p-3">No equipment found</p>';
        return;
    }
    
     const html = equipment.map(item => {
         // Use model as heading if equipment name is not available
         const displayName = item.equipmentName || item.vehicleNumber || item.model || 'Unknown Equipment';
         const category = item.mainCategory || item.equipmentCategory || 'N/A';
         const model = item.model || 'N/A';
         
         return `
         <div class="equipment-item" onclick="selectEquipment('${item.id || item.firebaseKey || 'unknown'}', '${displayName}', '${model}', '${category}')">
             <div class="equipment-name">${displayName}</div>
            <div class="equipment-details">
                 <strong>Category:</strong> ${category}<br>
                 <strong>Model:</strong> ${model}<br>
                <strong>Status:</strong> ${item.status || 'Available'}<br>
                <strong>Meter Reading:</strong> ${item.meterReading || '0'} ${item.meterUnit || 'KM'}
            </div>
        </div>
         `;
     }).join('');
    
    container.innerHTML = html;
}

// Render checklist list
function renderChecklistList(checklists) {
    const container = document.getElementById('checklistList');
    
    if (!checklists || checklists.length === 0) {
        container.innerHTML = '<p class="text-center text-muted p-3">No checklists found</p>';
        return;
    }
    
    const html = checklists.map(item => `
        <div class="checklist-item" onclick="selectChecklist('${item.document_id || item.id || 'unknown'}', '${item.document_name || item.title || 'Untitled Checklist'}')">
            <div class="checklist-title">${item.document_name || item.title || 'Untitled Checklist'}</div>
            <div class="checklist-description">
                <strong>ID:</strong> ${item.document_id || item.id || 'N/A'}<br>
                <strong>Version:</strong> ${item.version || 'N/A'}<br>
                <strong>Status:</strong> ${item.status || 'Available'}
            </div>
        </div>
    `).join('');
    
    container.innerHTML = html;
}

// Select equipment
function selectEquipment(id, name, model, category) {
    document.getElementById('equipmentDisplay').value = `${name} - ${model} (${category})`;
    document.getElementById('vehicleNumber').value = id;
    document.getElementById('vehicleName').value = name;
    document.getElementById('vinNumber').value = model; // Using model as VIN for now
    
    // Clear any previous meter reading errors
    clearMeterReadingError();
    
    // Find the selected equipment data to get meter reading
    const selectedEquipment = equipmentData.find(item => 
        (item.id || item.firebaseKey) === id || 
        (item.equipmentName || item.vehicleNumber) === name
    );
    
    if (selectedEquipment) {
        // Set the current meter reading as the default value
        const currentMeterReading = selectedEquipment.meterReading || 0;
        const meterUnit = selectedEquipment.meterUnit || 'KM';
        
        // Update the meter reading input
        document.getElementById('meter-Reading-input').value = currentMeterReading;
        
        // Update the meter unit select if it matches
        const meterUnitSelect = document.getElementById('meterReading');
        if (meterUnitSelect) {
            // Find and select the matching option
            for (let option of meterUnitSelect.options) {
                if (option.value === meterUnit) {
                    option.selected = true;
                    break;
                }
            }
        }
        
        // Update the current meter reading display
        const currentMeterDisplay = document.querySelector('.currentMeterValue');
        if (currentMeterDisplay) {
            // Format number to avoid scientific notation
            const reading = parseFloat(currentMeterReading);
            const formattedReading = reading > 999999 ? 
                reading.toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g, ',') : 
                reading.toString();
            currentMeterDisplay.textContent = `${formattedReading} ${meterUnit}`;
        }
        
        // Update the meter reading input placeholder to show the current reading
        const meterInput = document.getElementById('meter-Reading-input');
        if (meterInput) {
            // Format current reading for display (avoid scientific notation)
            const reading = parseFloat(currentMeterReading);
            const formattedReading = reading > 999999 ? 
                reading.toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g, ',') : 
                reading.toString();
            meterInput.placeholder = `Enter new reading (current: ${formattedReading} ${meterUnit})`;
        }
    }
    
    closeEquipmentModal();
}

// Select checklist
function selectChecklist(id, title) {
    document.getElementById('checklistDisplay').value = title;
    document.getElementById('inspectionChecklist').value = id;
    closeChecklistModal();
}

// Filter functions
function filterEquipment() {
    const searchTerm = document.getElementById('equipmentSearch').value.toLowerCase();
     const filtered = equipmentData.filter(item => {
         // Use the same display logic for filtering
         const displayName = item.equipmentName || item.vehicleNumber || item.model || 'Unknown Equipment';
         const category = item.mainCategory || item.equipmentCategory || 'N/A';
         const model = item.model || 'N/A';
         
         return displayName.toLowerCase().includes(searchTerm) ||
                category.toLowerCase().includes(searchTerm) ||
                model.toLowerCase().includes(searchTerm);
     });
    renderEquipmentList(filtered);
}

function filterChecklist() {
    const searchTerm = document.getElementById('checklistSearch').value.toLowerCase();
    const filtered = checklistData.filter(item => 
        (item.document_name || item.title || '').toLowerCase().includes(searchTerm) ||
        (item.document_id || item.id || '').toLowerCase().includes(searchTerm)
    );
    renderChecklistList(filtered);
}

// Close modals when clicking outside
window.onclick = function(event) {
    const equipmentModal = document.getElementById('equipmentModal');
    const checklistModal = document.getElementById('checklistModal');
    const noteModal = document.getElementById('noteModal');
    const imageModal = document.getElementById('imageModal');
    const errorModal = document.getElementById('errorModal');
    
    if (event.target === equipmentModal) {
        closeEquipmentModal();
    }
    if (event.target === checklistModal) {
        closeChecklistModal();
    }
    if (event.target === noteModal) {
        closeNoteModal();
    }
    if (event.target === imageModal) {
        closeImageModal();
    }
    if (event.target === errorModal) {
        closeErrorModal();
    }
}

// Form submission handling
document.addEventListener('DOMContentLoaded', function() {
    const inspectionForm = document.getElementById('inspection-form');
    const submitInspectionBtn = document.getElementById('submitInspectionBtn');

    if (inspectionForm) {
        inspectionForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Validate all required fields
            if (!validateInspectionForm()) {
                return;
            }
            
            // Disable submit button to prevent double submission
            submitInspectionBtn.disabled = true;
            submitInspectionBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Generating Report...';
            
            // Get form data
            const formData = new FormData(this);
            
            // Convert FormData to JSON
            const jsonData = {};
            formData.forEach((value, key) => {
                if (value !== '') {
                    jsonData[key] = value;
                }
            });

            // Add additional data that might not be in the form
            jsonData.reportNumber = document.getElementById('reportNumber').value;
            jsonData.coordinates = document.getElementById('coordinatesInput').value || '';
            jsonData.gpsAddress = document.getElementById('gpsAddressInput').value || '';
            jsonData.currentMeterReading = document.querySelector('.currentMeterValue').textContent;

            // Add inspection items data (if any)
            jsonData.inspectionItems = getInspectionItemsData();

            // Send AJAX request
            fetch('/inspection/store-inspection', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
                },
                body: JSON.stringify(jsonData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Show success message
                    alert('Inspection report generated successfully! Index: ' + data.index);
                    
                    // Reset form
                    inspectionForm.reset();
                    
                    // Redirect to inspection list
                    window.location.href = '/inspection';
                } else {
                    // Show error message
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while generating the inspection report. Please try again.');
            })
            .finally(() => {
                // Re-enable submit button
                submitInspectionBtn.disabled = false;
                submitInspectionBtn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"><path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" /><path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" /></g></svg>Generate Report';
            });
        });
    }
});

function getInspectionItemsData() {
    // This function would collect data from the inspection items in step 2
    // For now, return an empty array - you can expand this based on your needs
    return [];
}

function validateInspectionForm() {
    const requiredFields = [
        'country', 'project', 'inspector', 'vehicleNumber', 'vehicleName', 
        'vinNumber', 'meterReading', 'meterUnit', 'inspectionChecklist'
    ];
    
    let isValid = true;
    
    requiredFields.forEach(fieldName => {
        const field = document.querySelector(`[name="${fieldName}"]`);
        if (field && !field.value.trim()) {
            field.classList.add('is-invalid');
            isValid = false;
        } else if (field) {
            field.classList.remove('is-invalid');
        }
    });
    
    // Validate meter reading specifically
    if (!validateMeterReading()) {
        isValid = false;
    }
    
    if (!isValid) {
        showWarningAlert('Validation Error', 'Please fill in all required fields and ensure the new meter reading is greater than the current reading.');
    }
    
    return isValid;
}

// Add Bootstrap JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Initialize any Bootstrap components if needed
    console.log('Bootstrap initialized');
});

// Global variables for Step 2
let currentChecklist = null;
let currentSections = [];
let expandedSections = {};
let inspectionSelections = {};
let headerInputs = {};
let headerInputValues = {};
let headerInputErrors = {};
let showHeaderErrors = false;
let currentNoteItem = null;
let currentImageItem = null;
let inspectionNotes = {};
let inspectionImages = {};

// Load checklist data for Step 2
async function loadChecklistDataForStep2() {
    console.log('Loading checklist data for Step 2...');
    
    try {
        const selectedChecklistId = document.getElementById('inspectionChecklist').value;
        console.log('Selected checklist ID:', selectedChecklistId);
        
        if (!selectedChecklistId) {
            console.warn('No checklist selected, loading sample data');
            loadSampleChecklistData();
            return;
        }

        // Try to fetch checklist data from Firebase
        try {
            const response = await fetch('/api/fetch-checklists-from-firebase');
            const data = await response.json();
            
            if (data.success) {
                const checklist = data.checklists.find(c => c.document_id === selectedChecklistId || c.id === selectedChecklistId);
                if (checklist) {
                    currentChecklist = checklist;
                    document.getElementById('checklistTitleDisplay').textContent = checklist.document_name || checklist.title || 'Untitled Checklist';
                    
                    // Load header inputs
                    if (checklist.header_inputs) {
                        headerInputs = checklist.header_inputs;
                        renderHeaderInputs();
                        autoFillHeaderInputs();
                    }
                    
                    // Load sections
                    if (checklist.checklist) {
                        currentSections = processChecklistSections(checklist.checklist);
                        renderInspectionSections();
                    }
                    return;
                }
            }
        } catch (fetchError) {
            console.warn('Failed to fetch from Firebase, loading sample data:', fetchError);
        }
        
        // Fallback to sample data
        loadSampleChecklistData();
        
    } catch (error) {
        console.error('Error loading checklist data for Step 2:', error);
        loadSampleChecklistData();
    }
}

// Load sample checklist data for testing
function loadSampleChecklistData() {
    console.log('Loading sample checklist data...');
    
    // Set checklist title
    document.getElementById('checklistTitleDisplay').textContent = 'HSE-FOR-8.1.1 Lighting Plant Pre-start';
    
    // Load sample header inputs
    headerInputs = {
        'model': { label: 'Model', type: 'text', required: true },
        'fleet_no': { label: 'Fleet No', type: 'text', required: true },
        'shift': { label: 'Shift', type: 'text', required: true }
    };
    renderHeaderInputs();
    autoFillHeaderInputs();
    
    // Load sample inspection sections
    currentSections = [
        {
            id: 'A',
            title: 'A',
            items: [
                { id: 'A1', title: 'TYRE PRESSURE/CONDITION', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A2', title: 'TOW HINGE', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A3', title: 'AXLE/SPRING', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A4', title: 'WINCH CONDITION', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A5', title: 'BOOM LOCK PINS', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A6', title: 'JACK LEGS', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A7', title: 'ENGINE OIL LEVEL', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A8', title: 'OIL LEAKS', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A9', title: 'FUEL LEAKS', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A10', title: 'TAIL LIGHTS', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A11', title: 'SIGNAL LIGHTS', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A12', title: 'STARTING', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'A13', title: 'WORKING LIGHTS', type: 'radio', options: ['Ok', 'Reject', 'N/A'] }
            ]
        },
        {
            id: 'B',
            title: 'B',
            items: [
                { id: 'B1', title: 'BODY CONDITION', type: 'radio', options: ['Ok', 'Reject', 'N/A'] },
                { id: 'B2', title: 'FUEL LEVEL (ESTIMATION)', type: 'radio', options: ['Ok', 'Reject', 'N/A'] }
            ]
        }
    ];
    renderInspectionSections();
    
    console.log('Sample checklist data loaded successfully');
}

// Process checklist sections from the checklist data
function processChecklistSections(checklistData) {
    const sections = [];
    const sectionEntries = Object.entries(checklistData);
    
    sectionEntries.forEach(([sectionKey, sectionValue], idx) => {
        let subItems = [];
        
        // Handle array of strings
        if (Array.isArray(sectionValue) && sectionValue.length > 0 && typeof sectionValue[0] === 'string') {
            subItems = sectionValue.map((item, i) => ({
                key: `${sectionKey}_${i}`,
                itemName: item,
                category: sectionKey,
                inputType: 'Okay/Faulty/N/A',
                sortOrder: i,
                isInspectionRequired: false,
                description: '',
                instruction: ''
            }));
        }
        // Handle array of objects
        else if (Array.isArray(sectionValue) && sectionValue.length > 0 && typeof sectionValue[0] === 'object') {
            subItems = sectionValue.map((item, i) => ({
                key: `${sectionKey}_${i}`,
                itemName: item.itemName || item,
                category: sectionKey,
                inputType: item.inputType || 'Okay/Faulty/N/A',
                sortOrder: i,
                isInspectionRequired: item.isInspectionRequired || false,
                description: item.description || '',
                instruction: item.instruction || ''
            }));
        }
        
        if (subItems.length > 0) {
            sections.push({
                key: sectionKey,
                name: sectionKey,
                subItems: subItems
            });
        }
    });
    
    // Sort sections: A, B, C first, then the rest
    const sectionOrder = ['A', 'B', 'C'];
    const orderedSections = [];
    sectionOrder.forEach((key) => {
        const idx = sections.findIndex((s) => s.name === key);
        if (idx !== -1) {
            orderedSections.push(sections[idx]);
            sections.splice(idx, 1);
        }
    });
    
    return [...orderedSections, ...sections];
}

// Render header inputs
function renderHeaderInputs() {
    const container = document.getElementById('headerInputsContainer');
    if (!headerInputs || Object.keys(headerInputs).length === 0) {
        container.innerHTML = '<p class="empty-section-text">No header inputs found for this checklist</p>';
        return;
    }
    
    const html = Object.entries(headerInputs).map(([key, label]) => {
        const isDateField = isDateFieldKeyOrLabel(key, label);
        const isProjectSite = isProjectOrSiteField(key, label);
        
        // Skip date fields as they are auto-filled
        if (isDateField) {
            return '';
        }
        
        return `
            <div class="input-field-container">
                <label class="input-label">
                    ${formatHeaderLabel(label || key)} <span class="required-text">*</span>
                </label>
                <input type="text" 
                       class="form-control header-input-field ${isProjectSite ? 'disabled-input' : ''}" 
                       id="header_${key}" 
                       data-key="${key}"
                       value="${headerInputValues[key] || ''}"
                       placeholder="Enter ${formatHeaderLabel(label || key).toLowerCase()}"
                       ${isProjectSite ? 'readonly' : ''}
                       onchange="handleHeaderInputChange('${key}', this.value)">
                <div class="error-text" id="header_error_${key}" style="display: none;">This field is required</div>
            </div>
        `;
    }).join('');
    
    container.innerHTML = html;
}

// Render inspection sections
function renderInspectionSections() {
    const container = document.getElementById('inspectionSectionsContainer');
    
    if (!currentSections || currentSections.length === 0) {
        container.innerHTML = '<p class="empty-section-text">No sections available</p>';
        return;
    }
    
    const html = currentSections.map((section) => {
        const sectionItems = section.subItems || [];
        const selectedItemsCount = sectionItems.filter(item => inspectionSelections[item.key]).length;
        const totalItemsCount = sectionItems.length;
        
        return `
            <div class="inspection-section mb-3">
                <div class="section-header" onclick="toggleSection('${section.key}')">
                    <div class="section-header-content">
                        <i class="fas fa-chevron-${expandedSections[section.key] ? 'up' : 'down'} section-toggle-icon"></i>
                        <div class="section-header-text-container">
                            <span class="section-header-text">${formatSectionTitle(section.name)}</span>
                            <span class="section-item-count">(${selectedItemsCount}/${totalItemsCount} selected)</span>
                        </div>
                    </div>
                </div>
                <div class="section-content" id="section_${section.key}" style="display: ${expandedSections[section.key] ? 'block' : 'none'}">
                    ${section.subItems.map((item, index) => renderInspectionItem(item, index)).join('')}
                </div>
            </div>
        `;
    }).join('');
    
    container.innerHTML = html;
}

// Render individual inspection item
function renderInspectionItem(item, index) {
    const selectedOption = inspectionSelections[item.key] || '';
    const options = getOptionsForInputType(item.inputType);
    const itemNote = inspectionNotes[item.key] || '';
    const selectedFileUri = inspectionImages[item.key] || '';
    
    return `
        <div class="inspection-item mb-3">
            <div class="item-container">
                <div class="item-text">
                    ${index + 1}. ${formatItemNameUpper(item.itemName)}
                    ${item.isInspectionRequired ? '<span class="required-text"> (Required)</span>' : ''}
                </div>
                ${item.description ? `<div class="detail-text">Description: ${item.description}</div>` : ''}
                ${item.instruction ? `<div class="detail-text">Instruction: ${item.instruction}</div>` : ''}
                <div class="item-row">
                    <div class="options-container">
                        ${options.map(option => `
                            <button type="button" 
                                    class="btn option-button ${selectedOption === option ? 'selected-option-button' : ''} 
                                           ${getOptionButtonClass(option, selectedOption === option)}"
                                    onclick="handleSelectOption('${item.key}', '${option}')">
                                ${option}
                            </button>
                        `).join('')}
                    </div>
                    <div class="icons-container">
                        <button type="button" class="btn btn-outline-secondary btn-sm inspection-action-btn" onclick="handleNotePress('${item.key}')" title="Add Note">
                            <i class="fas fa-sticky-note"></i>
                        </button>
                        <button type="button" class="btn btn-outline-secondary btn-sm inspection-action-btn" onclick="handleFilePick('${item.key}')" title="Add Image">
                            <i class="fas fa-camera"></i>
                        </button>
                    </div>
                </div>
                ${itemNote ? `<div class="note-display"><strong>Note:</strong> ${itemNote}</div>` : ''}
                ${selectedFileUri ? `<div class="image-display"><img src="${selectedFileUri}" alt="Inspection Image" class="inspection-image"></div>` : ''}
            </div>
        </div>
    `;
}

// Helper functions
function isDateFieldKeyOrLabel(key, label) {
    const lowerKey = (key || '').toLowerCase();
    const lowerLabel = (label || '').toLowerCase();
    return lowerKey.includes('date') || lowerLabel.includes('date');
}

function isProjectOrSiteField(key, label) {
    const lowerKey = (key || '').toLowerCase();
    const lowerLabel = (label || '').toLowerCase();
    return (
        lowerKey.includes('project') ||
        lowerLabel.includes('project') ||
        lowerKey.includes('site') ||
        lowerLabel.includes('site') ||
        lowerKey.includes('location') ||
        lowerLabel.includes('location')
    );
}

function formatHeaderLabel(label) {
    if (!label) return '';
    return label
        .replace(/_/g, ' ')
        .split(' ')
        .map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase())
        .join(' ');
}

function formatSectionTitle(title) {
    if (!title) return '';
    return title
        .toString()
        .replace(/_/g, ' ')
        .split(' ')
        .map(word => word ? word.charAt(0).toUpperCase() + word.slice(1).toLowerCase() : '')
        .join(' ');
}

function formatItemNameUpper(name) {
    if (!name && name !== 0) return '';
    return String(name).replace(/_/g, ' ').toUpperCase();
}

function getOptionsForInputType(inputType) {
    switch (inputType) {
        case 'Okay/Faulty/N/A':
            return ['Okay', 'Faulty', 'N/A'];
        case 'Ok/Reject/N/A':
            return ['Ok', 'Reject', 'N/A'];
        case 'Ok/Not Ok':
            return ['Ok', 'Not Ok'];
        default:
            if (typeof inputType === 'string' && inputType.includes('/')) {
                const options = inputType.split('/').map((opt) => opt.trim()).filter((opt) => opt);
                if (options.length > 0) {
                    return options;
                }
            }
            return ['Okay', 'Faulty', 'N/A'];
    }
}

function getOptionButtonClass(option, isSelected) {
    if (!isSelected) return '';
    
    if (option === 'Okay' || option === 'Ok') return 'ok-button';
    if (option === 'Faulty' || option === 'Reject' || option === 'Not Ok') return 'reject-button';
    if (option === 'N/A') return 'na-button';
    return 'custom-option-button';
}

// Event handlers
function toggleSection(sectionKey) {
    expandedSections[sectionKey] = !expandedSections[sectionKey];
    const sectionContent = document.getElementById(`section_${sectionKey}`);
    const toggleIcon = document.querySelector(`#section_${sectionKey}`).previousElementSibling.querySelector('.section-toggle-icon');
    
    if (expandedSections[sectionKey]) {
        sectionContent.style.display = 'block';
        toggleIcon.className = 'fas fa-chevron-up section-toggle-icon';
    } else {
        sectionContent.style.display = 'none';
        toggleIcon.className = 'fas fa-chevron-down section-toggle-icon';
    }
}

function handleSelectOption(itemKey, option) {
    inspectionSelections[itemKey] = option;
    renderInspectionSections(); // Re-render to update counts
}

function handleHeaderInputChange(key, value) {
    headerInputValues[key] = value;
    
    // Validate in real-time
    const isEmpty = !value || value.trim() === '';
    headerInputErrors[key] = isEmpty;
    
    const errorElement = document.getElementById(`header_error_${key}`);
    if (errorElement) {
        errorElement.style.display = isEmpty ? 'block' : 'none';
    }
    
    const inputElement = document.getElementById(`header_${key}`);
    if (inputElement) {
        inputElement.classList.toggle('is-invalid', isEmpty);
    }
}

function handleNotePress(itemKey) {
    const selection = inspectionSelections[itemKey];
    if (!selection) {
        alert('Please make a selection first');
        return;
    }
    
    currentNoteItem = itemKey;
    const existingNote = inspectionNotes[itemKey] || '';
    document.getElementById('noteText').value = existingNote;
    openModal('noteModal');
}

function handleFilePick(itemKey) {
    const selection = inspectionSelections[itemKey];
    if (!selection) {
        alert('Please make a selection first');
        return;
    }
    
    currentImageItem = itemKey;
    openModal('imageModal');
}

// Note modal functions
function closeNoteModal() {
    closeModal('noteModal');
    currentNoteItem = null;
}

function saveNote() {
    if (!currentNoteItem) return;
    
    const noteText = document.getElementById('noteText').value.trim();
    if (noteText) {
        inspectionNotes[currentNoteItem] = noteText;
        renderInspectionSections(); // Re-render to show the note
    }
    
    closeNoteModal();
}

// Image modal functions
function closeImageModal() {
    closeModal('imageModal');
    currentImageItem = null;
    document.getElementById('imagePreviewContainer').style.display = 'none';
    document.getElementById('saveImageBtn').style.display = 'none';
}

function takePicture() {
    // For web, we'll simulate taking a picture by opening the file input
    // In a real mobile app, this would use the camera
    document.getElementById('imageFileInput').click();
}

function chooseFromGallery() {
    document.getElementById('imageFileInput').click();
}

function handleImageFileSelect(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('imagePreview').src = e.target.result;
            document.getElementById('imagePreviewContainer').style.display = 'block';
            document.getElementById('saveImageBtn').style.display = 'inline-block';
        };
        reader.readAsDataURL(file);
    }
}

function saveImage() {
    if (!currentImageItem) return;
    
    const imageSrc = document.getElementById('imagePreview').src;
    if (imageSrc) {
        inspectionImages[currentImageItem] = imageSrc;
        renderInspectionSections(); // Re-render to show the image
    }
    
    closeImageModal();
}

// Auto-fill header inputs with equipment data
function autoFillHeaderInputs() {
    try {
        // Get equipment data from Step 1
        const selectedEquipment = {
            model: document.getElementById('vinNumber').value,
            equipmentName: document.getElementById('vehicleName').value,
            vehicleNumber: document.getElementById('vehicleNumber').value,
            meterReading: document.getElementById('meter-Reading-input').value
        };
        
        const project = document.getElementById('project').value;
        
        // Auto-fill based on field names
        Object.keys(headerInputs).forEach(key => {
            const lowerKey = key.toLowerCase();
            const lowerLabel = (headerInputs[key] || '').toLowerCase();
            
            // Auto-fill model
            if (lowerKey.includes('model') || lowerLabel.includes('model')) {
                headerInputValues[key] = selectedEquipment.model || '';
            }
            
            // Auto-fill equipment name
            if (lowerKey.includes('equipment') || lowerLabel.includes('equipment')) {
                headerInputValues[key] = selectedEquipment.equipmentName || '';
            }
            
            // Auto-fill fleet number
            if (lowerKey.includes('fleet') || lowerLabel.includes('fleet')) {
                headerInputValues[key] = selectedEquipment.vehicleNumber || '';
            }
            
            // Auto-fill meter reading
            if (lowerKey.includes('meter') || lowerKey.includes('odometer') || lowerLabel.includes('meter') || lowerLabel.includes('odometer')) {
                headerInputValues[key] = selectedEquipment.meterReading || '';
            }
            
            // Auto-fill project/site/location
            if (isProjectOrSiteField(key, headerInputs[key])) {
                headerInputValues[key] = project || '';
            }
        });
        
        // Set today's date for date fields
        const today = new Date().toLocaleDateString();
        Object.keys(headerInputs).forEach(key => {
            const label = headerInputs[key] || '';
            if (isDateFieldKeyOrLabel(key, label)) {
                headerInputValues[key] = today;
            }
        });
        
        renderHeaderInputs();
    } catch (error) {
        console.error('Error auto-filling header inputs:', error);
    }
}

// Validate header inputs
function validateHeaderInputs() {
    const headerInputKeys = Object.keys(headerInputs);
    let hasErrors = false;
    
    headerInputKeys.forEach(key => {
        const isEmpty = !headerInputValues[key] || headerInputValues[key].trim() === '';
        headerInputErrors[key] = isEmpty;
        if (isEmpty) hasErrors = true;
        
        const errorElement = document.getElementById(`header_error_${key}`);
        const inputElement = document.getElementById(`header_${key}`);
        
        if (errorElement) {
            errorElement.style.display = isEmpty ? 'block' : 'none';
        }
        if (inputElement) {
            inputElement.classList.toggle('is-invalid', isEmpty);
        }
    });
    
    if (hasErrors) {
        alert('Please fill in all header information fields before proceeding.');
        return false;
    }
    
    return true;
}

// Complete inspection and go to Step 3
// New functions for the updated inspection form
function selectOption(itemId, option) {
    const item = document.querySelector(`[data-item="${itemId}"]`);
    const buttons = item.querySelectorAll('.btn-option');
    
    // Remove active class from all buttons
    buttons.forEach(btn => btn.classList.remove('active'));
    
    // Add active class to selected button
    const selectedBtn = item.querySelector(`[data-option="${option}"]`);
    selectedBtn.classList.add('active');
    
    // Update section counts
    updateSectionCounts();
}

function updateSectionCounts() {
    const sectionA = document.querySelector('#sectionA-count');
    const sectionB = document.querySelector('#sectionB-count');
    const sectionC = document.querySelector('#sectionC-count');
    
    if (sectionA) {
        const selectedA = document.querySelectorAll('#sectionA .btn-option.active').length;
        sectionA.textContent = selectedA;
    }
    
    if (sectionB) {
        const selectedB = document.querySelectorAll('#sectionB .btn-option.active').length;
        sectionB.textContent = selectedB;
    }
    
    if (sectionC) {
        const selectedC = document.querySelectorAll('#sectionC .btn-option.active').length;
        sectionC.textContent = selectedC;
    }
}

function openNotes(itemId) {
    // Open notes modal for the specific item
    alert(`Notes for ${itemId} - This would open a notes modal`);
}

function takePhoto(itemId) {
    // Open camera for the specific item
    alert(`Camera for ${itemId} - This would open camera`);
}

function toggleSection(sectionId) {
    const section = document.getElementById(sectionId);
    const icon = section.previousElementSibling.querySelector('.section-icon');
    
    if (section.style.display === 'none') {
        section.style.display = 'block';
        icon.textContent = '▼';
    } else {
        section.style.display = 'none';
        icon.textContent = '▲';
    }
}

function completeInspection() {
    if (!validateHeaderInputs()) {
        return;
    }
    
    // Save inspection data
    const inspectionData = {
        checklist: currentChecklist,
        sections: currentSections,
        selections: inspectionSelections,
        headerInputs: headerInputValues,
        notes: inspectionNotes,
        images: inspectionImages,
        timestamp: new Date().toISOString()
    };
    
    // Store in localStorage for Step 3
    localStorage.setItem('inspectionStep2Data', JSON.stringify(inspectionData));
    
    // Go to Step 3
    goToStep3();
}
</script>

<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* Main Container */
.inspection2-container {
    background: #f8fafc;
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    padding: 24px 24px 0 24px;
}

/* Header Section */
.inspection2-header {
    background: white;
    border: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    border-radius: 0;
    margin-bottom: 24px;
}

.header-content {
    padding: 32px;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 24px;
    flex-direction: row-reverse;
}

.back-section {
    flex-shrink: 0;
}

.back-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #0055a5;
    text-decoration: none;
    font-weight: 500;
    font-size: 14px;
    transition: all 0.2s ease;
}

.back-link:hover {
    color: black;
    transform: translateX(-2px);
}

.back-link svg {
    flex-shrink: 0;
}

.page-title h1 {
    color: #0f172a;
    font-weight: 700;
    font-size: 32px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0 0 8px 0;
}

.page-title p {
    color: #64748b;
    font-weight: 400;
    font-size: 16px;
    line-height: 1.5;
    margin: 0;
}

/* Step Indicator Section */
.step-indicator-section {
    background: white;
    border: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    border-radius: 0;
    margin-bottom: 0;
    padding: 32px;
}

.step-indicator {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 16px;
    /* max-width: 800px; */
    margin: 0 auto;
}

.step-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
    /* flex: 1; */
    position: relative;
}

.step-icon {
    width: 48px;
    height: 48px;
    border-radius: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f1f5f9;
    color: #64748b;
    transition: all 0.3s ease;
}

.step-item.active .step-icon {
    background: #0055a5;
    color: white;
    transform: scale(1.1);
}

.step-item.completed .step-icon {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
}

.step-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 4px;
}

.step-number {
    font-size: 12px;
    font-weight: 600;
    color: #64748b;
    background: #f1f5f9;
    width: 20px;
    height: 20px;
    border-radius: 0;
    display: flex;
    align-items: center;
    justify-content: center;
}

.step-item.active .step-number {
    background: #0055a5;
    color: white;
}

.step-item.completed .step-number {
    background: #10b981;
    color: white;
}

.step-title {
    font-size: 14px;
    font-weight: 500;
    color: #64748b;
    text-align: center;
}

.step-item.active .step-title {
    color: #0055a5;
    font-weight: 600;
}

.step-item.completed .step-title {
    color: #10b981;
    font-weight: 600;
}

.step-connector {
    flex: 1;
    height: 2px;
    background: #e2e8f0;
    position: relative;
    top: -24px;
}

.step-connector.completed {
    background: linear-gradient(90deg, #10b981 0%, #3b82f6 100%);
}

/* Form Section */
.form-section {
    background: white;
    border: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    border-radius: 0;
    margin-bottom: 0;
}

.form-header {
    padding: 16px 32px 24px 32px;
    border-bottom: 1px solid #e2e8f0;
}

.form-header h2 {
    color: #0f172a;
    font-weight: 700;
    font-size: 24px;
    line-height: 1.2;
    margin: 0 0 8px 0;
}

.form-header p {
    color: #64748b;
    font-weight: 400;
    font-size: 16px;
    line-height: 1.5;
    margin: 0;
}

/* Form Grid */
.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 32px;
    padding: 32px;
}

.form-column {
    display: flex;
    flex-direction: column;
    gap: 24px;
}

/* Form Groups */
.form-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.form-label {
    color: #374151;
    font-weight: 500;
    font-size: 14px;
    margin: 0;
}

.form-label.required::after {
    content: " *";
    color: #dc2626;
}

.form-control {
    padding: 12px 16px;
    border: 1px solid #d1d5db;
    border-radius: 0;
    font-size: 14px;
    font-weight: 400;
    color: #374151;
    background: white;
    transition: all 0.2s ease;
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.form-control::placeholder {
    color: #9ca3af;
}

.form-control:disabled {
    background: #f9fafb;
    color: #6b7280;
    cursor: not-allowed;
}

/* Input with Button */
.input-with-button {
    display: flex;
    gap: 8px;
}

.input-with-button .form-control {
    flex: 1;
}

.btn-select {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 12px 16px;
    border: 1px solid #d1d5db;
    border-radius: 0;
    background: white;
    color: #6b7280;
    cursor: pointer;
    transition: all 0.2s ease;
    min-width: 48px;
}

.btn-select:hover {
    background: #f9fafb;
    border-color: #3b82f6;
    color: #3b82f6;
}

/* Meter Reading Group */
.meter-reading-group {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 8px;
}

.meter-info {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-top: 8px;
}

.meter-label {
    font-size: 12px;
    color: #6b7280;
    font-weight: 400;
}

.meter-value {
    font-size: 12px;
    color: #374151;
    font-weight: 500;
}

/* GPS Section */
.gps-section {
    padding: 0 32px 32px 32px;
    border-top: 1px solid #e2e8f0;
    margin-top: 24px;
    padding-top: 24px;
}

.gps-controls {
    margin-bottom: 16px;
}

.btn-gps {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: 1px solid #0055a5;
    border-radius: 0;
    background: white;
    color: black;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-gps:hover {
    background: #0055a5;
    color: white;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

.gps-details {
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    padding: 16px;
}

.gps-info-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 16px;
}

.gps-info-item {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.gps-label {
    font-size: 12px;
    color: #6b7280;
    font-weight: 500;
}

.gps-value {
    font-size: 14px;
    color: #374151;
    font-weight: 400;
}

/* Form Actions */
.form-actions {
    padding: 24px 32px 32px 32px;
    display: flex;
    justify-content: center;
    gap: 20px;
}

/* Water Pump Prestart Check Styles */
.checklist-container {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    padding: 20px;
    margin-top: 20px;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
    overflow: hidden;
}

.checklist-container h2 {
    color: #1a202c;
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 20px;
    text-align: center;
    border-bottom: 2px solid #e2e8f0;
    padding-bottom: 10px;
}

.section {
    margin-bottom: 20px;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    overflow: hidden;
}

.section-header {
    background: #f7fafc;
    padding: 15px 20px;
    font-weight: 600;
    font-size: 1.1rem;
    color: #2d3748;
    cursor: pointer;
    display: flex;
    align-items: center;
    border-bottom: 1px solid #e2e8f0;
    transition: background-color 0.2s;
}

.section-header:hover {
    background: #edf2f7;
}

.section-icon {
    margin-right: 10px;
    font-size: 0.9rem;
    color: #4a5568;
    transition: transform 0.2s;
}

.inspection-items {
    background: white;
}

.item {
    display: flex;
    align-items: center;
    padding: 15px 20px;
    border-bottom: 1px solid #f1f5f9;
    transition: background-color 0.2s;
}

.item:last-child {
    border-bottom: none;
}

.item:hover {
    background: #f8fafc;
}

.item-label {
    flex: 1;
    font-weight: 500;
    color: #2d3748;
    font-size: 0.95rem;
    margin-right: 15px;
}

.options {
    display: flex;
    gap: 8px;
    margin-right: 15px;
}

.btn-option {
    padding: 6px 12px;
    border: 1px solid #cbd5e0;
    background: white;
    color: #4a5568;
    border-radius: 4px;
    font-size: 0.85rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s;
    min-width: 50px;
}

.btn-option:hover {
    background: #f7fafc;
    border-color: #a0aec0;
}

.btn-option.active {
    background: #3182ce;
    color: white;
    border-color: #3182ce;
}

.btn-option.active[data-option="reject"] {
    background: #e53e3e;
    border-color: #e53e3e;
}

.btn-option.active[data-option="na"] {
    background: #718096;
    border-color: #718096;
}

.item-icons {
    display: flex;
    gap: 8px;
}

.btn-icon {
    padding: 6px 8px;
    border: 1px solid #e2e8f0;
    background: white;
    color: #4a5568;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.2s;
    font-size: 0.9rem;
}

.btn-icon:hover {
    background: #f7fafc;
    border-color: #cbd5e0;
}

.btn-next {
    display: inline-flex;
    align-items: center;
    gap: 12px;
    padding: 16px 32px;
    border: none;
    border-radius: 0;
    background: #0055a5;
    color: white;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

.btn-next:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black;
}

.btn-next svg {
    flex-shrink: 0;
}

/* Checklist Title */
.checklist-title {
    padding: 12px 32px;
    border-bottom: 1px solid #e2e8f0;
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
}

.checklist-title h3 {
    color: #0f172a;
    font-weight: 600;
    font-size: 20px;
    margin: 0;
}

/* Header Inputs Section */
.header-inputs-section {
    padding: 12px 32px;
    border-bottom: 1px solid #e2e8f0;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.section-title {
    display: flex;
    align-items: center;
    gap: 12px;
}

.section-title h4 {
    color: #0f172a;
    font-weight: 600;
    font-size: 18px;
    margin: 0;
}

.required-indicator {
    font-size: 12px;
    color: #dc2626;
    font-weight: 500;
    background: #fef2f2;
    padding: 2px 8px;
    border-radius: 0;
}

.btn-auto-fill {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 16px;
    border: 1px solid #3b82f6;
    border-radius: 0;
    background: white;
    color: #3b82f6;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-auto-fill:hover {
    background: #3b82f6;
    color: white;
}

.header-inputs-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 20px;
}

/* Responsive Design */
/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .inspection2-container {
        padding: 20px;
    }
    
    .header-content {
        padding: 24px;
    }
    
    .form-grid {
        gap: 24px;
        padding: 24px;
    }
    
    .step-indicator-section {
        padding: 28px;
    }
    
    .inspection-checklist-section {
        padding: 28px;
    }
}

@media (max-width: 992px) {
    .inspection2-container {
        padding: 16px;
    }
    
    .header-content {
        flex-direction: column;
        align-items: stretch;
        gap: 20px;
        padding: 20px;
    }
    
    .page-title h1 {
        font-size: 28px;
    }
    
    .page-title p {
        font-size: 15px;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
        gap: 20px;
        padding: 20px;
    }
    
    .step-indicator {
        gap: 12px;
    }
    
    .step-connector {
        display: none;
    }
    
    .gps-info-grid {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .inspection-checklist-section {
        padding: 24px;
    }
    
    .section-header {
        padding: 16px 20px;
    }
    
    .inspection-item {
        padding: 20px;
    }
    
    .item-content {
        flex-direction: column;
        align-items: stretch;
        gap: 16px;
    }
    
    .item-actions {
        justify-content: center;
    }
}

@media (max-width: 768px) {
    .inspection2-container {
        padding: 0;
    }
    
    .inspection2-header {
        margin: 0 16px 16px 16px;
    }
    
    .header-content {
        padding: 16px;
        gap: 16px;
    }
    
    .page-title h1 {
        font-size: 24px;
        margin-bottom: 6px;
    }
    
    .page-title p {
        font-size: 14px;
    }
    
    .back-link {
        font-size: 13px;
        padding: 8px 0;
    }
    
    .step-indicator-section {
        margin: 0 16px 16px 16px;
        padding: 20px;
    }
    
    .step-indicator {
        flex-direction: column;
        gap: 16px;
    }
    
    .step-item {
        flex-direction: row;
        gap: 12px;
        width: 100%;
        justify-content: flex-start;
    }
    
    .step-icon {
        width: 40px;
        height: 40px;
    }
    
    .step-content {
        flex-direction: row;
        gap: 8px;
        align-items: center;
    }
    
    .step-title {
        font-size: 14px;
    }
    
    .step-connector {
        display: none;
    }
    
    .form-section {
        margin: 0 16px 16px 16px;
    }
    
    .form-header {
        padding: 20px 16px 16px 16px;
    }
    
    .form-header h2 {
        font-size: 20px;
    }
    
    .form-header p {
        font-size: 14px;
    }
    
    .form-grid {
        padding: 20px 16px;
    }
    
    .form-column {
        gap: 16px;
    }
    
    .form-group {
        margin-bottom: 16px;
    }
    
    .form-label {
        font-size: 14px;
        margin-bottom: 6px;
    }
    
    .form-control {
        padding: 12px 16px;
        font-size: 16px;
        min-height: 48px;
    }
    
    .meter-reading-group {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .gps-section {
        padding: 0 16px 20px 16px;
    }
    
    .gps-info-grid {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .form-actions {
        padding: 16px 16px 20px 16px;
    }
    
    .btn-next {
        width: 100%;
        padding: 14px 28px;
        font-size: 15px;
        min-height: 48px;
    }
    
    .inspection-checklist-section {
        margin: 0 16px 16px 16px;
        padding: 20px;
    }
    
    .checklist-title {
        padding: 16px;
    }
    
    .checklist-title h3 {
        font-size: 18px;
    }
    
    .header-inputs-section {
        padding: 16px;
    }
    
    .section-header {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
        padding: 16px;
    }
    
    .section-title {
        justify-content: center;
    }
    
    .section-title h4 {
        font-size: 16px;
    }
    
    .btn-auto-fill {
        width: 100%;
        justify-content: center;
        padding: 10px 16px;
        font-size: 14px;
        min-height: 44px;
    }
    
    .header-inputs-grid {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .inspection-item {
        padding: 16px;
    }
    
    .item-content {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
    }
    
    .item-info {
        flex-direction: column;
        align-items: flex-start;
        gap: 8px;
    }
    
    .item-number {
        width: 28px;
        height: 28px;
        font-size: 12px;
    }
    
    .item-title {
        font-size: 15px;
    }
    
    .item-description {
        font-size: 13px;
    }
    
    .item-actions {
        justify-content: center;
        flex-wrap: wrap;
        gap: 8px;
    }
    
    .btn-option {
        padding: 8px 12px;
        font-size: 13px;
        min-width: 70px;
        min-height: 40px;
    }
    
    .btn-note, .btn-image {
        padding: 8px 12px;
        font-size: 13px;
        min-height: 40px;
    }
    
    .btn-note svg, .btn-image svg {
        width: 14px;
        height: 14px;
    }
}

@media (max-width: 576px) {
    .inspection2-container {
        padding: 0;
    }
    
    .inspection2-header {
        margin: 0 12px 12px 12px;
    }
    
    .header-content {
        padding: 12px;
        gap: 12px;
    }
    
    .page-title h1 {
        font-size: 20px;
        margin-bottom: 4px;
    }
    
    .page-title p {
        font-size: 13px;
    }
    
    .back-link {
        font-size: 12px;
        padding: 6px 0;
    }
    
    .back-link svg {
        width: 16px;
        height: 16px;
    }
    
    .step-indicator-section {
        margin: 0 12px 12px 12px;
        padding: 16px;
    }
    
    .step-indicator {
        gap: 12px;
    }
    
    .step-item {
        gap: 10px;
    }
    
    .step-icon {
        width: 36px;
        height: 36px;
    }
    
    .step-icon svg {
        width: 16px;
        height: 16px;
    }
    
    .step-title {
        font-size: 12px;
    }
    
    .form-section {
        margin: 0 12px 12px 12px;
    }
    
    .form-header {
        padding: 16px 12px 12px 12px;
    }
    
    .form-header h2 {
        font-size: 18px;
    }
    
    .form-header p {
        font-size: 13px;
    }
    
    .form-grid {
        padding: 16px 12px;
    }
    
    .form-column {
        gap: 12px;
    }
    
    .form-group {
        margin-bottom: 12px;
    }
    
    .form-label {
        font-size: 13px;
        margin-bottom: 4px;
    }
    
    .form-control {
        padding: 10px 14px;
        font-size: 16px;
        min-height: 44px;
    }
    
    .gps-section {
        padding: 0 12px 16px 12px;
    }
    
    .form-actions {
        padding: 12px 12px 16px 12px;
    }
    
    .btn-next {
        padding: 12px 24px;
        font-size: 14px;
        min-height: 44px;
    }
    
    .inspection-checklist-section {
        margin: 0 12px 12px 12px;
        padding: 16px;
    }
    
    .checklist-title {
        padding: 12px;
    }
    
    .checklist-title h3 {
        font-size: 16px;
    }
    
    .header-inputs-section {
        padding: 12px;
    }
    
    .section-header {
        padding: 12px;
        gap: 10px;
    }
    
    .section-title h4 {
        font-size: 15px;
    }
    
    .btn-auto-fill {
        padding: 8px 12px;
        font-size: 13px;
        min-height: 40px;
    }
    
    .inspection-item {
        padding: 12px;
    }
    
    .item-content {
        gap: 10px;
    }
    
    .item-info {
        gap: 6px;
    }
    
    .item-number {
        width: 24px;
        height: 24px;
        font-size: 11px;
    }
    
    .item-title {
        font-size: 14px;
    }
    
    .item-description {
        font-size: 12px;
    }
    
    .item-actions {
        gap: 6px;
    }
    
    .btn-option {
        padding: 6px 10px;
        font-size: 12px;
        min-width: 60px;
        min-height: 36px;
    }
    
    .btn-note, .btn-image {
        padding: 6px 10px;
        font-size: 12px;
        min-height: 36px;
    }
    
    .btn-note svg, .btn-image svg {
        width: 12px;
        height: 12px;
    }
}

@media (max-width: 480px) {
    .inspection2-header {
        margin: 0 8px 8px 8px;
    }
    
    .header-content {
        padding: 10px;
        gap: 10px;
    }
    
    .page-title h1 {
        font-size: 18px;
        margin-bottom: 3px;
    }
    
    .page-title p {
        font-size: 12px;
    }
    
    .back-link {
        font-size: 11px;
        padding: 4px 0;
    }
    
    .back-link svg {
        width: 14px;
        height: 14px;
    }
    
    .step-indicator-section {
        margin: 0 8px 8px 8px;
        padding: 12px;
    }
    
    .step-indicator {
        gap: 8px;
    }
    
    .step-item {
        gap: 8px;
    }
    
    .step-icon {
        width: 32px;
        height: 32px;
    }
    
    .step-icon svg {
        width: 14px;
        height: 14px;
    }
    
    .step-title {
        font-size: 11px;
    }
    
    .form-section {
        margin: 0 8px 8px 8px;
    }
    
    .form-header {
        padding: 12px 8px 8px 8px;
    }
    
    .form-header h2 {
        font-size: 16px;
    }
    
    .form-header p {
        font-size: 12px;
    }
    
    .form-grid {
        padding: 12px 8px;
    }
    
    .form-column {
        gap: 10px;
    }
    
    .form-group {
        margin-bottom: 10px;
    }
    
    .form-label {
        font-size: 12px;
        margin-bottom: 3px;
    }
    
    .form-control {
        padding: 8px 12px;
        font-size: 16px;
        min-height: 40px;
    }
    
    .gps-section {
        padding: 0 8px 12px 8px;
    }
    
    .form-actions {
        padding: 8px 8px 12px 8px;
    }
    
    .btn-next {
        padding: 10px 20px;
        font-size: 13px;
        min-height: 40px;
    }
    
    .inspection-checklist-section {
        margin: 0 8px 8px 8px;
        padding: 12px;
    }
    
    .checklist-title {
        padding: 8px;
    }
    
    .checklist-title h3 {
        font-size: 14px;
    }
    
    .header-inputs-section {
        padding: 8px;
    }
    
    .section-header {
        padding: 8px;
        gap: 8px;
    }
    
    .section-title h4 {
        font-size: 14px;
    }
    
    .btn-auto-fill {
        padding: 6px 10px;
        font-size: 12px;
        min-height: 36px;
    }
    
    .inspection-item {
        padding: 8px;
    }
    
    .item-content {
        gap: 8px;
    }
    
    .item-info {
        gap: 4px;
    }
    
    .item-number {
        width: 20px;
        height: 20px;
        font-size: 10px;
    }
    
    .item-title {
        font-size: 13px;
    }
    
    .item-description {
        font-size: 11px;
    }
    
    .item-actions {
        gap: 4px;
    }
    
    .btn-option {
        padding: 4px 8px;
        font-size: 11px;
        min-width: 50px;
        min-height: 32px;
    }
    
    .btn-note, .btn-image {
        padding: 4px 8px;
        font-size: 11px;
        min-height: 32px;
    }
    
    .btn-note svg, .btn-image svg {
        width: 10px;
        height: 10px;
    }
}

@media (max-width: 360px) {
    .inspection2-header {
        margin: 0 6px 6px 6px;
    }
    
    .header-content {
        padding: 8px;
        gap: 8px;
    }
    
    .page-title h1 {
        font-size: 16px;
        margin-bottom: 2px;
    }
    
    .page-title p {
        font-size: 11px;
    }
    
    .back-link {
        font-size: 10px;
        padding: 3px 0;
    }
    
    .back-link svg {
        width: 12px;
        height: 12px;
    }
    
    .step-indicator-section {
        margin: 0 6px 6px 6px;
        padding: 10px;
    }
    
    .step-indicator {
        gap: 6px;
    }
    
    .step-item {
        gap: 6px;
    }
    
    .step-icon {
        width: 28px;
        height: 28px;
    }
    
    .step-icon svg {
        width: 12px;
        height: 12px;
    }
    
    .step-title {
        font-size: 10px;
    }
    
    .form-section {
        margin: 0 6px 6px 6px;
    }
    
    .form-header {
        padding: 10px 6px 6px 6px;
    }
    
    .form-header h2 {
        font-size: 15px;
    }
    
    .form-header p {
        font-size: 11px;
    }
    
    .form-grid {
        padding: 10px 6px;
    }
    
    .form-column {
        gap: 8px;
    }
    
    .form-group {
        margin-bottom: 8px;
    }
    
    .form-label {
        font-size: 11px;
        margin-bottom: 2px;
    }
    
    .form-control {
        padding: 6px 10px;
        font-size: 16px;
        min-height: 36px;
    }
    
    .gps-section {
        padding: 0 6px 10px 6px;
    }
    
    .form-actions {
        padding: 6px 6px 10px 6px;
    }
    
    .btn-next {
        padding: 8px 16px;
        font-size: 12px;
        min-height: 36px;
    }
    
    .inspection-checklist-section {
        margin: 0 6px 6px 6px;
        padding: 10px;
    }
    
    .checklist-title {
        padding: 6px;
    }
    
    .checklist-title h3 {
        font-size: 13px;
    }
    
    .header-inputs-section {
        padding: 6px;
    }
    
    .section-header {
        padding: 6px;
        gap: 6px;
    }
    
    .section-title h4 {
        font-size: 13px;
    }
    
    .btn-auto-fill {
        padding: 4px 8px;
        font-size: 11px;
        min-height: 32px;
    }
    
    .inspection-item {
        padding: 6px;
    }
    
    .item-content {
        gap: 6px;
    }
    
    .item-info {
        gap: 3px;
    }
    
    .item-number {
        width: 18px;
        height: 18px;
        font-size: 9px;
    }
    
    .item-title {
        font-size: 12px;
    }
    
    .item-description {
        font-size: 10px;
    }
    
    .item-actions {
        gap: 3px;
    }
    
    .btn-option {
        padding: 3px 6px;
        font-size: 10px;
        min-width: 45px;
        min-height: 28px;
    }
    
    .btn-note, .btn-image {
        padding: 3px 6px;
        font-size: 10px;
        min-height: 28px;
    }
    
    .btn-note svg, .btn-image svg {
        width: 8px;
        height: 8px;
    }
}

/* Focus states for accessibility */
.btn-next:focus,
.btn-gps:focus,
.btn-select:focus,
.btn-auto-fill:focus,
.form-control:focus {
    outline: 2px solid #3b82f6;
    outline-offset: 2px;
}

/* Smooth animations */
* {
    transition: all 0.2s ease;
}

/* Icon improvements */
.back-link svg,
.btn-next svg,
.btn-gps svg,
.btn-select svg,
.btn-auto-fill svg,
.step-icon svg {
    flex-shrink: 0;
}

/* Step 2 Enhanced UI Design - Matching Theme */
.checklist-title {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
}

.checklist-title h3 {
    color: #0f172a;
    font-weight: 600;
    font-size: 20px;
    margin: 0;
    text-align: center;
}

.header-inputs-section {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    margin-bottom: 20px;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
    overflow: hidden;
}

.section-header {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    padding: 20px;
    border-bottom: 1px solid #e2e8f0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.section-title h4 {
    color: #0f172a;
    font-weight: 600;
    font-size: 18px;
    margin: 0 0 4px 0;
}

.required-indicator {
    color: #ef4444;
    font-size: 12px;
    font-weight: 500;
}

.btn-auto-fill {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 16px;
    background: #0055A5;
    color: white;
    border: none;
    border-radius: 6px;
    font-weight: 500;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-auto-fill:hover {
    background: #004494;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0, 85, 165, 0.2);
}

.btn-auto-fill svg {
    flex-shrink: 0;
}

.header-inputs-grid {
    padding: 20px;
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}

.header-input-field {
    display: flex;
    flex-direction: column;
    gap: 6px;
}

.header-input-field label {
    color: #374151;
    font-weight: 500;
    font-size: 14px;
}

.header-input-field input {
    padding: 12px 16px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    font-size: 14px;
    transition: all 0.2s ease;
    background: white;
}

.header-input-field input:focus {
    outline: none;
    border-color: #0055A5;
    box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
}

/* .inspection-sections-container {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    margin-bottom: 20px;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
    overflow: hidden;
} */

.heading-container {
    padding: 16px 20px;
    background: #f8fafc;
    border-bottom: 1px solid #e2e8f0;
}

.heading-text {
    color: #64748b;
    font-size: 14px;
    margin: 0;
    text-align: center;
    font-style: italic;
}

.inspection-section {
    border-bottom: 1px solid #e2e8f0;
    transition: all 0.2s ease;
}

.inspection-section:last-child {
    border-bottom: none;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px 20px;
    background: #f8fafc;
    cursor: pointer;
    transition: all 0.2s ease;
    border: none;
}

.section-header:hover {
    background: #f1f5f9;
}

.section-header h5 {
    color: #0f172a;
    font-weight: 600;
    font-size: 16px;
    margin: 0;
    flex: 1;
}

.section-count {
    color: #64748b;
    font-size: 14px;
    font-weight: 500;
    margin-right: 12px;
}

.dropdown-icon {
    transition: transform 0.2s ease;
    color: #64748b;
    flex-shrink: 0;
}

.section-header.expanded .dropdown-icon {
    transform: rotate(180deg);
}

.section-content {
    display: none;
    padding: 0 20px 20px 20px;
    background: white;
}

.section-content.expanded {
    display: block;
}

.checklist-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px 0;
    border-bottom: 1px solid #f1f5f9;
    transition: all 0.2s ease;
}

.checklist-item:last-child {
    border-bottom: none;
}

.checklist-item:hover {
    background: #f8fafc;
    margin: 0 -20px;
    padding: 16px 20px;
    border-radius: 6px;
}

.item-label {
    color: #0f172a;
    font-weight: 500;
    font-size: 14px;
    flex: 1;
    margin: 0;
}

.item-options {
    display: flex;
    gap: 20px;
}

.option-label {
    display: flex;
    align-items: center;
    gap: 8px;
    cursor: pointer;
    font-size: 14px;
    color: #64748b;
    padding: 8px 12px;
    border-radius: 6px;
    transition: all 0.2s ease;
}

.option-label:hover {
    background: #f1f5f9;
    color: #0f172a;
}

.option-label input[type="radio"] {
    margin: 0;
    width: 16px;
    height: 16px;
    accent-color: #0055A5;
}

.option-text {
    font-weight: 500;
}

/* Navigation Buttons */
.d-flex.justify-content-center.mt-4 {
    display: flex;
    justify-content: center;
    gap: 16px;
    margin-top: 24px;
    padding: 20px;
}

.btn-outline-primary {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    background: transparent;
    color: #0055A5;
    border: 2px solid #0055A5;
    border-radius: 6px;
    font-weight: 500;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.2s ease;
    text-decoration: none;
}

.btn-outline-primary:hover {
    background: #0055A5;
    color: white;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0, 85, 165, 0.2);
}

.btn-primary {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    background: #0055A5;
    color: white;
    border: none;
    border-radius: 6px;
    font-weight: 500;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-primary:hover {
    background: #004494;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0, 85, 165, 0.2);
}

.btn-outline-primary i,
.btn-primary i {
    font-size: 14px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .header-inputs-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }
    
    .section-header {
        padding: 12px 16px;
    }
    
    .section-content {
        padding: 0 16px 16px 16px;
    }
    
    .checklist-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }
    
    .item-options {
        width: 100%;
        justify-content: space-between;
    }
    
    .d-flex.justify-content-center.mt-4 {
        flex-direction: column;
        align-items: center;
    }
    
    .btn-outline-primary,
    .btn-primary {
        width: 100%;
        max-width: 300px;
        justify-content: center;
    }
}
</style>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>