<!-- Modern Navbar -->
<div style="background: #0055a5; color: white; padding: 12px 24px; display: flex; align-items: center; justify-content: space-between; position: fixed; top: 0; left: 0; width: 100%; z-index: 1000; border-bottom: 1px solid rgba(255, 255, 255, 0.1); font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
    <div style="display: flex; align-items: center; gap: 16px; flex: 0 0 auto;">
        <button id="sidebar-toggle-btn" title="Toggle Sidebar" onclick="toggleSidebar(); return false;" style="border: 1px solid rgba(255, 255, 255, 0.1); cursor: pointer; padding: 10px; border-radius: 0; transition: all 0.2s ease; display: flex; align-items: center; justify-content: center; background: transparent; color: white;">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0;">
                <line x1="3" y1="6" x2="21" y2="6"/>
                <line x1="3" y1="12" x2="21" y2="12"/>
                <line x1="3" y1="18" x2="21" y2="18"/>
            </svg>
        </button>
        <div class="global-country-filter">
            <button
                id="globalCountryFilterBtn"
                type="button"
                class="global-country-filter-button"
                aria-haspopup="true"
                aria-expanded="false"
            >
                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 4h18"></path>
                    <path d="M8 12h8"></path>
                    <path d="M10 20h4"></path>
                </svg>
                <span id="globalCountryFilterLabel">All Countries</span>
                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polyline points="6 9 12 15 18 9"></polyline>
                </svg>
            </button>
            <div
                id="globalCountryFilterMenu"
                class="global-country-filter-menu"
                role="menu"
                aria-labelledby="globalCountryFilterBtn"
            >
                <div class="global-country-filter-header">Filter by Country</div>
                <label class="global-country-filter-option">
                    <input type="checkbox" value="DRC" class="global-country-option" checked>
                    <span>DRC</span>
                </label>
                <label class="global-country-filter-option">
                    <input type="checkbox" value="Zambia" class="global-country-option" checked>
                    <span>Zambia</span>
                </label>
                <div class="global-country-filter-divider"></div>
                <div class="global-country-filter-actions">
                    <button type="button" class="global-country-filter-reset" id="globalCountryFilterReset">Reset</button>
                    <button type="button" class="global-country-filter-apply" id="globalCountryFilterApply">Done</button>
                </div>
            </div>
        </div>
    </div>

    <div style="position: absolute; left: 50%; top: 50%; transform: translate(-50%, -50%); display: flex; justify-content: center; align-items: center;">
        <div style="display: flex; align-items: center; gap: 12px;">
            <img src="/images/Sidebar-logo.png" alt="Titan Drilling Logo" style="height: 50px; width: auto; object-fit: contain;">
        </div>
    </div>

    <div style="display: flex; align-items: center; gap: 8px; flex: 0 0 auto;">
        @auth
            <div style="display: flex; align-items: center; gap: 8px;">
                <span style="font-size: 14px; color: rgba(255, 255, 255, 0.9);">
                    Welcome, {{ Auth::user()->name }}
                </span>
                <a href="{{ route('admin.logout.get') }}" title="Logout" onclick="return confirmLogout(event)" style="display: flex; align-items: center; gap: 8px; padding: 10px 16px; border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 0; background: transparent; color: white; font-size: 14px; font-weight: 500; cursor: pointer; transition: all 0.2s ease; text-decoration: none;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0;">
                        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
                        <polyline points="16,17 21,12 16,7"/>
                        <line x1="21" y1="12" x2="9" y2="12"/>
                    </svg>
                    <span style="white-space: nowrap;">Logout</span>
                </a>
            </div>
        @else
            <div style="display: flex; align-items: center; gap: 8px;">
                <a href="{{ route('login') }}" title="Sign In" style="display: flex; align-items: center; gap: 8px; padding: 10px 16px; border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 0; background: transparent; color: white; font-size: 14px; font-weight: 500; cursor: pointer; transition: all 0.2s ease; text-decoration: none;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0;">
                        <path d="M15 3h4a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-4"/>
                        <polyline points="10,17 15,12 10,7"/>
                        <line x1="15" y1="12" x2="3" y2="12"/>
                    </svg>
                    <span style="white-space: nowrap;">Sign In</span>
                </a>
            </div>
        @endauth
        
        <a href="{{ route('profile') }}" title="Profile" style="display: flex; align-items: center; gap: 8px; padding: 10px 16px; border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 0; background: transparent; color: white; font-size: 14px; font-weight: 500; cursor: pointer; transition: all 0.2s ease; text-decoration: none;">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0;">
                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                <circle cx="12" cy="7" r="4"/>
            </svg>
            <span style="white-space: nowrap;">Profile</span>
        </a>
        
        
    </div>
</div>

<!-- Mobile Menu Overlay -->
<div id="mobileMenuOverlay" style="position: fixed; top: 0; left: 0; width: 100%; height: 100vh; z-index: 9999; display: none; opacity: 0; transition: all 0.2s ease; overflow-y: auto;">
    <div style="background: #ffffff; width: 100%; min-height: 100vh; transform: translateX(100%); transition: transform 0.3s ease; display: flex; flex-direction: column; box-shadow: -4px 0 12px rgba(0, 0, 0, 0.15); margin-top: 133px;">
        <!-- <div class="mobile-menu-header">
            <div class="mobile-menu-title">Navigation Menu</div>
            <button class="mobile-menu-close" onclick="toggleMobileMenu()" title="Close Menu">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="18" y1="6" x2="6" y2="18"/>
                    <line x1="6" y1="6" x2="18" y2="18"/>
                </svg>
            </button>
        </div> -->
        
        <div style="flex: 1; overflow-y: auto; padding: 0; height: calc(100vh - 80px); -webkit-overflow-scrolling: touch;">
            <nav style="padding: 0;">
                <!-- Dashboard Section -->
                <div style="border-bottom: 1px solid #e2e8f0;">
                    <div style="background: #f8fafc; color: #64748b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em; padding: 1rem 1.5rem 0.5rem; margin: 0;">Dashboard</div>
                    <a href="/dashboard" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <rect x="3" y="3" width="7" height="7"/>
                            <rect x="14" y="3" width="7" height="7"/>
                            <rect x="14" y="14" width="7" height="7"/>
                            <rect x="3" y="14" width="7" height="7"/>
                        </svg>
                        <span style="flex: 1;">Dashboard</span>
                    </a>
                </div>

                <!-- Maintenance Section -->
                <div style="border-bottom: 1px solid #e2e8f0;">
                    <div style="background: #f8fafc; color: #64748b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em; padding: 1rem 1.5rem 0.5rem; margin: 0;">Maintenance</div>
                    <a href="/maintenance/request" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                            <polyline points="14,2 14,8 20,8"/>
                            <line x1="16" y1="13" x2="8" y2="13"/>
                            <line x1="16" y1="17" x2="8" y2="17"/>
                        </svg>
                        <span style="flex: 1;">Request Maintenance</span>
                    </a>
                    <a href="/maintenance/workorder" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                            <polyline points="14,2 14,8 20,8"/>
                            <line x1="16" y1="13" x2="8" y2="13"/>
                            <line x1="16" y1="17" x2="8" y2="17"/>
                        </svg>
                        <span style="flex: 1;">Work Orders</span>
                    </a>
                    <a href="/maintenance/schedule" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                            <line x1="16" y1="2" x2="16" y2="6"/>
                            <line x1="8" y1="2" x2="8" y2="6"/>
                            <line x1="3" y1="10" x2="21" y2="10"/>
                        </svg>
                        <span style="flex: 1;">Service Schedule</span>
                    </a>
                    <a href="/maintenance/task-master" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M9 12l2 2 4-4"/>
                            <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                            <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                        </svg>
                        <span style="flex: 1;">Task Master</span>
                    </a>
                    <a href="/maintenance/labor-codes" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                        <span style="flex: 1;">Labor Codes</span>
                    </a>
                    <a href="/maintenance/parts-inventory" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"/>
                            <line x1="3" y1="6" x2="21" y2="6"/>
                            <path d="M16 10a4 4 0 0 1-8 0"/>
                        </svg>
                        <span style="flex: 1;">Parts Inventory</span>
                    </a>
                </div>

                <!-- Vehicles Section -->
                <div style="border-bottom: 1px solid #e2e8f0;">
                    <div style="background: #f8fafc; color: #64748b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em; padding: 1rem 1.5rem 0.5rem; margin: 0;">Vehicles</div>
                    <a href="/vehicles/inventory" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"/>
                            <line x1="3" y1="6" x2="21" y2="6"/>
                            <path d="M16 10a4 4 0 0 1-8 0"/>
                        </svg>
                        <span style="flex: 1;">Vehicle Inventory</span>
                    </a>
                    <a href="/vehicles/overview" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                            <circle cx="12" cy="12" r="3"/>
                        </svg>
                        <span style="flex: 1;">Vehicle Overview</span>
                    </a>
                    <a href="/vehicles/dvir-inspection" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M9 12l2 2 4-4"/>
                            <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                        </svg>
                        <span style="flex: 1;">DVIR Inspection</span>
                    </a>
                </div>

                <!-- Master Data Section -->
                <div style="border-bottom: 1px solid #e2e8f0;">
                    <div style="background: #f8fafc; color: #64748b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em; padding: 1rem 1.5rem 0.5rem; margin: 0;">Master Data</div>
                    <a href="/master-data/account" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                            <circle cx="12" cy="7" r="4"/>
                        </svg>
                        <span style="flex: 1;">Account</span>
                    </a>
                    <a href="/master-data/team-management" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                        <span style="flex: 1;">Team Management</span>
                    </a>
                    <a href="/master-data/documents" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                            <polyline points="14,2 14,8 20,8"/>
                        </svg>
                        <span style="flex: 1;">Documents</span>
                    </a>
                    <a href="/master-data/subscription" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                        </svg>
                        <span style="flex: 1;">Subscription</span>
                    </a>
                </div>

                <!-- Reports Section -->
                <div style="border-bottom: none;">
                    <div style="background: #f8fafc; color: #64748b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em; padding: 1rem 1.5rem 0.5rem; margin: 0;">Reports</div>
                    <a href="/reports/maintenance" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: 1px solid #f1f5f9;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M3 3v18h18"/>
                            <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"/>
                        </svg>
                        <span style="flex: 1;">Maintenance Reports</span>
                    </a>
                    <a href="/reports/vehicle" style="display: flex; align-items: center; gap: 1rem; padding: 1rem 1.5rem; color: #374151; text-decoration: none; font-size: 0.95rem; font-weight: 500; transition: all 0.2s ease; border-bottom: none;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="flex-shrink: 0; color: #64748b; transition: color 0.2s ease;">
                            <path d="M3 3v18h18"/>
                            <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"/>
                        </svg>
                        <span style="flex: 1;">Vehicle Reports</span>
                    </a>
                </div>
            </nav>
        </div>
    </div>
</div>

<style>
.global-country-filter {
    position: relative;
}

.global-country-filter-button {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 14px;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 0;
    color: #ffffff;
    font-size: 13px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    min-width: 180px;
    letter-spacing: 0.01em;
}

.global-country-filter-button:hover,
.global-country-filter-button:focus,
.global-country-filter-button[aria-expanded="true"] {
    background: rgba(255, 255, 255, 0.18);
    border-color: rgba(255, 255, 255, 0.4);
    outline: none;
}

.global-country-filter-button svg {
    flex-shrink: 0;
}

.global-country-filter-menu {
    position: absolute;
    top: calc(100% + 8px);
    left: 0;
    background: #ffffff;
    color: #1f2937;
    min-width: 220px;
    padding: 16px;
    border-radius: 12px;
    box-shadow: 0 12px 30px rgba(15, 23, 42, 0.18);
    border: 1px solid #e2e8f0;
    display: none;
    z-index: 1500;
}

.global-country-filter-menu.show {
    display: block;
    animation: fadeInMenu 0.2s ease;
}

.global-country-filter-header {
    font-size: 14px;
    font-weight: 600;
    color: #0f172a;
    margin-bottom: 12px;
}

.global-country-filter-option {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 8px 10px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 14px;
    color: #1f2937;
}

.global-country-filter-option input {
    width: 18px;
    height: 18px;
    accent-color: #0055a5;
}

.global-country-filter-option:hover {
    background: #f1f5f9;
}

.global-country-filter-divider {
    height: 1px;
    background: #e2e8f0;
    margin: 12px 0;
}

.global-country-filter-actions {
    display: flex;
    justify-content: flex-end;
    align-items: center;
    gap: 8px;
}

.global-country-filter-reset {
    border: none;
    background: rgba(0, 85, 165, 0.08);
    color: #0055a5;
    font-size: 13px;
    font-weight: 600;
    padding: 8px 14px;
    border-radius: 6px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.global-country-filter-reset:hover {
    background: rgba(0, 85, 165, 0.16);
}

.global-country-filter-apply {
    border: none;
    background: #0055a5;
    color: #ffffff;
    font-size: 13px;
    font-weight: 600;
    padding: 8px 16px;
    border-radius: 6px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.global-country-filter-apply:hover {
    background: #004a90;
}

@keyframes fadeInMenu {
    from {
        opacity: 0;
        transform: translateY(4px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Mobile responsive styles for inline CSS elements */
@media (max-width: 768px) {
    #mobileMenuOverlay {
        position: fixed !important;
        top: 0 !important;
        left: 0 !important;
        right: 0 !important;
        bottom: 0 !important;
        width: 100% !important;
        height: 100vh !important;
        overflow-y: auto !important;
        -webkit-overflow-scrolling: touch !important;
    }
    
    #mobileMenuOverlay > div {
        min-height: 100vh !important;
        margin-top: 133px !important;
        padding-bottom: 20px !important;
    }
    
    #mobileMenuOverlay > div > div {
        height: auto !important;
        min-height: calc(100vh - 80px) !important;
        overflow-y: visible !important;
        -webkit-overflow-scrolling: touch !important;
    }
    
    #mobileMenuOverlay > div > div > nav {
        padding-bottom: 40px !important;
    }
}

/* Touch Device Scrolling */
@media (hover: none) and (pointer: coarse) {
    #mobileMenuOverlay,
    #mobileMenuOverlay > div > div {
        -webkit-overflow-scrolling: touch !important;
        overscroll-behavior: contain !important;
    }
}

/* Mobile menu toggle button visibility */
@media (max-width: 768px) {
    button[onclick="toggleMobileMenu()"] {
        display: flex !important;
    }
}

@media (min-width: 769px) {
    button[onclick="toggleMobileMenu()"] {
        display: none !important;
    }
}
</style>

<script>
    // Test if custom alert system is working
console.log('Navbar script loading...');

// Custom Alert System - Embedded
window.showCustomAlert = function(message, type = 'info', options = {}) {
    const alertId = 'custom-alert-' + Date.now();
    const alertOverlay = document.createElement('div');
    alertOverlay.id = alertId;
    alertOverlay.style.cssText = `
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.6);
        z-index: 10000;
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transition: all 0.3s ease;
        backdrop-filter: blur(4px);
    `;

    const alertBox = document.createElement('div');
    alertBox.style.cssText = `
        background: white;
        border-radius: 12px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
        max-width: 400px;
        width: 90%;
        transform: scale(0.8) translateY(20px);
        transition: all 0.3s ease;
        overflow: hidden;
    `;

    const typeColors = {
        success: { bg: '#10b981', icon: '✓', title: 'Success' },
        error: { bg: '#ef4444', icon: '✕', title: 'Error' },
        warning: { bg: '#f59e0b', icon: '⚠', title: 'Warning' },
        info: { bg: '#3b82f6', icon: 'ℹ', title: 'Information' },
        confirm: { bg: '#8b5cf6', icon: '?', title: 'Confirm' }
    };

    const colors = typeColors[type] || typeColors.info;

    alertBox.innerHTML = `
        <div style="background: ${colors.bg}; color: white; padding: 20px; text-align: center;">
            <div style="font-size: 32px; margin-bottom: 8px;">${colors.icon}</div>
            <div style="font-size: 18px; font-weight: 600;">${colors.title}</div>
        </div>
        <div style="padding: 24px; text-align: center;">
            <div style="font-size: 16px; color: #374151; line-height: 1.5; margin-bottom: 24px;">${message}</div>
            <div style="display: flex; gap: 12px; justify-content: center;">
                ${type === 'confirm' ? 
                    `<button id="${alertId}-cancel" style="
                        background: #f3f4f6;
                        color: #374151;
                        border: none;
                        padding: 12px 24px;
                        border-radius: 8px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s ease;
                        min-width: 80px;
                    ">Cancel</button>
                    <button id="${alertId}-confirm" style="
                        background: ${colors.bg};
                        color: white;
                        border: none;
                        padding: 12px 24px;
                        border-radius: 8px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s ease;
                        min-width: 80px;
                    ">OK</button>` :
                    `<button id="${alertId}-ok" style="
                        background: ${colors.bg};
                        color: white;
                        border: none;
                        padding: 12px 24px;
                        border-radius: 8px;
                        font-weight: 500;
                        cursor: pointer;
                        transition: all 0.2s ease;
                        min-width: 80px;
                    ">OK</button>`
                }
            </div>
        </div>
    `;

    alertOverlay.appendChild(alertBox);
    document.body.appendChild(alertOverlay);

    // Animate in
    setTimeout(() => {
        alertOverlay.style.opacity = '1';
        alertBox.style.transform = 'scale(1) translateY(0)';
    }, 10);

    // Add hover effects
    const buttons = alertBox.querySelectorAll('button');
    buttons.forEach(button => {
        button.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-2px)';
            this.style.boxShadow = '0 4px 12px rgba(0, 0, 0, 0.2)';
        });
        button.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = 'none';
        });
    });

    return new Promise((resolve) => {
        if (type === 'confirm') {
            const cancelBtn = document.getElementById(`${alertId}-cancel`);
            const confirmBtn = document.getElementById(`${alertId}-confirm`);
            
            cancelBtn.addEventListener('click', () => {
                closeAlert(false);
            });
            
            confirmBtn.addEventListener('click', () => {
                closeAlert(true);
            });
        } else {
            const okBtn = document.getElementById(`${alertId}-ok`);
            okBtn.addEventListener('click', () => {
                closeAlert(true);
            });
        }

        // Close on overlay click
        alertOverlay.addEventListener('click', (e) => {
            if (e.target === alertOverlay) {
                closeAlert(type === 'confirm' ? false : true);
            }
        });

        function closeAlert(result) {
            alertOverlay.style.opacity = '0';
            alertBox.style.transform = 'scale(0.8) translateY(20px)';
            setTimeout(() => {
                if (alertOverlay.parentNode) {
                    document.body.removeChild(alertOverlay);
                }
                resolve(result);
            }, 300);
        }
    });
};

console.log('Custom alert system loaded!');

// Optimized Navbar Functionality
(function() {
    'use strict';
    
    // Cache DOM elements
    const sidebar = document.getElementById('sidebar');
    const sidebarToggle = document.getElementById('sidebar-toggle-btn');
    const mobileMenuOverlay = document.getElementById('mobileMenuOverlay');
    const siteSelect = document.querySelector('.site-select');
    const actionButtons = document.querySelectorAll('.action-btn');
    const mobileMenuLinks = document.querySelectorAll('.mobile-nav-link');
    const countryFilterConfig = {
        storageKey: 'global-country-filter',
        defaultSelection: ['DRC', 'Zambia']
    };
    let currentCountrySelection = [...countryFilterConfig.defaultSelection];

    function getStoredCountrySelection() {
        try {
            const stored = localStorage.getItem(countryFilterConfig.storageKey);
            if (stored) {
                const parsed = JSON.parse(stored);
                if (Array.isArray(parsed) && parsed.length > 0) {
                    return parsed;
                }
            }
        } catch (error) {
            console.error('Error parsing stored country selection:', error);
        }
        return [...countryFilterConfig.defaultSelection];
    }

    function saveCountryFilterSelection(selection) {
        try {
            localStorage.setItem(countryFilterConfig.storageKey, JSON.stringify(selection));
        } catch (error) {
            console.error('Error saving country selection:', error);
        }
    }

    function updateCountryFilterLabel() {
        const label = document.getElementById('globalCountryFilterLabel');
        if (!label) return;

        if (currentCountrySelection.length >= countryFilterConfig.defaultSelection.length) {
            label.textContent = 'All Countries';
        } else {
            label.textContent = currentCountrySelection.join(', ');
        }
    }

    function setCountryFilterMenuVisibility(show) {
        const filterBtn = document.getElementById('globalCountryFilterBtn');
        const filterMenu = document.getElementById('globalCountryFilterMenu');
        if (!filterBtn || !filterMenu) return;

        filterBtn.setAttribute('aria-expanded', show ? 'true' : 'false');
        filterMenu.classList.toggle('show', show);
    }

    function dispatchCountryFilterChange() {
        window.currentCountryFilterSelection = [...currentCountrySelection];
        window.dispatchEvent(new CustomEvent('countryFilterChanged', {
            detail: { selectedCountries: [...currentCountrySelection] }
        }));
    }

    function syncCountryFilterFromStorage() {
        const filterMenu = document.getElementById('globalCountryFilterMenu');
        if (!filterMenu) return;

        currentCountrySelection = getStoredCountrySelection();
        const checkboxes = filterMenu.querySelectorAll('.global-country-option');
        checkboxes.forEach(input => {
            input.checked = currentCountrySelection.includes(input.value);
        });
        updateCountryFilterLabel();
        dispatchCountryFilterChange();
    }

    function initGlobalCountryFilter() {
        const filterBtn = document.getElementById('globalCountryFilterBtn');
        const filterMenu = document.getElementById('globalCountryFilterMenu');
        const resetBtn = document.getElementById('globalCountryFilterReset');
        const applyBtn = document.getElementById('globalCountryFilterApply');

        if (!filterBtn || !filterMenu) {
            return;
        }

        const checkboxes = filterMenu.querySelectorAll('.global-country-option');
        currentCountrySelection = getStoredCountrySelection();
        const selectionSet = new Set(currentCountrySelection);

        checkboxes.forEach(input => {
            input.checked = selectionSet.has(input.value);
            input.addEventListener('change', function(e) {
                const checkedInputs = Array.from(checkboxes).filter(box => box.checked);
                if (checkedInputs.length === 0) {
                    e.target.checked = true;
                    return;
                }

                currentCountrySelection = checkedInputs.map(box => box.value);
                saveCountryFilterSelection(currentCountrySelection);
                updateCountryFilterLabel();
                dispatchCountryFilterChange();
            });
        });

        updateCountryFilterLabel();
        setCountryFilterMenuVisibility(false);

        filterBtn.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            const expanded = filterBtn.getAttribute('aria-expanded') === 'true';
            setCountryFilterMenuVisibility(!expanded);
        });

        document.addEventListener('click', function(e) {
            if (!filterMenu.contains(e.target) && !filterBtn.contains(e.target)) {
                setCountryFilterMenuVisibility(false);
            }
        });

        if (resetBtn) {
            resetBtn.addEventListener('click', function(e) {
                e.preventDefault();
                currentCountrySelection = [...countryFilterConfig.defaultSelection];
                checkboxes.forEach(box => {
                    box.checked = currentCountrySelection.includes(box.value);
                });
                saveCountryFilterSelection(currentCountrySelection);
                updateCountryFilterLabel();
                dispatchCountryFilterChange();
            });
        }

        if (applyBtn) {
            applyBtn.addEventListener('click', function(e) {
                e.preventDefault();
                dispatchCountryFilterChange();
                setCountryFilterMenuVisibility(false);
            });
        }

        dispatchCountryFilterChange();
    }

    window.getCountryFilterSelection = function() {
        return [...currentCountrySelection];
    };
    
    // Configuration
    const CONFIG = {
        mobileBreakpoint: 768,
        storageKeys: {
            sidebar: 'sidebar-collapsed',
            site: 'selected-site'
        }
    };

    // Sidebar Toggle Function
    function toggleSidebar() {
        console.log('Toggle sidebar clicked!');
        
        if (!sidebar) {
            console.error('Sidebar not found!');
            return;
        }
        
        console.log('Sidebar found, current classes:', sidebar.className);
        
        // Ensure sidebar is visible on desktop
        if (window.innerWidth > CONFIG.mobileBreakpoint) {
            sidebar.style.display = 'block';
            sidebar.style.visibility = 'visible';
            sidebar.style.opacity = '1';
        }
        
        // Check if sidebar is currently collapsed
        const isCurrentlyCollapsed = sidebar.classList.contains('collapsed');
        
        if (isCurrentlyCollapsed) {
            // Opening sidebar - slide in from left
            sidebar.classList.remove('collapsed', 'slide-out');
            sidebar.classList.add('slide-in');
            
            // Remove slide-in class after animation completes
            setTimeout(() => {
                sidebar.classList.remove('slide-in');
            }, 300);
        } else {
            // Closing sidebar - slide out to left
            sidebar.classList.add('slide-out');
            
            // Add collapsed class after slide animation starts
            setTimeout(() => {
                sidebar.classList.add('collapsed');
                sidebar.classList.remove('slide-out');
            }, 150);
        }
        
        const isCollapsed = !isCurrentlyCollapsed;
        console.log('Sidebar collapsed:', isCollapsed);
        
        // Update button state
        if (sidebarToggle) {
            sidebarToggle.setAttribute('aria-expanded', !isCollapsed);
            sidebarToggle.title = isCollapsed ? 'Expand Sidebar' : 'Collapse Sidebar';
        }
        
        // Save state to localStorage
        localStorage.setItem(CONFIG.storageKeys.sidebar, isCollapsed);
    }

    // Make toggleSidebar globally available
    window.toggleSidebar = toggleSidebar;
    
    // Also add a direct onclick handler as backup
    document.addEventListener('DOMContentLoaded', function() {
        const button = document.getElementById('sidebar-toggle-btn');
        if (button) {
            button.onclick = function(e) {
                e.preventDefault();
                e.stopPropagation();
                console.log('Direct onclick handler triggered!');
                toggleSidebar();
            };
        }
    });

    // Mobile Menu Toggle
    window.toggleMobileMenu = function() {
        const body = document.body;
        const isOpen = mobileMenuOverlay.style.display === 'block';
        
        if (isOpen) {
            mobileMenuOverlay.style.display = 'none';
            mobileMenuOverlay.style.opacity = '0';
            mobileMenuOverlay.querySelector('div').style.transform = 'translateX(100%)';
            body.style.overflow = '';
            body.classList.remove('mobile-menu-open');
        } else {
            mobileMenuOverlay.style.display = 'block';
            mobileMenuOverlay.style.opacity = '1';
            mobileMenuOverlay.querySelector('div').style.transform = 'translateX(0)';
            body.style.overflow = 'hidden';
            body.classList.add('mobile-menu-open');
        }
    };

    // Site Selector
    function initSiteSelector() {
        if (!siteSelect) return;
        
        const savedSite = localStorage.getItem(CONFIG.storageKeys.site);
        if (savedSite) {
            siteSelect.value = savedSite;
        }
        
        // Add hover effects for site selector
        siteSelect.addEventListener('mouseenter', function() {
            this.style.borderColor = 'rgba(255, 255, 255, 0.4)';
            this.style.background = 'rgba(255, 255, 255, 0.2)';
            this.style.boxShadow = '0 0 0 3px rgba(255, 255, 255, 0.1)';
        });
        
        siteSelect.addEventListener('mouseleave', function() {
            this.style.borderColor = 'rgba(255, 255, 255, 0.1)';
            this.style.background = 'transparent';
            this.style.boxShadow = 'none';
        });
        
        siteSelect.addEventListener('focus', function() {
            this.style.borderColor = 'rgba(255, 255, 255, 0.4)';
            this.style.background = 'rgba(255, 255, 255, 0.2)';
            this.style.boxShadow = '0 0 0 3px rgba(255, 255, 255, 0.1)';
        });
        
        siteSelect.addEventListener('blur', function() {
            this.style.borderColor = 'rgba(255, 255, 255, 0.1)';
            this.style.background = 'transparent';
            this.style.boxShadow = 'none';
        });
        
        siteSelect.addEventListener('change', function() {
            localStorage.setItem(CONFIG.storageKeys.site, this.value);
            showNotification(`Site changed to: ${this.options[this.selectedIndex].text}`, 'info');
        });
    }

    // Initialize Sidebar State
    function initSidebarState() {
        const sidebarCollapsed = localStorage.getItem(CONFIG.storageKeys.sidebar) === 'true';
        
        if (sidebar) {
            // Ensure sidebar is visible on desktop
            if (window.innerWidth > CONFIG.mobileBreakpoint) {
                sidebar.style.display = 'block';
                sidebar.style.visibility = 'visible';
                sidebar.style.opacity = '1';
            }
            
            // Remove any existing animation classes
            sidebar.classList.remove('slide-in', 'slide-out');
            
            if (sidebarCollapsed) {
                sidebar.classList.add('collapsed');
            } else {
                sidebar.classList.remove('collapsed');
            }
        }
        
        if (sidebarToggle) {
            const isCollapsed = sidebar ? sidebar.classList.contains('collapsed') : false;
            sidebarToggle.setAttribute('aria-expanded', !isCollapsed);
            sidebarToggle.title = isCollapsed ? 'Expand Sidebar' : 'Collapse Sidebar';
        }
    }

    // Action Button Handlers
    function initActionButtons() {
        actionButtons.forEach(button => {
            // Add hover effects
            button.addEventListener('mouseenter', function() {
                const title = this.getAttribute('title');
                let hoverColor = 'rgba(255, 255, 255, 0.2)';
                let borderColor = 'rgba(255, 255, 255, 0.4)';
                
                if (title === 'Profile') {
                    hoverColor = 'rgba(59, 130, 246, 0.3)';
                    borderColor = 'rgba(59, 130, 246, 0.5)';
                } else if (title === 'Settings') {
                    hoverColor = 'rgba(107, 114, 128, 0.3)';
                    borderColor = 'rgba(107, 114, 128, 0.5)';
                } else if (title === 'Sign In') {
                    hoverColor = 'rgba(34, 197, 94, 0.3)';
                    borderColor = 'rgba(34, 197, 94, 0.5)';
                } else if (title === 'Logout') {
                    hoverColor = 'rgba(239, 68, 68, 0.3)';
                    borderColor = 'rgba(239, 68, 68, 0.5)';
                }
                
                this.style.background = hoverColor;
                this.style.borderColor = borderColor;
                this.style.transform = 'translateY(-1px)';
            });
            
            button.addEventListener('mouseleave', function() {
                this.style.background = 'transparent';
                this.style.borderColor = 'rgba(255, 255, 255, 0.1)';
                this.style.transform = 'translateY(0)';
            });
            
            button.addEventListener('click', function(e) {
                const title = this.getAttribute('title');
                
                if (title === 'Sign In') {
                    showNotification('Redirecting to sign in...', 'info');
                    return;
                }
                
                e.preventDefault();
                
                const actions = {
                    'Profile': () => window.location.href = '{{ route("profile") }}',
                    'Settings': () => showNotification('Opening application settings...', 'info'),
                    'Logout': () => {
                        if (confirm('Are you sure you want to logout?')) {
                            window.location.href = '/admin/logout';
                        }
                    }
                };
                
                if (actions[title]) {
                    actions[title]();
                }
            });
        });
    }

    // Enhanced Notification System
    window.showNotification = function(message, type = 'info', duration = 3000) {
        const notificationId = 'notification-' + Date.now();
        const notification = document.createElement('div');
        notification.id = notificationId;
        notification.className = `custom-notification notification-${type}`;
        
        const typeConfig = {
            success: { 
                bg: '#10b981', 
                icon: '✓', 
                border: '#059669',
                title: 'Success'
            },
            error: { 
                bg: '#ef4444', 
                icon: '✕', 
                border: '#dc2626',
                title: 'Error'
            },
            warning: { 
                bg: '#f59e0b', 
                icon: '⚠', 
                border: '#d97706',
                title: 'Warning'
            },
            info: { 
                bg: '#3b82f6', 
                icon: 'ℹ', 
                border: '#1d4ed8',
                title: 'Information'
            }
        };
        
        const config = typeConfig[type] || typeConfig.info;
        
        notification.innerHTML = `
            <div style="
                display: flex;
                align-items: center;
                gap: 12px;
                padding: 16px 20px;
                background: white;
                border-left: 4px solid ${config.bg};
                border-radius: 8px;
                box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
                min-width: 300px;
                max-width: 400px;
            ">
                <div style="
                    width: 40px;
                    height: 40px;
                    background: ${config.bg};
                    border-radius: 50%;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    color: white;
                    font-size: 18px;
                    font-weight: bold;
                    flex-shrink: 0;
                ">${config.icon}</div>
                <div style="flex: 1;">
                    <div style="
                        font-weight: 600;
                        color: #1f2937;
                        font-size: 14px;
                        margin-bottom: 4px;
                    ">${config.title}</div>
                    <div style="
                        color: #6b7280;
                        font-size: 13px;
                        line-height: 1.4;
                    ">${message}</div>
                </div>
                <button onclick="closeNotification('${notificationId}')" style="
                    background: none;
                    border: none;
                    color: #9ca3af;
                    cursor: pointer;
                    padding: 4px;
                    border-radius: 4px;
                    transition: all 0.2s ease;
                    font-size: 18px;
                    line-height: 1;
                " title="Close">×</button>
            </div>
        `;
        
        notification.style.cssText = `
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 10001;
            opacity: 0;
            transform: translateX(100%) scale(0.9);
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        `;
        
        document.body.appendChild(notification);
        
        // Animate in
        setTimeout(() => {
            notification.style.opacity = '1';
            notification.style.transform = 'translateX(0) scale(1)';
        }, 10);
        
        // Auto close
        if (duration > 0) {
            setTimeout(() => {
                closeNotification(notificationId);
            }, duration);
        }
        
        // Add hover effects
        const closeBtn = notification.querySelector('button');
        closeBtn.addEventListener('mouseenter', function() {
            this.style.background = '#f3f4f6';
            this.style.color = '#374151';
        });
        closeBtn.addEventListener('mouseleave', function() {
            this.style.background = 'none';
            this.style.color = '#9ca3af';
        });
    };
    
    // Close notification function
    window.closeNotification = function(notificationId) {
        const notification = document.getElementById(notificationId);
        if (notification) {
            notification.style.opacity = '0';
            notification.style.transform = 'translateX(100%) scale(0.9)';
            setTimeout(() => {
                if (notification.parentNode) {
                    document.body.removeChild(notification);
                }
            }, 300);
        }
    };

    // Event Handlers
    function initEventHandlers() {
        console.log('Initializing event handlers...');
        console.log('Sidebar toggle button found:', sidebarToggle);
        
        // Sidebar toggle button click handler
        if (sidebarToggle) {
            console.log('Adding click event listener to sidebar toggle button');
            
            // Add hover effects for sidebar toggle
            sidebarToggle.addEventListener('mouseenter', function() {
                this.style.background = 'rgba(255, 255, 255, 0.2)';
                this.style.borderColor = 'rgba(255, 255, 255, 0.4)';
                this.style.transform = 'translateY(-1px)';
            });
            
            sidebarToggle.addEventListener('mouseleave', function() {
                this.style.background = 'transparent';
                this.style.borderColor = 'rgba(255, 255, 255, 0.1)';
                this.style.transform = 'translateY(0)';
            });
            
            sidebarToggle.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                console.log('Hamburger button clicked!');
                toggleSidebar();
            });
        } else {
            console.error('Sidebar toggle button not found!');
        }
        
        // Fallback: Try to find the button by class name as well
        const sidebarToggleByClass = document.querySelector('.sidebar-toggle');
        if (sidebarToggleByClass && !sidebarToggle) {
            console.log('Found sidebar toggle by class name, adding event listener');
            sidebarToggleByClass.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                console.log('Hamburger button clicked (fallback)!');
                toggleSidebar();
            });
        }
        
        // Additional fallback: Use event delegation
        document.addEventListener('click', function(e) {
            if (e.target.closest('.sidebar-toggle')) {
                e.preventDefault();
                e.stopPropagation();
                console.log('Hamburger button clicked (event delegation)!');
                toggleSidebar();
            }
        });

        // Keyboard shortcuts
        document.addEventListener('keydown', function(e) {
            if ((e.ctrlKey || e.metaKey) && e.key === 'b' && window.innerWidth > CONFIG.mobileBreakpoint) {
                e.preventDefault();
                toggleSidebar();
            }
            
            if (e.key === 'Escape') {
                const openDropdowns = document.querySelectorAll('.dropdown-menu.show');
                openDropdowns.forEach(dropdown => dropdown.classList.remove('show'));
                
                if (mobileMenuOverlay && mobileMenuOverlay.classList.contains('show')) {
                    toggleMobileMenu();
                }
            }
        });

        // Window resize handler
        window.addEventListener('resize', function() {
            const navbar = document.querySelector('.modern-navbar');
            const width = window.innerWidth;
            
            if (width <= CONFIG.mobileBreakpoint) {
                navbar.classList.add('mobile-layout');
                if (sidebarToggle) sidebarToggle.style.display = 'none';
                if (sidebar) {
                    sidebar.style.display = 'none';
                    sidebar.style.visibility = 'hidden';
                    sidebar.style.opacity = '0';
                    sidebar.style.transform = 'translateX(-100%)';
                }
            } else {
                navbar.classList.remove('mobile-layout');
                if (sidebarToggle) sidebarToggle.style.display = 'flex';
                if (sidebar) {
                    sidebar.style.display = 'block';
                    sidebar.style.visibility = 'visible';
                    sidebar.style.opacity = '1';
                    
                    // Remove animation classes and restore proper state
                    sidebar.classList.remove('slide-in', 'slide-out');
                    
                    const sidebarCollapsed = localStorage.getItem(CONFIG.storageKeys.sidebar) === 'true';
                    sidebar.classList.toggle('collapsed', sidebarCollapsed);
                    
                    // Update toggle button state
                    if (sidebarToggle) {
                        sidebarToggle.setAttribute('aria-expanded', !sidebarCollapsed);
                        sidebarToggle.title = sidebarCollapsed ? 'Expand Sidebar' : 'Collapse Sidebar';
                    }
                }
            }
        });

        // Mobile menu handlers
        if (mobileMenuOverlay) {
            mobileMenuOverlay.addEventListener('click', function(e) {
                if (e.target === mobileMenuOverlay) {
                    toggleMobileMenu();
                }
            });
        }

        mobileMenuLinks.forEach(link => {
            // Add hover effects for mobile menu links
            link.addEventListener('mouseenter', function() {
                this.style.background = '#f8fafc';
                this.style.color = '#0055a5';
                this.querySelector('svg').style.color = '#0055a5';
            });
            
            link.addEventListener('mouseleave', function() {
                this.style.background = 'transparent';
                this.style.color = '#374151';
                this.querySelector('svg').style.color = '#64748b';
            });
            
            link.addEventListener('click', toggleMobileMenu);
        });
    }

    // Initialize everything
    function init() {
        console.log('Initializing navbar...');
        console.log('Sidebar element:', sidebar);
        console.log('Sidebar toggle button:', sidebarToggle);
        
        initSiteSelector();
        initSidebarState();
        initActionButtons();
        initGlobalCountryFilter();
        initEventHandlers();
        
        console.log('Navbar initialization complete!');
    }

    // Custom Alert System - Embedded Version
    window.showCustomAlert = function(message, type = 'info', options = {}) {
        const alertId = 'custom-alert-' + Date.now();
        const alertOverlay = document.createElement('div');
        alertOverlay.id = alertId;
        alertOverlay.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.6);
            z-index: 10000;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: all 0.3s ease;
            backdrop-filter: blur(4px);
        `;

        const alertBox = document.createElement('div');
        alertBox.style.cssText = `
            background: white;
            border-radius: 12px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
            max-width: 400px;
            width: 90%;
            transform: scale(0.8) translateY(20px);
            transition: all 0.3s ease;
            overflow: hidden;
        `;

        const typeColors = {
            success: { bg: '#10b981', icon: '✓', title: 'Success' },
            error: { bg: '#ef4444', icon: '✕', title: 'Error' },
            warning: { bg: '#f59e0b', icon: '⚠', title: 'Warning' },
            info: { bg: '#3b82f6', icon: 'ℹ', title: 'Information' },
            confirm: { bg: '#8b5cf6', icon: '?', title: 'Confirm' }
        };

        const colors = typeColors[type] || typeColors.info;

        alertBox.innerHTML = `
            <div style="background: ${colors.bg}; color: white; padding: 20px; text-align: center;">
                <div style="font-size: 32px; margin-bottom: 8px;">${colors.icon}</div>
                <div style="font-size: 18px; font-weight: 600;">${colors.title}</div>
            </div>
            <div style="padding: 24px; text-align: center;">
                <div style="font-size: 16px; color: #374151; line-height: 1.5; margin-bottom: 24px;">${message}</div>
                <div style="display: flex; gap: 12px; justify-content: center;">
                    ${type === 'confirm' ? 
                        `<button id="${alertId}-cancel" style="
                            background: #f3f4f6;
                            color: #374151;
                            border: none;
                            padding: 12px 24px;
                            border-radius: 8px;
                            font-weight: 500;
                            cursor: pointer;
                            transition: all 0.2s ease;
                            min-width: 80px;
                        ">Cancel</button>
                        <button id="${alertId}-confirm" style="
                            background: ${colors.bg};
                            color: white;
                            border: none;
                            padding: 12px 24px;
                            border-radius: 8px;
                            font-weight: 500;
                            cursor: pointer;
                            transition: all 0.2s ease;
                            min-width: 80px;
                        ">OK</button>` :
                        `<button id="${alertId}-ok" style="
                            background: ${colors.bg};
                            color: white;
                            border: none;
                            padding: 12px 24px;
                            border-radius: 8px;
                            font-weight: 500;
                            cursor: pointer;
                            transition: all 0.2s ease;
                            min-width: 80px;
                        ">OK</button>`
                    }
                </div>
            </div>
        `;

        alertOverlay.appendChild(alertBox);
        document.body.appendChild(alertOverlay);

        // Animate in
        setTimeout(() => {
            alertOverlay.style.opacity = '1';
            alertBox.style.transform = 'scale(1) translateY(0)';
        }, 10);

        // Add hover effects
        const buttons = alertBox.querySelectorAll('button');
        buttons.forEach(button => {
            button.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-2px)';
                this.style.boxShadow = '0 4px 12px rgba(0, 0, 0, 0.2)';
            });
            button.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
                this.style.boxShadow = 'none';
            });
        });

        return new Promise((resolve) => {
            if (type === 'confirm') {
                const cancelBtn = document.getElementById(`${alertId}-cancel`);
                const confirmBtn = document.getElementById(`${alertId}-confirm`);
                
                cancelBtn.addEventListener('click', () => {
                    closeAlert(false);
                });
                
                confirmBtn.addEventListener('click', () => {
                    closeAlert(true);
                });
            } else {
                const okBtn = document.getElementById(`${alertId}-ok`);
                okBtn.addEventListener('click', () => {
                    closeAlert(true);
                });
            }

            // Close on overlay click
            alertOverlay.addEventListener('click', (e) => {
                if (e.target === alertOverlay) {
                    closeAlert(type === 'confirm' ? false : true);
                }
            });

            function closeAlert(result) {
                alertOverlay.style.opacity = '0';
                alertBox.style.transform = 'scale(0.8) translateY(20px)';
                setTimeout(() => {
                    if (alertOverlay.parentNode) {
                        document.body.removeChild(alertOverlay);
                    }
                    resolve(result);
                }, 300);
            }
        });
    };

    // Simple logout confirmation function
    window.confirmLogout = function(event) {
        console.log('Logout button clicked!');
        
        // Show confirmation dialog
        const confirmed = confirm('Are you sure you want to logout?');
        
        if (confirmed) {
            console.log('User confirmed logout');
            // Let the link proceed naturally
            return true;
        } else {
            console.log('User cancelled logout');
            // Prevent the link from proceeding
            event.preventDefault();
            return false;
        }
    };

    // Handle logout with custom alert (backup function)
    window.handleLogout = async function(event) {
        event.preventDefault();
        console.log('Logout button clicked!');
        
        try {
            // Check if custom alert function exists
            if (typeof window.showCustomAlert === 'function') {
                console.log('Using custom alert...');
                const confirmed = await window.showCustomAlert('Are you sure you want to logout?', 'confirm');
                if (confirmed) {
                    // Show loading notification
                    if (typeof window.showNotification === 'function') {
                        window.showNotification('Logging out...', 'info', 2000);
                    }
                    
                    // Redirect to logout route
                    setTimeout(() => {
                        window.location.href = '/admin/logout';
                    }, 1000);
                }
            } else {
                console.log('Custom alert not available, using fallback...');
                // Fallback to native confirm if custom alert is not available
                if (confirm('Are you sure you want to logout?')) {
                    window.location.href = '/admin/logout';
                }
            }
        } catch (error) {
            console.error('Logout error:', error);
            // Fallback to native confirm on error
            if (confirm('Are you sure you want to logout?')) {
                window.location.href = '/admin/logout';
            }
        }
    };

    // Test function for custom alerts
    window.testCustomAlert = function() {
        console.log('Test button clicked!');
        if (typeof window.showCustomAlert === 'function') {
            console.log('Custom alert function exists!');
            window.showCustomAlert('This is a test of the custom alert system!', 'info');
        } else {
            console.log('Custom alert function NOT found!');
            alert('Custom alert function not found!');
        }
    };

    // Replace default confirm with custom alert
    window.confirmLogout = function() {
        return window.showCustomAlert('Are you sure you want to logout?', 'confirm');
    }

    // Global alert functions for easy use
    window.showSuccess = function(message) {
        return window.showCustomAlert(message, 'success');
    };

    window.showError = function(message) {
        return window.showCustomAlert(message, 'error');
    };

    window.showWarning = function(message) {
        return window.showCustomAlert(message, 'warning');
    };

    window.showInfo = function(message) {
        return window.showCustomAlert(message, 'info');
    };

    window.showConfirm = function(message) {
        return window.showCustomAlert(message, 'confirm');
    };

    // Replace default browser alerts globally
    window.alert = function(message) {
        return window.showCustomAlert(message, 'info');
    };

    window.confirm = function(message) {
        return window.showCustomAlert(message, 'confirm');
    };

    // Override native confirm for all elements
    document.addEventListener('DOMContentLoaded', function() {
        // Override all onclick handlers that use confirm
        const elements = document.querySelectorAll('[onclick*="confirm("]');
        elements.forEach(element => {
            const originalOnclick = element.getAttribute('onclick');
            if (originalOnclick && originalOnclick.includes('confirm(')) {
                element.removeAttribute('onclick');
                element.addEventListener('click', function(e) {
                    e.preventDefault();
                    // Extract the confirm message from the original onclick
                    const match = originalOnclick.match(/confirm\(['"`]([^'"`]+)['"`]\)/);
                    if (match) {
                        const message = match[1];
                        window.showCustomAlert(message, 'confirm').then(result => {
                            if (result) {
                                // Execute the rest of the original onclick if user confirms
                                const remainingCode = originalOnclick.replace(/return\s+confirm\([^)]+\)[;]?/, '').trim();
                                if (remainingCode) {
                                    eval(remainingCode);
                                }
                            }
                        });
                    }
                });
            }
        });
    });

    window.addEventListener('storage', function(event) {
        if (event.key === countryFilterConfig.storageKey) {
            syncCountryFilterFromStorage();
        }
    });

    // Start when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
</script>

