@extends('welcome')

@section('title', 'Dashboard')

@section('styles')
<style>
    /* Import Google Fonts for better typography */
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
</style>
@endsection

@section('content')
<div style="background: #ffffff; padding: 0; border-radius: 0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); border: 1px solid #e2e8f0; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 32px; padding: 32px 32px 20px 32px; border-bottom: 1px solid #e2e8f0;" id="dashboardP-topbar">
        <div>
            <h1 style="color: #1e293b; font-weight: 700; font-size: 32px; line-height: 1.2; letter-spacing: -0.025em; margin: 0;">Dashboard</h1>
            <span style="color: #64748b; font-weight: 400; font-size: 16px; line-height: 1.5; margin-top: 4px; display: block;">Explore your needs here</span>
        </div>
        <div style="display: flex; gap: 12px; align-items: center;">
            <button style="background: #0055a5; color: #ffffff; padding: 12px 20px; border: none; border-radius: 0; font-size: 14px; font-weight: 500; display: inline-flex; align-items: center; gap: 8px; transition: all 0.2s ease; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); text-decoration: none; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; cursor: pointer;" data-bs-toggle="modal" data-bs-target="#dashboard" id="dashboardSetting">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 100 100" style="width: 20px; height: 20px; flex-shrink: 0;">
                    <path fill="currentColor" d="M1.965 12.5C.88 12.5 0 13.443 0 14.605v70.79c0 1.162.88 2.104 1.965 2.105h96.07c1.085 0 1.965-.943 1.965-2.105v-70.79c0-1.162-.88-2.104-1.965-2.105Zm22.408 4.213h12.385c3.19 1.117 6.48 2.17 9.773 3.135c7.26 2.126 14.43 3.856 20.004 5.056c1.774.382 3.307.687 4.711.957c-.961 1.034-1.904 2.065-2.867 3.094l-1.057 1.129c-6.493-2.033-13.921-4.056-23.474-6.059c-6.74-1.412-13.237-3.964-19.475-7.312m17.08 0h14.453a296 296 0 0 0 11.785 2.814c2.73.588 5.06 1.043 6.784 1.346a59 59 0 0 0 2.091.336c.52.071.951.085.795.09l.006.158a419 419 0 0 0 4.26-4.744h5.332c-4.469 5.16-9.513 10.604-14.564 16.002C62.597 43.184 52.989 53.4 48.97 59.592a10.4 10.4 0 0 1 1.79 5.836c0 1.793-.457 3.484-1.261 4.963c4.097 3.203 7.157 7.856 9.928 12.896h-4.635c-2.384-4.05-4.909-7.543-7.832-9.808a10.41 10.41 0 0 1-9.732 1.949a89 89 0 0 1-3.231 7.86h-4.43c1.527-3.143 2.92-6.369 4.096-9.782c-2.336-1.923-3.83-4.834-3.83-8.078c0-2.752 1.083-5.258 2.836-7.131c-5.91-13.21-16.585-20-28.738-27.215v-4.674c12.892 7.605 25.195 14.839 32.052 29.502a10.35 10.35 0 0 1 10.092.809c4.67-6.914 13.935-16.629 23.397-26.739c1.588-1.697 3.155-3.398 4.73-5.1c-.158-.026-.253-.038-.422-.068a192 192 0 0 1-6.931-1.375c-5.543-1.193-12.683-2.916-19.897-5.029a212 212 0 0 1-5.5-1.695m20.65 0H79.6c-.895 1.004-1.77 1.997-2.702 3.021c-.05-.005-.077-.004-.128-.011a59 59 0 0 1-2.036-.328c-1.697-.299-4.013-.75-6.726-1.334a291 291 0 0 1-5.904-1.348m26.846 0h7.12v4.385c-.042-.003-.082-.012-.124-.012h-.013a1.75 1.75 0 0 0 .013 3.5c.042 0 .082-.009.123-.012v3.524c-.04-.003-.08-.012-.123-.012h-.013a1.75 1.75 0 0 0 .013 3.5c.042 0 .082-.009.123-.012v3.524c-.04-.003-.08-.012-.123-.012a1.75 1.75 0 1 0 0 3.5c.042 0 .082-.009.123-.012v1.295c-.791-.251-1.598-.502-2.369-.754a1.75 1.75 0 0 0-1.54-.504c-.641-.213-1.257-.425-1.884-.638a1.75 1.75 0 1 0-3.078-1.055c-1.426-.499-2.822-.998-4.222-1.496a1.75 1.75 0 0 0-.942-.334c-.71-.253-1.433-.507-2.146-.76a1.75 1.75 0 0 0-.43-2.422l-1.596 1.71c-1.047-.37-2.159-.738-3.23-1.106c5-5.346 9.953-10.706 14.318-15.797m5.06 1.84c-1.156.286-2.137.788-3.138 1.545a1.75 1.75 0 1 0 3.139-1.545m-4.421 2.656a46 46 0 0 0-2.268 2.277a1.75 1.75 0 1 0 2.268-2.277m-85.656 1.99c18.115 12.035 33.234 17 51.261 19.965c-3.805 4.23-7.139 8.16-9.572 11.578a11.8 11.8 0 0 0-5.324-1.28c-1.241 0-2.441.194-3.57.552c-7.314-14.554-19.964-21.79-32.795-29.356Zm88.5 1.387a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m-6.28.148l-2.256 2.416a1.75 1.75 0 1 0 2.256-2.416m2.78 3.352a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m-6.121.228l-2.323 2.489a1.75 1.75 0 1 0 2.323-2.489m2.62 3.272a1.75 1.75 0 1 0 .028 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .028 3.5a1.75 1.75 0 0 0-.027-3.5m-88.5 1.248c11.478 6.84 21.321 13.273 26.981 25.223c-1.607 2.038-2.578 4.597-2.578 7.37c0 3.318 1.382 6.333 3.592 8.509c-1.164 3.244-2.53 6.33-4.024 9.351h-4.328l2.75-4.762l-2.922-1.687l1.041-1.805l-4.047-2.336l-6.115 10.59H3.931V48.32l7.684 4.582l4.778-8.012l-12.461-7.432ZM63.58 44.437c2.32.385 4.57.922 6.73 1.57a1.75 1.75 0 1 0 2.84.927c1.369.483 2.69 1 3.97 1.54a1.75 1.75 0 0 0 1.415.61c.649.29 1.276.584 1.897.88a1.75 1.75 0 1 0 3.127 1.56c.693.363 1.29.708 1.935 1.064l-.058-.002a1.75 1.75 0 1 0 1.464.773c3.197 1.81 5.717 3.38 7.327 4.172a1.75 1.75 0 0 0 1.723 2.055c.042 0 .08-.015.122-.018v3.53c-.04-.003-.08-.012-.123-.012h-.013a1.75 1.75 0 0 0 .013 3.5c.042 0 .082-.009.123-.012v3.524c-.04-.003-.08-.012-.123-.012a1.75 1.75 0 1 0 0 3.5c.042 0 .082-.009.123-.012v9.713H61.15c-2.7-5.02-5.69-9.798-9.795-13.324a11.8 11.8 0 0 0-.613-10.328c2.623-3.807 7.38-9.234 12.834-15.198zm4.37 4.649c-.218 0-.434.04-.637.12a11.4 11.4 0 0 0-.092 3.22a1.75 1.75 0 1 0 .729-3.34m7 0a1.75 1.75 0 1 0 0 3.5a1.75 1.75 0 0 0 0-3.5m-56.749 3.307l-3.623 6.275l-2.431 4.21l6.275 3.624l2.432-4.211l2.492 1.44l3.623-6.276l-2.492-1.44zm53.235.193a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m-3.5 3.5a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m-20.713.021c.013.031.021.061.035.092a70 70 0 0 1-.139 3.377a1.75 1.75 0 0 0 .104-3.469m-27.922 2.856a6.434 6.434 0 0 0-6.463 6.465a6.43 6.43 0 0 0 6.463 6.463a6.434 6.434 0 0 0 6.465-6.463a6.435 6.435 0 0 0-6.465-6.465m31.135.623a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m-52.135.877c2.783 0 4.965 2.182 4.965 4.965s-2.182 4.963-4.965 4.963s-4.963-2.18-4.963-4.963s2.18-4.965 4.963-4.965m34.635 2.623a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m-20.694.023c.224.556.658.995 1.444 1.514a1.75 1.75 0 0 0-1.444-1.514m10.194 3.477a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5m7 0a1.75 1.75 0 1 0 .027 3.5a1.75 1.75 0 0 0-.027-3.5M65.81 68.359c-3.228 0-5.877 2.65-5.877 5.877c0 3.228 2.65 5.875 5.877 5.875s5.875-2.647 5.875-5.875c0-3.227-2.648-5.877-5.875-5.877m16.134 1.727a1.75 1.75 0 0 0-1.271 2.953l2.562-.021a1.75 1.75 0 0 0-1.29-2.932m7 0a1.75 1.75 0 0 0-1.324 2.893l2.668-.024a1.75 1.75 0 0 0-1.344-2.87m-23.134 1.273a2.854 2.854 0 0 1 2.875 2.877a2.85 2.85 0 0 1-2.875 2.875a2.854 2.854 0 0 1-2.877-2.875a2.855 2.855 0 0 1 2.877-2.877m-18.913 4.02c2.168 1.932 4.174 4.707 6.118 7.908H35.65c.899-1.979 1.762-3.992 2.541-6.096c.686.124 1.387.2 2.106.2c2.433 0 4.704-.745 6.601-2.012" color="currentColor" />
                </svg>
                Dashboard Setting</button>
            <button style="background: #0055a5; color: #ffffff; padding: 12px 20px; border: none; border-radius: 0; font-size: 14px; font-weight: 500; display: inline-flex; align-items: center; gap: 8px; transition: all 0.2s ease; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); text-decoration: none; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; cursor: pointer;" data-bs-toggle="modal" data-bs-target="#Map">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" style="width: 20px; height: 20px; flex-shrink: 0;">
                    <path fill="currentColor" d="M4 6.143v12.824l5.065-2.17l6 3L20 17.68V4.857l1.303-.558a.5.5 0 0 1 .697.46V19l-7 3l-6-3l-6.303 2.701a.5.5 0 0 1-.697-.46V7zm12.243 5.1L12 15.485l-4.243-4.242a6 6 0 1 1 8.486 0M12 12.657l2.828-2.829a4 4 0 1 0-5.656 0z" />
                </svg>
                View Map</button>
            <a href="{{ route('privacy.policy') }}" target="_blank" style="background: #ffd205; color: #000000; padding: 12px 20px; border: none; border-radius: 0; font-size: 14px; font-weight: 500; display: inline-flex; align-items: center; gap: 8px; transition: all 0.2s ease; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); text-decoration: none; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; cursor: pointer;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" style="width: 20px; height: 20px; flex-shrink: 0;">
                    <path fill="currentColor" d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12c5.16-1.26 9-6.45 9-12V5l-9-4z"/>
                </svg>
                Privacy Policy</a>
            <button style="background: #0055a5; color: #ffffff; padding: 12px 20px; border: none; border-radius: 0; font-size: 14px; font-weight: 500; display: inline-flex; align-items: center; gap: 8px; transition: all 0.2s ease; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); text-decoration: none; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; cursor: pointer;">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" style="width: 20px; height: 20px; flex-shrink: 0;">
                    <g fill="none" stroke="currentColor" stroke-width="1">
                        <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z" />
                        <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7" />
                    </g>
                </svg>
                Export</button>
        </div>
    </div>
    <div style="width: 100%; padding: 0 32px 32px 32px; transition: all 0.3s ease;">
        <h2 style="color: #1e293b; font-weight: 600; font-size: 24px; line-height: 1.2; letter-spacing: -0.025em; margin-bottom: 20px;">Inspection Conducted</h2>
        <div style="display: flex; align-items: center; margin-bottom: 20px; flex-wrap: wrap;">
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #19A979;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Good</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Faulty</p>
        </div>
        <div style="display: flex; align-items: stretch; gap: 20px; flex-wrap: wrap; margin-bottom: 32px;">
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 48 48" style="width: 18px; height: 18px; flex-shrink: 0;">
                        <g fill="none" stroke="currentColor" stroke-width="4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M43 33V19H5v22a2 2 0 0 0 2 2h17" />
                            <path stroke-linejoin="round" d="M5 10a2 2 0 0 1 2-2h34a2 2 0 0 1 2 2v9H5z" />
                            <path stroke-linecap="round" d="M16 5v8m16-8v8" />
                            <circle cx="30" cy="32" r="7" />
                            <path stroke-linecap="round" stroke-linejoin="round" d="m36 37l6 5" />
                        </g>
                    </svg>
                    Total Inspection
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['totalInspections'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 16 16" style="width: 18px; height: 18px; flex-shrink: 0;">
                        <path fill="none" stroke="currentColor" d="M13.5 5v8.5h-11V5m11 0L11 2.5H5L2.5 5m11 0h-11M9 10l1.5 1.5M9.5 9a1.5 1.5 0 1 1-3 0a1.5 1.5 0 0 1 3 0Z" stroke-width="1" />
                    </svg>
                    Good Inspection
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['goodInspections'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 26 26" style="width: 18px; height: 18px; flex-shrink: 0;">
                        <path fill="currentColor" d="M13 0c-.7 0-1.206.294-1.406.594c-.1.1-.181.306-.281.406H10c-1.1 0-2 .9-2 2H6C4.3 3 3 4.3 3 6v17c0 1.7 1.3 3 3 3h14c1.7 0 3-1.3 3-3V6c0-1.7-1.3-3-3-3h-2c0-1.1-.9-2-2-2h-1.313c-.1-.1-.18-.306-.28-.406C14.206.294 13.7 0 13 0m-3 3h6v2h-6zM6 6h2.313c.3.6.987 1 1.687 1h6c.7 0 1.387-.4 1.688-1H20v17H6zm10.563 4.688c-.188 0-.37.068-.47.218l-4.405 4.688L10 14c-.3-.3-.8-.3-1 0l-.688.688c-.3.3-.3.8 0 1l2.782 2.624c.4.4 1.006.275 1.406-.125l5.406-5.78c.2-.2.207-.607-.093-.907l-.72-.594a.75.75 0 0 0-.53-.219z" />
                    </svg>
                    Faulty Inspection
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['faultyInspections'] ?? 0 }}</h1>
            </div>
        </div>
    </div>
    <div style="width: 100%; padding: 0 32px 32px 32px; transition: all 0.3s ease;">
        <h2 style="color: #1e293b; font-weight: 600; font-size: 24px; line-height: 1.2; letter-spacing: -0.025em; margin-bottom: 20px;">Issue Report</h2>
        <div style="display: flex; align-items: center; margin-bottom: 20px; flex-wrap: wrap;">
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #19A979;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Total Issue</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Resolved</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">In Progress</p>
        </div>
        <div style="display: flex; align-items: stretch; gap: 20px; flex-wrap: wrap; margin-bottom: 32px;">
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                            <path d="M8 5H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h5.697M18 12V7a2 2 0 0 0-2-2h-2" />
                            <path d="M8 5a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v0a2 2 0 0 1-2 2h-2a2 2 0 0 1-2-2m0 6h4m-4 4h3m3 2.5a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0-5 0m4.5 2L21 22" />
                        </g>
                    </svg>
                    Total Issue Reported
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['totalIssues'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 16 16">
                        <path fill="currentColor" fill-rule="evenodd" d="M13.657 3.05a.5.5 0 1 0-.707-.707l-.366.366A7 7 0 1 0 8 15a5 5 0 0 1-.597-1.03a6 6 0 1 1 4.471-10.552l-.71.71a5 5 0 1 0-4.08 8.788a5 5 0 0 1-.082-1.042A4.002 4.002 0 0 1 8 4a3.98 3.98 0 0 1 2.453.84l-.715.714a3 3 0 0 0-3.86 4.567a.5.5 0 1 0 .708-.707a2 2 0 0 1 2.43-3.137l-.757.757a1 1 0 1 0 .707.707l1.155-1.155l2.46-2.46a5.97 5.97 0 0 1 1.39 3.277c.367.158.713.36 1.029.597c0-1.636-.57-3.271-1.71-4.584zM16 12a4 4 0 1 1-8 0a4 4 0 0 1 8 0m-1.646-1.354a.5.5 0 0 1 0 .707l-2.5 2.5a.5.5 0 0 1-.708 0l-1-1a.5.5 0 0 1 .708-.707l.646.647l2.146-2.147a.5.5 0 0 1 .708 0" />
                    </svg>
                    Resolved
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['resolvedIssues'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <g fill="currentColor">
                            <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" opacity="0.3" />
                            <path fill-rule="evenodd" d="M1 12c0 6.075 4.925 11 11 11s11-4.925 11-11S18.075 1 12 1v2a9 9 0 1 1-9 9z" clip-rule="evenodd" />
                        </g>
                    </svg>
                    In Progress
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['inProgressIssues'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <path fill="currentColor" d="M15 16.69V13h1.5v2.82l2.44 1.41l-.75 1.3zM19.5 3.5L18 2l-1.5 1.5L15 2l-1.5 1.5L12 2l-1.5 1.5L9 2L7.5 3.5L6 2L4.5 3.5L3 2v20l1.5-1.5L6 22l1.5-1.5L9 22l1.58-1.58c.14.19.3.36.47.53A7.001 7.001 0 0 0 21 11.1V2zM11.1 11c-.6.57-1.07 1.25-1.43 2H6v-2zm-2.03 4c-.07.33-.07.66-.07 1s0 .67.07 1H6v-2zM18 9H6V7h12zm2.85 7c0 .64-.12 1.27-.35 1.86c-.26.58-.62 1.14-1.07 1.57c-.43.45-.99.81-1.57 1.07c-.59.23-1.22.35-1.86.35c-2.68 0-4.85-2.17-4.85-4.85c0-1.29.51-2.5 1.42-3.43c.93-.91 2.14-1.42 3.43-1.42c2.67 0 4.85 2.17 4.85 4.85" />
                    </svg>
                    Pending
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['pendingIssues'] ?? 0 }}</h1>
            </div>
        </div>
    </div>
    <div style="width: 100%; padding: 0 32px 32px 32px; transition: all 0.3s ease;">
        <h2 style="color: #1e293b; font-weight: 600; font-size: 24px; line-height: 1.2; letter-spacing: -0.025em; margin-bottom: 20px;">Fault Summary</h2>

        <div style="display: flex; align-items: center; margin-bottom: 20px; flex-wrap: wrap;">
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #19A979;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Faulty Vehicles</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Repair Items</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Replace Items</p>
        </div>

        <div style="display: flex; align-items: stretch; justify-content: center; gap: 20px;">

            <div style="flex: 0.6; display: flex; align-items: stretch; justify-content: center; gap: 20px; flex-wrap: wrap;">
                <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 160px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab;">
                    <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                            <path fill="currentColor" d="M6 9a.749.749 0 1 1-1.498 0A.749.749 0 0 1 6 9m4.749.749a.749.749 0 1 0 0-1.498a.749.749 0 0 0 0 1.498M3.034 6.074L3.044 6H2.5a.5.5 0 0 1 0-1h.673l.162-1.256A2 2 0 0 1 5.32 2h5.36a2 2 0 0 1 1.984 1.747L12.823 5h.677a.5.5 0 0 1 0 1h-.549l.01.072A1.5 1.5 0 0 1 14 7.5v3a1.5 1.5 0 0 1-1.5 1.5h-.003v1.25a.75.75 0 1 1-1.5 0V12H5v1.25a.75.75 0 0 1-1.5 0V12A1.5 1.5 0 0 1 2 10.5v-3a1.5 1.5 0 0 1 1.034-1.426m1.293-2.202L4.052 6h7.891l-.272-2.127A1 1 0 0 0 10.68 3H5.32a1 1 0 0 0-.992.872M12.5 11a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5z" />
                        </svg>
                        Faulty Vehicles
                    </p>
                    <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['faultyVehicles'] ?? 0 }}</h1>
                </div>
                <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 160px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab;">
                    <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M11 11L6 6M5 7.5L7.5 5l-3-1.5l-1 1zm14.975 1.475a3.5 3.5 0 0 0 .79-3.74l-1.422 1.422h-2v-2l1.422-1.422a3.5 3.5 0 0 0-4.529 4.53l-6.47 6.471a3.5 3.5 0 0 0-4.53 4.529l1.421-1.422h2v2l-1.422 1.422a3.5 3.5 0 0 0 4.53-4.528l6.472-6.472a3.5 3.5 0 0 0 3.738-.79" />
                                <path d="m11.797 14.5l5.604 5.604a1.35 1.35 0 0 0 1.911 0l.792-.792a1.35 1.35 0 0 0 0-1.911L14.5 11.797" />
                            </g>
                        </svg>
                        Repair Items
                    </p>
                    <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['repairItems'] ?? 0 }}</h1>
                </div>
                <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 160px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab;">
                    <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                            <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                <path d="M14 4a2 2 0 0 1 2-2m0 8a2 2 0 0 1-2-2m6-6a2 2 0 0 1 2 2m0 4a2 2 0 0 1-2 2M3 7l3 3l3-3" />
                                <path d="M6 10V5a3 3 0 0 1 3-3h1" />
                                <rect width="8" height="8" x="2" y="14" rx="2" />
                            </g>
                        </svg>
                        Replace Items
                    </p>
                    <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['replaceItems'] ?? 0 }}</h1>
                </div>
            </div>

            <div style="width: 500px; height: 407px; border: 1px solid #e2e8f0; overflow: hidden; flex: 0.6; padding: 20px; background: #f7f7f7; border-radius: 0; display: flex; flex-direction: column; justify-content: space-between; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <canvas id="myChart"></canvas>
            </div>
        </div>
    </div>
    <div style="width: 100%; padding: 0 32px 32px 32px; transition: all 0.3s ease;">
        <h2 style="color: #1e293b; font-weight: 600; font-size: 24px; line-height: 1.2; letter-spacing: -0.025em; margin-bottom: 20px;">Workorder Summary</h2>

        <div style="display: flex; align-items: center; margin-bottom: 20px; flex-wrap: wrap;">
            <h4>Status</h4>
            &nbsp;
            &nbsp;
            &nbsp;

            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #19A979;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Initiated</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">In Progress</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #F5D904;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">On Hold</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #5899DA;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Rework</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #E8743B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Postponed</p>
        </div>

        <div style="display: flex; align-items: center; margin-bottom: 20px; flex-wrap: wrap;">
            <h4>Priority</h4>
            &nbsp;
            &nbsp;
            &nbsp;

            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #19A979;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Low</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Medium</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #F5D904;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">High</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #5899DA;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Emergency</p>
        </div>





        <div style="display: flex; align-items: stretch; gap: 20px; flex-wrap: wrap; margin-bottom: 32px;">
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 512 512">
                        <path fill="currentColor" fill-rule="evenodd" d="M256 42.667c117.627 0 213.334 95.707 213.334 213.333S373.627 469.334 256 469.334c-117.626 0-213.333-95.707-213.333-213.334c0-117.626 95.707-213.333 213.333-213.333m0 42.667C161.56 85.334 85.334 161.56 85.334 256S161.56 426.667 256 426.667S426.667 350.441 426.667 256c0-94.44-76.226-170.666-170.667-170.666m.914 72.781c16.137 20.983 21.581 46.796 16.41 65.641q-.967 4.652 68.232 72.545q22.627 22.627 0 45.255q-21.296 21.295-42.593 2.505l-74.87-71.074c-18.846 5.171-44.658-.273-65.64-16.41c-15.39-20.235-20.697-46.685-16.41-65.641l32.82 32.82l32.82-16.41l16.41-32.82l-32.82-32.821c18.957-4.287 45.407 1.02 65.641 16.41" />
                    </svg>
                    Total Work Order
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['totalWorkOrders'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 2048 2048">
                        <path fill="currentColor" d="m1491 595l90 90l-749 749l-365-365l90-90l275 275zM1024 0q141 0 272 36t245 103t207 160t160 208t103 245t37 272q0 141-36 272t-103 245t-160 207t-208 160t-245 103t-272 37q-141 0-272-36t-245-103t-207-160t-160-208t-103-244t-37-273q0-141 36-272t103-245t160-207t208-160T751 37t273-37m0 1920q123 0 237-32t214-90t182-141t140-181t91-214t32-238q0-123-32-237t-90-214t-141-182t-181-140t-214-91t-238-32q-123 0-237 32t-214 90t-182 141t-140 181t-91 214t-32 238q0 123 32 237t90 214t141 182t181 140t214 91t238 32" />
                    </svg>
                    Completed
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['completedWorkOrders'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                            <path d="M4 21.4V2.6a.6.6 0 0 1 .6-.6h11.652a.6.6 0 0 1 .424.176l3.148 3.148A.6.6 0 0 1 20 5.75V21.4a.6.6 0 0 1-.6.6H4.6a.6.6 0 0 1-.6-.6" />
                            <path d="m10.635 10.415l1.039-2.203a.357.357 0 0 1 .652 0l1.04 2.203l2.323.356c.298.045.416.429.2.649l-1.68 1.713l.396 2.421c.051.311-.26.548-.527.401L12 14.812l-2.078 1.143c-.267.147-.578-.09-.527-.4l.396-2.422l-1.68-1.713c-.217-.22-.098-.604.2-.65zM16 2v3.4a.6.6 0 0 0 .6.6H20" />
                        </g>
                    </svg>
                    Initiated
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['initiatedWorkOrders'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <g fill="currentColor">
                            <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" opacity="0.3" />
                            <path fill-rule="evenodd" d="M1 12c0 6.075 4.925 11 11 11s11-4.925 11-11S18.075 1 12 1v2a9 9 0 1 1-9 9z" clip-rule="evenodd" />
                        </g>
                    </svg>
                    In Progress
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['inProgressWorkOrders'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.38 2.466C4.216.49 18.012 5.329 18 7.096c-.013 2.003-5.388 2.62-6.878 3.037c-.896.251-1.135.51-1.342 1.449c-.936 4.254-1.405 6.37-2.476 6.418C5.598 18.075.591 4.393 2.381 2.466M17.5 17.95l.9-1.35m3.6.9a4.5 4.5 0 1 1-9 0a4.5 4.5 0 0 1 9 0" />
                    </svg>
                    On Hold
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['onHoldWorkOrders'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <path fill="currentColor" d="m7 22l-4-4l4-4l1.4 1.45L6.85 17H17v-4h2v6H6.85l1.55 1.55zM5 11V5h12.15L15.6 3.45L17 2l4 4l-4 4l-1.4-1.45L17.15 7H7v4z" />
                    </svg>
                    Rework
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['reworkWorkOrders'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <path fill="currentColor" d="M13.5 8H12v5l4.28 2.54l.72-1.21l-3.5-2.08zM13 3a9 9 0 0 0-9 9H1l3.96 4.03L9 12H6a7 7 0 0 1 7-7a7 7 0 0 1 7 7a7 7 0 0 1-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42A8.9 8.9 0 0 0 13 21a9 9 0 0 0 9-9a9 9 0 0 0-9-9" />
                    </svg>
                    Postponed
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['postponedWorkOrders'] ?? 0 }}</h1>
            </div>
        </div>
    </div>
    <div style="width: 100%; padding: 0 32px 32px 32px; transition: all 0.3s ease;">
        <h2 style="color: #1e293b; font-weight: 600; font-size: 24px; line-height: 1.2; letter-spacing: -0.025em; margin-bottom: 20px;">Schedule</h2>
        <div style="display: flex; align-items: stretch; gap: 20px; flex-wrap: wrap; margin-bottom: 32px;">
            <div style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); border-color: #f59e0b; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #f59e0b; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                            <path d="M20.5 13.5a8.5 8.5 0 1 1-17 0a8.5 8.5 0 0 1 17 0" />
                            <path d="M12 19a5.5 5.5 0 1 1 0-11m1.5-4.5a1.5 1.5 0 1 0-3 0a1.5 1.5 0 0 0 3 0m-1.5 10L15 9" />
                        </g>
                    </svg>
                    Due Soon
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['dueSoonSchedules'] ?? 0 }}</h1>
            </div>
            <div style="background: linear-gradient(135deg, #fecaca 0%, #fca5a5 100%); border-color: #ef4444; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #ef4444; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 36 36">
                        <path fill="currentColor" d="M18 2a16 16 0 1 0 16 16A16 16 0 0 0 18 2m0 30a14 14 0 1 1 14-14a14 14 0 0 1-14 14" class="clr-i-outline clr-i-outline-path-1" />
                        <path fill="currentColor" d="M18.92 18.4v-7.65a1 1 0 0 0-2 0v8.72l5.9 4a1 1 0 1 0 1.11-1.66Z" class="clr-i-outline clr-i-outline-path-2" />
                        <path fill="currentColor" d="M8 17.94a9.94 9.94 0 0 1 15.41-8.35l.85-1.36a11.55 11.55 0 1 0-8.53 21L16 27.7a10 10 0 0 1-8-9.76" class="clr-i-outline clr-i-outline-path-3" />
                        <path fill="none" d="M0 0h36v36H0z" />
                    </svg>
                    Overdue
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['overdueSchedules'] ?? 0 }}</h1>
            </div>
            <div style="background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%); border-color: #10b981; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #10b981; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <path fill="currentColor" d="M13.5 8H12v5l4.28 2.54l.72-1.21l-3.5-2.08zM13 3a9 9 0 0 0-9 9H1l3.96 4.03L9 12H6a7 7 0 0 1 7-7a7 7 0 0 1 7 7a7 7 0 0 1-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42A8.9 8.9 0 0 0 13 21a9 9 0 0 0 9-9a9 9 0 0 0-9-9" />
                    </svg>
                    Total Schedule
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['totalSchedules'] ?? 0 }}</h1>
            </div>
        </div>
    </div>
    <div style="width: 100%; padding: 0 32px 32px 32px; transition: all 0.3s ease;">
        <h2 style="color: #1e293b; font-weight: 600; font-size: 24px; line-height: 1.2; letter-spacing: -0.025em; margin-bottom: 20px;">Request Summary</h2>

        <div style="display: flex; align-items: center; margin-bottom: 20px; flex-wrap: wrap;">
            <h4>Priority</h4>
            &nbsp;
            &nbsp;
            &nbsp;

            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #19A979;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Requested</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Accepted</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Resolved</p>

            &nbsp;
            &nbsp;
            <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
            </div>
            &nbsp;
            <p style="font-size: 14px; font-weight: 500; color: #64748b; margin: 0;">Emergency</p>
        </div>



        <div style="display: flex; align-items: stretch; gap: 20px; flex-wrap: wrap; margin-bottom: 32px;">
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                        <path fill="currentColor" d="M3 3c-1.11 0-2 .89-2 2v14a2 2 0 0 0 2 2h14c1.11 0 2-.89 2-2V9l-6-6zm14 16H3V5h7v7h7zm-5-9V4.5l5.5 5.5zm11-3v6h-2V7zm-2 8h2v2h-2z" />
                    </svg>
                    Requested
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['requestedRequests'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 32 32">
                        <path fill="currentColor" d="m22 27.18l-2.59-2.59L18 26l4 4l8-8l-1.41-1.41zM9 17h7v2H9zm0-5h12v2H9zm0-5h12v2H9z" />
                        <path fill="currentColor" d="M16 30H6c-1.103 0-2-.897-2-2V4c0-1.103.897-2 2-2h18c1.103 0 2 .897 2 2v15h-2V4H6v24h10z" />
                    </svg>
                    Accepted
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['acceptedRequests'] ?? 0 }}</h1>
            </div>
            <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 16 16">
                        <path fill="currentColor" fill-rule="evenodd" d="M13.657 3.05a.5.5 0 1 0-.707-.707l-.366.366A7 7 0 1 0 8 15a5 5 0 0 1-.597-1.03a6 6 0 1 1 4.471-10.552l-.71.71a5 5 0 1 0-4.08 8.788a5 5 0 0 1-.082-1.042A4.002 4.002 0 0 1 8 4a3.98 3.98 0 0 1 2.453.84l-.715.714a3 3 0 0 0-3.86 4.567a.5.5 0 1 0 .708-.707a2 2 0 0 1 2.43-3.137l-.757.757a1 1 0 1 0 .707.707l1.155-1.155l2.46-2.46a5.97 5.97 0 0 1 1.39 3.277c.367.158.713.36 1.029.597c0-1.636-.57-3.271-1.71-4.584zM16 12a4 4 0 1 1-8 0a4 4 0 0 1 8 0m-1.646-1.354a.5.5 0 0 1 0 .707l-2.5 2.5a.5.5 0 0 1-.708 0l-1-1a.5.5 0 0 1 .708-.707l.646.647l2.146-2.147a.5.5 0 0 1 .708 0" />
                    </svg>
                    Resolved
                </p>
                <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['resolvedRequests'] ?? 0 }}</h1>
            </div>
        </div>
    </div>
    <div style="width: 100%; padding: 0 32px 32px 32px; transition: all 0.3s ease;">
        <h2 style="color: #1e293b; font-weight: 600; font-size: 24px; line-height: 1.2; letter-spacing: -0.025em; margin-bottom: 20px;">Vehicle Status</h2>
        <div>

            <div style="display: flex; align-items: center; margin-bottom: 20px; flex-wrap: wrap;">
                <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #19A979;">
                </div>
                &nbsp;
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">Active</p>

                &nbsp;
                &nbsp;
                <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
                </div>
                &nbsp;
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">Breakdown</p>

                &nbsp;
                &nbsp;
                <div style="width: 12px; height: 12px; border-radius: 0; display: inline-block; flex-shrink: 0; background: #ED4A7B;">
                </div>
                &nbsp;
                <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">Maintenance</p>
            </div>

            <div style="display: flex; align-items: stretch; justify-content: space-between; gap: 20px;">
                <div style="width: 500px; height: 407px; border: 1px solid #e2e8f0; overflow: hidden; flex: 0.6; padding: 20px; background: #f7f7f7; border-radius: 0; display: flex; flex-direction: column; justify-content: space-between; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                    <canvas id="vehicle-status"></canvas>
                </div>

                <div style="flex: 0.6; display: flex; align-items: stretch; justify-content: center; flex-wrap: wrap; gap: 20px;">
                    <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                        <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 2048 2048">
                                <path fill="currentColor" d="M1792 384h-128V256H475l768 768l-768 768h1189v-128h128v256H256v-91l805-805l-805-805v-91h1536z" />
                            </svg>
                            Total Vehicles
                        </p>
                        <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['totalVehicles'] ?? 0 }}</h1>
                    </div>
                    <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                        <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                                <path fill="currentColor" d="m7 8.5l2-2l-2-2l-2 2zM4 14q-.825 0-1.412-.587T2 12V3q0-.825.588-1.412T4 1h16q.825 0 1.413.588T22 3v9q0 .825-.587 1.413T20 14h-3.225q.15-.5.2-1t0-1H20V3H4v9h3.025q-.05.5 0 1t.2 1zm12.5-7q.625 0 1.063-.437T18 5.5t-.437-1.062T16.5 4t-1.062.438T15 5.5t.438 1.063T16.5 7M5 23v-2.1q0-.875.488-1.625t1.287-1.125q1.225-.575 2.55-.862T12 17t2.675.288t2.55.862q.8.375 1.288 1.125T19 20.9V23zm2-2h10v-.1q0-.3-.175-.55t-.45-.375q-1.05-.475-2.15-.725T12 19t-2.225.25t-2.15.725q-.275.125-.45.375T7 20.9zm5-5q-1.45 0-2.475-1.025T8.5 12.5t1.025-2.475T12 9t2.475 1.025T15.5 12.5t-1.025 2.475T12 16m0-2q.625 0 1.063-.437T13.5 12.5t-.437-1.062T12 11t-1.062.438T10.5 12.5t.438 1.063T12 14m0 7" />
                            </svg>
                            In Maintenance Vehicles
                        </p>
                        <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['maintenanceVehicles'] ?? 0 }}</h1>
                    </div>
                    <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                        <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-width="2" d="M13.213 9.787a3.39 3.39 0 0 0-4.795 0l-3.425 3.426a3.39 3.39 0 0 0 4.795 4.794l.321-.304m-.321-4.49a3.39 3.39 0 0 0 4.795 0l3.424-3.426a3.39 3.39 0 0 0-4.794-4.795l-1.028.961M19.573 20l-1.787-1.786m0 0L16 16.427m1.786 1.787l1.787-1.787m-1.787 1.787L16 20" />
                            </svg>
                            Active Vehicles
                        </p>
                        <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['activeVehicles'] ?? 0 }}</h1>
                    </div>
                    <div style="background: #f7f7f7; padding: 24px; border-radius: 0; flex: 1; min-width: 280px; min-height: 140px; display: flex; flex-direction: column; justify-content: space-between; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); transition: all 0.2s ease; cursor: grab; font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                        <p style="color: #0055a5; font-weight: 500; font-size: 16px; line-height: 1.4; margin: 0; display: flex; align-items: center; gap: 8px;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" style="width: 18px; height: 18px; flex-shrink: 0;" viewBox="0 0 24 24">
                                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-width="2" d="M13.213 9.787a3.39 3.39 0 0 0-4.795 0l-3.425 3.426a3.39 3.39 0 0 0 4.795 4.794l.321-.304m-.321-4.49a3.39 3.39 0 0 0 4.795 0l3.424-3.426a3.39 3.39 0 0 0-4.794-4.795l-1.028.961M19.573 20l-1.787-1.786m0 0L16 16.427m1.786 1.787l1.787-1.787m-1.787 1.787L16 20" />
                            </svg>
                            Breakdown Vehicles
                        </p>
                        <h1 style="color: #555555; font-weight: 600; font-size: 36px; line-height: 1; letter-spacing: -0.025em; margin: 0;">{{ $dashboardData['breakdownVehicles'] ?? 0 }}</h1>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
// Optimized Dashboard Functionality
(function() {
    'use strict';
    
    // Configuration object
    const CONFIG = {
        chartColors: {
            primary: '#0055A5',
            secondary: '#F5D904',
            success: '#19A979',
            warning: '#F5D904',
            danger: '#DC0D0E',
            info: '#3b82f6',
            repair: '#ED4A7B'
        },
        chartOptions: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top'
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    };
    
    // Cache DOM elements
    let elements = {};
    
    function initElements() {
        elements = {
            faultChart: document.getElementById('myChart'),
            vehicleStatusChart: document.getElementById('vehicle-status'),
            dashboardSettingBtn: document.getElementById('dashboardSetting'),
            viewMapBtn: document.querySelector('button[data-bs-target="#Map"]'),
            exportBtn: document.querySelector('.btns button:last-child')
        };
    }
    
    // Initialize fault summary chart
    function initFaultChart() {
        if (!elements.faultChart) return;
        
        new Chart(elements.faultChart.getContext('2d'), {
            type: 'bar',
            data: {
                labels: ['Faulty Vehicles', 'Repair Items', 'Replace Items'],
                datasets: [{
                    data: [{{ $dashboardData['faultyVehicles'] ?? 0 }}, {{ $dashboardData['repairItems'] ?? 0 }}, {{ $dashboardData['replaceItems'] ?? 0 }}],
                    backgroundColor: [CONFIG.chartColors.danger, CONFIG.chartColors.warning, CONFIG.chartColors.repair]
                }]
            },
            options: CONFIG.chartOptions
        });
    }
    
    // Initialize vehicle status chart
    function initVehicleStatusChart() {
        if (!elements.vehicleStatusChart) return;
        
        new Chart(elements.vehicleStatusChart.getContext('2d'), {
            type: 'bar',
            data: {
                labels: ['Vehicle Status'],
                datasets: [{
                    label: 'Active',
                    data: [{{ $dashboardData['activeVehicles'] ?? 0 }}],
                    backgroundColor: CONFIG.chartColors.success
                }, {
                    label: 'Breakdown',
                    data: [{{ $dashboardData['breakdownVehicles'] ?? 0 }}],
                    backgroundColor: CONFIG.chartColors.danger
                }, {
                    label: 'Maintenance',
                    data: [{{ $dashboardData['maintenanceVehicles'] ?? 0 }}],
                    backgroundColor: CONFIG.chartColors.warning
                }]
            },
            options: {
                ...CONFIG.chartOptions,
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Count'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Status'
                        }
                    }
                }
            }
        });
    }
    
    // Initialize all charts
    function initCharts() {
        initFaultChart();
        initVehicleStatusChart();
    }
    
    // Initialize button event handlers
    function initButtonHandlers() {
        // Dashboard Setting Button
        if (elements.dashboardSettingBtn) {
            elements.dashboardSettingBtn.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                if (typeof showInfoAlert === 'function') {
                    showInfoAlert(
                        'Dashboard Settings', 
                        'Dashboard settings modal would open here. This is a custom alert using the same design as the job card page.',
                        function() {
                            console.log('Dashboard settings alert confirmed');
                        }
                    );
                }
            });
        }

        // View Map Button
        if (elements.viewMapBtn) {
            elements.viewMapBtn.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                if (typeof showInfoAlert === 'function') {
                    showInfoAlert(
                        'View Map', 
                        'Map view modal would open here. This will show the interactive map with all locations and markers.',
                        function() {
                            console.log('View map alert confirmed');
                        }
                    );
                }
            });
        }

        // Export Button
        if (elements.exportBtn && !elements.exportBtn.hasAttribute('data-bs-target')) {
            elements.exportBtn.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                if (typeof showSuccessAlert === 'function') {
                    showSuccessAlert(
                        'Export Data', 
                        'Export functionality would open here. This will allow you to export dashboard data in various formats (PDF, Excel, CSV).',
                        function() {
                            console.log('Export alert confirmed');
                        }
                    );
                }
            });
        }
    }
    
    // Initialize all functionality
    function init() {
        initElements();
        initCharts();
        initButtonHandlers();
    }
    
    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
    
    // Make functions globally accessible if needed
    window.initDashboardCharts = initCharts;
})();
</script>
@endsection

