@extends('welcome')

@section('title', 'Reminder')

@section('content')
<div class="reminder-container">
    <!-- Header Section -->
    <div class="reminder-header">
        <div class="header-content">
            <div class="page-title">
                <h1>Inspection Reminders</h1>
                <p>Manage driver inspection reminders and missed inspection reports</p>
            </div>
        </div>
    </div>
    
    <!-- Tab Section -->
    <div class="tab-section">
        <div class="tab-container">
            <!-- Tab Navigation -->
            <div class="tab-navigation">
                <ul class="tab-list" role="tablist">
                    <li class="tab-item">
                        <button class="tab-button active" data-bs-toggle="pill" data-bs-target="#driver-reminder" role="tab" aria-selected="true">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                                <circle cx="9" cy="7" r="4"></circle>
                                <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                                <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                            </svg>
                            Driver Inspection Reminder
                        </button>
                    </li>
                    <li class="tab-item">
                        <button class="tab-button" data-bs-toggle="pill" data-bs-target="#missed-report" role="tab" aria-selected="false">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                <polyline points="14,2 14,8 20,8"></polyline>
                                <line x1="16" y1="13" x2="8" y2="13"></line>
                                <line x1="16" y1="17" x2="8" y2="17"></line>
                                <polyline points="10,9 9,9 8,9"></polyline>
                            </svg>
                            Missed Inspection Report
                        </button>
                    </li>
                </ul>
            </div>
            
            <!-- Tab Content -->
            <div class="tab-content">
                <!-- Driver Inspection Reminder Tab -->
                <div id="driver-reminder" class="tab-pane active" role="tabpanel">
                    <div class="tab-content-body">
                        <!-- Action Bar -->
                        <div class="action-bar">
                            <div class="search-container">
                                <div class="search-input-wrapper">
                                    <svg class="search-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <circle cx="11" cy="11" r="8"></circle>
                                        <path d="m21 21-4.35-4.35"></path>
                                    </svg>
                                    <input type="text" class="search-input" placeholder="Search reminders..." id="driverSearchInput">
                                </div>
                            </div>
                            <div class="action-buttons">
                                <button class="btn-primary" data-bs-toggle="modal" data-bs-target="#add-reminders">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <line x1="12" y1="5" x2="12" y2="19"></line>
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                    </svg>
                                    Create Reminder
                                </button>
                            </div>
                        </div>
                        
                        <!-- Table Section -->
                        <div class="table-section">
                            <div class="table-container">
                                <table class="reminder-table">
                                    <thead>
                                        <tr>
                                            <th>Action</th>
                                            <th>Title</th>
                                            <th>Drivers</th>
                                            <th>Frequency</th>
                                            <th>Notification Time</th>
                                            <th>On/Off</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="no-data-row">
                                            <td colspan="6" class="no-data-cell">
                                                <div class="no-data-content">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                                                        <circle cx="12" cy="12" r="10"></circle>
                                                        <line x1="12" y1="8" x2="12" y2="12"></line>
                                                        <line x1="12" y1="16" x2="12.01" y2="16"></line>
                                                    </svg>
                                                    <h3>No Reminders</h3>
                                                    <p>Create your first driver inspection reminder to get started.</p>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Missed Inspection Report Tab -->
                <div id="missed-report" class="tab-pane" role="tabpanel">
                    <div class="tab-content-body">
                        <!-- Action Bar -->
                        <div class="action-bar">
                            <div class="search-container">
                                <div class="search-input-wrapper">
                                    <svg class="search-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <circle cx="11" cy="11" r="8"></circle>
                                        <path d="m21 21-4.35-4.35"></path>
                                    </svg>
                                    <input type="text" class="search-input" placeholder="Search reports..." id="reportSearchInput">
                                </div>
                            </div>
                            <div class="action-buttons">
                                <button class="btn-primary" data-bs-toggle="modal" data-bs-target="#add-reminders-report">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <line x1="12" y1="5" x2="12" y2="19"></line>
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                    </svg>
                                    Create Report
                                </button>
                                <button class="btn-secondary" data-bs-toggle="modal" data-bs-target="#report-history">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M3 3v18h18"></path>
                                        <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"></path>
                                    </svg>
                                    View History
                                </button>
                            </div>
                        </div>
                        
                        <!-- Table Section -->
                        <div class="table-section">
                            <div class="table-container">
                                <table class="reminder-table">
                                    <thead>
                                        <tr>
                                            <th>Action</th>
                                            <th>Title</th>
                                            <th>Drivers</th>
                                            <th>Frequency</th>
                                            <th>Notification Time</th>
                                            <th>On/Off</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="no-data-row">
                                            <td colspan="6" class="no-data-cell">
                                                <div class="no-data-content">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                                                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                                        <polyline points="14,2 14,8 20,8"></polyline>
                                                        <line x1="16" y1="13" x2="8" y2="13"></line>
                                                        <line x1="16" y1="17" x2="8" y2="17"></line>
                                                    </svg>
                                                    <h3>No Reports</h3>
                                                    <p>Create your first missed inspection report to get started.</p>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Create Driver Reminder Modal -->
<div class="modal fade" id="add-reminders" tabindex="-1" aria-labelledby="addReminderModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addReminderModalLabel">Create Driver Inspection Reminder</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="modal-description">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"></circle>
                        <line x1="12" y1="8" x2="12" y2="12"></line>
                        <line x1="12" y1="16" x2="12.01" y2="16"></line>
                    </svg>
                    <p>Notify driver when a required routine inspection is required.</p>
                </div>
                <form id="reminderForm">
                    <div class="form-group">
                        <label for="reminderTitle" class="form-label">Title <span class="required">*</span></label>
                        <input type="text" class="form-control" id="reminderTitle" placeholder="Enter reminder title" required>
                    </div>
                    <div class="form-group">
                        <label for="notificationTime" class="form-label">Notification Time <span class="required">*</span></label>
                        <input type="time" class="form-control" id="notificationTime" required>
                    </div>
                    <div class="form-group">
                        <label for="drivers" class="form-label">Drivers <span class="required">*</span></label>
                        <input type="text" class="form-control" id="drivers" placeholder="Select drivers" required>
                    </div>
                    <div class="form-group">
                        <label for="repeatFrequency" class="form-label">Repeat <span class="required">*</span></label>
                        <select class="form-control" id="repeatFrequency" required>
                            <option value="">Select frequency</option>
                            <option value="daily">Every Day (M,T,W,T,F,S,S)</option>
                            <option value="weekday">Every Weekday (M,T,W,T,F)</option>
                            <option value="specific-weekday">Specific Week day</option>
                            <option value="specific-month">Specific Month date</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Days <span class="required">*</span></label>
                        <div class="day-selector">
                            <label class="day-option">
                                <input type="checkbox" name="days" value="monday">
                                <span class="day-label">M</span>
                            </label>
                            <label class="day-option">
                                <input type="checkbox" name="days" value="tuesday">
                                <span class="day-label">T</span>
                            </label>
                            <label class="day-option">
                                <input type="checkbox" name="days" value="wednesday">
                                <span class="day-label">W</span>
                            </label>
                            <label class="day-option">
                                <input type="checkbox" name="days" value="thursday">
                                <span class="day-label">T</span>
                            </label>
                            <label class="day-option">
                                <input type="checkbox" name="days" value="friday">
                                <span class="day-label">F</span>
                            </label>
                            <label class="day-option">
                                <input type="checkbox" name="days" value="saturday">
                                <span class="day-label">S</span>
                            </label>
                            <label class="day-option">
                                <input type="checkbox" name="days" value="sunday">
                                <span class="day-label">S</span>
                            </label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="reminderMessage" class="form-label">Message</label>
                        <textarea class="form-control" id="reminderMessage" rows="4" placeholder="Enter reminder message"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn-save" onclick="saveReminder()">Set Reminder</button>
            </div>
        </div>
    </div>
</div>
<!-- Create Missed Inspection Report Modal -->
<div class="modal fade" id="add-reminders-report" tabindex="-1" aria-labelledby="addReportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addReportModalLabel">Create Missed Inspection Report</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="reportForm">
                    <div class="form-row">
                        <div class="form-group">
                            <label for="reportTitle" class="form-label">Title <span class="required">*</span></label>
                            <input type="text" class="form-control" id="reportTitle" placeholder="Enter report title" required>
                        </div>
                        <div class="form-group">
                            <label for="reportTime" class="form-label">Report Time <span class="required">*</span></label>
                            <input type="time" class="form-control" id="reportTime" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inspectionForm" class="form-label">Inspection Form <span class="required">*</span></label>
                        <select class="form-control" id="inspectionForm" required>
                            <option value="">Select Inspection Checklist from list</option>
                            <option value="daily-inspection">Daily Vehicle Inspection</option>
                            <option value="pre-trip">Pre-Trip Inspection</option>
                            <option value="post-trip">Post-Trip Inspection</option>
                        </select>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="reportFrequency" class="form-label">Repeat <span class="required">*</span></label>
                            <select class="form-control" id="reportFrequency" required>
                                <option value="">Select frequency</option>
                                <option value="daily">Every Day (M,T,W,T,F,S,S)</option>
                                <option value="weekday">Every Weekday (M,T,W,T,F)</option>
                                <option value="specific-weekday">Specific Week day</option>
                                <option value="specific-month">Specific Month date</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Days <span class="required">*</span></label>
                            <div class="day-selector">
                                <label class="day-option">
                                    <input type="checkbox" name="reportDays" value="monday">
                                    <span class="day-label">M</span>
                                </label>
                                <label class="day-option">
                                    <input type="checkbox" name="reportDays" value="tuesday">
                                    <span class="day-label">T</span>
                                </label>
                                <label class="day-option">
                                    <input type="checkbox" name="reportDays" value="wednesday">
                                    <span class="day-label">W</span>
                                </label>
                                <label class="day-option">
                                    <input type="checkbox" name="reportDays" value="thursday">
                                    <span class="day-label">T</span>
                                </label>
                                <label class="day-option">
                                    <input type="checkbox" name="reportDays" value="friday">
                                    <span class="day-label">F</span>
                                </label>
                                <label class="day-option">
                                    <input type="checkbox" name="reportDays" value="saturday">
                                    <span class="day-label">S</span>
                                </label>
                                <label class="day-option">
                                    <input type="checkbox" name="reportDays" value="sunday">
                                    <span class="day-label">S</span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="reportMessage" class="form-label">Message</label>
                        <textarea class="form-control" id="reportMessage" rows="3" placeholder="Enter report message"></textarea>
                    </div>
                    
                    <div class="email-section">
                        <div class="section-header">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                                <polyline points="22,6 12,13 2,6"></polyline>
                            </svg>
                            <h4>Send email when a required routine inspection is missed</h4>
                        </div>
                        
                        <div class="email-list-header">
                            <h5>Email List</h5>
                            <button type="button" class="btn-add-email" data-bs-toggle="modal" data-bs-target="#add-email">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <line x1="12" y1="5" x2="12" y2="19"></line>
                                    <line x1="5" y1="12" x2="19" y2="12"></line>
                                </svg>
                                Add Email
                            </button>
                        </div>
                        
                        <div class="email-list">
                            <div class="empty-email-list">
                                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                                    <polyline points="22,6 12,13 2,6"></polyline>
                                </svg>
                                <p>No email addresses added</p>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn-save" onclick="saveReport()">Set Report</button>
            </div>
        </div>
    </div>
</div>
<!-- Add Email Modal -->
<div class="modal fade" id="add-email" tabindex="-1" aria-labelledby="addEmailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addEmailModalLabel">Add Email Address</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="emailForm">
                    <div class="form-group">
                        <label for="emailAddress" class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="emailAddress" placeholder="Enter email address" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn-save" onclick="addEmail()">Add Email</button>
            </div>
        </div>
    </div>
</div>

<!-- Report History Modal -->
<div class="modal fade" id="report-history" tabindex="-1" aria-labelledby="reportHistoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="reportHistoryModalLabel">Missed Inspection Report History</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-section">
                    <div class="table-container">
                        <table class="reminder-table">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Inspection Form</th>
                                    <th>Vehicles</th>
                                    <th>Frequency</th>
                                    <th>Reporting Time</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="no-data-row">
                                    <td colspan="5" class="no-data-cell">
                                        <div class="no-data-content">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M3 3v18h18"></path>
                                                <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"></path>
                                            </svg>
                                            <h3>No History</h3>
                                            <p>No missed inspection reports found.</p>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
// Search functionality
document.getElementById('driverSearchInput').addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    console.log('Searching driver reminders for:', searchTerm);
    // Add search functionality here
});

document.getElementById('reportSearchInput').addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    console.log('Searching reports for:', searchTerm);
    // Add search functionality here
});

// Save reminder functionality
function saveReminder() {
    const title = document.getElementById('reminderTitle').value;
    const time = document.getElementById('notificationTime').value;
    const drivers = document.getElementById('drivers').value;
    const frequency = document.getElementById('repeatFrequency').value;
    const message = document.getElementById('reminderMessage').value;
    
    if (!title.trim() || !time || !drivers.trim() || !frequency) {
        showNotification('Please fill in all required fields', 'warning');
        return;
    }
    
    console.log('Saving reminder:', { title, time, drivers, frequency, message });
    
    // Close modal
    const modal = bootstrap.Modal.getInstance(document.getElementById('add-reminders'));
    modal.hide();
    
    // Show success notification
    showNotification('Reminder created successfully!', 'success');
    
    // Reset form
    document.getElementById('reminderForm').reset();
}

// Save report functionality
function saveReport() {
    const title = document.getElementById('reportTitle').value;
    const time = document.getElementById('reportTime').value;
    const form = document.getElementById('inspectionForm').value;
    const frequency = document.getElementById('reportFrequency').value;
    const message = document.getElementById('reportMessage').value;
    
    if (!title.trim() || !time || !form || !frequency) {
        showNotification('Please fill in all required fields', 'warning');
        return;
    }
    
    console.log('Saving report:', { title, time, form, frequency, message });
    
    // Close modal
    const modal = bootstrap.Modal.getInstance(document.getElementById('add-reminders-report'));
    modal.hide();
    
    // Show success notification
    showNotification('Report created successfully!', 'success');
    
    // Reset form
    document.getElementById('reportForm').reset();
}

// Add email functionality
function addEmail() {
    const email = document.getElementById('emailAddress').value;
    
    if (!email.trim()) {
        showNotification('Please enter an email address', 'warning');
        return;
    }
    
    if (!isValidEmail(email)) {
        showNotification('Please enter a valid email address', 'warning');
        return;
    }
    
    console.log('Adding email:', email);
    
    // Close modal
    const modal = bootstrap.Modal.getInstance(document.getElementById('add-email'));
    modal.hide();
    
    // Show success notification
    showNotification('Email added successfully!', 'success');
    
    // Reset form
    document.getElementById('emailForm').reset();
}

// Email validation
function isValidEmail(email) {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}

// Notification system
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999212121211; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}

// Initialize page
document.addEventListener('DOMContentLoaded', function() {
    console.log('Reminder page loaded');
    
    // Add focus to first search input on page load
    document.getElementById('driverSearchInput').focus();
});
</script>
<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* Main Container */
.reminder-container {
    min-height: 100vh;
}

/* Header Section */
.reminder-header {
    background: white;
    border: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    border-radius: 0;
    margin-bottom: 24px;
}

.header-content {
    padding: 32px;
}

.page-title h1 {
    color: #0f172a;
    font-weight: 700;
    font-size: 32px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0 0 8px 0;
}

.page-title p {
    color: #64748b;
    font-weight: 400;
    font-size: 16px;
    line-height: 1.5;
    margin: 0;
}

/* Tab Section */
.tab-section {
    background: white;
    border: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    border-radius: 0;
    overflow: hidden;
}

.tab-container {
    padding: 0;
}

/* Tab Navigation */
.tab-navigation {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border-bottom: 1px solid #e2e8f0;
    padding: 0;
}

.tab-list {
    display: flex;
    list-style: none;
    margin: 0;
    padding: 0;
}

.tab-item {
    flex: 1;
}

.tab-button {
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 16px 24px;
    border: none;
    background: transparent;
    color: #64748b;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    border-bottom: 3px solid transparent;
}

.tab-button:hover {
    background: rgba(59, 130, 246, 0.05);
    color: #3b82f6;
}

.tab-button.active {
    background: white;
    color: #3b82f6;
    border-bottom-color: #3b82f6;
    box-shadow: 0 -2px 4px rgba(0, 0, 0, 0.05);
}

.tab-button svg {
    flex-shrink: 0;
}

/* Tab Content */
.tab-content {
    min-height: 500px;
}

.tab-content-body {
    padding: 24px;
}

/* Action Bar */
.action-bar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 20px;
    margin-bottom: 24px;
    flex-wrap: wrap;
}

.search-container {
    position: relative;
}

.search-input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.search-icon {
    position: absolute;
    left: 16px;
    z-index: 2;
    color: #64748b;
    width: 16px;
    height: 16px;
}

.search-input {
    padding: 12px 16px 12px 44px;
    border: 1px solid #d1d5db;
    border-radius: 0;
    height: 44px;
    width: 300px;
    font-size: 14px;
    font-weight: 400;
    color: #374151;
    background: white;
    transition: all 0.2s ease;
}

.search-input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.search-input::placeholder {
    color: #9ca3af;
}

.action-buttons {
    display: flex;
    gap: 12px;
    align-items: center;
}

/* Buttons */
.btn-primary, .btn-secondary {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: 0;
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    transition: all 0.2s ease;
    cursor: pointer;
    box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
}

.btn-primary {
    background: #0055a5;
    color: white;
}

.btn-primary:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black;
}

.btn-secondary {
    background: #f3f4f6;
    color: #374151;
    border: 1px solid #d1d5db;
}

.btn-secondary:hover {
    background: #e5e7eb;
    color: #1f2937;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* Table Section */
.table-section {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    overflow: hidden;
}

.table-container {
    overflow-x: auto;
}

.reminder-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
}

.reminder-table thead {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
}

.reminder-table th {
    padding: 16px 20px;
    text-align: left;
    font-weight: 600;
    color: #374151;
    border-bottom: 1px solid #e2e8f0;
    white-space: nowrap;
}

.reminder-table td {
    padding: 16px 20px;
    border-bottom: 1px solid #f1f5f9;
    color: #6b7280;
}

.reminder-table tbody tr:hover {
    background: #f8fafc;
}

/* No Data State */
.no-data-row {
    background: white;
}

.no-data-cell {
    text-align: center;
    padding: 48px 20px;
}

.no-data-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 16px;
    color: #9ca3af;
}

.no-data-content svg {
    color: #d1d5db;
}

.no-data-content h3 {
    color: #6b7280;
    font-weight: 600;
    font-size: 18px;
    margin: 0;
}

.no-data-content p {
    color: #9ca3af;
    font-weight: 400;
    font-size: 14px;
    margin: 0;
    max-width: 300px;
}

/* Modal Styling */
.modal-content {
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    z-index: 1000222;
}

.modal-header {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border-bottom: 1px solid #e2e8f0;
    padding: 20px 24px;
}

.modal-title {
    color: #0f172a;
    font-weight: 600;
    font-size: 18px;
    margin: 0;
}

.btn-close {
    background: none;
    border: none;
    font-size: 24px;
    color: #64748b;
    opacity: 1;
    transition: all 0.2s ease;
}

.btn-close:hover {
    color: #374151;
    transform: scale(1.1);
}

.modal-body {
    padding: 24px;
}

/* Modal Description */
.modal-description {
    display: flex;
    align-items: center;
    gap: 12px;
    background: #f0f9ff;
    border: 1px solid #bae6fd;
    border-radius: 0;
    padding: 16px;
    margin-bottom: 24px;
}

.modal-description svg {
    color: #0284c7;
    flex-shrink: 0;
}

.modal-description p {
    color: #0369a1;
    font-weight: 400;
    font-size: 14px;
    margin: 0;
}

/* Form Styling */
.form-group {
    margin-bottom: 20px;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-bottom: 20px;
}

.form-label {
    display: block;
    color: #374151;
    font-weight: 500;
    font-size: 14px;
    margin-bottom: 8px;
}

.required {
    color: #dc2626;
}

.form-control {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid #d1d5db;
    border-radius: 0;
    font-size: 14px;
    font-weight: 400;
    color: #374151;
    background: white;
    transition: all 0.2s ease;
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.form-control::placeholder {
    color: #9ca3af;
}

textarea.form-control {
    resize: vertical;
    min-height: 100px;
}

/* Day Selector */
.day-selector {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
}

.day-option {
    display: flex;
    align-items: center;
    cursor: pointer;
}

.day-option input[type="checkbox"] {
    display: none;
}

.day-label {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border: 2px solid #d1d5db;
    border-radius: 0;
    background: white;
    color: #6b7280;
    font-weight: 500;
    font-size: 14px;
    transition: all 0.2s ease;
}

.day-option input[type="checkbox"]:checked + .day-label {
    background: #3b82f6;
    border-color: #3b82f6;
    color: white;
}

.day-option:hover .day-label {
    border-color: #3b82f6;
    color: #3b82f6;
}

/* Email Section */
.email-section {
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    padding: 20px;
    margin-top: 24px;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 20px;
}

.section-header svg {
    color: #3b82f6;
    flex-shrink: 0;
}

.section-header h4 {
    color: #0f172a;
    font-weight: 600;
    font-size: 16px;
    margin: 0;
}

.email-list-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 16px;
}

.email-list-header h5 {
    color: #374151;
    font-weight: 600;
    font-size: 14px;
    margin: 0;
}

.btn-add-email {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 16px;
    border: 1px solid #3b82f6;
    border-radius: 0;
    background: white;
    color: #3b82f6;
    font-size: 13px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-add-email:hover {
    background: #3b82f6;
    color: white;
}

.email-list {
    min-height: 80px;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    background: white;
    padding: 20px;
}

.empty-email-list {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
    color: #9ca3af;
}

.empty-email-list svg {
    color: #d1d5db;
}

.empty-email-list p {
    color: #9ca3af;
    font-weight: 400;
    font-size: 14px;
    margin: 0;
}

/* Modal Footer */
.modal-footer {
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
    padding: 16px 24px;
    display: flex;
    gap: 12px;
    justify-content: flex-end;
}

.btn-cancel, .btn-save {
    padding: 10px 20px;
    border: none;
    border-radius: 0;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-cancel {
    background: #f3f4f6;
    color: #374151;
}

.btn-cancel:hover {
    background: #e5e7eb;
    color: #1f2937;
}

.btn-save {
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: white;
}

.btn-save:hover {
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .reminder-container {
        padding: 20px;
    }
    
    .header-content {
        padding: 24px;
    }
    
    .search-input {
        width: 250px;
    }
    
    .tab-content-body {
        padding: 20px;
    }
}

@media (max-width: 992px) {
    .reminder-container {
        padding: 16px;
    }
    
    .header-content {
        padding: 20px;
    }
    
    .page-title h1 {
        font-size: 28px;
    }
    
    .page-title p {
        font-size: 15px;
    }
    
    .tab-content-body {
        padding: 18px;
    }
    
    .action-bar {
        flex-direction: column;
        align-items: stretch;
        gap: 16px;
    }
    
    .search-input {
        width: 100%;
        max-width: 400px;
    }
    
    .action-buttons {
        justify-content: center;
        flex-wrap: wrap;
        gap: 12px;
    }
    
    .btn-primary, .btn-secondary {
        flex: 1;
        min-width: 140px;
        justify-content: center;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 16px;
    }
    
    .tab-button {
        padding: 14px 20px;
        font-size: 13px;
    }
    
    .day-selector {
        justify-content: center;
        gap: 6px;
    }
    
    .day-label {
        width: 38px;
        height: 38px;
        font-size: 13px;
    }
}

@media (max-width: 768px) {
    .reminder-container {
        padding: 0;
    }
    
    .reminder-header {
        margin: 0 16px 16px 16px;
    }
    
    .header-content {
        padding: 16px;
    }
    
    .page-title h1 {
        font-size: 24px;
        margin-bottom: 6px;
    }
    
    .page-title p {
        font-size: 14px;
    }
    
    .tab-section {
        margin: 0 16px 16px 16px;
    }
    
    .tab-content-body {
        padding: 16px;
    }
    
    .tab-navigation {
        padding: 0;
    }
    
    .tab-list {
        flex-direction: column;
    }
    
    .tab-item {
        flex: none;
    }
    
    .tab-button {
        width: 100%;
        padding: 12px 16px;
        font-size: 13px;
        justify-content: flex-start;
        border-bottom: 1px solid #e2e8f0;
        border-right: none;
    }
    
    .tab-button.active {
        background: #f8fafc;
        border-bottom-color: #3b82f6;
        border-right: 3px solid #3b82f6;
    }
    
    .action-bar {
        flex-direction: column;
        align-items: stretch;
        gap: 16px;
    }
    
    .search-container {
        width: 100%;
    }
    
    .search-input {
        width: 100%;
        padding: 12px 16px 12px 44px;
        font-size: 16px;
        min-height: 48px;
    }
    
    .action-buttons {
        flex-direction: column;
        gap: 12px;
    }
    
    .btn-primary, .btn-secondary {
        width: 100%;
        justify-content: center;
        padding: 14px 20px;
        font-size: 14px;
        min-height: 48px;
    }
    
    .table-section {
        margin-top: 16px;
    }
    
    .table-container {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    .reminder-table {
        font-size: 12px;
        min-width: 600px;
    }
    
    .reminder-table th,
    .reminder-table td {
        padding: 12px 8px;
        white-space: nowrap;
    }
    
    .reminder-table th {
        font-size: 11px;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }
    
    .reminder-table td {
        font-size: 12px;
    }
    
    .no-data-cell {
        padding: 40px 16px !important;
    }
    
    .no-data-content h3 {
        font-size: 16px;
    }
    
    .no-data-content p {
        font-size: 13px;
    }
    
    .no-data-content svg {
        width: 40px;
        height: 40px;
    }
    
    .day-selector {
        justify-content: center;
        gap: 6px;
        flex-wrap: wrap;
    }
    
    .day-label {
        width: 36px;
        height: 36px;
        font-size: 12px;
    }
    
    .email-section {
        padding: 16px;
        margin-top: 16px;
    }
    
    .section-header h4 {
        font-size: 15px;
    }
    
    .email-list-header {
        flex-direction: column;
        gap: 12px;
        align-items: stretch;
    }
    
    .btn-add-email {
        width: 100%;
        justify-content: center;
        padding: 10px 16px;
        font-size: 13px;
        min-height: 44px;
    }
    
    .email-list {
        padding: 16px;
    }
    
    .empty-email-list svg {
        width: 28px;
        height: 28px;
    }
    
    .empty-email-list p {
        font-size: 13px;
    }
    
    /* Modal Responsive */
    .modal-dialog {
        margin: 10px;
        max-width: calc(100% - 20px);
    }
    
    .modal-content {
        border-radius: 8px;
    }
    
    .modal-header {
        padding: 16px 20px;
    }
    
    .modal-title {
        font-size: 16px;
    }
    
    .modal-body {
        padding: 20px;
    }
    
    .modal-description {
        padding: 12px 16px;
        margin-bottom: 20px;
    }
    
    .modal-description svg {
        width: 20px;
        height: 20px;
    }
    
    .modal-description p {
        font-size: 13px;
    }
    
    .form-group {
        margin-bottom: 16px;
    }
    
    .form-label {
        font-size: 13px;
        margin-bottom: 6px;
    }
    
    .form-control {
        padding: 12px 16px;
        font-size: 16px;
        min-height: 48px;
    }
    
    .form-row {
        gap: 12px;
    }
    
    .modal-footer {
        padding: 16px 20px;
        flex-direction: column;
        gap: 12px;
    }
    
    .btn-cancel, .btn-save {
        width: 100%;
        padding: 12px 20px;
        font-size: 14px;
        min-height: 44px;
    }
}

@media (max-width: 576px) {
    .reminder-container {
        padding: 0;
    }
    
    .reminder-header {
        margin: 0 12px 12px 12px;
    }
    
    .header-content {
        padding: 12px;
    }
    
    .page-title h1 {
        font-size: 20px;
        margin-bottom: 4px;
    }
    
    .page-title p {
        font-size: 13px;
    }
    
    .tab-section {
        margin: 0 12px 12px 12px;
    }
    
    .tab-content-body {
        padding: 12px;
    }
    
    .tab-button {
        padding: 10px 12px;
        font-size: 12px;
    }
    
    .action-bar {
        gap: 12px;
    }
    
    .search-input {
        padding: 10px 14px 10px 40px;
        font-size: 16px;
        min-height: 44px;
    }
    
    .search-icon {
        width: 14px;
        height: 14px;
        left: 14px;
    }
    
    .action-buttons {
        gap: 8px;
    }
    
    .btn-primary, .btn-secondary {
        padding: 12px 16px;
        font-size: 13px;
        min-height: 44px;
    }
    
    .reminder-table {
        font-size: 11px;
        min-width: 500px;
    }
    
    .reminder-table th,
    .reminder-table td {
        padding: 10px 6px;
    }
    
    .reminder-table th {
        font-size: 10px;
    }
    
    .reminder-table td {
        font-size: 11px;
    }
    
    .no-data-cell {
        padding: 32px 12px !important;
    }
    
    .no-data-content h3 {
        font-size: 15px;
    }
    
    .no-data-content p {
        font-size: 12px;
    }
    
    .no-data-content svg {
        width: 36px;
        height: 36px;
    }
    
    .day-selector {
        gap: 4px;
    }
    
    .day-label {
        width: 32px;
        height: 32px;
        font-size: 11px;
    }
    
    .email-section {
        padding: 12px;
        margin-top: 12px;
    }
    
    .section-header h4 {
        font-size: 14px;
    }
    
    .email-list-header h5 {
        font-size: 13px;
    }
    
    .btn-add-email {
        padding: 8px 12px;
        font-size: 12px;
        min-height: 40px;
    }
    
    .email-list {
        padding: 12px;
    }
    
    .empty-email-list svg {
        width: 24px;
        height: 24px;
    }
    
    .empty-email-list p {
        font-size: 12px;
    }
    
    /* Modal Responsive */
    .modal-dialog {
        margin: 8px;
        max-width: calc(100% - 16px);
    }
    
    .modal-header {
        padding: 12px 16px;
    }
    
    .modal-title {
        font-size: 15px;
    }
    
    .modal-body {
        padding: 16px;
    }
    
    .modal-description {
        padding: 10px 12px;
        margin-bottom: 16px;
    }
    
    .modal-description svg {
        width: 18px;
        height: 18px;
    }
    
    .modal-description p {
        font-size: 12px;
    }
    
    .form-group {
        margin-bottom: 12px;
    }
    
    .form-label {
        font-size: 12px;
        margin-bottom: 4px;
    }
    
    .form-control {
        padding: 10px 14px;
        font-size: 16px;
        min-height: 44px;
    }
    
    .form-row {
        gap: 10px;
    }
    
    .modal-footer {
        padding: 12px 16px;
        gap: 8px;
    }
    
    .btn-cancel, .btn-save {
        padding: 10px 16px;
        font-size: 13px;
        min-height: 40px;
    }
}

@media (max-width: 480px) {
    .reminder-header {
        margin: 0 8px 8px 8px;
    }
    
    .header-content {
        padding: 10px;
    }
    
    .page-title h1 {
        font-size: 18px;
        margin-bottom: 3px;
    }
    
    .page-title p {
        font-size: 12px;
    }
    
    .tab-section {
        margin: 0 8px 8px 8px;
    }
    
    .tab-content-body {
        padding: 10px;
    }
    
    .tab-button {
        padding: 8px 10px;
        font-size: 11px;
    }
    
    .action-bar {
        gap: 10px;
    }
    
    .search-input {
        padding: 8px 12px 8px 36px;
        font-size: 16px;
        min-height: 40px;
    }
    
    .search-icon {
        width: 12px;
        height: 12px;
        left: 12px;
    }
    
    .action-buttons {
        gap: 6px;
    }
    
    .btn-primary, .btn-secondary {
        padding: 10px 14px;
        font-size: 12px;
        min-height: 40px;
    }
    
    .reminder-table {
        font-size: 10px;
        min-width: 400px;
    }
    
    .reminder-table th,
    .reminder-table td {
        padding: 8px 4px;
    }
    
    .reminder-table th {
        font-size: 9px;
    }
    
    .reminder-table td {
        font-size: 10px;
    }
    
    .no-data-cell {
        padding: 24px 8px !important;
    }
    
    .no-data-content h3 {
        font-size: 14px;
    }
    
    .no-data-content p {
        font-size: 11px;
    }
    
    .no-data-content svg {
        width: 32px;
        height: 32px;
    }
    
    .day-selector {
        gap: 3px;
    }
    
    .day-label {
        width: 28px;
        height: 28px;
        font-size: 10px;
    }
    
    .email-section {
        padding: 10px;
        margin-top: 10px;
    }
    
    .section-header h4 {
        font-size: 13px;
    }
    
    .email-list-header h5 {
        font-size: 12px;
    }
    
    .btn-add-email {
        padding: 6px 10px;
        font-size: 11px;
        min-height: 36px;
    }
    
    .email-list {
        padding: 10px;
    }
    
    .empty-email-list svg {
        width: 20px;
        height: 20px;
    }
    
    .empty-email-list p {
        font-size: 11px;
    }
    
    /* Modal Responsive */
    .modal-dialog {
        margin: 4px;
        max-width: calc(100% - 8px);
    }
    
    .modal-header {
        padding: 10px 12px;
    }
    
    .modal-title {
        font-size: 14px;
    }
    
    .modal-body {
        padding: 12px;
    }
    
    .modal-description {
        padding: 8px 10px;
        margin-bottom: 12px;
    }
    
    .modal-description svg {
        width: 16px;
        height: 16px;
    }
    
    .modal-description p {
        font-size: 11px;
    }
    
    .form-group {
        margin-bottom: 10px;
    }
    
    .form-label {
        font-size: 11px;
        margin-bottom: 3px;
    }
    
    .form-control {
        padding: 8px 12px;
        font-size: 16px;
        min-height: 40px;
    }
    
    .form-row {
        gap: 8px;
    }
    
    .modal-footer {
        padding: 10px 12px;
        gap: 6px;
    }
    
    .btn-cancel, .btn-save {
        padding: 8px 12px;
        font-size: 12px;
        min-height: 36px;
    }
}

@media (max-width: 360px) {
    .reminder-header {
        margin: 0 6px 6px 6px;
    }
    
    .header-content {
        padding: 8px;
    }
    
    .page-title h1 {
        font-size: 16px;
        margin-bottom: 2px;
    }
    
    .page-title p {
        font-size: 11px;
    }
    
    .tab-section {
        margin: 0 6px 6px 6px;
    }
    
    .tab-content-body {
        padding: 8px;
    }
    
    .tab-button {
        padding: 6px 8px;
        font-size: 10px;
    }
    
    .action-bar {
        gap: 8px;
    }
    
    .search-input {
        padding: 6px 10px 6px 32px;
        font-size: 16px;
        min-height: 36px;
    }
    
    .search-icon {
        width: 10px;
        height: 10px;
        left: 10px;
    }
    
    .action-buttons {
        gap: 4px;
    }
    
    .btn-primary, .btn-secondary {
        padding: 8px 12px;
        font-size: 11px;
        min-height: 36px;
    }
    
    .reminder-table {
        font-size: 9px;
        min-width: 350px;
    }
    
    .reminder-table th,
    .reminder-table td {
        padding: 6px 3px;
    }
    
    .reminder-table th {
        font-size: 8px;
    }
    
    .reminder-table td {
        font-size: 9px;
    }
    
    .no-data-cell {
        padding: 20px 6px !important;
    }
    
    .no-data-content h3 {
        font-size: 13px;
    }
    
    .no-data-content p {
        font-size: 10px;
    }
    
    .no-data-content svg {
        width: 28px;
        height: 28px;
    }
    
    .day-selector {
        gap: 2px;
    }
    
    .day-label {
        width: 24px;
        height: 24px;
        font-size: 9px;
    }
    
    .email-section {
        padding: 8px;
        margin-top: 8px;
    }
    
    .section-header h4 {
        font-size: 12px;
    }
    
    .email-list-header h5 {
        font-size: 11px;
    }
    
    .btn-add-email {
        padding: 4px 8px;
        font-size: 10px;
        min-height: 32px;
    }
    
    .email-list {
        padding: 8px;
    }
    
    .empty-email-list svg {
        width: 18px;
        height: 18px;
    }
    
    .empty-email-list p {
        font-size: 10px;
    }
    
    /* Modal Responsive */
    .modal-dialog {
        margin: 2px;
        max-width: calc(100% - 4px);
    }
    
    .modal-header {
        padding: 8px 10px;
    }
    
    .modal-title {
        font-size: 13px;
    }
    
    .modal-body {
        padding: 10px;
    }
    
    .modal-description {
        padding: 6px 8px;
        margin-bottom: 10px;
    }
    
    .modal-description svg {
        width: 14px;
        height: 14px;
    }
    
    .modal-description p {
        font-size: 10px;
    }
    
    .form-group {
        margin-bottom: 8px;
    }
    
    .form-label {
        font-size: 10px;
        margin-bottom: 2px;
    }
    
    .form-control {
        padding: 6px 10px;
        font-size: 16px;
        min-height: 36px;
    }
    
    .form-row {
        gap: 6px;
    }
    
    .modal-footer {
        padding: 8px 10px;
        gap: 4px;
    }
    
    .btn-cancel, .btn-save {
        padding: 6px 10px;
        font-size: 11px;
        min-height: 32px;
    }
}

/* Focus states for accessibility */
.btn-primary:focus,
.btn-secondary:focus,
.search-input:focus,
.form-control:focus,
.tab-button:focus,
.btn-cancel:focus,
.btn-save:focus,
.btn-add-email:focus {
    outline: 2px solid #3b82f6;
    outline-offset: 2px;
}

/* Smooth animations */
* {
    transition: all 0.2s ease;
}

/* Icon improvements */
.btn-primary svg,
.btn-secondary svg,
.tab-button svg,
.btn-add-email svg {
    flex-shrink: 0;
}
</style>
@endsection