# Asset Compilation Guide

## Overview
This project uses Vite for asset compilation and management. CSS and JS files need to be compiled before they can be served by Laravel.

## Setup

### 1. Install Dependencies
```bash
npm install
```

### 2. Development Mode
For development with auto-recompilation:
```bash
npm run dev
```

### 3. Production Build
For production deployment:
```bash
npm run build
```

### 4. Watch Mode
For development with file watching:
```bash
npm run watch
```

## File Structure

### CSS Files
- Source: `resources/css/`
- Compiled: `public/build/assets/css/`

### JS Files
- Source: `resources/js/`
- Compiled: `public/build/assets/js/`

## Adding New CSS Files

1. Place your CSS file in `resources/css/`
2. Add it to `vite.config.js` in the `input` array
3. Use `@vite(['resources/css/your-file.css'])` in Blade templates
4. Run `npm run build` to compile

## Adding New JS Files

1. Place your JS file in `resources/js/`
2. Add it to `vite.config.js` in the `input` array
3. Use `@vite(['resources/js/your-file.js'])` in Blade templates
4. Run `npm run build` to compile

## Troubleshooting

### CSS Not Loading
1. Check if the file is in `resources/css/`
2. Verify it's added to `vite.config.js`
3. Make sure you're using `@vite()` directive in Blade templates
4. Run `npm run build` to recompile

### JS Not Loading
1. Check if the file is in `resources/js/`
2. Verify it's added to `vite.config.js`
3. Make sure you're using `@vite()` directive in Blade templates
4. Run `npm run build` to recompile

## Current Compiled Assets

- `incident-form.css` → `public/build/assets/css/incident-form-[hash].css`
- `app.js` → `public/build/assets/js/app-[hash].js`
- `app.css` → `public/build/assets/css/app-[hash].css`

## Notes

- Always run `npm run build` after making changes to CSS/JS files
- The `[hash]` in filenames ensures proper cache busting
- Never edit files directly in the `public/build/` directory
- Use `npm run dev` for development with hot reloading
