<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Accept");

require 'vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Read incoming JSON
$data = json_decode(file_get_contents("php://input"), true);

// Validate input
if (
    empty($data['to']) ||
    empty($data['subject']) ||
    empty($data['message'])
) {
    http_response_code(400);
    echo json_encode(["success" => false, "error" => "Missing required fields"]);
    exit;
}

// Validate email format
if (!filter_var($data['to'], FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(["success" => false, "error" => "Invalid email format"]);
    exit;
}

$mail = new PHPMailer(true);

try {
    // SMTP Configuration
    $mail->isSMTP();
    $mail->Host = 'titandrillingzm.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'support@titandrillingzm.com';
    $mail->Password = '1L$%o5Xl8v*Wr*vL';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port = 465;

    // Email Content
    $mail->setFrom('support@titandrillingzm.com', 'Titan Drilling');
    $mail->addAddress($data['to']);
    $mail->isHTML(true);
    $mail->Subject = $data['subject'];
    
    // Enhanced HTML email body
    $mail->Body = '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Titan Drilling Email</title>
    </head>
    <body style="margin: 0; padding: 0; font-family: Arial, Helvetica, sans-serif; background-color: #f4f4f4;">
        <table role="presentation" width="100%" style="max-width: 600px; margin: 20px auto; background-color: #ffffff; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            <tr>
                <td style="padding: 20px; text-align: center; background-color: #0055A5; border-radius: 8px 8px 0 0;">
                    <img src="https://titandrillingzm.com/AppAutomationEmail/TitanDrilling_Logo.jpg" alt="Titan Drilling Logo" style="max-width: 200px; height: auto; display: block; margin: 0 auto;">
                </td>
            </tr>
            <tr>
                <td style="padding: 30px;">
                    <h1 style="color: #003087; font-size: 24px; margin: 0 0 20px; text-align: center;">' . htmlspecialchars($data['subject']) . '</h1>
                    <div style="color: #333333; font-size: 16px; line-height: 1.6; margin-bottom: 20px;">
                        ' . nl2br(htmlspecialchars($data['message'])) . '
                    </div>
                    <hr style="border: 0; border-top: 1px solid #e0e0e0; margin: 20px 0;">
                    <p style="color: #666666; font-size: 14px; text-align: center; margin: 0;">
                        &copy; ' . date('Y') . ' Titan Drilling. All rights reserved.<br>
                        <a href="https://titandrillingzm.com" style="color: #003087; text-decoration: none;">Visit our website</a>
                    </p>
                </td>
            </tr>
        </table>
    </body>
    </html>';

    $mail->AltBody = strip_tags($data['message']);

    $mail->send();
    echo json_encode(["success" => true, "message" => "Email sent successfully"]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "error" => "Failed to send email: " . $mail->ErrorInfo]);
}
?>