import React from 'react';
import { View, Text, TouchableOpacity, StyleSheet } from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';

const HomaUploadbtn = ({
  onUploadEquipment,
  onUploadUsers,
  loadingEquipment,
  loadingUsers,
}) => {
  return (
    <View style={styles.container}>
      <TouchableOpacity
        style={[styles.buttonWrapper, loadingEquipment && styles.buttonDisabled]}
        onPress={onUploadEquipment}
        disabled={loadingEquipment}
        activeOpacity={0.8}
      >
        <LinearGradient colors={['#ffd205', '#0055A5']} style={styles.button}>
          <MaterialIcons name="cloud-upload" size={20} color="#fff" />
          <Text style={styles.text}>
            {loadingEquipment ? 'Uploading Equipment…' : 'Upload Equipment'}
          </Text>
        </LinearGradient>
      </TouchableOpacity>

      <TouchableOpacity
        style={[styles.buttonWrapper, loadingUsers && styles.buttonDisabled]}
        onPress={onUploadUsers}
        disabled={loadingUsers}
        activeOpacity={0.8}
      >
        <LinearGradient colors={['#ffd205', '#0055A5']} style={styles.button}>
          <MaterialIcons name="cloud-upload" size={20} color="#fff" />
          <Text style={styles.text}>
            {loadingUsers ? 'Uploading Users…' : 'Upload GlobalUsers'}
          </Text>
        </LinearGradient>
      </TouchableOpacity>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    width: '100%',
    alignItems: 'center',
    marginTop: 12,
    marginBottom: 18,
  },
  buttonWrapper: {
    width: 220,
    borderRadius: 6,
    overflow: 'hidden',
    marginVertical: 6,
  },
  buttonDisabled: {
    opacity: 0.65,
  },
  button: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    height: 44,
    paddingHorizontal: 12,
  },
  text: {
    color: '#fff',
    fontSize: 15,
    fontWeight: '700',
    marginLeft: 10,
  },
});

export default HomaUploadbtn;