<?php
/**
 * Complete FCM Testing File
 * Upload this to your server and access via browser to test everything
 */

header('Content-Type: text/html; charset=utf-8');

echo "<h1>Complete FCM Testing for Titan Drilling</h1>";
echo "<p>This page will help you test your FCM setup completely.</p>";

// Your Firebase configuration
$firebaseConfig = [
    'apiKey' => 'AIzaSyBUk_ddoTBctL3gcniqiEer0rRVEzTjVx0',
    'databaseURL' => 'https://titan-drilling-1f8e9-default-rtdb.firebaseio.com',
    'projectId' => 'titan-drilling-1f8e9',
    'projectNumber' => '749788854975'
];

echo "<h2>Your Firebase Configuration:</h2>";
echo "<ul>";
echo "<li><strong>Project ID:</strong> {$firebaseConfig['projectId']}</li>";
echo "<li><strong>Project Number:</strong> {$firebaseConfig['projectNumber']}</li>";
echo "<li><strong>API Key:</strong> {$firebaseConfig['apiKey']}</li>";
echo "<li><strong>Database URL:</strong> {$firebaseConfig['databaseURL']}</li>";
echo "</ul>";

echo "<hr>";

echo "<h2>Test 1: Firebase Database Access</h2>";

// Test Firebase database access
$url = $firebaseConfig['databaseURL'] . '/Globalusers/admins.json';
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    echo "<p style='color: green;'>✅ Firebase database accessible</p>";
    $data = json_decode($response, true);
    if ($data) {
        $tokenCount = 0;
        $users = [];
        foreach ($data as $userId => $userData) {
            if (isset($userData['NotificationFCMtoken'])) {
                $tokenCount++;
                $users[] = $userId;
            }
        }
        echo "<p>Found <strong>{$tokenCount}</strong> FCM tokens in database</p>";
        if ($tokenCount > 0) {
            echo "<p>Users with tokens:</p><ul>";
            foreach ($users as $userId) {
                echo "<li>{$userId}</li>";
            }
            echo "</ul>";
        }
    } else {
        echo "<p>No data found in database</p>";
    }
} else {
    echo "<p style='color: red;'>❌ Cannot access Firebase database (HTTP {$httpCode})</p>";
}

echo "<hr>";

echo "<h2>Test 2: PHP API Connection</h2>";

// Test PHP API connection
$apiUrl = 'https://owninfotech.com/titanNotificationsFCM.php?action=test_connection';
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    $result = json_decode($response, true);
    if ($result && $result['success']) {
        echo "<p style='color: green;'>✅ PHP API is working correctly</p>";
        echo "<p>Server: {$result['server']}</p>";
        echo "<p>Timestamp: {$result['timestamp']}</p>";
    } else {
        echo "<p style='color: red;'>❌ PHP API returned error</p>";
        echo "<p>Response: " . htmlspecialchars($response) . "</p>";
    }
} else {
    echo "<p style='color: red;'>❌ Cannot access PHP API (HTTP {$httpCode})</p>";
}

echo "<hr>";

echo "<h2>Test 3: FCM Server Key Test</h2>";

// Test FCM Server Key if provided
if (isset($_GET['fcm_key']) && !empty($_GET['fcm_key'])) {
    $testKey = $_GET['fcm_key'];
    
    echo "<p><strong>Testing FCM Key:</strong> " . substr($testKey, 0, 20) . "...</p>";
    
    $testData = [
        'to' => 'test_token_123',
        'notification' => [
            'title' => 'Test Notification',
            'body' => 'This is a test notification'
        ]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: key=' . $testKey,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "<p>HTTP Code: {$httpCode}</p>";
    echo "<p>Response: " . htmlspecialchars($response) . "</p>";
    
    $result = json_decode($response, true);
    
    if ($httpCode === 200) {
        if ($result && isset($result['failure']) && $result['failure'] == 1) {
            echo "<p style='color: orange;'>⚠️ FCM API working but test token invalid (expected)</p>";
            echo "<p>Error: " . ($result['results'][0]['error'] ?? 'Unknown') . "</p>";
            echo "<p style='color: green;'>✅ <strong>This FCM Server Key is working!</strong></p>";
            echo "<p>You can now use this key in your titanNotificationsFCM.php file.</p>";
        } else {
            echo "<p style='color: green;'>✅ FCM API working correctly</p>";
        }
    } else {
        echo "<p style='color: red;'>❌ FCM API error</p>";
        if ($result && isset($result['error'])) {
            echo "<p>Error: " . $result['error'] . "</p>";
            
            if (strpos($result['error'], 'Unauthorized') !== false) {
                echo "<p style='color: red;'><strong>This key is not valid for FCM!</strong></p>";
                echo "<p>You need a different key that starts with 'AAAA...'</p>";
            }
        }
    }
} else {
    echo "<p>To test your FCM Server Key, add it as a parameter:</p>";
    echo "<p><code>?fcm_key=YOUR_ACTUAL_FCM_SERVER_KEY</code></p>";
    echo "<p><strong>Example:</strong> <code>?fcm_key=AAAA...</code></p>";
}

echo "<hr>";

echo "<h2>Test 4: Send Test Notification</h2>";

// Form to send test notification
echo "<form method='POST' action=''>";
echo "<p><strong>Title:</strong> <input type='text' name='test_title' value='Test Notification' style='width: 300px;'></p>";
echo "<p><strong>Message:</strong> <textarea name='test_message' style='width: 300px; height: 100px;'>This is a test notification from Titan Drilling</textarea></p>";
echo "<p><strong>FCM Key:</strong> <input type='text' name='test_fcm_key' placeholder='Enter your FCM Server Key' style='width: 400px;'></p>";
echo "<p><input type='submit' name='send_test' value='Send Test Notification' style='background: #007AFF; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;'></p>";
echo "</form>";

// Handle test notification
if (isset($_POST['send_test']) && !empty($_POST['test_fcm_key'])) {
    $testKey = $_POST['test_fcm_key'];
    $testTitle = $_POST['test_title'] ?? 'Test Notification';
    $testMessage = $_POST['test_message'] ?? 'This is a test notification';
    
    echo "<h3>Test Results:</h3>";
    
    $testData = [
        'to' => 'test_token_123',
        'notification' => [
            'title' => $testTitle,
            'body' => $testMessage
        ]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: key=' . $testKey,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "<p>HTTP Code: {$httpCode}</p>";
    echo "<p>Response: " . htmlspecialchars($response) . "</p>";
    
    $result = json_decode($response, true);
    
    if ($httpCode === 200) {
        if ($result && isset($result['failure']) && $result['failure'] == 1) {
            echo "<p style='color: orange;'>⚠️ FCM API working but test token invalid (expected)</p>";
            echo "<p>Error: " . ($result['results'][0]['error'] ?? 'Unknown') . "</p>";
            echo "<p style='color: green;'>✅ <strong>FCM Server Key is working correctly!</strong></p>";
        } else {
            echo "<p style='color: green;'>✅ FCM API working correctly</p>";
        }
    } else {
        echo "<p style='color: red;'>❌ FCM API error</p>";
        if ($result && isset($result['error'])) {
            echo "<p>Error: " . $result['error'] . "</p>";
        }
    }
}

echo "<hr>";

echo "<h2>How to Find Your FCM Server Key</h2>";
echo "<h3>Method 1: Google Cloud Console (Recommended)</h3>";
echo "<ol>";
echo "<li>Go to <a href='https://console.cloud.google.com/' target='_blank'>Google Cloud Console</a></li>";
echo "<li>Select your project: <strong>{$firebaseConfig['projectId']}</strong></li>";
echo "<li>Go to <strong>APIs & Services</strong> → <strong>Credentials</strong></li>";
echo "<li>Look for <strong>API Keys</strong> or <strong>Service Account Keys</strong></li>";
echo "<li>Or go to <strong>APIs & Services</strong> → <strong>Library</strong></li>";
echo "<li>Search for <strong>Cloud Messaging API</strong> and enable it</li>";
echo "</ol>";

echo "<h3>Method 2: Direct Links</h3>";
echo "<ul>";
echo "<li><a href='https://console.cloud.google.com/apis/credentials?project={$firebaseConfig['projectId']}' target='_blank'>Google Cloud Console - Credentials</a></li>";
echo "<li><a href='https://console.firebase.google.com/project/{$firebaseConfig['projectId']}/settings' target='_blank'>Firebase Console - Project Settings</a></li>";
echo "<li><a href='https://console.cloud.google.com/apis/library/fcm.googleapis.com?project={$firebaseConfig['projectId']}' target='_blank'>Enable Cloud Messaging API</a></li>";
echo "</ul>";

echo "<hr>";

echo "<h2>Next Steps</h2>";
echo "<ol>";
echo "<li>Find your FCM Server Key (should start with AAAA...)</li>";
echo "<li>Test it using the form above</li>";
echo "<li>Update titanNotificationsFCM.php with the correct key</li>";
echo "<li>Generate FCM tokens in your app</li>";
echo "<li>Test sending notifications from your app</li>";
echo "</ol>";

echo "<hr>";
echo "<p><strong>Current User ID from your app:</strong> cahj3jJqe5Z16pQdLGSWrNgm84o1</p>";
echo "<p><strong>Expected FCM token path:</strong> /Globalusers/admins/cahj3jJqe5Z16pQdLGSWrNgm84o1/NotificationFCMtoken</p>";
?> 