# Incident Report Form - Blade Implementation

This document describes the new Blade-based incident report form that replicates all the functionality from the React Native version.

## Features

### ✅ Complete Feature Parity with React Native Version

1. **Multi-Step Form Navigation**
   - Step 1: Basic Information (Incident Details, Location, Equipment, Incident Types)
   - Step 2: Additional Details (Weather, Activity, Images)
   - Step 3: Generate Report (Summary and Submission)

2. **Form Validation**
   - Real-time field validation
   - Required field checking
   - Email format validation
   - Custom validation for incident types and equipment involvement

3. **GPS Location Integration**
   - Get current location using browser geolocation API
   - Reverse geocoding to get address from coordinates
   - Fallback to coordinates if address lookup fails

4. **Dynamic Form Behavior**
   - Country/Project mapping (Zambia/DRC with respective projects)
   - Auto-generated incident numbers based on country and project
   - Conditional fields (equipment details, other incident category)
   - Dynamic incident type selection

5. **Image Upload**
   - Support for up to 8 images
   - Image preview functionality
   - File type and size validation (5MB max)
   - Drag and drop interface

6. **Data Persistence**
   - Form data stored in Firebase
   - Automatic PDF generation
   - Incident number generation with proper sequencing

## File Structure

```
resources/views/inspection/
├── create_incident_report.blade.php    # Main form template
├── incident_report.blade.php           # Updated with new button link

public/css/
└── incident-form.css                   # Complete styling

public/js/
└── incident-form.js                    # All JavaScript functionality

app/Http/Controllers/
└── IncidentController.php              # Updated with new method

routes/
└── web.php                             # Updated with new route
```

## Usage

### Accessing the Form

1. Navigate to the Incident Report page: `/inspection/incident_report`
2. Click the "Create Incident" button
3. This will redirect to: `/inspection/create-incident-report`

### Form Workflow

1. **Step 1 - Basic Information**
   - Select country (Zambia/DRC)
   - Select project (dynamically populated based on country)
   - Incident number auto-generates
   - Select incident category
   - Enter incident area
   - Specify equipment involvement
   - Select incident types (checkboxes)
   - Get GPS location (optional)

2. **Step 2 - Additional Details**
   - Weather condition
   - Vehicle activity
   - Incident cause description
   - Equipment damage description
   - Additional comments
   - Reporter information
   - Upload up to 8 images

3. **Step 3 - Generate Report**
   - Review summary
   - Submit form to create incident report
   - PDF automatically generated

## Technical Implementation

### JavaScript Class Structure

```javascript
class IncidentForm {
    constructor()           // Initialize form
    bindEvents()           // Bind all event listeners
    validateStep()         // Validate current step
    nextStep()            // Move to next step
    prevStep()            // Move to previous step
    submitForm()          // Submit form data
    getCurrentLocation()  // Get GPS coordinates
    generateIncidentNumber() // Generate unique incident number
    // ... other methods
}
```

### CSS Architecture

- CSS Custom Properties for consistent theming
- Responsive design with mobile-first approach
- Modern card-based layout
- Smooth animations and transitions
- Accessibility-focused styling

### Backend Integration

- Laravel Blade templating
- CSRF protection
- Form validation
- Firebase integration for data storage
- PDF generation support

## Configuration

### Country/Project Mapping

The form supports the following country-project combinations:

**Zambia:**
- Kansanshi
- Kalumbila
- Kimteto
- Kobold
- FQM Exploration
- Mimosa

**DRC:**
- Lubumbashi
- Musompo
- IME
- Kamoa

### Incident Number Format

Format: `{COUNTRY_CODE}-{PROJECT_CODE}-INC-{NUMBER}`

Examples:
- `ZAM-KAN-INC-001`
- `DRC-MUS-INC-001`

## API Endpoints

- `GET /inspection/create-incident-report` - Display form
- `POST /inspection/generate-incident-number` - Generate incident number
- `POST /inspection/store-incident` - Store incident data

## Dependencies

- Bootstrap 5 (for modals and alerts)
- Font Awesome (for icons)
- Browser Geolocation API
- BigDataCloud Geocoding API (free alternative to Google Maps)

## Browser Compatibility

- Modern browsers with ES6+ support
- Geolocation API support
- File API support for image uploads
- FormData API for file uploads

## Security Features

- CSRF token protection
- File type validation
- File size limits
- Input sanitization
- XSS protection through Blade templating

## Performance Optimizations

- Lazy loading of form steps
- Image preview without server upload
- Efficient DOM manipulation
- Minimal external dependencies
- Optimized CSS with custom properties

## Future Enhancements

- Offline form support with localStorage
- Real-time form validation
- Advanced image editing
- Multi-language support
- Advanced reporting features
- Integration with external mapping services

## Troubleshooting

### Common Issues

1. **GPS Location Not Working**
   - Ensure HTTPS is enabled
   - Check browser permissions
   - Verify geolocation API support

2. **Image Upload Issues**
   - Check file size (max 5MB)
   - Verify file type (images only)
   - Ensure proper form encoding

3. **Form Validation Errors**
   - Check required fields
   - Verify email format
   - Ensure at least one incident type selected

### Debug Mode

Enable browser console logging by setting:
```javascript
localStorage.setItem('debug', 'true');
```

## Support

For technical support or feature requests, please refer to the development team or create an issue in the project repository.

