# Team KPI Reporting - MongoDB Migration Plan

## Overview
Migrating all Team KPI Reporting pages from Firebase to MongoDB backends.

## Files to Update (7 files with Firebase):
1. ✅ SupervisorKPI.blade.php
2. ✅ EmployeesKPI.blade.php  
3. ✅ EmployeesClosed.blade.php
4. ✅ EmployeesParticipated.blade.php
5. ✅ InspectionsClosed.blade.php
6. ✅ InspectionsOpened.blade.php
7. ✅ EquipmentStatus.blade.php
8. ✅ SitesKPI.blade.php (no Firebase - navigation only)
9. ✅ TeamKPIHome.blade.php (no Firebase - navigation only)

## MongoDB Backend APIs Required

### Available Backend APIs:
- **GlobalAdminUsersHandle.js** (Port 5003) - `/users/all`
  - Users/Team members data
  
- **GlobalInspectionHandler.js** (Port 5004) - `/inspections/all`
  - GlobalInspectionReport data
  
- **GlobalJobcardReports.js** (Port 5005) - `/jobcards/all`
  - GlobalWorkOrders data (job cards)
  
- **GlobalRequestMaintenanceHandler.js** (Port 5009) - `/maintenance/all`
  - GlobalRequestMaintenancereport data
  
- **GlobalServiceSchdule.js** (Port 5010) - `/service-schedules/all`
  - GlobalServiceSchdule data

- **GlobalEquipmentJsonData.js** (Port 5001) - `/equipment/all`
  - GlobalEquipments data

- **FuelLogHandle.js** (Port 5011) - `/fuel-logs/all`
  - GlobalFuelLog data

## Common Changes Needed

### 1. Remove Firebase SDK:
```html
<!-- Remove these -->
<script src="https://www.gstatic.com/firebasejs/..."></script>
```

### 2. Add MongoDB API Configuration:
```javascript
const API_BASE_URL = {
    users: 'http://168.231.113.219:5003',
    inspections: 'http://168.231.113.219:5006',
    workOrders: 'http://168.231.113.219:5007',
    maintenance: 'http://168.231.113.219:5008',
    serviceSchedules: 'http://168.231.113.219:5009',
    equipment: 'http://168.231.113.219:5010'
};
```

### 3. Date Formatting:
```javascript
function formatDate(dateValue) {
    // day/month/year HH:MM:SS
}

function formatDateOnly(dateValue) {
    // day/month/year
}
```

### 4. Update Chart.js to v4.4.0

### 5. Replace Firebase calls with fetch() to MongoDB APIs

## Data Mapping

### Users (from GlobalUsers collection):
- _id, name, email, employeeNumber
- role, department, countries, projects
- loginStatus, createdAt, updatedAt

### Inspections (from GlobalInspectionReport):
- _id, adminUid, equipmentName, equipmentNo
- inspectionType, status, country, project
- inspectorName, inspectionDate, createdAt

### Work Orders (from GlobalWorkOrders):
- _id, adminUid, requestNumber
- equipmentName, equipmentNo, workOrderType
- status, country, project, createdAt

### Maintenance (from GlobalRequestMaintenancereport):
- _id, adminUid, requestNumber
- equipmentName, maintenanceType, status
- country, project, requestDate, createdAt

### Service Schedules (from GlobalServiceScheduled):
- _id, adminUid, scheduleNumber
- equipmentName, serviceType, status
- scheduledDate, completedDate, createdAt

## Migration Strategy

1. **Check existing MongoDB backends** - verify ports and endpoints
2. **Create missing backends** if needed
3. **Update each file** with MongoDB fetch calls
4. **Add date formatting** helpers
5. **Update Chart.js** to v4.4.0
6. **Test each page** individually

## Implementation Order

1. Start with SupervisorKPI (most complex)
2. Then EmployeesKPI
3. Then simpler pages (InspectionsClosed, InspectionsOpened)
4. Finally EmployeesClosed, EmployeesParticipated, EquipmentStatus

