<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('incident_reports', function (Blueprint $table) {
            $table->id();
            $table->string('incident_number')->unique();
            $table->string('country');
            $table->string('project');
            $table->datetime('incident_date');
            $table->string('location');
            $table->text('incident_types');
            $table->string('incident_area')->nullable();
            $table->enum('involves_equipment', ['yes', 'no']);
            $table->string('incident_category');
            $table->string('severity');
            $table->string('weather_condition');
            $table->string('vehicle_activity');
            $table->string('vehicle_category')->nullable();
            $table->string('operator_name')->nullable();
            $table->string('equipment_display')->nullable();
            $table->string('vehicle_number')->nullable();
            $table->string('vehicle_name')->nullable();
            $table->string('vin_number')->nullable();
            $table->text('incident_cause')->nullable();
            $table->text('equipment_damage')->nullable();
            $table->text('additional_comment')->nullable();
            $table->string('reported_by')->nullable();
            $table->json('image_paths')->nullable();
            $table->string('pdf_path')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('incident_reports');
    }
};
