@extends('welcome')

@section('title', 'Excel Report')

@section('content')
<div class="excel-report-container">
    <div class="excel-report-header">
        <div class="header-content">
            <div class="page-title">
                <h1>Analytics & Excel Reports</h1>
                <p>Generate comprehensive reports and view analytics dashboards</p>
            </div>
        </div>
    </div>
    
    <div class="excel-report-content">
        <div class="content-box">
            <div class="action-bar">
                <div class="action-content">
                    <div class="page-title">
                        <h1>Analytics Report</h1>
                    </div>
                    <div class="action-buttons">
                        <button class="btn-create" onclick="exportAllReports()">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
                                <polyline points="7,10 12,15 17,10"/>
                                <line x1="12" y1="15" x2="12" y2="3"/>
                            </svg>
                            Export All Reports
                        </button>
                        <button class="btn-secondary" onclick="refreshCharts()">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="23,4 23,10 17,10"/>
                                <polyline points="1,20 1,14 7,14"/>
                                <path d="M20.49 9A9 9 0 0 0 5.64 5.64L1 10m22 4l-4.64 4.36A9 9 0 0 1 3.51 15"/>
                            </svg>
                            Refresh Charts
                        </button>
                    </div>
                </div>
            </div>
            <div class="reports-section">
                <div class="reports-grid">
                    <!-- Report Card Template -->
                    <div class="report-card" data-report="incident">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                    <polyline points="10,9 9,9 8,9"/>
                                </svg>
                            </div>
                            <h3>Incident Report</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="incident-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="incident-start-date" name="incident_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="incident-end-date">End Date</label>
                                    <input type="date" class="form-control" id="incident-end-date" name="incident_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M9 12l2 2 4-4"/>
                                    <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                                    <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                                    <path d="M12 3c0 1-1 3-3 3s-3-2-3-3 1-3 3-3 3 2 3 3"/>
                                    <path d="M12 21c0-1 1-3 3-3s3 2 3 3-1 3-3 3-3-2-3-3"/>
                                </svg>
                            </div>
                            <h3>Inspection</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="inspection-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="inspection-start-date" name="inspection_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="inspection-end-date">End Date</label>
                                    <input type="date" class="form-control" id="inspection-end-date" name="inspection_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                    
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                                    <circle cx="9" cy="7" r="4"/>
                                    <path d="M22 21v-2a4 4 0 0 0-3-3.87"/>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                                </svg>
                            </div>
                            <h3>Operator Daily Reporting</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="operator-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="operator-start-date" name="operator_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="operator-end-date">End Date</label>
                                    <input type="date" class="form-control" id="operator-end-date" name="operator_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                </div>
                <div class="reports-grid">
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                                    <line x1="16" y1="2" x2="16" y2="6"/>
                                    <line x1="8" y1="2" x2="8" y2="6"/>
                                    <line x1="3" y1="10" x2="21" y2="10"/>
                                </svg>
                            </div>
                            <h3>Completed Schedule</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="schedule-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="schedule-start-date" name="schedule_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="schedule-end-date">End Date</label>
                                    <input type="date" class="form-control" id="schedule-end-date" name="schedule_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                    
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 3h18v18H3zM9 9h6v6H9z"/>
                                    <path d="M9 1v6"/>
                                    <path d="M15 1v6"/>
                                    <path d="M9 17v6"/>
                                    <path d="M15 17v6"/>
                                    <path d="M1 9h6"/>
                                    <path d="M17 9h6"/>
                                    <path d="M1 15h6"/>
                                    <path d="M17 15h6"/>
                                </svg>
                            </div>
                            <h3>Consolidate Fuel Report</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="fuel-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="fuel-start-date" name="fuel_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="fuel-end-date">End Date</label>
                                    <input type="date" class="form-control" id="fuel-end-date" name="fuel_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                    
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 3h18v18H3zM9 9h6v6H9z"/>
                                    <path d="M9 1v6"/>
                                    <path d="M15 1v6"/>
                                    <path d="M9 17v6"/>
                                    <path d="M15 17v6"/>
                                    <path d="M1 9h6"/>
                                    <path d="M17 9h6"/>
                                    <path d="M1 15h6"/>
                                    <path d="M17 15h6"/>
                                </svg>
                            </div>
                            <h3>Fuel Log</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="log-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="log-start-date" name="log_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="log-end-date">End Date</label>
                                    <input type="date" class="form-control" id="log-end-date" name="log_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                </div>
                <div class="reports-grid">
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 3h18v18H3zM9 9h6v6H9z"/>
                                    <path d="M9 1v6"/>
                                    <path d="M15 1v6"/>
                                    <path d="M9 17v6"/>
                                    <path d="M15 17v6"/>
                                    <path d="M1 9h6"/>
                                    <path d="M17 9h6"/>
                                    <path d="M1 15h6"/>
                                    <path d="M17 15h6"/>
                                </svg>
                            </div>
                            <h3>Fuel Bunker History</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="bunker-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="bunker-start-date" name="bunker_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="bunker-end-date">End Date</label>
                                    <input type="date" class="form-control" id="bunker-end-date" name="bunker_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                    
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                    <polyline points="10,9 9,9 8,9"/>
                                </svg>
                            </div>
                            <h3>Workorder</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="workorder-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="workorder-start-date" name="workorder_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="workorder-end-date">End Date</label>
                                    <input type="date" class="form-control" id="workorder-end-date" name="workorder_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                    
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 3h18v18H3zM9 9h6v6H9z"/>
                                    <path d="M9 1v6"/>
                                    <path d="M15 1v6"/>
                                    <path d="M9 17v6"/>
                                    <path d="M15 17v6"/>
                                    <path d="M1 9h6"/>
                                    <path d="M17 9h6"/>
                                    <path d="M1 15h6"/>
                                    <path d="M17 15h6"/>
                                </svg>
                            </div>
                            <h3>Parts Consumption Report</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="parts-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="parts-start-date" name="parts_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="parts-end-date">End Date</label>
                                    <input type="date" class="form-control" id="parts-end-date" name="parts_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                </div>
                <div class="reports-grid">
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M19 17h2l.64-2.54A6 6 0 0 0 20 7a6 6 0 0 0-6-6H6a6 6 0 0 0-6 6c0 2.34 1.95 4.18 4.35 4.46L7 17h2"/>
                                    <path d="M14 11a5 5 0 0 0-10 0"/>
                                </svg>
                            </div>
                            <h3>Vehicle Report</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="vehicle-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="vehicle-start-date" name="vehicle_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="vehicle-end-date">End Date</label>
                                    <input type="date" class="form-control" id="vehicle-end-date" name="vehicle_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                    
                    <div class="report-card">
                        <div class="report-header">
                            <div class="report-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14.7 6.3a1 1 0 0 0 0 1.4l1.6 1.6a1 1 0 0 0 1.4 0l3.77-3.77a6 6 0 0 1-7.94 7.94l-6.91 6.91a2.12 2.12 0 0 1-3-3l6.91-6.91a6 6 0 0 1 7.94-7.94l-3.76 3.76z"/>
                                </svg>
                            </div>
                            <h3>Tool Issued/Return Report</h3>
                        </div>
                        <form class="report-form" action="">
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="tool-start-date">Start Date</label>
                                    <input type="date" class="form-control" id="tool-start-date" name="tool_start_date">
                                </div>
                                <div class="form-group">
                                    <label for="tool-end-date">End Date</label>
                                    <input type="date" class="form-control" id="tool-end-date" name="tool_end_date">
                                </div>
                            </div>
                            <button type="submit" class="btn-export">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 7c0-1.886 0-2.828.586-3.414S5.114 3 7 3h10c1.886 0 2.828 0 3.414.586S21 5.114 21 7v10c0 1.886 0 2.828-.586 3.414S18.886 21 17 21H7c-1.886 0-2.828 0-3.414-.586S3 18.886 3 17z"/>
                                    <path d="M3 12c0 .932 0 1.398.152 1.765a2 2 0 0 0 1.083 1.083C4.602 15 5.068 15 6 15h.675c.581 0 .872 0 1.104.134a1 1 0 0 1 .164.118c.2.178.292.453.476 1.005l.125.375c.22.66.33.99.592 1.18c.262.188.61.188 1.306.188h3.117c.695 0 1.043 0 1.305-.189s.372-.518.592-1.178l.125-.376c.184-.552.276-.827.476-1.005a1 1 0 0 1 .164-.118c.232-.134.523-.134 1.104-.134H18c.932 0 1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083C21 13.398 21 12.932 21 12M9.5 9.5L12 7m0 0l2.5 2.5M12 7v7"/>
                                </svg>
                                Excel Export
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="analytics-section">
                <div class="analytics-header">
                    <h2>Analytics Dashboard</h2>
                    <div class="year-selector">
                        <label for="year">Select Year:</label>
                        <select class="form-select" id="year" name="year">
                            <option value="">Select Year</option>
                            <option value="2025">2025</option>
                            <option value="2024">2024</option>
                            <option value="2023">2023</option>
                            <option value="2022">2022</option>
                            <option value="2021">2021</option>
                            <option value="2020">2020</option>
                            <option value="2019">2019</option>
                            <option value="2018">2018</option>
                            <option value="2017">2017</option>
                            <option value="2016">2016</option>
                            <option value="2015">2015</option>
                            <option value="2014">2014</option>
                            <option value="2013">2013</option>
                            <option value="2012">2012</option>
                            <option value="2011">2011</option>
                            <option value="2010">2010</option>
                            <option value="2009">2009</option>
                            <option value="2008">2008</option>
                            <option value="2007">2007</option>
                        </select>
                    </div>
                </div>
                <div class="charts-grid">
                    <div class="chart-card">
                        <div class="chart-header">
                            <h3>Inspection Conducted by Month</h3>
                        </div>
                        <div class="chart-container">
                            <canvas id="vehicle-status"></canvas>
                        </div>
                    </div>
                    
                    <div class="chart-card">
                        <div class="chart-header">
                            <h3>Good vs Faulty Inspection</h3>
                        </div>
                        <div class="chart-container">
                            <canvas id="good-faulty"></canvas>
                        </div>
                    </div>
                    
                    <div class="chart-card">
                        <div class="chart-header">
                            <h3>Action vs No Action Taken</h3>
                        </div>
                        <div class="chart-container">
                            <canvas id="action"></canvas>
                        </div>
                    </div>
                    
                    <div class="chart-card">
                        <div class="chart-header">
                            <h3>Top Running Vehicles</h3>
                        </div>
                        <div class="chart-container">
                            <canvas id="running"></canvas>
                        </div>
                    </div>
                </div>
                
                <div class="fuel-consumption-section">
                    <div class="chart-card full-width">
                        <div class="chart-header">
                            <h3>Top Fuel Consumption Vehicles</h3>
                        </div>
                        <div class="no-data-state">
                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M3 3h18v18H3zM9 9h6v6H9z"/>
                                <path d="M9 1v6"/>
                                <path d="M15 1v6"/>
                                <path d="M9 17v6"/>
                                <path d="M15 17v6"/>
                                <path d="M1 9h6"/>
                                <path d="M17 9h6"/>
                                <path d="M1 15h6"/>
                                <path d="M17 15h6"/>
                            </svg>
                            <p>No Data Available</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    <script>
        function toggleSidebar() {
            const sidebar = document.querySelector('.sidebar');
            sidebar.classList.toggle('collapsed');
        }
    </script>
</div>
<script>
    var dropdown = document.getElementsByClassName("dropdown-btn");
    var i;

    for (i = 0; i < dropdown.length; i++) {
        dropdown[i].addEventListener("click", function() {
            this.classList.toggle("active");
            var dropdownContent = this.nextElementSibling;
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        });
    }
</script>
<!-- Chart.js Library -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>
<script>
// Optimized Chart Initialization
(function() {
    'use strict';
    
    // Chart configuration
    const CHART_CONFIG = {
        months: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
        defaultColors: ["red", "green", "blue", "orange", "brown"],
        primaryColors: ["#0055A5", "#0055A1"],
        defaultOptions: {
            legend: { display: false },
            scales: {
                yAxes: [{ ticks: { beginAtZero: true } }]
            }
        }
    };

    // Chart data configurations
    const charts = [
        {
            id: "vehicle-status",
            title: "Inspection Conducted by Month",
            data: [],
            colors: CHART_CONFIG.defaultColors
        },
        {
            id: "good-faulty",
            title: "Good vs Faulty Inspection",
            data: [],
            colors: CHART_CONFIG.defaultColors
        },
        {
            id: "action",
            title: "Action vs No Action Taken",
            data: [],
            colors: CHART_CONFIG.defaultColors
        },
        {
            id: "running",
            title: "Top Running vehicles",
            data: [14000, 2340],
            colors: CHART_CONFIG.primaryColors,
            labels: ["vehicle-1", "vehicle-2"]
        }
    ];

    // Initialize all charts
    function initCharts() {
        charts.forEach(chart => {
            const config = {
        type: "bar",
        data: {
                    labels: chart.labels || CHART_CONFIG.months,
            datasets: [{
                        backgroundColor: chart.colors,
                        data: chart.data
            }]
        },
        options: {
                    ...CHART_CONFIG.defaultOptions,
            title: {
                display: true,
                        text: chart.title
                    }
                }
            };
            
            new Chart(chart.id, config);
        });
    }

    // Initialize charts when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initCharts);
    } else {
        initCharts();
    }
})();
</script>
@endsection

<style>
/* CSS Variables for better maintainability */
:root {
    --primary-color: #0055a5;
    --primary-hover: rgba(255, 255, 255, 0.2);
    --text-primary: #1e293b;
    --text-secondary: #374151;
    --text-muted: #64748b;
    --text-light: #cbd5e1;
    --bg-primary: #f8fafc;
    --bg-white: #ffffff;
    --border-color: #e2e8f0;
    --border-light: #cbd5e1;
    --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    --shadow-lg: 0 4px 8px rgba(239, 68, 68, 0.3);
    --radius-sm: 4px;
    --radius-md: 0;
    --transition-base: all 0.2s ease;
    --font-family: 'Inter', sans-serif;
    --z-index-notification: 9999;
}

/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* ===== MAIN CONTAINER ===== */
.excel-report-container {
    min-height: 100vh;
    background: var(--bg-primary);
    font-family: var(--font-family);
    padding: 0;
    margin: 0;
    overflow-x: hidden;
    overflow-y: visible;
}

/* ===== HEADER STYLES ===== */
.excel-report-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    padding: 2rem 0;
    margin-bottom: 0;
    box-shadow: var(--shadow-md);
    display: none;
}

.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

.page-title h1 {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--bg-white);
    margin: 0 0 0.5rem 0;
    letter-spacing: -0.025em;
}

.page-title p {
    font-size: 1.125rem;
    color: var(--text-light);
    margin: 0;
    font-weight: 400;
}

/* ===== MAIN CONTENT ===== */
.excel-report-content {
    padding: 0;
    background: var(--bg-primary);
    min-height: auto;
    overflow: visible;
}

.content-box {
    background: var(--bg-white);
    padding: 20px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--border-color);
    font-family: var(--font-family);
    margin-bottom: 1rem;
    margin: 0;
}

/* ===== ACTION BAR ===== */
.action-bar {
    background: transparent;
    border: none;
    border-radius: var(--radius-md);
    padding: 0;
    margin-bottom: 24px;
    box-shadow: none;
}

.action-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.page-title h1, .page-title h2 {
    color: var(--text-primary);
    font-weight: 700;
    font-size: 28px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0;
}

.action-buttons {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    flex-wrap: wrap;
}

/* ===== BUTTON STYLES ===== */
.btn-create,
.btn-secondary {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: var(--radius-md);
    font-size: 0.875rem;
    font-weight: 600;
    font-family: var(--font-family);
    cursor: pointer;
    transition: var(--transition-base);
    white-space: nowrap;
}

.btn-create {
    background: var(--primary-color);
    color: var(--bg-white);
}

.btn-create:hover {
    background: var(--primary-hover);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
    color: black !important;
}

.btn-secondary {
    background: var(--bg-white);
    color: var(--text-muted);
    border: 2px solid var(--border-color);
}

.btn-secondary:hover {
    background: var(--bg-primary);
    border-color: var(--border-light);
    color: var(--text-secondary);
    transform: translateY(-1px);
}

/* ===== REPORTS SECTION ===== */
.reports-section {
    margin-bottom: 1.5rem;
}

.reports-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.report-card {
    background: var(--bg-white);
    border: 1px solid var(--border-color);
    border-radius: var(--radius-md);
    padding: 1.25rem;
    box-shadow: var(--shadow-sm);
    transition: var(--transition-base);
}

.report-card:hover {
    box-shadow: var(--shadow-md);
    transform: translateY(-1px);
}

.report-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1.25rem;
    padding-bottom: 0.75rem;
    border-bottom: 1px solid var(--border-color);
}

.report-icon {
    width: 48px;
    height: 48px;
    background: var(--primary-color);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--bg-white);
    flex-shrink: 0;
}

.report-header h3 {
    font-size: 1.25rem;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
}

.report-form {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 0.75rem;
}

.form-group {
    display: flex;
    flex-direction: column;
}

.form-group label {
    font-weight: 600;
    color: var(--text-secondary);
    margin-bottom: 0.375rem;
    font-size: 0.8rem;
}

.form-control {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-sm);
    padding: 0.625rem 0.75rem;
    font-size: 0.8rem;
    font-weight: 500;
    color: var(--text-primary);
    background: var(--bg-white);
    transition: var(--transition-base);
    font-family: var(--font-family);
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.btn-export {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 0.625rem 1.25rem;
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    color: var(--bg-white);
    border: none;
    border-radius: var(--radius-sm);
    font-size: 0.8rem;
    font-weight: 600;
    font-family: var(--font-family);
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: 0 2px 4px rgba(239, 68, 68, 0.2);
    margin-top: 0.375rem;
    min-height: 44px;
}

.btn-export:hover {
    background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
    transform: translateY(-1px);
    /* box-shadow: var(--shadow-lg); */
}

/* ===== ANALYTICS SECTION ===== */
.analytics-section {
    margin-top: 3rem;
    padding-top: 2rem;
    border-top: 1px solid #e2e8f0;
}

.analytics-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
    flex-wrap: wrap;
    gap: 1rem;
}

.analytics-header h2 {
    font-size: 1.875rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}

.year-selector {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.year-selector label {
    font-weight: 600;
    color: #374151;
    font-size: 0.875rem;
}

.form-select {
    border: 2px solid #e2e8f0;
    border-radius: 0;
    padding: 0.75rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #1e293b;
    background: #ffffff;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
    min-width: 120px;
}

.form-select:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

/* ===== CHARTS SECTION ===== */
.charts-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.chart-card {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    padding: 1.25rem;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    transition: all 0.2s ease;
}

.chart-card:hover {
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
}

.chart-card.full-width {
    grid-column: 1 / -1;
}

.chart-header {
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 1px solid #e2e8f0;
}

.chart-header h3 {
    font-size: 1rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}

.chart-container {
    position: relative;
    height: 250px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.chart-container canvas {
    max-width: 100%;
    max-height: 100%;
}

/* ===== FUEL CONSUMPTION SECTION ===== */
.fuel-consumption-section {
    margin-top: 2rem;
}

.no-data-state {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 200px;
    color: #64748b;
    gap: 1rem;
}

.no-data-state svg {
    color: #cbd5e1;
}

.no-data-state p {
    font-size: 1rem;
    font-weight: 500;
    margin: 0;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 992px) {
    .reports-grid {
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 16px;
    }
    
    .charts-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }
}

@media (max-width: 768px) {
    .excel-report-container,
    .excel-report-content {
        padding: 0;
    }
    
    .content-box {
        padding: 16px;
        margin: 0;
        border-radius: var(--radius-md);
    }
    
    .page-title h1 {
        font-size: 24px;
        margin-bottom: 8px;
    }
    
    .action-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }
    
    .action-buttons {
        width: 100%;
        justify-content: flex-start;
        flex-wrap: wrap;
        gap: 8px;
    }
    
    .btn-create,
    .btn-secondary {
        padding: 12px 16px;
        font-size: 14px;
        min-height: 44px;
        width: 100%;
        justify-content: center;
    }
    
    .reports-grid {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .report-card {
        padding: 16px;
    }
    
    .report-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 8px;
    }
    
    .report-icon {
        width: 40px;
        height: 40px;
    }
    
    .report-header h3 {
        font-size: 18px;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .form-control {
        padding: 12px;
        font-size: 16px;
        min-height: 44px;
    }
    
    .btn-export {
        padding: 12px 16px;
        font-size: 14px;
        min-height: 44px;
        width: 100%;
    }
    
    .analytics-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }
    
    .analytics-header h2 {
        font-size: 20px;
    }
    
    .year-selector {
        width: 100%;
    }
    
    .form-select {
        width: 100%;
        padding: 12px;
        font-size: 16px;
        min-height: 44px;
    }
    
    .charts-grid {
        grid-template-columns: 1fr;
        gap: 12px;
    }
    
    .chart-card {
        padding: 16px;
    }
    
    .chart-header h3 {
        font-size: 16px;
    }
    
    .chart-container {
        height: 200px;
    }
}

@media (max-width: 576px) {
    .content-box {
        padding: 14px;
    }
    
    .page-title h1 {
        font-size: 22px;
    }
    
    .action-content {
        gap: 12px;
    }
    
    .action-buttons {
        gap: 6px;
    }
    
    .btn-create,
    .btn-secondary {
        padding: 10px 14px;
        font-size: 13px;
        min-height: 40px;
        width: 100%;
        justify-content: center;
    }
    
    .reports-grid {
        gap: 10px;
    }
    
    .report-card {
        padding: 14px;
    }
    
    .report-header h3 {
        font-size: 17px;
    }
    
    .form-control {
        padding: 10px;
        font-size: 15px;
        min-height: 40px;
    }
    
    .btn-export {
        padding: 10px 14px;
        font-size: 13px;
        min-height: 40px;
    }
    
    .analytics-header h2 {
        font-size: 19px;
    }
    
    .chart-container {
        height: 190px;
    }
}

@media (max-width: 480px) {
    .content-box {
        padding: 12px;
    }
    
    .page-title h1 {
        font-size: 20px;
    }
    
    .action-buttons {
        flex-direction: column;
        gap: 8px;
    }
    
    .btn-create,
    .btn-secondary {
        width: 100%;
        justify-content: center;
    }
    
    .report-card {
        padding: 12px;
    }
    
    .report-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 6px;
    }
    
    .report-icon {
        width: 36px;
        height: 36px;
    }
    
    .report-header h3 {
        font-size: 16px;
    }
    
    .form-control {
        padding: 10px;
        font-size: 16px;
    }
    
    .btn-export {
        padding: 10px 12px;
        font-size: 13px;
    }
    
    .analytics-header h2 {
        font-size: 18px;
    }
    
    .chart-card {
        padding: 12px;
    }
    
    .chart-header h3 {
        font-size: 14px;
    }
    
    .chart-container {
        height: 180px;
    }
    
    .no-data-state {
        height: 120px;
    }
}

/* ===== ACCESSIBILITY ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
}

/* ===== FOCUS STYLES ===== */
button:focus-visible,
input:focus-visible,
select:focus-visible {
    outline: 2px solid #3b82f6;
    outline-offset: 2px;
}

/* ===== ENHANCED RESPONSIVE DESIGN ===== */
@media (max-width: 992px) {
    .reports-grid {
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 16px;
    }
    
    .charts-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }
}

@media (max-width: 576px) {
    .content-box {
        padding: 14px;
    }
    
    .page-title h1 {
        font-size: 22px;
    }
    
    .action-content {
        gap: 12px;
    }
    
    .action-buttons {
        gap: 6px;
    }
    
    .btn-create,
    .btn-secondary {
        padding: 10px 14px;
        font-size: 13px;
        min-height: 40px;
        width: 100%;
        justify-content: center;
    }
    
    .reports-grid {
        gap: 10px;
    }
    
    .report-card {
        padding: 14px;
    }
    
    .report-header h3 {
        font-size: 17px;
    }
    
    .form-control {
        padding: 10px;
        font-size: 15px;
        min-height: 40px;
    }
    
    .btn-export {
        padding: 10px 14px;
        font-size: 13px;
        min-height: 40px;
    }
    
    .analytics-header h2 {
        font-size: 19px;
    }
    
    .chart-container {
        height: 190px;
    }
}


/* ===== PRINT STYLES ===== */
@media print {
    .action-bar,
    .btn-export,
    .btn-create,
    .btn-secondary {
        display: none !important;
    }
    
    .excel-report-container {
        background: white;
    }
    
    .excel-report-header {
        background: white;
        color: black;
    }
    
    .report-card,
    .chart-card {
        border: 1px solid #000;
        break-inside: avoid;
    }
}
</style>

<script>
// Optimized Excel Report Functionality
(function() {
    'use strict';
    
    // Configuration
    const CONFIG = {
        notificationTimeout: 5000,
        selectors: {
            reportForms: '.report-form',
            yearSelector: '#year'
        }
    };

    // Cached DOM elements
    let elements = {};
    
    // Initialize DOM elements
    function initElements() {
        elements = {
            reportForms: document.querySelectorAll(CONFIG.selectors.reportForms),
            yearSelector: document.querySelector(CONFIG.selectors.yearSelector)
        };
    }

    // Export all reports functionality
    window.exportAllReports = function() {
        console.log('Exporting all reports...');
        showNotification('Exporting all reports...', 'info');
        // Add export all logic here
    };
    
    // Refresh charts functionality
    window.refreshCharts = function() {
        console.log('Refreshing charts...');
        showNotification('Refreshing charts...', 'info');
        location.reload();
    };
    
    // Form submission handling
    function initFormHandlers() {
        elements.reportForms.forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            const reportType = this.closest('.report-card').querySelector('h3').textContent;
            
            console.log(`Exporting ${reportType}:`, Object.fromEntries(formData));
            showNotification(`${reportType} export started successfully!`, 'success');
        });
    });
    }
    
    // Year selector functionality
    function initYearSelector() {
        if (elements.yearSelector) {
            elements.yearSelector.addEventListener('change', function() {
            const selectedYear = this.value;
            if (selectedYear) {
                console.log('Year changed to:', selectedYear);
                refreshCharts();
            }
        });
        }
    }
    
    // Notification system
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `notification notification-${type}`;
        notification.innerHTML = `
            <div class="notification-content">
                <span>${message}</span>
                <button class="notification-close" aria-label="Close notification">&times;</button>
            </div>
        `;
        
        document.body.appendChild(notification);
        
        // Auto remove after timeout
        setTimeout(() => removeNotification(notification), CONFIG.notificationTimeout);
        
        // Close button functionality
        notification.querySelector('.notification-close').addEventListener('click', () => {
            removeNotification(notification);
        });
    }
    
    function removeNotification(notification) {
        if (notification && notification.parentNode) {
                notification.parentNode.removeChild(notification);
            }
    }
    
    // Add notification styles
    function addNotificationStyles() {
    const notificationStyles = document.createElement('style');
    notificationStyles.textContent = `
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
                z-index: var(--z-index-notification);
            padding: 1rem 1.5rem;
                border-radius: var(--radius-md);
                box-shadow: var(--shadow-md);
                font-family: var(--font-family);
            font-weight: 500;
            max-width: 400px;
            animation: slideIn 0.3s ease-out;
        }
        
        .notification-success {
            background: #10b981;
                color: var(--bg-white);
            border-left: 4px solid #059669;
        }
        
        .notification-error {
            background: #ef4444;
                color: var(--bg-white);
            border-left: 4px solid #dc2626;
        }
        
        .notification-info {
            background: #3b82f6;
                color: var(--bg-white);
            border-left: 4px solid #1d4ed8;
        }
        
        .notification-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
        }
        
        .notification-close {
            background: none;
            border: none;
            color: inherit;
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0;
            line-height: 1;
        }
        
        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
    `;
    document.head.appendChild(notificationStyles);
    }

    // Initialize everything
    function init() {
        initElements();
        initFormHandlers();
        initYearSelector();
        addNotificationStyles();
    }

    // Start when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
</script>