@extends('welcome')

@section('title', 'Enhanced Dashboard')

@section('content')
<div class="content-box">
    <!-- Enhanced Header with Quick Actions -->
    <div class="dashboard-header mb-4">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="contentHeading1 mb-2">Enhanced Dashboard</h1>
                <p class="text-muted mb-0">Real-time insights and quick actions</p>
            </div>
            <div class="col-md-6 text-end">
                <div class="btn-group" role="group">
                    <button class="btn btn-outline-primary" onclick="dynamicLoader.preloadPage('{{ route('inspection.index') }}')">
                        <i class="fas fa-sync-alt me-1"></i>Preload Inspection
                    </button>
                    <button class="btn btn-outline-success" onclick="dynamicLoader.clearCache()">
                        <i class="fas fa-broom me-1"></i>Clear Cache
                    </button>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#quickActionsModal">
                        <i class="fas fa-bolt me-1"></i>Quick Actions
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title text-muted">Total Inspections</h6>
                            <h2 class="mb-0 text-primary">{{ $dashboardData['totalInspections'] ?? 0 }}</h2>
                            <small class="text-success">
                                <i class="fas fa-arrow-up me-1"></i>12% increase
                            </small>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-clipboard-check fa-2x text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title text-muted">Active Vehicles</h6>
                            <h2 class="mb-0 text-success">{{ $dashboardData['activeVehicles'] ?? 0 }}</h2>
                            <small class="text-info">
                                <i class="fas fa-info-circle me-1"></i>90% operational
                            </small>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-truck fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title text-muted">Pending Work Orders</h6>
                            <h2 class="mb-0 text-warning">{{ $dashboardData['pendingIssues'] ?? 0 }}</h2>
                            <small class="text-warning">
                                <i class="fas fa-clock me-1"></i>3 urgent
                            </small>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-tools fa-2x text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title text-muted">Fuel Efficiency</h6>
                            <h2 class="mb-0 text-info">{{ $dashboardData['fuelEfficiency'] ?? 87 }}%</h2>
                            <small class="text-success">
                                <i class="fas fa-arrow-up me-1"></i>5% improvement
                            </small>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-gas-pump fa-2x text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Total Reports Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Total Reports Summary</h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-4">
                            <div class="report-stat">
                                <h2 class="text-primary">{{ $dashboardData['totalInspections'] ?? 0 }}</h2>
                                <p class="text-muted mb-0">Total Inspection Reports</p>
                                <small class="text-success">From Firebase Database</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="report-stat">
                                <h2 class="text-success">{{ $dashboardData['totalWorkOrders'] ?? 0 }}</h2>
                                <p class="text-muted mb-0">Total Work Orders</p>
                                <small class="text-info">From Firebase Database</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="report-stat">
                                <h2 class="text-warning">{{ $dashboardData['requestedRequests'] ?? 0 }}</h2>
                                <p class="text-muted mb-0">Total Maintenance Requests</p>
                                <small class="text-warning">From Firebase Database</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <div class="col-lg-8 mb-3">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Monthly Performance Overview</h5>
                    <div class="btn-group btn-group-sm" role="group">
                        <button type="button" class="btn btn-outline-secondary active">Monthly</button>
                        <button type="button" class="btn btn-outline-secondary">Quarterly</button>
                        <button type="button" class="btn btn-outline-secondary">Yearly</button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="performanceChart" height="100"></canvas>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4 mb-3">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Vehicle Status Distribution</h5>
                </div>
                <div class="card-body">
                    <canvas id="vehicleStatusChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activities and Quick Actions -->
    <div class="row">
        <div class="col-lg-8 mb-3">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Recent Activities</h5>
                </div>
                <div class="card-body p-0">
                    <div class="activity-list">
                        <div class="activity-item d-flex align-items-center p-3 border-bottom">
                            <div class="activity-icon bg-success text-white rounded-circle me-3">
                                <i class="fas fa-check"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">Inspection completed for Vehicle #V001</h6>
                                <small class="text-muted">2 minutes ago</small>
                            </div>
                            <button class="btn btn-sm btn-outline-primary" onclick="dynamicLoader.loadPage('{{ route('inspection.index') }}', 'Inspection Report')">
                                View Details
                            </button>
                        </div>
                        
                        <div class="activity-item d-flex align-items-center p-3 border-bottom">
                            <div class="activity-icon bg-warning text-white rounded-circle me-3">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">Maintenance alert for Vehicle #V003</h6>
                                <small class="text-muted">15 minutes ago</small>
                            </div>
                            <button class="btn btn-sm btn-outline-warning" onclick="dynamicLoader.loadPage('{{ route('maintenance.request') }}', 'Request Maintenance')">
                                Schedule
                            </button>
                        </div>
                        
                        <div class="activity-item d-flex align-items-center p-3">
                            <div class="activity-icon bg-info text-white rounded-circle me-3">
                                <i class="fas fa-gas-pump"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">Fuel refill completed at Station A</h6>
                                <small class="text-muted">1 hour ago</small>
                            </div>
                            <button class="btn btn-sm btn-outline-info" onclick="dynamicLoader.loadPage('{{ route('fuel.logger') }}', 'Fuel Logger')">
                                View Log
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4 mb-3">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button class="btn btn-outline-primary text-start" onclick="dynamicLoader.loadPage('{{ route('inspection.do_inspection') }}', 'Do Inspection')">
                            <i class="fas fa-clipboard-check me-2"></i>Start New Inspection
                        </button>
                        <button class="btn btn-outline-success text-start" onclick="dynamicLoader.loadPage('{{ route('maintenance.workorder') }}', 'Workorder')">
                            <i class="fas fa-tools me-2"></i>Create Work Order
                        </button>
                        <button class="btn btn-outline-info text-start" onclick="dynamicLoader.loadPage('{{ route('vehicles.inventory') }}', 'Vehicles Inventory')">
                            <i class="fas fa-truck me-2"></i>View Vehicles
                        </button>
                        <button class="btn btn-outline-warning text-start" onclick="dynamicLoader.loadPage('{{ route('dashboard.inspection_kpi') }}', 'Inspection KPI')">
                            <i class="fas fa-chart-line me-2"></i>View KPIs
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions Modal -->
<div class="modal fade" id="quickActionsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Quick Actions Dashboard</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="card h-100">
                            <div class="card-body text-center">
                                <i class="fas fa-clipboard-check fa-3x text-primary mb-3"></i>
                                <h6>Inspection Management</h6>
                                <div class="d-grid gap-2">
                                    <button class="btn btn-sm btn-outline-primary" onclick="dynamicLoader.loadPage('{{ route('inspection.index') }}', 'Inspection Report')">
                                        View Reports
                                    </button>
                                    <button class="btn btn-sm btn-outline-success" onclick="dynamicLoader.loadPage('{{ route('inspection.do_inspection') }}', 'Do Inspection')">
                                        New Inspection
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <div class="card h-100">
                            <div class="card-body text-center">
                                <i class="fas fa-tools fa-3x text-warning mb-3"></i>
                                <h6>Maintenance</h6>
                                <div class="d-grid gap-2">
                                    <button class="btn btn-sm btn-outline-warning" onclick="dynamicLoader.loadPage('{{ route('maintenance.workorder') }}', 'Workorder')">
                                        Work Orders
                                    </button>
                                    <button class="btn btn-sm btn-outline-info" onclick="dynamicLoader.loadPage('{{ route('maintenance.request') }}', 'Request Maintenance')">
                                        Request Service
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* CSS Variables for better maintainability */
:root {
    --primary-color: #0055a5;
    --primary-hover: #3b82f6;
    --text-primary: #1e293b;
    --text-secondary: #374151;
    --text-muted: #64748b;
    --text-light: #cbd5e1;
    --bg-primary: #f8fafc;
    --bg-white: #ffffff;
    --bg-hover: #f8f9fa;
    --border-color: #e2e8f0;
    --border-light: #cbd5e1;
    --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    --shadow-lg: 0 8px 25px rgba(0, 0, 0, 0.1);
    --radius-sm: 0;
    --radius-md: 10px;
    --radius-lg: 15px;
    --transition-base: all 0.2s ease;
    --transition-slow: all 0.3s ease;
    --font-family: 'Inter', sans-serif;
    --z-index-modal: 1055;
    --z-index-notification: 9999;
}

/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* Card styles */
.stat-card {
    transition: var(--transition-base);
    border: none;
    box-shadow: var(--shadow-sm);
    font-family: var(--font-family);
}

.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.stat-icon {
    opacity: 0.8;
}

/* Activity list styles */
.activity-list .activity-item {
    transition: var(--transition-base);
}

.activity-list .activity-item:hover {
    background-color: var(--bg-hover);
}

.activity-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Dashboard header */
.dashboard-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: var(--bg-white);
    padding: 2rem;
    border-radius: var(--radius-lg);
    margin-bottom: 2rem;
}

.dashboard-header h1,
.dashboard-header p {
    color: var(--bg-white);
}

.dashboard-header .btn-outline-primary,
.dashboard-header .btn-outline-success {
    color: var(--bg-white);
    border-color: rgba(255, 255, 255, 0.5);
}

.dashboard-header .btn-outline-primary:hover,
.dashboard-header .btn-outline-success:hover {
    background-color: var(--bg-white);
    color: #667eea;
}

/* Report statistics */
.report-stat {
    padding: 20px;
    border-radius: var(--radius-md);
    background: linear-gradient(135deg, var(--bg-hover) 0%, #e9ecef 100%);
    transition: var(--transition-base);
}

.report-stat:hover {
    transform: translateY(-5px);
    box-shadow: var(--shadow-lg);
}

.report-stat h2 {
    font-size: 2.5rem;
    font-weight: bold;
    margin-bottom: 10px;
    color: var(--text-primary);
}

.report-stat p {
    font-size: 1.1rem;
    margin-bottom: 5px;
    color: var(--text-secondary);
}

.report-stat small {
    font-size: 0.9rem;
    font-weight: 500;
    color: var(--text-muted);
}

/* ===== ENHANCED RESPONSIVE DESIGN ===== */
@media (max-width: 992px) {
    .content-box {
        padding: 0;
    }
    
    .dashboard-header {
        padding: 1rem;
        margin-bottom: 1.5rem;
        border-radius: 8px;
    }
    
    .dashboard-header .row {
        flex-direction: column;
        gap: 1rem;
    }
    
    .dashboard-header .col-md-6 {
        width: 100%;
        text-align: center;
    }
    
    .dashboard-header .btn-group {
        flex-direction: column;
        width: 100%;
        gap: 0.5rem;
    }
    
    .dashboard-header .btn {
        width: 100%;
        margin: 0;
    }
    
    .stat-card .card-body {
        padding: 1rem;
    }
    
    .stat-card h2 {
        font-size: 1.5rem;
    }
    
    .stat-card h6 {
        font-size: 0.8rem;
    }
    
    .report-stat {
        padding: 15px;
    }
    
    .report-stat h2 {
        font-size: 2rem;
    }
    
    .report-stat p {
        font-size: 1rem;
    }
}

/* ===== ACCESSIBILITY ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
}

/* ===== FOCUS STYLES ===== */
button:focus-visible,
.btn:focus-visible {
    outline: 2px solid var(--primary-color);
    outline-offset: 2px;
}

/* ===== PRINT STYLES ===== */
@media print {
    .dashboard-header {
        background: white !important;
        color: black !important;
    }
    
    .stat-card,
    .report-stat {
        border: 1px solid #000;
        break-inside: avoid;
    }
}

@media (max-width: 768px) {
    .content-box {
        padding: 0;
    }
    
    .dashboard-header {
        padding: 1rem;
        margin-bottom: 1rem;
        border-radius: 0;
    }
    
    .dashboard-header h1 {
        font-size: 1.5rem;
        margin-bottom: 0.5rem;
    }
    
    .dashboard-header p {
        font-size: 0.9rem;
    }
    
    .dashboard-header .btn-group {
        gap: 0.75rem;
    }
    
    .dashboard-header .btn {
        padding: 0.75rem 1rem;
        font-size: 0.9rem;
    }
    
    .stat-card .card-body {
        padding: 1rem;
    }
    
    .stat-card h2 {
        font-size: 1.5rem;
    }
    
    .stat-card h6 {
        font-size: 0.85rem;
    }
    
    .stat-icon i {
        font-size: 1.75rem !important;
    }
    
    .report-stat {
        padding: 12px;
        margin-bottom: 1rem;
    }
    
    .report-stat h2 {
        font-size: 1.75rem;
    }
    
    .report-stat p {
        font-size: 0.9rem;
    }
    
    .report-stat small {
        font-size: 0.8rem;
    }
    
    .activity-item {
        padding: 1rem;
        flex-direction: column;
        align-items: flex-start;
        gap: 0.75rem;
    }
    
    .activity-item .d-flex {
        width: 100%;
        justify-content: space-between;
        align-items: center;
    }
    
    .activity-icon {
        width: 35px;
        height: 35px;
    }
    
    .activity-item h6 {
        font-size: 0.9rem;
        margin-bottom: 0.25rem;
    }
    
    .activity-item small {
        font-size: 0.8rem;
    }
    
    .activity-item .btn {
        font-size: 0.8rem;
        padding: 0.4rem 0.8rem;
    }
    
    .card-header h5 {
        font-size: 1rem;
    }
    
    .card-body .d-grid .btn {
        font-size: 0.9rem;
        padding: 0.75rem 1rem;
        text-align: left;
    }
}

@media (max-width: 576px) {
    .content-box {
        padding: 0;
    }
    
    .dashboard-header {
        padding: 0.75rem;
        margin-bottom: 0.75rem;
    }
    
    .dashboard-header h1 {
        font-size: 1.25rem;
    }
    
    .dashboard-header p {
        font-size: 0.8rem;
    }
    
    .dashboard-header .btn-group {
        gap: 0.5rem;
    }
    
    .dashboard-header .btn {
        padding: 0.6rem 0.8rem;
        font-size: 0.8rem;
    }
    
    .stat-card .card-body {
        padding: 0.75rem;
    }
    
    .stat-card h2 {
        font-size: 1.25rem;
    }
    
    .stat-card h6 {
        font-size: 0.75rem;
    }
    
    .stat-icon i {
        font-size: 1.5rem !important;
    }
    
    .report-stat {
        padding: 10px;
        margin-bottom: 0.75rem;
    }
    
    .report-stat h2 {
        font-size: 1.5rem;
    }
    
    .report-stat p {
        font-size: 0.85rem;
    }
    
    .report-stat small {
        font-size: 0.75rem;
    }
    
    .activity-item {
        padding: 0.75rem;
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
    
    .activity-item .d-flex {
        width: 100%;
        justify-content: space-between;
        align-items: center;
    }
    
    .activity-icon {
        width: 30px;
        height: 30px;
    }
    
    .activity-item h6 {
        font-size: 0.85rem;
        margin-bottom: 0.25rem;
    }
    
    .activity-item small {
        font-size: 0.75rem;
    }
    
    .activity-item .btn {
        font-size: 0.75rem;
        padding: 0.35rem 0.7rem;
    }
    
    .card-header h5 {
        font-size: 0.9rem;
    }
    
    .card-body .d-grid .btn {
        font-size: 0.8rem;
        padding: 0.6rem 0.8rem;
        text-align: left;
    }
    
    .btn-group {
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .btn {
        font-size: 0.8rem;
        padding: 0.5rem 0.8rem;
    }
}

@media (max-width: 480px) {
    .content-box {
        padding: 0;
    }
    
    .dashboard-header {
        padding: 0.5rem;
        margin-bottom: 0.5rem;
    }
    
    .dashboard-header h1 {
        font-size: 1.1rem;
    }
    
    .dashboard-header p {
        font-size: 0.75rem;
    }
    
    .dashboard-header .btn-group {
        gap: 0.4rem;
    }
    
    .dashboard-header .btn {
        padding: 0.5rem 0.6rem;
        font-size: 0.75rem;
    }
    
    .stat-card .card-body {
        padding: 0.6rem;
    }
    
    .stat-card h2 {
        font-size: 1.1rem;
    }
    
    .stat-card h6 {
        font-size: 0.7rem;
    }
    
    .stat-icon i {
        font-size: 1.25rem !important;
    }
    
    .report-stat {
        padding: 8px;
        margin-bottom: 0.5rem;
    }
    
    .report-stat h2 {
        font-size: 1.25rem;
    }
    
    .report-stat p {
        font-size: 0.8rem;
    }
    
    .report-stat small {
        font-size: 0.7rem;
    }
    
    .activity-item {
        padding: 0.6rem;
        flex-direction: column;
        align-items: flex-start;
        gap: 0.4rem;
    }
    
    .activity-item .d-flex {
        width: 100%;
        justify-content: space-between;
        align-items: center;
    }
    
    .activity-icon {
        width: 25px;
        height: 25px;
    }
    
    .activity-item h6 {
        font-size: 0.8rem;
        margin-bottom: 0.2rem;
    }
    
    .activity-item small {
        font-size: 0.7rem;
    }
    
    .activity-item .btn {
        font-size: 0.7rem;
        padding: 0.3rem 0.6rem;
    }
    
    .card-header h5 {
        font-size: 0.85rem;
    }
    
    .card-body .d-grid .btn {
        font-size: 0.75rem;
        padding: 0.5rem 0.6rem;
        text-align: left;
    }
    
    .btn {
        font-size: 0.75rem;
        padding: 0.4rem 0.6rem;
    }
}

@media (max-width: 360px) {
    .dashboard-header {
        padding: 0.4rem;
        margin-bottom: 0.4rem;
    }
    
    .dashboard-header h1 {
        font-size: 1rem;
    }
    
    .dashboard-header p {
        font-size: 0.7rem;
    }
    
    .dashboard-header .btn {
        padding: 0.4rem 0.5rem;
        font-size: 0.7rem;
    }
    
    .stat-card .card-body {
        padding: 0.5rem;
    }
    
    .stat-card h2 {
        font-size: 1rem;
    }
    
    .stat-card h6 {
        font-size: 0.65rem;
    }
    
    .stat-icon i {
        font-size: 1rem !important;
    }
    
    .report-stat {
        padding: 6px;
        margin-bottom: 0.4rem;
    }
    
    .report-stat h2 {
        font-size: 1.1rem;
    }
    
    .report-stat p {
        font-size: 0.75rem;
    }
    
    .report-stat small {
        font-size: 0.65rem;
    }
    
    .activity-item {
        padding: 0.5rem;
    }
    
    .activity-icon {
        width: 20px;
        height: 20px;
    }
    
    .activity-item h6 {
        font-size: 0.75rem;
    }
    
    .activity-item small {
        font-size: 0.65rem;
    }
    
    .activity-item .btn {
        font-size: 0.65rem;
        padding: 0.25rem 0.5rem;
    }
    
    .card-header h5 {
        font-size: 0.8rem;
    }
    
    .card-body .d-grid .btn {
        font-size: 0.7rem;
        padding: 0.4rem 0.5rem;
    }
    
    .btn {
        font-size: 0.7rem;
        padding: 0.35rem 0.5rem;
    }
}
</style>
@endsection

@section('scripts')
<script>
// Optimized Enhanced Dashboard Functionality
(function() {
    'use strict';
    
    // Configuration object
    const CONFIG = {
        chartColors: {
            primary: '#0055A5',
            secondary: '#F5D904',
            success: '#19A979',
            warning: '#F5D904',
            danger: '#DC0D0E',
            info: '#3b82f6'
        },
        chartOptions: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top'
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    };
    
    // Cache DOM elements
    let elements = {};
    
    function initElements() {
        elements = {
            performanceChart: document.getElementById('performanceChart'),
            vehicleStatusChart: document.getElementById('vehicleStatusChart')
        };
    }
    
    // Initialize performance chart
    function initPerformanceChart() {
        if (!elements.performanceChart) return;
        
        new Chart(elements.performanceChart.getContext('2d'), {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                datasets: [{
                    label: 'Inspections',
                    data: [65, 78, 82, 75, 90, {{ $dashboardData['totalInspections'] ?? 0 }}],
                    borderColor: CONFIG.chartColors.primary,
                    backgroundColor: 'rgba(0, 85, 165, 0.1)',
                    tension: 0.4
                }, {
                    label: 'Maintenance',
                    data: [45, 52, 48, 60, 55, {{ $dashboardData['totalWorkOrders'] ?? 0 }}],
                    borderColor: CONFIG.chartColors.secondary,
                    backgroundColor: 'rgba(245, 217, 4, 0.1)',
                    tension: 0.4
                }]
            },
            options: CONFIG.chartOptions
        });
    }
    
    // Initialize vehicle status chart
    function initVehicleStatusChart() {
        if (!elements.vehicleStatusChart) return;
        
        new Chart(elements.vehicleStatusChart.getContext('2d'), {
            type: 'doughnut',
            data: {
                labels: ['Active', 'Maintenance', 'Breakdown'],
                datasets: [{
                    data: [{{ $dashboardData['activeVehicles'] ?? 0 }}, {{ $dashboardData['maintenanceVehicles'] ?? 0 }}, {{ $dashboardData['breakdownVehicles'] ?? 0 }}],
                    backgroundColor: [CONFIG.chartColors.success, CONFIG.chartColors.warning, CONFIG.chartColors.danger]
                }]
            },
            options: {
                ...CONFIG.chartOptions,
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }
        });
    }
    
    // Initialize all charts
    function initCharts() {
        initPerformanceChart();
        initVehicleStatusChart();
    }
    
    // Initialize all functionality
    function init() {
        initElements();
        initCharts();
    }
    
    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
    
    // Make functions globally accessible if needed
    window.initEnhancedCharts = initCharts;
})();
</script>
@endsection
