<?php $__env->startSection('title', 'Corrective Action Builder'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    :root {
        --ca-primary: #0066ff;
        --ca-primary-light: #e8f0ff;
        --ca-success: #16a34a;
        --ca-danger: #dc2626;
        --ca-warning: #f59e0b;
        --ca-dark: #0f172a;
        --ca-border: #e2e8f0;
    }
    .ca-container {
        max-width: 1280px;
        margin: 0 auto;
        padding: 24px 32px 80px;
        font-family: 'Inter', system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
    }
    .ca-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        gap: 16px;
    }
    .ca-header h1 {
        font-size: 28px;
        margin: 0;
        color: var(--ca-dark);
        font-weight: 700;
    }
    .ca-meta {
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
        font-size: 14px;
        color: #475569;
    }
    .ca-meta span {
        background: var(--ca-primary-light);
        color: var(--ca-primary);
        padding: 4px 10px;
        border-radius: 999px;
        font-weight: 600;
    }
    .ca-steps {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
        margin-bottom: 24px;
    }
    .ca-step {
        border: 1px solid var(--ca-border);
        border-radius: 12px;
        padding: 18px;
        background: #fff;
        display: flex;
        align-items: center;
        gap: 16px;
        transition: all 0.2s ease;
        position: relative;
    }
    .ca-step::before {
        content: attr(data-step);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: 2px solid var(--ca-border);
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        color: var(--ca-dark);
    }
    .ca-step.active {
        border-color: var(--ca-primary);
        background: #fff;
        box-shadow: 0 10px 25px rgba(15, 23, 42, 0.08);
    }
    .ca-step.active::before {
        border-color: var(--ca-primary);
        background: var(--ca-primary);
        color: #fff;
    }
    .ca-step h3 {
        margin: 0;
        font-size: 16px;
        color: var(--ca-dark);
        font-weight: 700;
    }
    .ca-step p {
        margin: 4px 0 0;
        font-size: 14px;
        color: #475569;
    }
    .ca-content {
        background: #fff;
        border-radius: 18px;
        border: 1px solid var(--ca-border);
        box-shadow: 0 20px 40px rgba(15, 23, 42, 0.08);
        padding: 32px;
        position: relative;
    }
    .ca-section {
        display: none;
        animation: fadeIn 0.35s ease;
    }
    .ca-section.active {
        display: block;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .summary-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px;
    }
    .summary-card {
        border: 1px solid var(--ca-border);
        border-radius: 12px;
        padding: 16px;
        background: #f8fafc;
    }
    .summary-card h4 {
        margin: 0;
        font-size: 13px;
        letter-spacing: 0.08em;
        text-transform: uppercase;
        color: #94a3b8;
    }
    .summary-card strong {
        display: block;
        margin-top: 6px;
        font-size: 16px;
        color: var(--ca-dark);
    }
    .faulty-items-list {
        border: 1px solid var(--ca-border);
        border-radius: 12px;
        max-height: 520px;
        overflow: auto;
    }
    .faulty-item {
        padding: 18px 20px;
        border-bottom: 1px solid var(--ca-border);
        display: flex;
        flex-direction: column;
        gap: 12px;
        position: relative;
    }
    .faulty-item:last-child {
        border-bottom: none;
    }
    .faulty-item h5 {
        margin: 0 0 6px;
        font-size: 15px;
        color: var(--ca-dark);
    }
    .faulty-item small {
        color: #475569;
        display: block;
        font-size: 13px;
    }
    .note-indicator {
        font-size: 12px;
        color: #475569;
        margin-top: 4px;
    }
    .note-btn {
        position: absolute;
        top: 16px;
        right: 20px;
        border: none;
        background: #e0f2fe;
        color: #0369a1;
        padding: 6px 10px;
        border-radius: 999px;
        font-size: 12px;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 4px;
        cursor: pointer;
        transition: all 0.2s;
    }
    .note-btn:hover {
        background: #0369a1;
        color: #fff;
    }
    .note-btn svg {
        width: 14px;
        height: 14px;
    }
    .note-modal {
        position: fixed;
        inset: 0;
        background: rgba(15,23,42,0.45);
        display: none;
        align-items: center;
        justify-content: center;
        z-index: 1200;
        padding: 20px;
    }
    .note-modal.visible {
        display: flex;
    }
    .note-modal__content {
        background: #fff;
        border-radius: 16px;
        width: min(420px, 100%);
        box-shadow: 0 20px 40px rgba(15, 23, 42, 0.25);
        padding: 24px;
        display: flex;
        flex-direction: column;
        gap: 16px;
    }
    .note-modal__actions {
        display: flex;
        justify-content: flex-end;
        gap: 12px;
    }
    .note-modal__actions button {
        border: none;
        border-radius: 8px;
        padding: 10px 18px;
        font-weight: 600;
        cursor: pointer;
    }
    .note-modal__actions .cancel-btn {
        background: #e2e8f0;
        color: #0f172a;
    }
    .note-modal__actions .save-btn {
        background: var(--ca-primary);
        color: #fff;
    }
    .status-chips {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
    }
    .status-chip {
        --chip-color: var(--ca-dark);
        border: 1px solid var(--chip-color);
        color: var(--chip-color);
        padding: 10px 16px;
        border-radius: 999px;
        font-weight: 600;
        font-size: 13px;
        background: #fff;
        cursor: pointer;
        transition: all 0.2s;
    }
    .status-chip.selected {
        background: var(--chip-color);
        color: #fff;
        box-shadow: 0 10px 20px rgba(15,23,42,0.15);
    }
    .note-indicator {
        font-size: 12px;
        color: #475569;
        margin-top: 4px;
    }
    .note-btn {
        position: absolute;
        top: 16px;
        right: 20px;
        border: none;
        background: #e0f2fe;
        color: #0369a1;
        padding: 6px 10px;
        border-radius: 999px;
        font-size: 12px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 4px;
        cursor: pointer;
        transition: all 0.2s;
    }
    .note-btn:hover {
        background: #0369a1;
        color: #fff;
    }
    .note-btn svg {
        width: 14px;
        height: 14px;
    }
    .note-modal {
        position: fixed;
        inset: 0;
        background: rgba(15,23,42,0.45);
        display: none;
        align-items: center;
        justify-content: center;
        z-index: 1200;
        padding: 20px;
    }
    .note-modal.visible {
        display: flex;
    }
    .note-modal__content {
        background: #fff;
        border-radius: 16px;
        width: min(420px, 100%);
        box-shadow: 0 20px 40px rgba(15, 23, 42, 0.25);
        padding: 24px;
        display: flex;
        flex-direction: column;
        gap: 16px;
    }
    .note-modal__actions {
        display: flex;
        justify-content: flex-end;
        gap: 12px;
    }
    .note-modal__actions button {
        border: none;
        border-radius: 8px;
        padding: 10px 18px;
        font-weight: 600;
        cursor: pointer;
    }
    .note-modal__actions .cancel-btn {
        background: #e2e8f0;
        color: #0f172a;
    }
    .note-modal__actions .save-btn {
        background: var(--ca-primary);
        color: #fff;
    }
    .ca-actions {
        margin-top: 28px;
        display: flex;
        justify-content: space-between;
        gap: 16px;
        flex-wrap: wrap;
    }
    .ca-actions .btn {
        border: none;
        border-radius: 10px;
        padding: 14px 22px;
        font-weight: 600;
        font-size: 15px;
        cursor: pointer;
        transition: all 0.2s ease;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }
    .btn-secondary {
        background: #f1f5f9;
        color: #1e293b;
    }
    .btn-primary {
        background: var(--ca-primary);
        color: #fff;
        box-shadow: 0 10px 20px rgba(0,102,255,0.25);
    }
    .btn-success {
        background: var(--ca-success);
        color: #fff;
        box-shadow: 0 10px 20px rgba(22,163,74,0.25);
    }
    .btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
        box-shadow: none;
    }
    .radio-group {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
    }
    .radio-pill {
        border: 1px solid var(--ca-border);
        border-radius: 999px;
        padding: 10px 18px;
        cursor: pointer;
        font-weight: 600;
        color: #475569;
        transition: all 0.2s;
    }
    .radio-pill.selected {
        border-color: var(--ca-primary);
        color: var(--ca-primary);
        box-shadow: 0 8px 16px rgba(0,102,255,0.15);
    }
    .form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 20px;
        margin-top: 24px;
    }
    .form-field {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }
    .form-field label {
        font-size: 14px;
        font-weight: 600;
        color: #334155;
    }
    .form-field input,
    .form-field textarea,
    .form-field select {
        border: 1px solid var(--ca-border);
        border-radius: 10px;
        padding: 12px 14px;
        font-size: 15px;
        font-family: inherit;
    }
    .signature-pad {
        border: 2px dashed var(--ca-border);
        border-radius: 10px;
        height: 150px;
        background: #f8fafc;
        position: relative;
        overflow: hidden;
    }
    .signature-pad canvas {
        width: 100%;
        height: 100%;
        border-radius: 8px;
        cursor: crosshair;
        touch-action: none;
        display: block;
        background: #ffffff;
        pointer-events: auto;
        user-select: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
    }
    .signature-tools {
        margin-top: 6px;
        display: flex;
        gap: 12px;
    }
    .signature-tools button {
        border: none;
        background: #e2e8f0;
        color: #0f172a;
        padding: 6px 12px;
        border-radius: 6px;
        font-size: 13px;
        cursor: pointer;
    }
    .ca-alert {
        padding: 14px 16px;
        border-radius: 10px;
        background: #fef3c7;
        color: #92400e;
        border: 1px solid #fcd34d;
        margin-bottom: 20px;
        display: none;
    }
    .ca-alert.visible {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .toast-container {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        display: flex;
        flex-direction: column;
        gap: 10px;
    }
    .toast {
        min-width: 280px;
        padding: 14px 16px;
        border-radius: 12px;
        color: #fff;
        font-weight: 600;
        box-shadow: 0 10px 30px rgba(15,23,42,0.15);
    }
    .toast.success { background: var(--ca-success); }
    .toast.error { background: var(--ca-danger); }
    .toast.info { background: var(--ca-primary); }
    .ca-loader {
        position: absolute;
        inset: 0;
        background: rgba(255,255,255,0.85);
        display: none;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        gap: 12px;
        border-radius: 18px;
        z-index: 10;
    }
    .ca-loader.visible {
        display: flex;
    }
    .ca-loader span {
        font-weight: 600;
        color: #475569;
    }
    .ca-success-modal {
        position: fixed;
        inset: 0;
        background: rgba(15,23,42,0.45);
        display: none;
        align-items: center;
        justify-content: center;
        z-index: 1400;
        padding: 20px;
    }
    .ca-success-modal.visible {
        display: flex;
    }
    .ca-success-modal__content {
        background: #fff;
        border-radius: 20px;
        max-width: 420px;
        width: 100%;
        padding: 28px 32px;
        text-align: center;
        box-shadow: 0 25px 55px rgba(15,23,42,0.2);
    }
    .ca-success-modal__icon {
        width: 72px;
        height: 72px;
        border-radius: 50%;
        background: #dcfce7;
        color: #16a34a;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 34px;
        margin: 0 auto 16px;
    }
    .ca-success-modal__actions {
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
        margin-top: 24px;
        justify-content: center;
    }
    .ca-success-modal__actions .btn {
        flex: 1 1 140px;
        justify-content: center;
    }
    @media (max-width: 768px) {
        .faulty-item {
            grid-template-columns: 1fr;
        }
        .ca-header {
            flex-direction: column;
            align-items: flex-start;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="ca-container" id="correctiveActionApp">
    <div class="ca-header">
        <div>
            <h1>Corrective Action Builder</h1>
            <div class="ca-meta">
                <span id="metaInspectionId">Inspection: --</span>
                <span id="metaRequestNumber">Request #: --</span>
                <span id="metaEquipment">Equipment: --</span>
            </div>
        </div>
        <div>
            <a href="<?php echo e(route('inspection.index')); ?>" class="btn btn-secondary" style="text-decoration:none;">
                ← Back to inspections
            </a>
        </div>
    </div>

    <div class="ca-steps">
        <div class="ca-step active" data-step="1">
            <div>
                <h3>Step 1: Faulty Items</h3>
                <p>Review each fault and capture corrective status</p>
            </div>
        </div>
        <div class="ca-step" data-step="2">
            <div>
                <h3>Step 2: Signatures & PDF</h3>
                <p>Capture responsibility, signatures & upload report</p>
            </div>
        </div>
    </div>

    <div class="ca-content">
        <div class="ca-loader" id="caLoader">
            <svg width="60" height="60" viewBox="0 0 44 44" stroke="#2563eb">
                <g fill="none" fill-rule="evenodd" stroke-width="4">
                    <circle cx="22" cy="22" r="19.5"></circle>
                </g>
            </svg>
            <span id="loaderText">Loading inspection data...</span>
        </div>

        <div class="ca-alert" id="caAlert">
            <strong id="caAlertTitle"></strong>
            <span id="caAlertMessage"></span>
        </div>

        <div class="ca-section active" id="step1Section">
            <div class="summary-grid" id="step1Summary">
                <div class="summary-card">
                    <h4>Report Number</h4>
                    <strong id="summaryRequestNumber">--</strong>
                </div>
                <div class="summary-card">
                    <h4>Inspector</h4>
                    <strong id="summaryInspector">--</strong>
                </div>
                <div class="summary-card">
                    <h4>Equipment</h4>
                    <strong id="summaryEquipment">--</strong>
                </div>
                <div class="summary-card">
                    <h4>Faulty Items</h4>
                    <strong id="summaryFaultyCount">0</strong>
                </div>
            </div>

            <div class="faulty-items-list" id="faultyItemsList">
                <div style="padding: 24px; text-align: center; color: #94a3b8;">
                    No inspection selected yet.
                </div>
            </div>

            <div class="ca-actions">
                <button class="btn btn-secondary" id="resetStep1Btn">Reset selection</button>
                <div style="display:flex; gap:12px;">
                    <button class="btn btn-secondary" id="step1SaveDraftBtn">Save Draft</button>
                    <button class="btn btn-primary" id="goToStep2Btn" disabled>
                        Continue to Signatures →
                    </button>
                </div>
            </div>
        </div>

        <div class="ca-section" id="step2Section">
            <div class="summary-grid">
                <div class="summary-card">
                    <h4>Faulty Count</h4>
                    <strong id="summaryFaultyCountStep2">0</strong>
                </div>
                <div class="summary-card">
                    <h4>Corrective Status</h4>
                    <strong id="summaryStatusStep2">In progress</strong>
                </div>
                <div class="summary-card">
                    <h4>Last Saved</h4>
                    <strong id="summarySavedAtStep2">Never</strong>
                </div>
            </div>

            <div class="form-grid">
                <div class="form-field">
                    <label>Is equipment satisfactory after action?</label>
                    <div class="radio-group" id="satisfactoryRadios">
                        <div class="radio-pill" data-value="true">Yes, approved</div>
                        <div class="radio-pill" data-value="false">No, needs follow-up</div>
                    </div>
                </div>
                <div class="form-field">
                    <label>Responsible role</label>
                    <div class="radio-group" id="roleRadios">
                        <div class="radio-pill" data-value="Mechanic">Mechanic</div>
                        <div class="radio-pill" data-value="Operator">Operator</div>
                        <div class="radio-pill" data-value="Both">Both</div>
                    </div>
                </div>
            </div>

            <div class="form-grid" id="signatureBlocks">
                <div class="form-field" data-role="mechanic">
                    <label>Mechanic Name</label>
                    <input type="text" id="mechanicName" placeholder="Enter mechanic full name">
                    <label style="margin-top:12px;">Mechanic Signature</label>
                    <div class="signature-pad">
                        <canvas id="mechanicSignaturePad" data-empty="true"></canvas>
                    </div>
                    <div class="signature-tools">
                        <button type="button" data-action="clear" data-target="mechanicSignaturePad">Clear</button>
                    </div>
                </div>
                <div class="form-field" data-role="operator">
                    <label>Operator Name</label>
                    <input type="text" id="operatorName" placeholder="Enter operator full name">
                    <label style="margin-top:12px;">Operator Signature</label>
                    <div class="signature-pad">
                        <canvas id="operatorSignaturePad" data-empty="true"></canvas>
                    </div>
                    <div class="signature-tools">
                        <button type="button" data-action="clear" data-target="operatorSignaturePad">Clear</button>
                    </div>
                </div>
            </div>

            <div class="form-field" style="margin-top: 12px;">
                <label>Corrective Action Notes</label>
                <textarea id="correctiveNotes" rows="3" placeholder="Add any important notes, observations, or follow-up instructions"></textarea>
            </div>

            <div class="ca-actions">
                <button class="btn btn-secondary" id="backToStep1Btn">← Back to Faulty Items</button>
                <div style="display:flex; gap:12px;">
                    <button class="btn btn-secondary" id="step2SaveDraftBtn">Save Draft</button>
                    <button class="btn btn-primary" id="downloadPdfBtn" disabled>
                        <i class="fas fa-download"></i> Download PDF
                    </button>
                    <button class="btn btn-success" id="finalizeBtn">
                        Finalize & Sync →
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="toast-container" id="toastContainer"></div>
<div class="note-modal" id="noteModal">
    <div class="note-modal__content">
        <div>
            <h3 id="noteModalTitle" style="margin:0; font-size:18px; color:#0f172a;">Add note</h3>
            <p style="margin:4px 0 0; color:#475569; font-size:13px;">Add an internal comment for this faulty item.</p>
        </div>
        <textarea id="noteModalTextarea" rows="4" style="width:100%; border:1px solid var(--ca-border); border-radius:10px; padding:12px; font-family:inherit;"></textarea>
        <div class="note-modal__actions">
            <button type="button" class="cancel-btn" id="noteModalCancel">Cancel</button>
            <button type="button" class="save-btn" id="noteModalSave">Save</button>
        </div>
    </div>
</div>
<div class="ca-success-modal" id="caSuccessModal" aria-hidden="true">
    <div class="ca-success-modal__content">
        <div class="ca-success-modal__icon">
            <i class="fas fa-check"></i>
        </div>
        <h3 style="margin:0; font-size:20px; color:#0f172a;">Corrective Action Ready</h3>
        <p id="caSuccessModalMessage" style="margin:12px 0 0; color:#475569;">
            The corrective action PDF has been generated successfully.
        </p>
        <div class="ca-success-modal__actions">
            <button type="button" class="btn btn-secondary" id="caSuccessBackBtn">← Back to Inspection Reports</button>
            <button type="button" class="btn btn-primary" id="caSuccessDownloadPdfBtn">
                <i class="fas fa-download"></i> Download PDF
            </button>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
(function() {
    const AUTH_USER = <?php echo json_encode(auth()->user()->email ?? auth()->user()->name ?? 'unknown-admin', 15, 512) ?>;
    const INITIAL_INSPECTION_ID = <?php echo json_encode($inspectionId ?? request('inspectionId'), 15, 512) ?>;
    const INITIAL_REQUEST_NUMBER = <?php echo json_encode($requestNumber ?? request('requestNumber'), 15, 512) ?>;
    const INITIAL_MODE = <?php echo json_encode($mode ?? request('mode') ?? '', 15, 512) ?>;
    const INSPECTION_REPORTS_URL = <?php echo json_encode(route('inspection.index'), 15, 512) ?>;
    const LOGO_URL = <?php echo json_encode(asset('images/titan-drlling_blue-removebg-preview.png'), 15, 512) ?>;

    const API_ROUTES = {
        inspectionReport: "/api/corrective/inspection",
        correctiveAction: "/api/corrective-actions",
        uploadPdf: "/api/corrective-actions",
        uploadSignature: "/api/corrective-actions"
    };
    const INSPECTION_HANDLER_BASE_URL = <?php echo json_encode(rtrim(config('services.inspection_handler.base_url') ?? '', '/'), 512) ?>;

    const CSRF_TOKEN = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');

    const STATUS_COLORS = {
        'Fixed': '#16a34a',
        'Not Fixed': '#dc2626',
        'No need': '#f59e0b'
    };

    const PDF_TEMPLATE_CSS = `
    body {
      font-family: Arial, sans-serif;
      margin: 20px;
      padding: 0;
      font-size: 12px;
      color: #000;
    }
    .header-row {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 10px;
      width: 100%;
    }
    .logo-left {
      display: flex;
      align-items: center;
      justify-content: center;
      flex-shrink: 0;
      width: 140px;
      height: auto;
    }
    .logo-left img {
      width: 140px;
      height: 50px;
      object-fit: contain;
      display: block;
      max-width: 140px;
      max-height: 50px;
      margin: 0 auto;
    }
    .doc-info-box {
      width: 340px;
      flex-shrink: 0;
      margin-left: auto;
    }
    .doc-info-box table {
      width: 100%;
      border: 1px solid #222;
      border-collapse: collapse;
      font-size: 12px;
    }
    .doc-info-box td {
      border: 1px solid #222;
      padding: 4px 8px;
      text-align: left;
    }
    .title-section {
      text-align: center;
      margin: 10px 0 0 0;
    }
    .title-section h2 {
      margin: 0;
      font-size: 18px;
      font-weight: bold;
    }
    .request-number {
      font-size: 14px;
      font-weight: bold;
      margin-top: 4px;
    }
    .info-boxes-row {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      margin: 16px 0 10px 0;
    }
    .info-box {
      width: 45%;
    }
    .info-box table {
      width: 100%;
      border: 1px solid #222;
      border-collapse: collapse;
      font-size: 12px;
    }
    .info-box td {
      border: 1px solid #222;
      padding: 4px 8px;
      text-align: left;
    }
    .classification {
      margin-bottom: 20px;
    }
    .classification table {
      width: 100%;
    }
    .classification td {
      border: 1px solid black;
      padding: 5px;
      text-align: left;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 20px;
    }
    th, td {
      border: 1px solid black;
      padding: 8px;
      text-align: center;
    }
    th {
      background-color: #f2f2f2;
      font-weight: bold;
    }
    .checklist th:nth-child(1), .checklist td:nth-child(1) { width: 25%; text-align: left; }
    .checklist th:nth-child(2), .checklist td:nth-child(2),
    .checklist th:nth-child(3), .checklist td:nth-child(3),
    .checklist th:nth-child(4), .checklist td:nth-child(4) { width: 13%; }
    .checklist th:nth-child(5), .checklist td:nth-child(5),
    .checklist th:nth-child(6), .checklist td:nth-child(6) { width: 15.5%; }

    .corrective-table th:nth-child(1), .corrective-table td:nth-child(1) { width: 10%; text-align: center; }
    .corrective-table th:nth-child(2), .corrective-table td:nth-child(2) { width: 35%; text-align: left; }
    .corrective-table th:nth-child(3), .corrective-table td:nth-child(3) { width: 20%; text-align: center; }
    .corrective-table th:nth-child(4), .corrective-table td:nth-child(4) { width: 35%; text-align: left; }

    .summary-section-table {
      width: 100%;
      margin-top: 30px;
      border: none;
    }
    .summary-section-table td {
      border: none;
      padding: 8px;
      font-size: 14px;
      text-align: left;
    }
    .summary-section-table .label {
      font-weight: bold;
      width: 180px;
    }
    .summary-section-table .signature-cell {
      text-align: right;
      vertical-align: middle;
      padding-right: 30px;
    }
    .section-break {
      margin-top: 20px;
      border-top: 2px solid #015185;
      padding-top: 10px;
    }
    .signature-img {
      width: 120px;
      height: 60px;
      border: 1px solid #ccc;
      background: #f9f9f9;
    }
    `;

    let elements = {};

    function cacheElements() {
        return {
            loader: document.getElementById('caLoader'),
            loaderText: document.getElementById('loaderText'),
            alert: document.getElementById('caAlert'),
            alertTitle: document.getElementById('caAlertTitle'),
            alertMessage: document.getElementById('caAlertMessage'),
            steps: document.querySelectorAll('.ca-step'),
            sections: {
                step1: document.getElementById('step1Section'),
                step2: document.getElementById('step2Section')
            },
            meta: {
                inspectionId: document.getElementById('metaInspectionId'),
                requestNumber: document.getElementById('metaRequestNumber'),
                equipment: document.getElementById('metaEquipment')
            },
            summary: {
                requestNumber: document.getElementById('summaryRequestNumber'),
                inspector: document.getElementById('summaryInspector'),
                equipment: document.getElementById('summaryEquipment'),
                faultyCount: document.getElementById('summaryFaultyCount'),
                faultyCountStep2: document.getElementById('summaryFaultyCountStep2'),
                statusStep2: document.getElementById('summaryStatusStep2'),
                savedAtStep2: document.getElementById('summarySavedAtStep2'),
            },
            faultyList: document.getElementById('faultyItemsList'),
            stepButtons: {
                resetStep1: document.getElementById('resetStep1Btn'),
                saveDraftStep1: document.getElementById('step1SaveDraftBtn'),
                goToStep2: document.getElementById('goToStep2Btn'),
                backToStep1: document.getElementById('backToStep1Btn'),
                saveDraftStep2: document.getElementById('step2SaveDraftBtn'),
                finalize: document.getElementById('finalizeBtn'),
                downloadPdf: document.getElementById('downloadPdfBtn'),
            },
            radios: {
                satisfactory: document.getElementById('satisfactoryRadios'),
                role: document.getElementById('roleRadios'),
            },
            inputs: {
                mechanicName: document.getElementById('mechanicName'),
                operatorName: document.getElementById('operatorName'),
                notes: document.getElementById('correctiveNotes'),
            },
            signaturePads: {
                mechanic: document.getElementById('mechanicSignaturePad'),
                operator: document.getElementById('operatorSignaturePad'),
            },
            toastContainer: document.getElementById('toastContainer'),
            noteModal: {
                container: document.getElementById('noteModal'),
                title: document.getElementById('noteModalTitle'),
                textarea: document.getElementById('noteModalTextarea'),
                save: document.getElementById('noteModalSave'),
                cancel: document.getElementById('noteModalCancel')
            },
            successModal: {
                container: document.getElementById('caSuccessModal'),
                message: document.getElementById('caSuccessModalMessage'),
                back: document.getElementById('caSuccessBackBtn'),
                downloadPdf: document.getElementById('caSuccessDownloadPdfBtn')
            }
        };
    }

    const state = {
        inspectionId: INITIAL_INSPECTION_ID || null,
        requestNumber: INITIAL_REQUEST_NUMBER || null,
        inspection: null,
        faultyItems: [],
        subItemStatuses: {},
        subItemNotes: {},
        currentStep: 1,
        isSaving: false,
        correctiveAction: null,
        hasCorrectiveAction: false,
        selectedRole: null,
        isSatisfactory: null,
        mechanicName: '',
        operatorName: '',
        notes: '',
        mechanicSignature: null,
        operatorSignature: null,
        mechanicSignatureUri: null,
        operatorSignatureUri: null,
        pdfDownloadUrl: null,
        pdfFileName: null,
        lastSavedAt: null,
        activeNoteItemId: null,
    };

    function escapeHtml(value) {
        if (value === null || value === undefined) return '';
        return String(value)
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#39;');
    }

    function formatDate(value) {
        if (!value) return new Date().toLocaleDateString('en-GB', { day: 'numeric', month: 'long', year: 'numeric' });
        const date = new Date(value);
        if (Number.isNaN(date.getTime())) return new Date().toLocaleDateString('en-GB', { day: 'numeric', month: 'long', year: 'numeric' });
        return date.toLocaleDateString('en-GB', {
            day: 'numeric',
            month: 'long',
            year: 'numeric'
        });
    }
    
    function formatDateShort(value) {
        if (!value) return new Date().toLocaleDateString('en-GB', { day: 'numeric', month: 'long', year: 'numeric' });
        const date = new Date(value);
        if (Number.isNaN(date.getTime())) return new Date().toLocaleDateString('en-GB', { day: 'numeric', month: 'long', year: 'numeric' });
        return date.toLocaleDateString('en-GB', {
            day: 'numeric',
            month: 'long',
            year: 'numeric'
        });
    }

    function formatTime(value) {
        if (!value) return '--';
        const date = new Date(value);
        if (Number.isNaN(date.getTime())) return value;
        return date.toLocaleTimeString(undefined, {
            hour: '2-digit',
            minute: '2-digit'
        });
    }

    function buildAbsoluteUrl(url) {
        if (!url) return null;
        if (/^https?:\/\//i.test(url)) {
            return url;
        }
        const base = (INSPECTION_HANDLER_BASE_URL || '').toString().trim();
        if (!base) {
            return url;
        }
        if (url.startsWith('/')) {
            return `${base}${url}`;
        }
        return `${base}/${url}`;
    }

    async function requestJson(url, options = {}) {
        const opts = {
            credentials: 'same-origin',
            ...options,
            headers: {
                'Accept': 'application/json',
                ...(options.headers || {})
            }
        };
        const method = (opts.method || 'GET').toUpperCase();
        const hasBody = opts.body && !(opts.body instanceof FormData);
        if (hasBody && !opts.headers['Content-Type']) {
            opts.headers['Content-Type'] = 'application/json';
        }
        if (method !== 'GET' && method !== 'HEAD' && CSRF_TOKEN && !opts.headers['X-CSRF-TOKEN']) {
            opts.headers['X-CSRF-TOKEN'] = CSRF_TOKEN;
        }
        const response = await fetch(url, opts);
        const rawText = await response.text();
        let data = {};
        if (rawText) {
            try {
                data = JSON.parse(rawText);
            } catch (err) {
                throw new Error(`Unexpected response (${response.status})`);
            }
        }
        return { response, data };
    }

    function showLoader(show, text = 'Loading...') {
        if (!elements.loader) return;
        elements.loader.classList.toggle('visible', show);
        if (elements.loaderText) {
            elements.loaderText.textContent = text;
        }
    }

    function showAlert(type, title, message) {
        if (!elements.alert) return;
        elements.alert.classList.add('visible');
        elements.alert.style.background = type === 'error' ? '#fee2e2' : '#fef3c7';
        elements.alert.style.color = type === 'error' ? '#b91c1c' : '#92400e';
        elements.alert.style.borderColor = type === 'error' ? '#fecaca' : '#fcd34d';
        elements.alertTitle.textContent = title;
        elements.alertMessage.textContent = message;
    }

    function hideAlert() {
        elements.alert?.classList.remove('visible');
    }

    function showToast(type, message, detail) {
        if (!elements.toastContainer) return;
        const toast = document.createElement('div');
        toast.className = `toast ${type}`;
        toast.textContent = detail ? `${message} – ${detail}` : message;
        elements.toastContainer.appendChild(toast);
        setTimeout(() => {
            toast.remove();
        }, 4200);
    }

    function setStep(step) {
        state.currentStep = step;
        elements.steps.forEach((node, idx) => {
            node.classList.toggle('active', idx === step - 1);
        });
        elements.sections.step1.classList.toggle('active', step === 1);
        elements.sections.step2.classList.toggle('active', step === 2);
    }

    function extractFaultyItems(inspection) {
        const items = [];
        const step2 = inspection?.step2 || {};
        if (step2.sections && step2.selections) {
            const selections = step2.selections || {};
            const notes = step2.notes || {};
            (step2.sections || []).forEach(section => {
                if (Array.isArray(section.subItems)) {
                    section.subItems.forEach(subItem => {
                        const key = subItem.key || subItem.id || subItem.itemName;
                        const status = selections[key];
                        const statusLower = (status || '').toString().toLowerCase();
                        const faultyStatuses = ['faulty','fail','failed','not ok','reject','defective','no','poor','bad','replace','repair'];
                        if (faultyStatuses.includes(statusLower)) {
                            items.push({
                                id: key,
                                name: subItem.itemName || subItem.label || key,
                                section: section.name || 'General',
                                category: subItem.category || section.category || 'General',
                                status: status,
                                note: notes[key] || subItem.description || '',
                            });
                        }
                    });
                }
            });
        } else if (Array.isArray(step2.faultyItems)) {
            step2.faultyItems.forEach((item, idx) => {
                items.push({
                    id: item.id || item.key || `faulty_${idx}`,
                    name: item.name || item.itemName || 'Faulty item',
                    section: item.section || item.sectionName || 'General',
                    category: item.category || 'General',
                    status: item.status || 'Faulty',
                    note: item.note || '',
                });
            });
        } else if (typeof step2.faultyItems === 'number') {
            // fallback: just create placeholder entries
            for (let i = 1; i <= step2.faultyItems; i++) {
                items.push({
                    id: `faulty_${i}`,
                    name: `Faulty item #${i}`,
                    section: 'General',
                    category: 'N/A',
                    status: 'Faulty',
                    note: '',
                });
            }
        }
        return items;
    }

    function renderFaultyItems() {
        if (!elements.faultyList) return;
        const items = state.faultyItems;
        if (!items.length) {
            elements.faultyList.innerHTML = '<div style="padding: 32px; text-align:center; color:#94a3b8;">No faulty items detected for this inspection.</div>';
            elements.stepButtons.goToStep2.disabled = true;
            return;
        }
            const rows = items.map((item, index) => {
            const statuses = ['Fixed','Not Fixed','No need'];
            const chips = statuses.map(status => {
                const selected = state.subItemStatuses[item.id] === status;
                const color = STATUS_COLORS[status] || '#475569';
                return `<div class="status-chip ${selected ? 'selected' : ''}" data-item="${item.id}" data-value="${status}" style="--chip-color: ${color};">
                    ${status}
                </div>`;
            }).join('');
            return `
                <div class="faulty-item">
                    <button type="button" class="note-btn" data-item="${item.id}">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M3 5a2 2 0 0 1 2-2h9.5L21 9.5V19a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2Z"></path>
                            <path d="M13 3v6h6"></path>
                        </svg>
                        Note
                    </button>
                    <div>
                        <h5>${index + 1}. ${item.name}</h5>
                        <small>${item.section} • ${item.category}</small>
                        ${item.note ? `<small>Note: ${item.note}</small>` : ''}
                        ${state.subItemNotes[item.id] ? `<div class="note-indicator">🗒 ${state.subItemNotes[item.id]}</div>` : ''}
                    </div>
                    <div class="status-chips">${chips}</div>
                </div>
            `;
        }).join('');
        elements.faultyList.innerHTML = rows;
        elements.stepButtons.goToStep2.disabled = !canProceedStep1();
            attachNoteButtons();
    }

    function canProceedStep1() {
        if (!state.faultyItems.length) return false;
        return state.faultyItems.every(item => !!state.subItemStatuses[item.id]);
    }

    function validateBeforeSave({ requireStep2 = false } = {}) {
        if (!state.inspectionId) {
            showAlert('error', 'Missing inspection', 'Inspection ID not provided.');
            return false;
        }
        if (!canProceedStep1()) {
            showToast('error', 'Incomplete', 'Set status for every faulty item first.');
            return false;
        }
        syncFormStateFromInputs();
        if (requireStep2) {
            if (!state.selectedRole) {
                showToast('error', 'Missing role', 'Choose who is responsible for the corrective action.');
                return false;
            }
            if (typeof state.isSatisfactory !== 'boolean') {
                showToast('error', 'Missing status', 'Indicate if equipment is satisfactory now.');
                return false;
            }
            if ((state.selectedRole === 'Mechanic' || state.selectedRole === 'Both') && !state.mechanicName) {
                showToast('error', 'Missing mechanic name', 'Provide mechanic responsible.');
                return false;
            }
            if ((state.selectedRole === 'Operator' || state.selectedRole === 'Both') && !state.operatorName) {
                showToast('error', 'Missing operator name', 'Provide operator responsible.');
                return false;
            }
        }
        return true;
    }

    function attachFaultyListListeners() {
        elements.faultyList?.addEventListener('click', (event) => {
            const target = event.target.closest('.status-chip');
            if (!target) return;
            const itemId = target.dataset.item;
            const value = target.dataset.value;
            if (!itemId || !value) return;
            state.subItemStatuses[itemId] = value;
            renderFaultyItems();
        });
    }

    function attachRadios() {
        ['satisfactory','role'].forEach(groupName => {
            elements.radios[groupName]?.addEventListener('click', (event) => {
                const pill = event.target.closest('.radio-pill');
                if (!pill) return;
                const value = pill.dataset.value;
                if (!value) return;
                elements.radios[groupName].querySelectorAll('.radio-pill').forEach(node => node.classList.remove('selected'));
                pill.classList.add('selected');
                if (groupName === 'satisfactory') {
                    state.isSatisfactory = value === 'true';
                } else {
                    state.selectedRole = value;
                    updateSignatureVisibility();
                }
            });
        });
    }

    function updateSignatureVisibility() {
        const role = state.selectedRole;
        const blocks = document.querySelectorAll('#signatureBlocks .form-field');
        if (!blocks.length) return;
        if (!role) {
            blocks.forEach(block => block.style.display = 'flex');
            return;
        }
        const normalizedRole = role === 'Both' ? 'both' : role.toLowerCase();
        blocks.forEach(block => {
            const blockRole = (block.dataset.role || '').toLowerCase();
            if (normalizedRole === 'both') {
                block.style.display = 'flex';
            } else {
                block.style.display = blockRole === normalizedRole ? 'flex' : 'none';
            }
        });
        
        // Re-initialize signature pads after visibility changes
        setTimeout(() => {
            initSignaturePads();
        }, 100);
    }

    function initSignaturePads() {
        Object.entries(elements.signaturePads).forEach(([key, canvas]) => {
            if (!canvas) {
                console.warn(`Canvas not found for ${key}`);
                return;
            }
            
            // Check if canvas is visible before initializing
            const rect = canvas.getBoundingClientRect();
            if (rect.width === 0 || rect.height === 0) {
                console.log(`Canvas ${key} not visible yet, will retry`);
                return;
            }
            
            // Store canvas ID for reference
            const canvasId = canvas.id;
            
            // Remove old event listeners if re-initializing by cloning
            if (canvas.dataset.initialized === 'true') {
                const parent = canvas.parentNode;
                const newCanvas = canvas.cloneNode(true);
                newCanvas.removeAttribute('data-initialized');
                parent.replaceChild(newCanvas, canvas);
                // Get fresh reference
                canvas = document.getElementById(canvasId);
                if (!canvas) {
                    console.error(`Failed to get canvas ${canvasId} after clone`);
                    return;
                }
                // Update elements reference
                elements.signaturePads[key] = canvas;
            }
            
            // Mark as initialized
            canvas.dataset.initialized = 'true';
            
            let drawing = false;
            let lastX = 0;
            let lastY = 0;
            
            // Get context - will be refreshed on resize
            const getContext = () => {
                const ctx = canvas.getContext('2d');
                const rect = canvas.getBoundingClientRect();
                const ratio = window.devicePixelRatio || 1;
                
                // Set actual size in memory (scaled for device pixel ratio)
                canvas.width = rect.width * ratio;
                canvas.height = rect.height * ratio;
                
                // Scale drawing context to match device pixel ratio
                ctx.scale(ratio, ratio);
                
                // Set drawing properties
                ctx.lineWidth = 2;
                ctx.lineCap = 'round';
                ctx.lineJoin = 'round';
                ctx.strokeStyle = '#0f172a';
                ctx.fillStyle = '#ffffff';
                
                // Fill with white background
                ctx.fillRect(0, 0, rect.width, rect.height);
                
                return ctx;
            };
            
            // Initialize canvas
            let ctx = getContext();
            
            // Re-initialize on resize
            let resizeTimeout;
            const handleResize = () => {
                clearTimeout(resizeTimeout);
                resizeTimeout = setTimeout(() => {
                    const wasEmpty = canvas.dataset.empty === 'true';
                    ctx = getContext();
                    drawing = false;
                    if (wasEmpty) {
                        canvas.dataset.empty = 'true';
                    }
                }, 100);
            };
            window.addEventListener('resize', handleResize);
            
            // Get position relative to canvas
            function getPos(e) {
                const rect = canvas.getBoundingClientRect();
                let clientX, clientY;
                
                if (e.touches && e.touches.length > 0) {
                    clientX = e.touches[0].clientX;
                    clientY = e.touches[0].clientY;
                } else if (e.changedTouches && e.changedTouches.length > 0) {
                    clientX = e.changedTouches[0].clientX;
                    clientY = e.changedTouches[0].clientY;
                } else {
                    clientX = e.clientX;
                    clientY = e.clientY;
                }
                
                return {
                    x: clientX - rect.left,
                    y: clientY - rect.top
                };
            }
            
            // Start drawing
            const start = (e) => {
                e.preventDefault();
                e.stopPropagation();
                drawing = true;
                canvas.dataset.empty = 'false';
                const pos = getPos(e);
                lastX = pos.x;
                lastY = pos.y;
                ctx.beginPath();
                ctx.moveTo(lastX, lastY);
                ctx.stroke();
            };
            
            // Continue drawing
            const draw = (e) => {
                if (!drawing) return;
                e.preventDefault();
                e.stopPropagation();
                const pos = getPos(e);
                ctx.lineTo(pos.x, pos.y);
                ctx.stroke();
                lastX = pos.x;
                lastY = pos.y;
            };
            
            // Stop drawing
            const end = (e) => {
                if (drawing) {
                    e.preventDefault();
                    e.stopPropagation();
                    drawing = false;
                }
            };
            
            // Mouse events
            canvas.addEventListener('mousedown', start);
            canvas.addEventListener('mousemove', draw);
            canvas.addEventListener('mouseup', end);
            canvas.addEventListener('mouseleave', end);
            
            // Touch events
            canvas.addEventListener('touchstart', start, { passive: false });
            canvas.addEventListener('touchmove', draw, { passive: false });
            canvas.addEventListener('touchend', end, { passive: false });
            canvas.addEventListener('touchcancel', end, { passive: false });
            
            console.log(`✅ Signature pad initialized for ${key}`);
        });

        // Clear button handlers
        document.querySelectorAll('.signature-tools button[data-action="clear"]').forEach(btn => {
            btn.addEventListener('click', () => {
                const targetId = btn.dataset.target;
                const canvas = document.getElementById(targetId);
                if (!canvas) return;
                const ctx = canvas.getContext('2d');
                const rect = canvas.getBoundingClientRect();
                ctx.clearRect(0, 0, rect.width, rect.height);
                ctx.fillStyle = '#ffffff';
                ctx.fillRect(0, 0, rect.width, rect.height);
                canvas.dataset.empty = 'true';
                showToast('info', 'Signature cleared', targetId.includes('mechanic') ? 'Mechanic' : 'Operator');
            });
        });
    }

    function getSignatureData(canvas) {
        if (!canvas || canvas.dataset.empty === 'true') return null;
        try {
            // Get signature as data URL with high quality
            return canvas.toDataURL('image/png', 1.0);
        } catch (error) {
            console.warn('Failed to get signature data:', error);
            return null;
        }
    }

    function syncFormStateFromInputs() {
        state.mechanicName = elements.inputs.mechanicName.value.trim();
        state.operatorName = elements.inputs.operatorName.value.trim();
        state.notes = elements.inputs.notes.value.trim();
        state.mechanicSignature = getSignatureData(elements.signaturePads.mechanic);
        state.operatorSignature = getSignatureData(elements.signaturePads.operator);
    }

    function loadSignatureIntoCanvas(canvas, signatureUri) {
        if (!canvas || !signatureUri) return;
        const ctx = canvas.getContext('2d');
        const img = new Image();
        img.crossOrigin = 'anonymous';
        img.onload = () => {
            // Resize canvas to match display size with device pixel ratio
            const ratio = window.devicePixelRatio || 1;
            const displayWidth = canvas.offsetWidth;
            const displayHeight = canvas.offsetHeight;
            
            // Save current canvas content if any
            const currentWidth = canvas.width;
            const currentHeight = canvas.height;
            
            // Resize canvas
            canvas.width = displayWidth * ratio;
            canvas.height = displayHeight * ratio;
            ctx.scale(ratio, ratio);
            
            // Re-apply drawing context settings
            ctx.lineWidth = 2;
            ctx.lineCap = 'round';
            ctx.strokeStyle = '#0f172a';
            
            // Clear and draw the signature image
            ctx.clearRect(0, 0, displayWidth, displayHeight);
            ctx.drawImage(img, 0, 0, displayWidth, displayHeight);
            canvas.dataset.empty = 'false';
        };
        img.onerror = () => {
            console.warn('Failed to load signature image:', signatureUri);
            canvas.dataset.empty = 'true';
        };
        img.src = signatureUri;
    }

    function populateFormFromState() {
        elements.inputs.mechanicName.value = state.mechanicName || '';
        elements.inputs.operatorName.value = state.operatorName || '';
        elements.inputs.notes.value = state.notes || '';
        if (typeof state.isSatisfactory === 'boolean') {
            elements.radios.satisfactory.querySelectorAll('.radio-pill').forEach(pill => {
                pill.classList.toggle('selected', pill.dataset.value === String(state.isSatisfactory));
            });
        }
        if (state.selectedRole) {
            elements.radios.role.querySelectorAll('.radio-pill').forEach(pill => {
                pill.classList.toggle('selected', pill.dataset.value === state.selectedRole);
            });
        }
        updateSignatureVisibility();
        
        // Load signatures into canvas if they exist
        // Use setTimeout to ensure canvas is fully initialized
        setTimeout(() => {
            if (state.mechanicSignature && (state.selectedRole === 'Mechanic' || state.selectedRole === 'Both')) {
                loadSignatureIntoCanvas(elements.signaturePads.mechanic, state.mechanicSignature);
            }
            if (state.operatorSignature && (state.selectedRole === 'Operator' || state.selectedRole === 'Both')) {
                loadSignatureIntoCanvas(elements.signaturePads.operator, state.operatorSignature);
            }
        }, 100);
        
        if (state.lastSavedAt) {
            elements.summary.savedAtStep2.textContent = new Date(state.lastSavedAt).toLocaleString();
        }
        
        // Update hasCorrectiveAction flag display
        if (state.hasCorrectiveAction) {
            showToast('info', 'Update mode', 'Editing existing corrective action');
        }
    }

    async function saveCorrectiveAction({ finalize = false, skipValidation = false } = {}) {
        const requireStep2 = state.currentStep === 2 || finalize;
        if (!skipValidation && !validateBeforeSave({ requireStep2 })) {
            return false;
        }
        // Always sync form state to capture signatures and input values
        syncFormStateFromInputs();
        const correctiveData = {
            subItemStatuses: state.subItemStatuses,
            faultyCount: state.faultyItems.length,
            updatedAt: new Date().toISOString(),
            role: state.selectedRole,
            isSatisfactory: state.isSatisfactory,
            mechanicName: state.mechanicName,
            operatorName: state.operatorName,
            mechanicSignatureUri: state.mechanicSignature,
            operatorSignatureUri: state.operatorSignature,
            notes: state.notes,
            subItemNotes: state.subItemNotes,
            pdfDownloadUrl: state.pdfDownloadUrl,
        };
        try {
            state.isSaving = true;
            showLoader(true, finalize ? 'Finalizing corrective action...' : 'Saving draft...');
            const { response, data } = await requestJson(API_ROUTES.correctiveAction, {
                method: 'POST',
                body: JSON.stringify({
                    reportId: state.inspectionId,
                    userId: AUTH_USER,
                    correctiveActionData: correctiveData
                })
            });
            if (!response.ok || !data.success) {
                throw new Error(data.error || 'Failed to save');
            }
            state.hasCorrectiveAction = true;
            state.lastSavedAt = new Date().toISOString();
            state.correctiveAction = correctiveData;
            elements.summary.savedAtStep2.textContent = new Date(state.lastSavedAt).toLocaleString();
            elements.summary.statusStep2.textContent = finalize ? 'Completed' : 'Draft saved';
            const message = finalize ? 'Corrective action finalized' : 'Draft saved';
            showToast('success', message, state.requestNumber || state.inspectionId);
            if (finalize) {
                showAlert('info', 'Corrective action synced', 'Data saved to MongoDB. You can close this tab or download the PDF later.');
            }
            return true;
        } catch (error) {
            console.error(error);
            showToast('error', 'Save failed', error.message);
            showAlert('error', 'Save failed', error.message);
            return false;
        } finally {
            showLoader(false);
            state.isSaving = false;
        }
    }

    async function generateCorrectiveActionPdf() {
        if (!state.inspectionId) return false;
        try {
            showLoader(true, 'Generating corrective action PDF...');
            
            // Generate HTML content
            let html;
            try {
                html = await buildPdfHtml();
                if (!html || typeof html !== 'string' || html.trim().length === 0) {
                    throw new Error('Failed to generate PDF HTML content - HTML is empty');
                }
                console.log('✅ PDF HTML generated successfully, length:', html.length);
            } catch (htmlError) {
                console.error('❌ Error building PDF HTML:', htmlError);
                throw new Error('Failed to generate PDF HTML: ' + htmlError.message);
            }
            
            // Prepare request payload
            const requestPayload = {
                html: html,
                inspectionId: state.inspectionId,
                requestNumber: state.requestNumber,
                correctiveActionData: {
                    subItemStatuses: state.subItemStatuses,
                    faultyCount: state.faultyItems.length,
                    role: state.selectedRole,
                    isSatisfactory: state.isSatisfactory,
                    mechanicName: state.mechanicName,
                    operatorName: state.operatorName,
                    notes: state.notes,
                    subItemNotes: state.subItemNotes
                }
            };
            
            console.log('📤 Sending PDF generation request:', {
                hasHtml: !!requestPayload.html,
                htmlLength: requestPayload.html?.length || 0,
                inspectionId: requestPayload.inspectionId,
                requestNumber: requestPayload.requestNumber
            });
            
            // Send HTML to backend to generate PDF using DomPDF
            const response = await fetch('/api/generate-corrective-action-pdf', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': CSRF_TOKEN || '',
                    'Accept': 'application/json'
                },
                body: JSON.stringify(requestPayload)
            });
            
            if (!response.ok) {
                const errorData = await response.json().catch(() => ({ message: 'Failed to generate PDF' }));
                throw new Error(errorData.message || 'PDF generation failed');
            }
            
            // Get PDF blob from response
            const pdfBlob = await response.blob();
            const fileName = generatePdfFileName();
            
            // Upload PDF blob to storage
            const uploadResult = await uploadPdfBlob(pdfBlob, fileName);
            state.pdfDownloadUrl = buildAbsoluteUrl(uploadResult.downloadUrl || uploadResult.absoluteDownloadUrl || state.pdfDownloadUrl);
            state.pdfFileName = uploadResult.fileName || fileName;
            updateDownloadButtonState(true);
            showToast('success', 'PDF generated', state.pdfFileName || state.requestNumber || '');
            return true;
        } catch (error) {
            console.error(error);
            showToast('error', 'PDF generation failed', error.message);
            showAlert('error', 'PDF generation failed', error.message);
            return false;
        } finally {
            showLoader(false);
        }
    }

    function generatePdfFileName() {
        const base = state.requestNumber || state.inspectionId || 'corrective_action';
        return `corrective_action_${base}_${Date.now()}.pdf`;
    }


    async function uploadPdfBlob(blob, fileName) {
        const uploadUrl = `${API_ROUTES.correctiveAction}/${encodeURIComponent(state.inspectionId)}/upload-pdf`;
        const formData = new FormData();
        const pdfBlob = blob instanceof Blob ? blob : new Blob([blob], { type: 'application/pdf' });
        formData.append('pdf', pdfBlob, fileName);
        formData.append('userId', AUTH_USER);
        const headers = {};
        if (CSRF_TOKEN) {
            headers['X-CSRF-TOKEN'] = CSRF_TOKEN;
        }
        const response = await fetch(uploadUrl, {
            method: 'POST',
            credentials: 'same-origin',
            body: formData,
            headers
        });
        const rawText = await response.text();
        let data = {};
        if (rawText) {
            try {
                data = JSON.parse(rawText);
            } catch (_) {
                throw new Error('Unexpected response while uploading PDF');
            }
        }
        if (!response.ok || !data.success) {
            throw new Error(data.error || 'Failed to upload PDF');
        }
        return data;
    }

    function buildChecklistRows() {
        // Match React Native logic exactly - only include items with selections of Ok, Okay, Reject, Not Ok, or N/A
        let checklistRows = '';
        const inspection = state.inspection || {};
        const step2 = inspection.step2 || {};
        const sections = step2.sections || [];
        const selections = step2.selections || {};
        const notes = step2.notes || {};

        // Include items with selections of Ok, Okay, Reject, Not Ok, or N/A (same as React Native)
        const selectedItems = sections.flatMap((section) =>
            (section.subItems || []).filter((item) => 
                selections[item.key] && 
                ['Ok', 'Okay', 'Reject', 'Not Ok', 'N/A'].includes(selections[item.key])
            )
        );

        if (selectedItems.length === 0) {
            checklistRows = `
                <tr>
                    <td colspan="6">No selected inspection items available</td>
                </tr>
            `;
        } else {
            selectedItems.forEach((item) => {
                const selection = selections[item.key] || 'N/A';
                const isOkay = selection === 'Okay' || selection === 'Ok';
                const isFaulty = selection === 'Faulty' || selection === 'Reject' || selection === 'Not Ok';
                const isNA = selection === 'N/A';
                const comment = (notes && notes[item.key]) ? notes[item.key] : '';
                const classification = item.isInspectionRequired ? 'A' : 'B';
                checklistRows += `
                    <tr>
                        <td>${escapeHtml(item.itemName || 'Unknown')}</td>
                        <td style="text-align: center;">${classification}</td>
                        <td style="text-align: center;">${isOkay ? '✓' : ''}</td>
                        <td style="text-align: center;">${isFaulty ? 'X' : ''}</td>
                        <td style="text-align: center;">${isNA ? '—' : ''}</td>
                        <td style="text-align: left;">${escapeHtml(comment || '')}</td>
                    </tr>
                `;
            });
        }
        return checklistRows;
    }

    function buildCorrectiveRows() {
        if (!state.faultyItems.length) {
            return [{
                name: 'No faulty items recorded',
                status: 'N/A',
                comment: ''
            }];
        }
        return state.faultyItems.map(item => ({
            name: item.name,
            status: state.subItemStatuses[item.id] || 'Pending',
            comment: state.subItemNotes[item.id] || item.note || ''
        }));
    }

    function isValidSignatureUri(uri) {
        return uri && typeof uri === 'string' && (uri.startsWith('data:image') || uri.startsWith('http'));
    }

    async function loadLogoAsBase64() {
        return new Promise((resolve) => {
            const img = new Image();
            img.crossOrigin = 'anonymous';
            img.onload = function() {
                const canvas = document.createElement('canvas');
                canvas.width = this.width;
                canvas.height = this.height;
                const ctx = canvas.getContext('2d');
                ctx.drawImage(this, 0, 0);
                try {
                    const base64 = canvas.toDataURL('image/png');
                    resolve(base64);
                } catch (e) {
                    console.warn('Failed to convert logo to base64:', e);
                    resolve(null);
                }
            };
            img.onerror = function() {
                console.warn('Failed to load logo image');
                resolve(null);
            };
            // Try local logo first, then fallback to external
            img.src = LOGO_URL || 'https://www.titanafricadrilling.com/wp-content/uploads/2022/10/titan-drlling_blue.png';
        });
    }

    async function buildPdfHtml() {
        const inspection = state.inspection || {};
        const step1 = inspection.step1 || {};
        const step3 = inspection.step3 || {};
        const equipment = step1.selectedEquipment || {};
        const requestNumber = state.requestNumber || inspection.requestNumber || inspection.id || '--';
        const country = step1.country || inspection.country || 'Not specified';
        const project = step1.project || step1.location || inspection.project || 'Not specified';
        const inspector = step1.inspector || step1.inspectorName || 'Not specified';
        const equipmentName = equipment.equipmentName || inspection.equipmentName || 'Not specified';
        const equipmentNumber = equipment.vehicleNumber || equipment.id || 'N/A';
        const hours = equipment.meterReading ? `${equipment.meterReading} ${equipment.meterUnit || 'Hours'}`.trim() : 'N/A';
        const createdAt = step1.createdAt || inspection.createdAt || new Date().toISOString();
        const remarks = step3.additionalNote || state.notes || 'N/A';
        const satisfaction = typeof state.isSatisfactory === 'boolean'
            ? (state.isSatisfactory ? 'Satisfactory' : 'Unsatisfactory')
            : 'Not Specified';
        const roleText = state.selectedRole || 'N/A';
        const mechanicName = state.mechanicName || 'N/A';
        const operatorName = state.operatorName || 'N/A';
        
        // Get signatures - match React Native logic
        const mechanicSignSrc = (state.selectedRole === 'Mechanic' || state.selectedRole === 'Both') && isValidSignatureUri(state.mechanicSignature)
            ? state.mechanicSignature
            : null;
        const operatorSignSrc = (state.selectedRole === 'Operator' || state.selectedRole === 'Both') && isValidSignatureUri(state.operatorSignature)
            ? state.operatorSignature
            : null;
        
        const checklistRows = buildChecklistRows();
        const correctiveItems = buildCorrectiveRows();
        const correctiveRows = correctiveItems.length > 0
            ? correctiveItems.map((row, index) => `
                <tr>
                    <td style="text-align: center;">${index + 1}</td>
                    <td>${escapeHtml(row.name)}</td>
                    <td>${escapeHtml(row.status)}</td>
                    <td>${escapeHtml(row.comment || '')}</td>
                </tr>
            `).join('')
            : '<tr><td colspan="4">No corrective action items available</td></tr>';
        
        // Get step3 summary data (match React Native)
        const overallCondition = step3.overallCondition || 'N/A';
        const equipmentStatus = step3.equipmentStatus || 'N/A';
        const priority = step3.priority || 'N/A';
        const safeToUse = step3.safeToUse || step3.vehicleSafeToUse || 'N/A';
        
        // Get inspector signature from multiple possible locations (match React Native logic)
        let inspectorSignatureUrl = null;
        if (step3.signatureDownloadUrl) {
            inspectorSignatureUrl = step3.signatureDownloadUrl;
        } else if (step3.inspectorSignature) {
            inspectorSignatureUrl = step3.inspectorSignature;
        } else if (step3.signatureData && typeof step3.signatureData === 'string' && step3.signatureData.startsWith('data:image')) {
            inspectorSignatureUrl = step3.signatureData;
        } else if (step3.individualSignatures && typeof step3.individualSignatures === 'object') {
            // Try to get first individual signature
            const signatureKeys = Object.keys(step3.individualSignatures);
            if (signatureKeys.length > 0) {
                const firstKey = signatureKeys[0];
                const firstSignature = step3.individualSignatures[firstKey];
                if (firstSignature && typeof firstSignature === 'string') {
                    inspectorSignatureUrl = firstSignature;
                }
            }
        }
        
        // Convert inspector signature to base64 if it's a URL (for reliable PDF rendering)
        let inspectorSignatureBase64 = null;
        if (inspectorSignatureUrl && !inspectorSignatureUrl.startsWith('data:image')) {
            try {
                const sigResponse = await fetch(inspectorSignatureUrl);
                if (sigResponse.ok) {
                    const blob = await sigResponse.blob();
                    inspectorSignatureBase64 = await new Promise((resolve) => {
                        const reader = new FileReader();
                        reader.onloadend = () => resolve(reader.result);
                        reader.readAsDataURL(blob);
                    });
                }
            } catch (e) {
                console.warn('Failed to convert inspector signature to base64:', e);
                // Fallback to original URL
                inspectorSignatureBase64 = inspectorSignatureUrl;
            }
        } else if (inspectorSignatureUrl) {
            inspectorSignatureBase64 = inspectorSignatureUrl;
        }

        // Load logo as base64 for reliable PDF rendering
        const logoBase64 = await loadLogoAsBase64();
        const logoSrc = logoBase64 || (LOGO_URL || 'https://www.titanafricadrilling.com/wp-content/uploads/2022/10/titan-drlling_blue.png');

        return `
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Inspection and Corrective Action Report</title>
  <style>${PDF_TEMPLATE_CSS}</style>
</head>
<body>
  <div class="header-row">
    <div class="logo-left">
      <img src="${logoSrc}" alt="Titan Africa Drilling Logo" style="width: 140px; height: 50px; object-fit: contain; display: block; margin: 0 auto;"/>
    </div>
    <div class="doc-info-box">
      <table>
        <tr><td>Document Name</td><td>${escapeHtml(step1.checklistTitle || 'Inspection and Corrective Action Report')}</td></tr>
        <tr><td>Document ID</td><td>CA-${escapeHtml(requestNumber)}</td></tr>
        <tr><td>Version Date</td><td>${formatDateShort(new Date())}</td></tr>
        <tr><td>Version</td><td>1.0</td></tr>
        <tr><td>Approved</td><td>${escapeHtml(inspector)}</td></tr>
        <tr><td>Country</td><td>${escapeHtml(country)}</td></tr>
        <tr><td>Project</td><td>${escapeHtml(project)}</td></tr>
      </table>
    </div>
  </div>

  <div class="title-section">
    <h2>${escapeHtml(step1.checklistTitle || 'INSPECTION AND CORRECTIVE ACTION REPORT')}</h2>
    <div class="request-number">NO: ${escapeHtml(requestNumber)}</div>
  </div>

  <div class="info-boxes-row">
    <div class="info-box">
      <table>
        <tr><td>DATE</td><td>${formatDateShort(createdAt)}</td></tr>
        <tr><td>SITE / PROJECT</td><td>${escapeHtml(project)}</td></tr>
        <tr><td>INSPECTOR</td><td>${escapeHtml(inspector)}</td></tr>
      </table>
    </div>
    <div class="info-box">
      <table>
        <tr><td>COMPRESSOR No</td><td>${escapeHtml(equipmentName)}</td></tr>
        <tr><td>HOURS</td><td>${escapeHtml(hours)}</td></tr>
      </table>
    </div>
  </div>

  <div class="classification">
    <table>
      <tr><td>1. ALL DEFECTS UNDER "A" CLASSIFICATION TO BE ATTENDED IMMEDIATELY</td></tr>
      <tr><td>2. ALL DEFECTS UNDER "B" CLASSIFICATION TO BE ATTENDED WITHIN 48 HOURS</td></tr>
      <tr><td>3. ALL DEFECTS UNDER "C" CLASSIFICATION TO BE ATTENDED TO AS SOON AS POSSIBLE</td></tr>
    </table>
  </div>

  <table class="checklist">
    <tr>
      <th>DESCRIPTION</th>
      <th>CLASS</th>
      <th>OKAY</th>
      <th>FAULTY</th>
      <th>N/A</th>
      <th>COMMENT</th>
    </tr>
    ${checklistRows}
    <tr>
      <td>REMARKS</td>
      <td colspan="5">${escapeHtml(remarks)}</td>
    </tr>
  </table>

  <table class="summary-section-table">
    <tr>
      <td class="label">Overall Condition</td>
      <td>${escapeHtml(overallCondition)}</td>
      <td class="signature-cell" rowspan="3">
        ${inspectorSignatureBase64
          ? `<img src="${escapeHtml(inspectorSignatureBase64)}" alt="Inspector Signature" class="signature-img" />`
          : '<div class="signature-img" style="display: flex; align-items: center; justify-content: center; color: #999;">Not Provided</div>'}
      </td>
    </tr>
    <tr>
      <td class="label">Vehicle Safe To Use</td>
      <td style="color: ${safeToUse === 'Yes' ? '#28a745' : '#e74c3c'};">
        ${escapeHtml(safeToUse)}
      </td>
    </tr>
    <tr>
      <td class="label">Maintenance Priority</td>
      <td>${escapeHtml(priority)}</td>
    </tr>
  </table>

  <div class="section-break"></div>
  <h2>CORRECTIVE ACTION ITEMS</h2>
  <div style="margin-bottom: 15px;">
    <p><strong>Equipment Condition After Correction:</strong> ${escapeHtml(satisfaction)}</p>
    <p><strong>Role:</strong> ${escapeHtml(roleText)}</p>
    <p><strong>Mechanic Name:</strong> ${escapeHtml(mechanicName)}</p>
    <p><strong>Operator Name:</strong> ${escapeHtml(operatorName)}</p>
  </div>

  <table class="corrective-table">
    <tr>
      <th>S.No</th>
      <th>Item</th>
      <th>Status</th>
      <th>Comment</th>
    </tr>
    ${correctiveRows}
  </table>

  <table class="summary-section-table">
    <tr>
      <td class="label">Mechanic Signature</td>
      <td class="signature-cell">
        ${mechanicSignSrc
          ? `<img src="${escapeHtml(mechanicSignSrc)}" alt="Mechanic Signature" class="signature-img" />`
          : '<div class="signature-img" style="display: flex; align-items: center; justify-content: center; color: #999;">Not Provided</div>'}
      </td>
      <td class="label">Operator Signature</td>
      <td class="signature-cell">
        ${operatorSignSrc
          ? `<img src="${escapeHtml(operatorSignSrc)}" alt="Operator Signature" class="signature-img" />`
          : '<div class="signature-img" style="display: flex; align-items: center; justify-content: center; color: #999;">Not Provided</div>'}
      </td>
    </tr>
  </table>
</body>
</html>`;
    }

    async function loadExistingCorrectiveAction() {
        if (!state.inspectionId) return;
        try {
            const { response, data: payload } = await requestJson(`${API_ROUTES.correctiveAction}/${encodeURIComponent(state.inspectionId)}`);
            if (!response.ok || !payload.success || !payload.data) {
                state.hasCorrectiveAction = false;
                return;
            }
            const data = payload.data;
            state.correctiveAction = data;
            state.hasCorrectiveAction = true;
            state.lastSavedAt = data.updatedAt || data.createdAt || new Date().toISOString();
            state.subItemStatuses = data.subItemStatuses || state.subItemStatuses;
            state.selectedRole = data.role || state.selectedRole;
            state.isSatisfactory = typeof data.isSatisfactory === 'boolean' ? data.isSatisfactory : state.isSatisfactory;
            state.mechanicName = data.mechanicName || '';
            state.operatorName = data.operatorName || '';
            state.notes = data.notes || '';
            state.pdfDownloadUrl = buildAbsoluteUrl(data.pdfDownloadUrl || data.correctiveAction?.pdfDownloadUrl || null);
            state.pdfFileName = data.pdfFileName || state.pdfFileName;
            state.subItemNotes = data.subItemNotes || state.subItemNotes;
            
            // Load signatures if they exist
            if (data.mechanicSignatureUri) {
                state.mechanicSignatureUri = data.mechanicSignatureUri;
                // If it's a data URI, use it directly; otherwise try to load it
                if (data.mechanicSignatureUri.startsWith('data:image')) {
                    state.mechanicSignature = data.mechanicSignatureUri;
                } else {
                    // Try to load signature image
                    try {
                        const sigResponse = await fetch(data.mechanicSignatureUri);
                        if (sigResponse.ok) {
                            const blob = await sigResponse.blob();
                            state.mechanicSignature = await new Promise((resolve) => {
                                const reader = new FileReader();
                                reader.onloadend = () => resolve(reader.result);
                                reader.readAsDataURL(blob);
                            });
                        }
                    } catch (e) {
                        console.warn('Failed to load mechanic signature:', e);
                    }
                }
            }
            
            if (data.operatorSignatureUri) {
                state.operatorSignatureUri = data.operatorSignatureUri;
                if (data.operatorSignatureUri.startsWith('data:image')) {
                    state.operatorSignature = data.operatorSignatureUri;
                } else {
                    try {
                        const sigResponse = await fetch(data.operatorSignatureUri);
                        if (sigResponse.ok) {
                            const blob = await sigResponse.blob();
                            state.operatorSignature = await new Promise((resolve) => {
                                const reader = new FileReader();
                                reader.onloadend = () => resolve(reader.result);
                                reader.readAsDataURL(blob);
                            });
                        }
                    } catch (e) {
                        console.warn('Failed to load operator signature:', e);
                    }
                }
            }
            
            if (data.updatedAt) {
                state.lastSavedAt = data.updatedAt;
            }
            renderFaultyItems();
            populateFormFromState();
            showToast('info', 'Loaded existing corrective action', state.requestNumber || state.inspectionId);
            updateDownloadButtonState(Boolean(state.pdfDownloadUrl));
        } catch (error) {
            console.warn('No corrective action found yet', error);
            state.hasCorrectiveAction = false;
        }
    }

    async function fetchInspectionData() {
        if (!state.inspectionId) {
            showAlert('error', 'Missing inspection', 'Provide an inspectionId query parameter.');
            return;
        }
        try {
            showLoader(true, 'Fetching inspection...');
            const { response, data } = await requestJson(`${API_ROUTES.inspectionReport}/${encodeURIComponent(state.inspectionId)}`);
            if (!response.ok || !data.success) {
                throw new Error(data.error || 'Unable to fetch inspection');
            }
            state.inspection = data.data;
            state.requestNumber = state.requestNumber || state.inspection.requestNumber || state.inspection.step1?.requestNumber || null;
            state.faultyItems = extractFaultyItems(state.inspection);
            state.faultyItems.forEach(item => {
                if (!state.subItemStatuses[item.id]) {
                    state.subItemStatuses[item.id] = null;
                }
            });
            updateSummary();
            renderFaultyItems();
            await loadExistingCorrectiveAction();
        } catch (error) {
            console.error(error);
            showAlert('error', 'Failed to load inspection', error.message);
        } finally {
            showLoader(false);
        }
    }

    function updateSummary() {
        elements.meta.inspectionId.textContent = `Inspection: ${state.inspectionId || '--'}`;
        elements.meta.requestNumber.textContent = `Request #: ${state.requestNumber || '--'}`;
        const equipmentName = state.inspection?.step1?.selectedEquipment?.equipmentName || state.inspection?.equipmentName || 'N/A';
        elements.meta.equipment.textContent = `Equipment: ${equipmentName}`;

        elements.summary.requestNumber.textContent = state.requestNumber || '--';
        elements.summary.inspector.textContent = state.inspection?.step1?.inspector || 'N/A';
        elements.summary.equipment.textContent = equipmentName;
        elements.summary.faultyCount.textContent = state.faultyItems.length;
        elements.summary.faultyCountStep2.textContent = state.faultyItems.length;
    }

    function attachEventHandlers() {
        elements.stepButtons.resetStep1?.addEventListener('click', () => {
            Object.keys(state.subItemStatuses).forEach(key => state.subItemStatuses[key] = null);
            renderFaultyItems();
            showToast('info', 'Selections cleared');
        });
        elements.stepButtons.saveDraftStep1?.addEventListener('click', () => saveCorrectiveAction({ finalize: false }));
        elements.stepButtons.goToStep2?.addEventListener('click', () => {
            if (!canProceedStep1()) {
                showToast('error', 'Incomplete', 'Please set status for each faulty item.');
                return;
            }
            setStep(2);
        });
        elements.stepButtons.backToStep1?.addEventListener('click', () => setStep(1));
        elements.stepButtons.saveDraftStep2?.addEventListener('click', () => saveCorrectiveAction({ finalize: false }));
        elements.stepButtons.finalize?.addEventListener('click', handleFinalizeClick);
        elements.stepButtons.downloadPdf?.addEventListener('click', () => {
            if (!state.pdfDownloadUrl) {
                showToast('info', 'PDF not available', 'Finalize the corrective action first.');
                return;
            }
            downloadPdf(state.pdfDownloadUrl);
        });

        elements.inputs.mechanicName.addEventListener('input', (e) => state.mechanicName = e.target.value);
        elements.inputs.operatorName.addEventListener('input', (e) => state.operatorName = e.target.value);
        elements.inputs.notes.addEventListener('input', (e) => state.notes = e.target.value);

        elements.noteModal.save?.addEventListener('click', saveNoteFromModal);
        elements.noteModal.cancel?.addEventListener('click', closeNoteModal);

        elements.successModal.downloadPdf?.addEventListener('click', () => {
            if (!state.pdfDownloadUrl) {
                showToast('info', 'PDF not ready yet', 'Please wait a moment and try again.');
                return;
            }
            downloadPdf(state.pdfDownloadUrl);
        });

        elements.successModal.back?.addEventListener('click', () => {
            const targetUrl = (INSPECTION_REPORTS_URL && INSPECTION_REPORTS_URL.length) ? INSPECTION_REPORTS_URL : '/inspection/inspection-report';
            window.location.href = targetUrl;
        });

        elements.successModal.container?.addEventListener('click', (event) => {
            if (event.target === elements.successModal.container) {
                closeSuccessModal();
            }
        });
    }

    async function handleFinalizeClick() {
        if (state.isSaving) return;
        const valid = validateBeforeSave({ requireStep2: true });
        if (!valid) return;
        state.isSaving = true;
        try {
            const pdfReady = await generateCorrectiveActionPdf();
            if (!pdfReady) return;
            const saved = await saveCorrectiveAction({ finalize: true, skipValidation: true });
            if (saved) {
                openSuccessModal();
            }
        } finally {
            state.isSaving = false;
        }
    }

    function init() {
        elements = cacheElements();
        updateDownloadButtonState(false);
        hideAlert();
        attachFaultyListListeners();
        attachRadios();
        
        // Initialize signature pads after DOM is ready and visible
        setTimeout(() => {
            initSignaturePads();
            // Also initialize when step 2 becomes active
            const observer = new MutationObserver(() => {
                if (state.currentStep === 2) {
                    setTimeout(() => {
                        initSignaturePads();
                    }, 50);
                }
            });
            observer.observe(document.getElementById('step2Section'), {
                attributes: true,
                attributeFilter: ['class']
            });
        }, 200);
        
        attachEventHandlers();
        updateSignatureVisibility();
        if (INITIAL_MODE === 'create') {
            showToast('info', 'Create mode', 'Fill Step 1 to begin corrective action.');
        } else if (INITIAL_MODE === 'update') {
            showToast('info', 'Update mode', 'Loading existing corrective action…');
        }
        if (!state.inspectionId) {
            showAlert('error', 'Inspection not provided', 'Append ?inspectionId=<ID> to the URL.');
            return;
        }
        fetchInspectionData();
    }

    function attachNoteButtons() {
        document.querySelectorAll('.note-btn').forEach(btn => {
            btn.addEventListener('click', () => openNoteModal(btn.dataset.item));
        });
    }

    function openNoteModal(itemId) {
        if (!itemId || !elements.noteModal.container) return;
        state.activeNoteItemId = itemId;
        const item = state.faultyItems.find(entry => entry.id === itemId);
        if (elements.noteModal.title) {
            elements.noteModal.title.textContent = item ? `Notes for ${item.name}` : 'Add note';
        }
        if (elements.noteModal.textarea) {
            elements.noteModal.textarea.value = state.subItemNotes[itemId] || '';
        }
        elements.noteModal.container.classList.add('visible');
    }

    function closeNoteModal() {
        elements.noteModal.container?.classList.remove('visible');
        state.activeNoteItemId = null;
    }

    function saveNoteFromModal() {
        if (!state.activeNoteItemId) {
            closeNoteModal();
            return;
        }
        const text = (elements.noteModal.textarea?.value || '').trim();
        if (text) {
            state.subItemNotes[state.activeNoteItemId] = text;
        } else {
            delete state.subItemNotes[state.activeNoteItemId];
        }
        closeNoteModal();
        renderFaultyItems();
    }

    function openSuccessModal() {
        if (!elements.successModal.container) return;
        const pdfReady = Boolean(state.pdfDownloadUrl);
        elements.successModal.container.classList.add('visible');
        elements.successModal.container.setAttribute('aria-hidden', 'false');
        if (elements.successModal.message) {
            elements.successModal.message.textContent = pdfReady
                ? 'Your corrective action PDF is ready. You can view it now or head back to the reports list.'
                : 'Corrective action saved. The PDF will be available shortly.';
        }
    }

    function closeSuccessModal() {
        if (!elements.successModal.container) return;
        elements.successModal.container.classList.remove('visible');
        elements.successModal.container.setAttribute('aria-hidden', 'true');
    }

    function updateDownloadButtonState(enabled) {
        if (!elements.stepButtons.downloadPdf) return;
        elements.stepButtons.downloadPdf.disabled = !enabled;
    }

    function downloadPdf(url) {
        const absoluteUrl = buildAbsoluteUrl(url);
        if (!absoluteUrl) {
            showToast('error', 'Download failed', 'PDF link missing.');
            return;
        }
        const link = document.createElement('a');
        link.href = absoluteUrl;
        link.target = '_blank';
        link.rel = 'noopener';
        link.download = state.pdfFileName || `${state.requestNumber || state.inspectionId || 'corrective_action'}.pdf`;
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    }

    document.addEventListener('DOMContentLoaded', init);
})();
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/inspection/InsCorrectiveAction/StepsCorrectiveAction.blade.php ENDPATH**/ ?>