<?php $__env->startSection('title', 'HSE Inspection Reports'); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-dQ39zqK1p5MnZ3V4n5nRkubgOZpO2wK0uX0hUxX67+xoycGgSoxuV+/Nx8IJ3mVXkB0Uqz3BSPBZz1Yz4Z6kNA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    :root {
        --hse-primary: #015185;
        --hse-primary-dark: #023f64;
        --hse-accent: #0f8a5f;
        --hse-danger: #c0392b;
        --hse-warning: #f39c12;
        --hse-bg: #f5f7fb;
        --hse-border: #e0e7ef;
        --hse-text: #0f172a;
        --hse-muted: #64748b;
        --hse-card-bg: #ffffff;
        --hse-shadow: 0 12px 30px rgba(15, 81, 133, 0.08);
    }

    body.modal-open {
        overflow: hidden;
    }

    .hse-screen {
        min-height: 100vh;
        padding: 32px;
        background: var(--hse-bg);
    }

    @media (max-width: 1024px) {
        .hse-screen {
            padding: 20px;
        }
    }

    .hse-header {
        background: linear-gradient(135deg, var(--hse-primary), var(--hse-primary-dark));
        border-radius: 20px;
        padding: 28px;
        color: #fff;
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        gap: 24px;
        flex-wrap: wrap;
        box-shadow: var(--hse-shadow);
    }

    .hse-header-left {
        display: flex;
        align-items: flex-start;
        gap: 16px;
        flex: 1 1 60%;
        min-width: 280px;
    }

    .hse-back-button {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 44px;
        height: 44px;
        border-radius: 50%;
        border: 1px solid rgba(255,255,255,0.4);
        color: #fff;
        text-decoration: none;
        font-size: 18px;
        transition: opacity 0.2s ease, transform 0.2s ease;
    }

    .hse-back-button:hover {
        opacity: 0.85;
        transform: translateX(-2px);
    }

    .hse-header-text h1 {
        margin: 4px 0;
    }

    .hse-breadcrumb {
        color: rgba(255,255,255,0.75);
        margin: 0;
        font-size: 14px;
    }

    .hse-breadcrumb a {
        color: rgba(255,255,255,0.85);
        text-decoration: none;
    }

    .hse-breadcrumb span {
        margin: 0 6px;
    }

    .hse-header-right {
        display: flex;
        flex-direction: column;
        gap: 12px;
        align-items: stretch;
        flex: 1 1 35%;
        min-width: 260px;
    }

    .hse-header-search {
        position: relative;
        display: flex;
        align-items: center;
    }

    .hse-header-search i {
        position: absolute;
        left: 14px;
        color: var(--hse-muted);
    }

    .hse-header-search input {
        width: 100%;
        padding: 12px 16px 12px 42px;
        border-radius: 999px;
        border: none;
        outline: none;
        font-size: 14px;
        color: var(--hse-text);
        background: rgba(255,255,255,0.95);
        box-shadow: 0 10px 25px rgba(0,0,0,0.12);
    }

    .hse-header-buttons {
        display: flex;
        gap: 10px;
        justify-content: flex-end;
        flex-wrap: wrap;
    }

    .sr-only {
        position: absolute;
        width: 1px;
        height: 1px;
        padding: 0;
        margin: -1px;
        overflow: hidden;
        clip: rect(0,0,0,0);
        white-space: nowrap;
        border: 0;
    }

    .hse-header h1 {
        font-size: 28px;
        margin-bottom: 10px;
    }

    .hse-header p {
        margin: 0;
        color: rgba(255, 255, 255, 0.85);
    }

    .hse-header-actions {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .hse-controls {
        margin-top: 20px;
        margin-bottom: 12px;
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
        align-items: center;
        background: #fff;
        padding: 16px 20px;
        border-radius: 14px;
        border: 1px solid var(--hse-border);
        box-shadow: var(--hse-shadow);
    }

    .hse-search {
        flex: 1;
        min-width: 240px;
        position: relative;
    }

    .hse-search input {
        width: 100%;
        padding: 12px 16px 12px 42px;
        border-radius: 12px;
        border: 1px solid var(--hse-border);
        font-size: 15px;
        color: var(--hse-text);
        background: #fff;
        transition: border-color 0.2s ease;
    }

    .hse-search input::placeholder {
        color: var(--hse-muted);
    }

    .hse-search input:focus {
        outline: none;
        border-color: var(--hse-primary);
        box-shadow: 0 0 0 3px rgba(1, 81, 133, 0.08);
    }

    .hse-search i {
        position: absolute;
        top: 50%;
        left: 14px;
        transform: translateY(-50%);
        color: var(--hse-muted);
    }

    .hse-filter-group {
        display: flex;
        align-items: center;
        gap: 10px;
        flex-wrap: wrap;
    }

    .hse-filter-group select {
        border-radius: 10px;
        border: 1px solid var(--hse-border);
        padding: 10px 14px;
        background: #fff;
        color: var(--hse-text);
        min-width: 170px;
    }

    .hse-btn {
        border: none;
        border-radius: 10px;
        padding: 10px 18px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        transition: transform 0.15s ease, box-shadow 0.15s ease, background 0.2s ease;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .hse-btn i {
        font-size: 14px;
    }

    .hse-btn.primary {
        background: var(--hse-primary);
        color: #fff;
        box-shadow: 0 8px 18px rgba(1, 81, 133, 0.2);
    }

    .hse-btn.primary:hover {
        background: var(--hse-primary-dark);
    }

    .hse-btn.ghost {
        background: rgba(1, 81, 133, 0.08);
        color: var(--hse-primary);
    }

    .hse-btn.light {
        background: #fff;
        border: 1px solid var(--hse-border);
        color: var(--hse-text);
    }

    .hse-btn.danger {
        background: rgba(192, 57, 43, 0.1);
        color: var(--hse-danger);
    }

    .hse-btn:disabled {
        opacity: 0.6;
        cursor: not-allowed;
        box-shadow: none;
    }

    .hse-card-container {
        background: #fff;
        border-radius: 18px;
        border: 1px solid var(--hse-border);
        box-shadow: var(--hse-shadow);
        margin-top: 24px;
    }

    .hse-tab-header {
        display: flex;
        gap: 10px;
        padding: 12px 16px 0;
        border-bottom: 1px solid var(--hse-border);
        background: #fff;
        border-radius: 18px 18px 0 0;
        flex-wrap: wrap;
    }

    .hse-tab-button {
        border: none;
        background: rgba(1, 81, 133, 0.08);
        color: var(--hse-primary);
        padding: 10px 18px;
        border-radius: 999px 999px 0 0;
        font-weight: 600;
        cursor: pointer;
        transition: background 0.2s ease, color 0.2s ease, transform 0.2s ease;
    }

    .hse-tab-button:hover {
        transform: translateY(-1px);
    }

    .hse-tab-button.active {
        background: var(--hse-primary);
        color: #fff;
        box-shadow: 0 10px 20px rgba(1, 81, 133, 0.18);
    }

    .hse-tab-panel {
        display: none;
        padding: 0 0 24px;
    }

    .hse-tab-panel.active {
        display: block;
    }

    .hse-card-section {
        padding: 24px;
    }

    .hse-summary-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        gap: 12px;
        margin-bottom: 18px;
    }

    .hse-summary-subtitle {
        color: var(--hse-muted);
        margin: 4px 0 0 0;
        font-size: 14px;
    }

    .hse-summary-timestamp {
        color: var(--hse-muted);
        font-size: 13px;
    }

    .hse-summary-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(210px, 1fr));
        gap: 18px;
    }

    .hse-summary-card {
        background: var(--hse-card-bg);
        border-radius: 16px;
        padding: 20px;
        border: 1px solid var(--hse-border);
        box-shadow: var(--hse-shadow);
    }

    .hse-summary-label {
        font-size: 14px;
        color: var(--hse-muted);
        text-transform: uppercase;
        letter-spacing: 0.08em;
    }

    .hse-summary-value {
        font-size: 32px;
        font-weight: 700;
        margin: 12px 0 6px;
        color: var(--hse-text);
    }

    .hse-summary-meta {
        font-size: 13px;
        color: var(--hse-muted);
    }

    .hse-table-card {
        margin-top: 28px;
        background: var(--hse-card-bg);
        border-radius: 18px;
        border: 1px solid var(--hse-border);
        padding: 0;
        box-shadow: var(--hse-shadow);
        overflow: hidden;
    }

    .hse-table-card > .hse-table-toolbar {
        padding: 24px;
    }

    .hse-table-toolbar {
        display: flex;
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 12px;
        margin-bottom: 16px;
    }

    .hse-table-meta {
        color: var(--hse-muted);
        font-size: 14px;
    }

    .hse-table-wrapper {
        overflow-x: auto;
        overflow-y: visible;
        border-radius: 12px;
        border: 1px solid var(--hse-border);
        margin: 0 24px 24px;
        position: relative;
    }

    table.hse-table {
        width: 100%;
        border-collapse: collapse;
        min-width: 1100px;
        table-layout: fixed;
    }

    .hse-table thead {
        background: #f8fafc;
    }

    .hse-table th {
        text-align: left;
        padding: 12px 16px;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: var(--hse-muted);
        font-weight: 600;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .hse-table tbody tr:nth-child(every) {
        background: #fff;
    }

    .hse-table td {
        padding: 14px 16px;
        border-top: 1px solid var(--hse-border);
        font-size: 14px;
        color: var(--hse-text);
        white-space: nowrap;
        overflow: visible;
        text-overflow: ellipsis;
    }
    
    /* Action cell with dropdown needs special handling */
    .hse-table td:has(.hse-dropdown),
    .hse-table td:nth-child(2) {
        overflow: visible;
        position: relative;
        z-index: 1;
    }
    
    .hse-table tbody tr {
        position: relative;
    }

    .hse-table tbody tr:hover {
        background: rgba(1, 81, 133, 0.03);
    }

    .hse-dropdown {
        position: relative;
        display: inline-block;
    }

    .hse-action-btn {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 8px 14px;
        border-radius: 6px;
        border: 1px solid var(--hse-border);
        background: #fff;
        color: var(--hse-text);
        font-size: 13px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.2s ease;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
        white-space: nowrap;
    }

    .hse-action-btn:hover {
        background: var(--hse-bg);
        border-color: var(--hse-primary);
        color: var(--hse-primary);
    }

    .hse-action-btn.active {
        background: var(--hse-primary);
        border-color: var(--hse-primary);
        color: #fff;
        box-shadow: 0 2px 4px rgba(1, 81, 133, 0.2);
    }

    .hse-action-btn i {
        font-size: 14px;
    }

    .hse-dropdown-menu {
        position: absolute;
        left: 91px;
        top: calc(100% + 8px);
        min-width: 220px;
        max-width: 280px;
        background: #fff;
        border: 1px solid var(--hse-border);
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15), 0 0 0 1px rgba(0, 0, 0, 0.05);
        padding: 6px 0;
        opacity: 0;
        visibility: hidden;
        pointer-events: none;
        transform: translateY(-8px);
        transition: opacity 0.2s ease, transform 0.2s ease, visibility 0.2s ease;
        z-index: 1050;
        display: none;
        flex-direction: column;
        margin-top: 4px;
    }

    .hse-dropdown-menu.show {
        opacity: 1;
        visibility: visible;
        pointer-events: auto;
        transform: translateY(0);
        display: flex;
    }

    .hse-dropdown-item {
        width: 100%;
        border: none;
        background: none;
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 10px 16px;
        border-radius: 0;
        font-size: 13px;
        font-weight: 500;
        color: var(--hse-text);
        cursor: pointer;
        transition: background 0.15s ease, color 0.15s ease;
        text-align: left;
        white-space: nowrap;
        margin: 0;
    }

    .hse-dropdown-item:first-child {
        border-radius: 6px 6px 0 0;
    }

    .hse-dropdown-item:last-child {
        border-radius: 0 0 6px 6px;
    }

    .hse-dropdown-item i {
        font-size: 14px;
        width: 18px;
        text-align: center;
        flex-shrink: 0;
    }

    .hse-dropdown-item:hover:not(:disabled) {
        background: rgba(1, 81, 133, 0.08);
        color: var(--hse-primary);
    }

    .hse-dropdown-item.danger {
        color: var(--hse-danger);
    }

    .hse-dropdown-item.danger:hover:not(:disabled) {
        background: rgba(192, 57, 43, 0.12);
        color: var(--hse-danger);
    }

    .hse-dropdown-item:disabled {
        opacity: 0.45;
        cursor: not-allowed;
    }

    .hse-dropdown-divider {
        height: 1px;
        width: 100%;
        background: var(--hse-border);
        margin: 6px 0;
    }

    .status-pill {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        border-radius: 999px;
        padding: 4px 12px;
        font-size: 12px;
        font-weight: 600;
        text-transform: capitalize;
    }

    .status-pill.completed {
        background: rgba(15, 154, 95, 0.1);
        color: var(--hse-accent);
    }

    .status-pill.draft {
        background: rgba(243, 156, 18, 0.12);
        color: var(--hse-warning);
    }

    .status-pill.archived {
        background: rgba(15, 23, 42, 0.08);
        color: var(--hse-text);
    }

    .status-pill.pending {
        background: rgba(192, 57, 43, 0.12);
        color: var(--hse-danger);
    }

.corrective-cell {
    display: flex;
    flex-direction: column;
    gap: 6px;
}

.corrective-meta-line {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    font-size: 12px;
    color: var(--hse-muted);
    align-items: center;
}

.corrective-number {
    font-weight: 600;
    color: var(--hse-text);
    background: rgba(1, 81, 133, 0.08);
    padding: 2px 8px;
    border-radius: 999px;
}

.corrective-number.muted {
    color: var(--hse-muted);
    background: rgba(100, 116, 139, 0.1);
}

.corrective-unsafe {
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

    .hse-pagination {
        margin-top: 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 12px;
    }

    .hse-pagination .page-controls {
        display: flex;
        gap: 8px;
    }

    .page-btn {
        border: 1px solid var(--hse-border);
        background: #fff;
        border-radius: 8px;
        padding: 8px 12px;
        min-width: 40px;
        text-align: center;
        cursor: pointer;
        font-weight: 600;
        color: var(--hse-text);
    }

    .page-btn.active {
        background: var(--hse-primary);
        color: #fff;
        border-color: var(--hse-primary);
    }

    .page-btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .hse-empty-state,
    .hse-error-state {
        text-align: center;
        padding: 40px 20px;
        color: var(--hse-muted);
    }

    .hse-empty-state i,
    .hse-error-state i {
        font-size: 42px;
        margin-bottom: 12px;
        color: var(--hse-primary);
    }

    .hse-inline-loader {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 24px;
        gap: 12px;
        color: var(--hse-primary);
    }

    .spinner {
        width: 28px;
        height: 28px;
        border: 3px solid rgba(1, 81, 133, 0.15);
        border-top-color: var(--hse-primary);
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        to {
            transform: rotate(360deg);
        }
    }

    .hse-modal {
        position: fixed;
        inset: 0;
        background: rgba(15, 23, 42, 0.55);
        display: none;
        align-items: center;
        justify-content: center;
        padding: 20px;
        z-index: 1050;
    }

    .hse-modal.active {
        display: flex;
    }

    .hse-modal-content {
        background: #fff;
        border-radius: 18px;
        width: min(100%, 960px);
        max-height: 90vh;
        display: flex;
        flex-direction: column;
        box-shadow: 0 30px 60px rgba(15, 23, 42, 0.25);
    }

    .hse-modal-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--hse-border);
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: 12px;
    }

    .hse-modal-footer {
        padding: 7px 24px;
        border-top: 1px solid var(--hse-border);
        display: flex;
        justify-content: flex-end;
        align-items: center;
        gap: 12px;
        flex-wrap: wrap;
    }

    .hse-modal-header h3 {
        margin: 0;
        font-size: 20px;
        color: var(--hse-text);
    }

    .hse-modal-body {
        padding: 20px 24px;
        overflow-y: auto;
    }

    .modal-close-btn {
        border: none;
        background: transparent;
        font-size: 26px;
        color: var(--hse-muted);
        cursor: pointer;
    }

    .details-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
        gap: 14px;
    }

    .details-card {
        border: 1px solid var(--hse-border);
        border-radius: 12px;
        padding: 14px;
        background: #f8fafc;
    }

    .details-card span {
        display: block;
    }

    .details-label {
        font-size: 12px;
        text-transform: uppercase;
        color: var(--hse-muted);
        letter-spacing: 0.08em;
    }

    .details-value {
        font-size: 15px;
        font-weight: 600;
        color: var(--hse-text);
        margin-top: 4px;
    }

    .details-section {
        margin-top: 18px;
    }

    .details-section h4 {
        margin-bottom: 12px;
        color: var(--hse-text);
    }

    .details-badges {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
    }

    .details-badge {
        background: rgba(1, 81, 133, 0.1);
        color: var(--hse-primary);
        border-radius: 999px;
        padding: 6px 14px;
        font-size: 13px;
        font-weight: 600;
    }

    .safety-summary {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
    }

    .safety-chip {
        flex: 1;
        min-width: 140px;
        border-radius: 12px;
        padding: 12px;
        color: #fff;
    }

    .safety-chip.safe {
        background: linear-gradient(135deg, #0f9d58, #0b7c44);
    }

    .safety-chip.unsafe {
        background: linear-gradient(135deg, #d93025, #b3241b);
    }

    .safety-chip.na {
        background: linear-gradient(135deg, #a0aec0, #718096);
    }

    .safety-chip strong {
        font-size: 20px;
        display: block;
    }

    .attachments-list {
        list-style: none;
        padding-left: 0;
        margin: 0;
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .attachments-list a {
        color: var(--hse-primary);
        text-decoration: none;
        font-weight: 600;
    }

    .attachments-list a:hover {
        text-decoration: underline;
    }

    .pdf-modal iframe {
        width: 100%;
        height: 70vh;
        border: none;
        border-radius: 0 0 18px 18px;
    }

    .hse-toast-container {
        position: fixed;
        top: 24px;
        right: 24px;
        display: flex;
        flex-direction: column;
        gap: 10px;
        z-index: 1100;
    }

    .hse-toast {
        min-width: 260px;
        max-width: 360px;
        padding: 14px 16px;
        border-radius: 12px;
        color: #fff;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 10px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        transition: opacity 0.3s ease;
    }

    .hse-toast.success {
        background: linear-gradient(135deg, #0f9d58, #0b7c44);
    }

    .hse-toast.error {
        background: linear-gradient(135deg, #d93025, #b3241b);
    }

    .hse-toast.info {
        background: linear-gradient(135deg, #2563eb, #1d4ed8);
    }

    .hse-global-loader {
        position: fixed;
        inset: 0;
        background: rgba(15, 23, 42, 0.65);
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        gap: 14px;
        color: #fff;
        z-index: 1200;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="hse-screen" role="main" aria-label="HSE inspection reports">
<div class="hse-header">
    <div class="hse-header-left">
        <a href="<?php echo e(route('inspection.inspection_report')); ?>" class="hse-back-button" aria-label="Back to Inspection Reports">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div class="hse-header-text">
            <p class="hse-breadcrumb">
                <a href="<?php echo e(route('inspection.inspection_report')); ?>">Inspection Reports</a>
                <span>/</span>
                HSE Inspection Reports
            </p>
            <h1>HSE Inspection Reports</h1>
            <p>Review and manage every HSE inspection, mirror the native experience, and keep corrective actions on track.</p>
        </div>
    </div>
    <div class="hse-header-right">
        <div class="hse-header-search">
            <i class="fas fa-search" aria-hidden="true"></i>
            <input type="text" id="hseSearchInput" placeholder="Search by request #, project, equipment, document ID, location..." aria-label="Search HSE reports">
        </div>
        <div class="hse-header-buttons">
            <button type="button" class="hse-btn light" id="hseRefreshBtn">
                <i class="fas fa-sync-alt"></i>
                Refresh
            </button>
        </div>
    </div>
</div>

<div class="hse-controls">
    <div class="hse-filter-group">
        <label class="sr-only" for="hseCountryFilter">Filter by country</label>
        <select id="hseCountryFilter" aria-label="Filter by country">
            <option value="all">All Countries</option>
        </select>
        <label class="sr-only" for="hseStatusFilter">Filter by status</label>
        <select id="hseStatusFilter" aria-label="Filter by status">
            <option value="all">All statuses</option>
            <option value="completed">Completed</option>
            <option value="draft">Draft</option>
            <option value="archived">Archived</option>
        </select>
        <label class="sr-only" for="hsePageSize">Rows per page</label>
        <select id="hsePageSize" aria-label="Rows per page">
            <option value="10">10 rows</option>
            <option value="20">20 rows</option>
            <option value="50">50 rows</option>
        </select>
        <button type="button" class="hse-btn light" id="hseClearFiltersBtn">
            <i class="fas fa-eraser"></i> Clear Filters
        </button>
    </div>
</div>


    <div class="hse-card-container">
        <div class="hse-tab-header" role="tablist" aria-label="HSE tab navigation">
            <button id="hseReportsTab" class="hse-tab-button active" type="button" role="tab" aria-selected="true" data-hse-tab="reports" data-hse-panel="hseReportsPanel">
                HSE Reports
            </button>
            <button id="hseCorrectiveTab" class="hse-tab-button" type="button" role="tab" aria-selected="false" data-hse-tab="corrective" data-hse-panel="hseCorrectivePanel">
                Corrective Actions
            </button>
        </div>

        <div id="hseReportsPanel" class="hse-tab-panel active" role="tabpanel" aria-labelledby="hseReportsTab">
            <div class="hse-table-card" aria-live="polite">
                <div class="hse-table-toolbar">
                    <div>
                        <h2 style="margin:0; font-size:20px; color:var(--hse-text);">Reports Table</h2>
                        <p class="hse-table-meta" id="hseTableMeta">Loading reports...</p>
                    </div>
                    <div style="color: var(--hse-muted); font-size: 13px;">
                        <!-- Data source: <?php echo e(route('inspection.hse_reports.data')); ?> -->
                    </div>
                </div>

                <div class="hse-table-wrapper">
                    <table class="hse-table" aria-describedby="hseTableMeta">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Actions</th>
                                <th>Request #</th>
                                <th>Document ID</th>
                                <th>Country</th>
                                <th>Project</th>
                                <th>Equipment</th>
                                <th>Created</th>
                            </tr>
                        </thead>
                        <tbody id="hseTableBody">
                            <!-- Rows injected via JS -->
                        </tbody>
                    </table>
                </div>

                <div id="hseTableLoader" class="hse-inline-loader" hidden>
                    <div class="spinner" role="status" aria-label="Loading"></div>
                    <span>Fetching HSE inspections...</span>
                </div>

                <div id="hseEmptyState" class="hse-empty-state" hidden>
                    <i class="fas fa-file-alt" aria-hidden="true"></i>
                    <p>No HSE reports found.</p>
                </div>

                <div id="hseErrorState" class="hse-error-state" hidden>
                    <i class="fas fa-triangle-exclamation" aria-hidden="true"></i>
                    <p id="hseErrorMessage">Unable to fetch reports. Please try again.</p>
                </div>

                <div class="hse-pagination" id="hsePagination">
                    <!-- Pagination controls injected dynamically -->
                </div>
            </div>
        </div>

        <div id="hseCorrectivePanel" class="hse-tab-panel" role="tabpanel" aria-labelledby="hseCorrectiveTab" aria-hidden="true">
            <div class="hse-table-card">
                <div class="hse-table-toolbar">
                    <div>
                        <h2 style="margin:0; font-size:20px; color:var(--hse-text);">Corrective Actions</h2>
                        <p class="hse-table-meta" id="hseCorrectiveMeta">Awaiting corrective data...</p>
                    </div>
                    <div style="color: var(--hse-muted); font-size: 13px;">
                        Source: Corrective tab cache
                    </div>
                </div>

                <div class="hse-table-wrapper">
                    <table class="hse-table" aria-describedby="hseCorrectiveMeta">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Corrective #</th>
                                <th>Request #</th>
                                <th>Status</th>
                                <th>Unsafe Items</th>
                                <th>Updated</th>
                                <th>PDF</th>
                            </tr>
                        </thead>
                        <tbody id="hseCorrectiveTableBody">
                            <!-- Corrective rows injected via JS -->
                        </tbody>
                    </table>
                </div>

                <div id="hseCorrectiveLoader" class="hse-inline-loader" hidden>
                    <div class="spinner" role="status" aria-label="Loading"></div>
                    <span>Gathering corrective actions...</span>
                </div>

                <div id="hseCorrectiveEmptyState" class="hse-empty-state" hidden>
                    <i class="fas fa-screwdriver-wrench" aria-hidden="true"></i>
                    <p>No corrective actions found yet.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Details Modal -->
<div id="hseDetailsModal" class="hse-modal" role="dialog" aria-modal="true" aria-labelledby="hseDetailsTitle">
    <div class="hse-modal-content">
        <div class="hse-modal-header">
            <h3 id="hseDetailsTitle">HSE Report Details</h3>
            <button type="button" class="modal-close-btn" data-modal-close aria-label="Close details modal">&times;</button>
        </div>
        <div class="hse-modal-body" id="hseDetailsContent">
            <!-- Details injected via JS -->
        </div>
        <div class="hse-modal-footer">
            <button type="button" class="hse-btn ghost" id="hseDetailsHsePdfBtn">
                <i class="fas fa-file-pdf"></i> HSE PDF
            </button>
            <button type="button" class="hse-btn ghost" id="hseDetailsCorrectivePdfBtn">
                <i class="fas fa-screwdriver-wrench"></i> Corrective PDF
            </button>
            <button type="button" class="hse-btn primary" data-modal-close>Close</button>
        </div>
    </div>
</div>

<!-- PDF Modal -->
<div id="hsePdfModal" class="hse-modal" role="dialog" aria-modal="true" aria-labelledby="hsePdfTitle">
    <div class="hse-modal-content pdf-modal">
        <div class="hse-modal-header">
            <h3 id="hsePdfTitle">PDF Preview</h3>
            <button type="button" class="modal-close-btn" data-modal-close aria-label="Close PDF modal">&times;</button>
        </div>
        <div>
            <iframe id="hsePdfIframe" title="HSE PDF preview"></iframe>
        </div>
        <div class="hse-modal-footer">
            <a id="hsePdfDownload" class="hse-btn primary" href="#" target="_blank" rel="noopener">
                <i class="fas fa-download"></i> Download
            </a>
            <button type="button" class="hse-btn light" data-modal-close>Close</button>
        </div>
    </div>
</div>

<!-- Corrective Modal -->
<div id="hseCorrectiveModal" class="hse-modal" role="dialog" aria-modal="true" aria-labelledby="hseCorrectiveTitle">
    <div class="hse-modal-content">
        <div class="hse-modal-header">
            <h3 id="hseCorrectiveTitle">Corrective Action</h3>
            <button type="button" class="modal-close-btn" data-modal-close aria-label="Close corrective modal">&times;</button>
        </div>
        <div class="hse-modal-body" id="hseCorrectiveContent">
            <!-- Corrective details injected via JS -->
        </div>
        <div class="hse-modal-footer">
            <button type="button" class="hse-btn light" data-modal-close>Close</button>
        </div>
    </div>
</div>

<div id="hseToastContainer" class="hse-toast-container" aria-live="polite"></div>
<div id="hseGlobalLoader" class="hse-global-loader" hidden>
    <div class="spinner" role="status" aria-label="Processing"></div>
    <p id="hseGlobalLoaderText">Processing...</p>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
(function() {
    const REPORT_LIMIT = 500;
    
    // Get base URL from environment or use default
    // In production, these absolute URLs may have SSL certificate issues, so we prefer Laravel routes
    const HSE_BASE_URL = "<?php echo e(env('HSE_REPORTS_BASE_URL', 'https://admin.titandrillingzm.com:6032')); ?>".trim();
    const HSE_CORRECTIVE_BASE_URL = "<?php echo e(env('MONGODB_HSE_CORRECTIVE_API_BASE_URL', 'https://api.titandrillingzm.com:6032')); ?>".trim();
    const HSE_CORRECTIVE_GET_ALL = "<?php echo e(env('MONGODB_HSE_CORRECTIVE_GET_ALL_URL', '')); ?>".trim();
    
    // Detect production environment
    const isProduction = window.location.hostname !== 'localhost' && window.location.hostname !== '127.0.0.1' && !window.location.hostname.includes('local');
    
    // Fallback to Laravel routes if absolute URL fails
    const LARAVEL_ROUTES = {
        reports: "<?php echo e(route('inspection.hse_reports.data')); ?>",
        corrective: "<?php echo e(route('inspection.hse_reports.corrective', ['reportId' => '__ID__'])); ?>",
        delete: "<?php echo e(url('/inspection/hse-reports')); ?>"
    };
    
    // Build routes with proper URL construction
    const buildAbsoluteUrl = (baseUrl, path) => {
        const cleanBase = baseUrl.replace(/\/+$/, ''); // Remove trailing slashes
        const cleanPath = path.replace(/^\/+/, ''); // Remove leading slashes
        return `${cleanBase}/${cleanPath}`;
    };
    
    const ROUTES = {
        reports: buildAbsoluteUrl(HSE_BASE_URL, '/inspection/hse-reports/data'),
        reportsFallback: LARAVEL_ROUTES.reports,
        corrective: buildAbsoluteUrl(HSE_BASE_URL, '/inspection/hse-reports/corrective'),
        correctiveFallback: LARAVEL_ROUTES.corrective.replace('__ID__', ''),
        delete: buildAbsoluteUrl(HSE_BASE_URL, '/inspection/hse-reports'),
        deleteFallback: LARAVEL_ROUTES.delete,
        correctiveAll: HSE_CORRECTIVE_GET_ALL || buildAbsoluteUrl(HSE_CORRECTIVE_BASE_URL, '/hse-corrective-actions')
    };
    
    // Debug: Log the routes being used
    console.log('🔧 HSE Routes Configuration:', {
        HSE_BASE_URL,
        currentHost: window.location.hostname,
        currentProtocol: window.location.protocol,
        reports: ROUTES.reports,
        reportsFallback: ROUTES.reportsFallback,
        correctiveAll: ROUTES.correctiveAll,
        'Note': 'Will try Laravel route first, then absolute URL as fallback'
    });
    
    // Helper to build corrective action URL
    function getCorrectiveActionUrl(reportId) {
        return ROUTES.corrective + "/" + encodeURIComponent(reportId);
    }
    
    // Helper to get corrective action URL with fallback
    function getCorrectiveActionUrlWithFallback(reportId) {
        const fallbackUrl = LARAVEL_ROUTES.corrective.replace('__ID__', encodeURIComponent(reportId));
        return ROUTES.corrective + "/" + encodeURIComponent(reportId);
    }
    const CSRF_TOKEN = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '';

    const SAFE_VALUES = new Set(['safe', 'ok', 'okay', 'pass', 'operational', 'satisfactory']);
    const UNSAFE_VALUES = new Set(['unsafe', 'faulty', 'reject', 'not ok', 'not okay', 'fail', 'failures', 'unsatisfactory']);
    const NA_VALUES = new Set(['n/a', 'not applicable', 'na']);

    let filtersInitialized = false;

    const state = {
        allReports: [],
        filteredReports: [],
        correctiveCache: new Map(),
        correctiveRecords: [],
        correctiveSource: 'embedded',
        searchTerm: '',
        statusFilter: 'all',
        countryFilter: 'all',
        pageSize: 10,
        currentPage: 1,
        isLoading: false,
        activeReportId: null,
        activeTab: 'reports'
    };

    const dom = {
        searchInput: document.getElementById('hseSearchInput'),
        countryFilter: document.getElementById('hseCountryFilter'),
        statusFilter: document.getElementById('hseStatusFilter'),
        pageSize: document.getElementById('hsePageSize'),
        clearFilters: document.getElementById('hseClearFiltersBtn'),
        refreshBtn: document.getElementById('hseRefreshBtn'),
        tableBody: document.getElementById('hseTableBody'),
        tableLoader: document.getElementById('hseTableLoader'),
        emptyState: document.getElementById('hseEmptyState'),
        errorState: document.getElementById('hseErrorState'),
        errorMessage: document.getElementById('hseErrorMessage'),
        pagination: document.getElementById('hsePagination'),
        tableMeta: document.getElementById('hseTableMeta'),
        totalCount: document.getElementById('hseTotalCount'),
        totalMeta: document.getElementById('hseTotalMeta'),
        completedCount: document.getElementById('hseCompletedCount'),
        draftCount: document.getElementById('hseDraftCount'),
        attentionCount: document.getElementById('hseAttentionCount'),
        toastContainer: document.getElementById('hseToastContainer'),
        globalLoader: document.getElementById('hseGlobalLoader'),
        globalLoaderText: document.getElementById('hseGlobalLoaderText'),
        detailsModal: document.getElementById('hseDetailsModal'),
        detailsContent: document.getElementById('hseDetailsContent'),
        detailsHsePdfBtn: document.getElementById('hseDetailsHsePdfBtn'),
        detailsCorrectivePdfBtn: document.getElementById('hseDetailsCorrectivePdfBtn'),
        pdfModal: document.getElementById('hsePdfModal'),
        pdfIframe: document.getElementById('hsePdfIframe'),
        pdfDownload: document.getElementById('hsePdfDownload'),
        pdfTitle: document.getElementById('hsePdfTitle'),
        correctiveModal: document.getElementById('hseCorrectiveModal'),
        correctiveContent: document.getElementById('hseCorrectiveContent'),
        correctiveCloseButtons: Array.from(document.querySelectorAll('#hseCorrectiveModal [data-modal-close]')),
        tabButtons: Array.from(document.querySelectorAll('[data-hse-tab]')),
        tabPanels: Array.from(document.querySelectorAll('.hse-tab-panel')),
        reportsPanel: document.getElementById('hseReportsPanel'),
        correctivePanel: document.getElementById('hseCorrectivePanel'),
        correctiveMeta: document.getElementById('hseCorrectiveMeta'),
        correctiveTableBody: document.getElementById('hseCorrectiveTableBody'),
        correctiveEmptyState: document.getElementById('hseCorrectiveEmptyState'),
        correctiveLoader: document.getElementById('hseCorrectiveLoader')
    };

    let openDropdownMenu = null;
    let openDropdownToggle = null;

    // Wait for DOM to be fully ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        // DOM is already ready
        setTimeout(init, 100);
    }

    function init() {
        // Verify critical DOM elements exist
        if (!dom.tableBody || !dom.searchInput) {
            console.error('Critical DOM elements not found. Retrying in 500ms...');
            setTimeout(init, 500);
            return;
        }
        
        attachEvents();
        const initialTabButton = dom.tabButtons && dom.tabButtons.length > 0 
            ? dom.tabButtons.find((btn) => btn && btn.dataset.hseTab === state.activeTab) || dom.tabButtons[0]
            : null;
        if (initialTabButton) {
            switchTab(initialTabButton.dataset.hseTab, initialTabButton);
        }
        loadReports().finally(() => {
            loadCorrectiveRecords();
        });
    }

    function resetFiltersToDefaults() {
        state.searchTerm = '';
        state.statusFilter = 'all';
        state.countryFilter = 'all';
        state.currentPage = 1;
        if (dom.searchInput) dom.searchInput.value = '';
        if (dom.statusFilter) dom.statusFilter.value = 'all';
        if (dom.countryFilter) dom.countryFilter.value = 'all';
    }

    function attachEvents() {
        // Add event listeners only if elements exist
        if (dom.searchInput) {
            dom.searchInput.addEventListener('input', (event) => {
                state.searchTerm = (event.target.value || '').trim().toLowerCase();
                applyFilters();
            });
        }

        if (dom.countryFilter) {
            dom.countryFilter.addEventListener('change', (event) => {
                state.countryFilter = event.target.value;
                applyFilters();
            });
        }

        if (dom.statusFilter) {
            dom.statusFilter.addEventListener('change', (event) => {
                state.statusFilter = event.target.value;
                applyFilters();
            });
        }

        if (dom.pageSize) {
            dom.pageSize.addEventListener('change', (event) => {
                state.pageSize = Number(event.target.value) || 10;
                state.currentPage = 1;
                renderTable();
            });
        }

        if (dom.clearFilters) {
            dom.clearFilters.addEventListener('click', () => {
                state.searchTerm = '';
                state.statusFilter = 'all';
                state.countryFilter = 'all';
                if (dom.searchInput) dom.searchInput.value = '';
                if (dom.statusFilter) dom.statusFilter.value = 'all';
                if (dom.countryFilter) dom.countryFilter.value = 'all';
                applyFilters();
            });
        }

        if (dom.refreshBtn) {
            dom.refreshBtn.addEventListener('click', () => {
                loadReports().finally(() => {
                    loadCorrectiveRecords();
                });
            });
        }

        // Listen to global country filter changes from header
        window.addEventListener('countryFilterChanged', (event) => {
            const selectedCountries = event.detail?.selectedCountries || [];
            if (selectedCountries.length > 0 && !selectedCountries.includes('All Countries')) {
                // If specific countries are selected, filter by the first one (or combine logic)
                // For simplicity, we'll use the first selected country
                state.countryFilter = selectedCountries[0];
                if (dom.countryFilter) {
                    dom.countryFilter.value = selectedCountries[0];
                }
            } else {
                // All Countries selected
                state.countryFilter = 'all';
                if (dom.countryFilter) {
                    dom.countryFilter.value = 'all';
                }
            }
            applyFilters();
        });

        // Also check if there's a stored country selection on page load
        // Do not auto-override the default filter selection on initial load.

        dom.tableBody.addEventListener('click', handleTableAction);
        if (dom.correctiveTableBody) {
            dom.correctiveTableBody.addEventListener('click', handleCorrectiveTableAction);
        }
        document.addEventListener('click', handleGlobalClicks);
        document.addEventListener('keydown', (event) => {
            if (event.key === 'Escape') {
                closeAllDropdowns();
            }
        });

        document.querySelectorAll('[data-modal-close]').forEach((btn) => {
            btn.addEventListener('click', () => closeModal(btn.closest('.hse-modal')));
        });

        dom.correctiveCloseButtons?.forEach((btn) => {
            btn.addEventListener('click', () => closeModal(dom.correctiveModal));
        });

        dom.detailsModal.addEventListener('click', (event) => {
            if (event.target === dom.detailsModal) {
                closeModal(dom.detailsModal);
            }
        });

        dom.pdfModal.addEventListener('click', (event) => {
            if (event.target === dom.pdfModal) {
                closeModal(dom.pdfModal);
            }
        });

        dom.correctiveModal?.addEventListener('click', (event) => {
            if (event.target === dom.correctiveModal) {
                closeModal(dom.correctiveModal);
            }
        });

        dom.detailsHsePdfBtn.addEventListener('click', () => {
            if (state.activeReportId) {
                viewHsePdf(state.activeReportId);
            }
        });

        dom.detailsCorrectivePdfBtn.addEventListener('click', () => {
            if (state.activeReportId) {
                viewCorrectivePdf(state.activeReportId);
            }
        });

        dom.tabButtons.forEach((button) => {
            button.addEventListener('click', () => {
                switchTab(button.dataset.hseTab, button);
            });
        });
    }

    async function loadReports() {
        if (state.isLoading) return;
        state.isLoading = true;
        toggleTableLoader(true);
        toggleError(false);

        // Only use Laravel route in production to avoid SSL certificate issues
        // The absolute URL with port 6032 has SSL certificate problems
        const urlsToTry = [
            { url: ROUTES.reportsFallback, name: 'Laravel Route', useCors: false }
        ];
        
        // Only add absolute URL fallback in local development (not in production)
        // In production, skip absolute URL to avoid SSL certificate errors
        if (!isProduction && ROUTES.reports) {
            urlsToTry.push({ url: ROUTES.reports, name: 'Absolute URL', useCors: true });
        }

        let lastError = null;
        let lastResponse = null;
        
        for (const urlConfig of urlsToTry) {
            try {
                console.log(`🔄 Attempting to load HSE reports from: ${urlConfig.name}`);
                console.log(`   URL: ${urlConfig.url}`);
                
                const fullUrl = `${urlConfig.url}?page=1&limit=${REPORT_LIMIT}`;
                
                const fetchOptions = {
                    method: 'GET',
                    headers: { 
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    credentials: urlConfig.useCors ? 'include' : 'same-origin'
                };
                
                // Only set mode for CORS if it's a different origin
                // Skip CORS requests in production to avoid SSL certificate issues
                if (urlConfig.useCors && !isProduction && urlConfig.url.startsWith('http') && !urlConfig.url.includes(window.location.hostname)) {
                    fetchOptions.mode = 'cors';
                }
                
                const response = await fetch(fullUrl, fetchOptions);
                lastResponse = response;

                if (!response.ok) {
                    // Try to get error message from response
                    let errorMessage = `API responded with status ${response.status}`;
                    let errorData = null;
                    
                    try {
                        const responseText = await response.text();
                        if (responseText) {
                            errorData = JSON.parse(responseText);
                            errorMessage = errorData.message || errorData.error || errorMessage;
                        }
                    } catch (e) {
                        // If response is not JSON, use default message
                        console.warn('Could not parse error response as JSON');
                    }
                    
                    console.warn(`❌ ${urlConfig.name} failed:`, {
                        status: response.status,
                        statusText: response.statusText,
                        message: errorMessage,
                        errorData: errorData
                    });
                    
                    // For 4xx/5xx errors, try next URL (unless it's a 404 from Laravel, which means route doesn't exist)
                    if (response.status >= 400) {
                        lastError = new Error(`${urlConfig.name}: ${errorMessage} (Status: ${response.status})`);
                        // Continue to try next URL
                        continue;
                    }
                    
                    throw new Error(errorMessage);
                }

                const payload = await response.json();
                const reports = Array.isArray(payload.data) ? payload.data : [];

                if (reports.length === 0 && !payload.success) {
                    console.warn(`⚠️ ${urlConfig.name} returned empty or unsuccessful response:`, payload);
                    lastError = new Error(payload.message || 'No reports returned');
                    continue; // Try next URL
                }

                console.log(`✅ Successfully loaded ${reports.length} reports from ${urlConfig.name}`);
                
                state.allReports = reports.map(normalizeReport);
                state.correctiveCache.clear();
                populateCountryFilter(); // Populate country filter dropdown
                if (!filtersInitialized) {
                    resetFiltersToDefaults();
                    filtersInitialized = true;
                }
                applyFilters(true);
                updateSummaryCards();
                showToast('success', `Loaded ${state.allReports.length} HSE reports`);
                hydrateCorrectiveData(state.allReports).catch((error) => {
                    console.warn('Corrective hydration skipped:', error);
                });
                refreshCorrectiveRecords();
                
                // Success - exit function
                toggleTableLoader(false);
                state.isLoading = false;
                return;
                
            } catch (error) {
                console.error(`❌ Failed to load from ${urlConfig.name}:`, {
                    error: error.message,
                    stack: error.stack,
                    name: error.name,
                    url: urlConfig.url
                });
                
                // If it's an SSL/certificate error or network error, log it and skip
                if (error.message && (
                    error.message.includes('ERR_CERT') || 
                    error.message.includes('certificate') || 
                    error.message.includes('SSL') ||
                    error.message.includes('Failed to fetch') ||
                    error.name === 'TypeError'
                )) {
                    console.warn(`⚠️ Skipping ${urlConfig.name} due to SSL/network error. This is expected in production.`);
                }
                
                lastError = error;
                // Continue to try next URL
                continue;
            }
        }

        // If we get here, all URLs failed
        console.error('❌ All URL attempts failed. Last error:', lastError);
        console.error('Last response status:', lastResponse?.status);
        
        const errorMsg = lastError?.message || 'Unable to fetch reports from any source. Please check your connection and backend configuration.';
        toggleError(true, errorMsg);
        state.allReports = [];
        state.filteredReports = [];
        renderTable();
        refreshCorrectiveRecords();
        updateSummaryCards();
        
        // Show user-friendly error toast
        showToast('error', 'Failed to load HSE reports. Please check backend service configuration.');
        toggleTableLoader(false);
        state.isLoading = false;
    }

    function normalizeReport(report) {
        const clone = { ...report };
        clone._id = clone._id || clone.id || clone.requestNumber || clone.step1?.requestNumber || '';
        clone.requestNumber = clone.requestNumber || clone.step1?.requestNumber || clone._id;
        clone.status = (clone.status || 'draft').toLowerCase();
        clone.createdAt = clone.createdAt || clone.step1?.createdAt || clone.updatedAt;
        clone.correctiveAction =
            clone.correctiveAction ||
            clone.correctiveActionData ||
            clone.correctiveActionInfo ||
            clone.meta?.correctiveAction ||
            null;
        return clone;
    }

    function normalizeCorrectiveAction(data = {}) {
        if (!data) return null;
        const clone = { ...data };
        clone._id = clone._id || clone.id || clone.correctiveId || clone.corrective_id || '';
        clone.reportId =
            clone.reportId ||
            clone.reportID ||
            clone.requestNumber ||
            clone.step1?.requestNumber ||
            clone.meta?.reportId ||
            clone._id;
        clone.requestNumber = clone.requestNumber || clone.reportId || clone._id;
        clone.correctiveActionNumber =
            clone.correctiveActionNumber ||
            clone.correctiveNumber ||
            clone.metadata?.correctiveActionNumber ||
            clone.requestNumber;
        clone.status = (clone.status || '').toLowerCase();
        clone.updatedAt = clone.updatedAt || clone.lastModified || clone.createdAt || clone.timestamp || null;
        return clone;
    }

    function getCachedCorrective(...identifiers) {
        const keys = [];
        identifiers.forEach((value) => {
            if (!value) return;
            if (typeof value === 'object') {
                keys.push(
                    value,
                    value._id,
                    value.id,
                    value.reportId,
                    value.requestNumber,
                    value.correctiveActionNumber,
                    value.step1?.requestNumber,
                    value.meta?.requestNumber
                );
            } else {
                keys.push(value);
            }
        });

        for (const key of keys) {
            const normalized = normalizeKey(key);
            if (!normalized) continue;
            if (state.correctiveCache.has(normalized)) {
                return state.correctiveCache.get(normalized) || null;
            }
        }

        return null;
    }

    function applyFilters(skipReset = false) {
        const term = state.searchTerm;
        const status = state.statusFilter;
        const country = state.countryFilter;

        state.filteredReports = state.allReports.filter((report) => {
            // Filter by status
            const matchesStatus = status === 'all' || (report.status || '').toLowerCase() === status;
            if (!matchesStatus) return false;
            
            // Filter by country
            const reportCountry = pickFirst(report.step1?.country, report.country, '').trim();
            const matchesCountry = country === 'all' || reportCountry.toLowerCase() === country.toLowerCase();
            if (!matchesCountry) return false;
            
            // Filter by search term
            if (!term) return true;

            const haystack = [
                pickFirst(report.requestNumber, report._id),
                pickFirst(report.step1?.selectedChecklist?.document_id),
                reportCountry,
                pickFirst(report.step1?.project, report.project),
                pickFirst(report.step1?.selectedEquipment?.equipmentName, report.step1?.selectedEquipment?.equipmentNumber),
                pickFirst(report.userId),
            ]
                .filter(Boolean)
                .map((value) => value.toLowerCase());

            return haystack.some((value) => value.includes(term));
        });

        if (!skipReset) {
            state.currentPage = 1;
        }

        renderTable();
        updateSummaryCards();
    }

    function populateCountryFilter() {
        if (!dom.countryFilter) return;
        
        // Get unique countries from all reports
        const countries = new Set();
        state.allReports.forEach((report) => {
            const country = pickFirst(report.step1?.country, report.country, '').trim();
            if (country) {
                countries.add(country);
            }
        });
        
        // Sort countries alphabetically
        const sortedCountries = Array.from(countries).sort();
        
        // Clear existing options except "All Countries"
        dom.countryFilter.innerHTML = '<option value="all">All Countries</option>';
        
        // Add country options
        sortedCountries.forEach((country) => {
            const option = document.createElement('option');
            option.value = country;
            option.textContent = country;
            dom.countryFilter.appendChild(option);
        });
    }

    function renderTable() {
        const total = state.filteredReports.length;
        const allTotal = state.allReports.length;

        if (!total) {
            dom.tableBody.innerHTML = '';
            dom.emptyState.hidden = false;
            dom.tableMeta.textContent = allTotal
                ? 'No reports match the applied filters.'
                : 'No reports available.';
            dom.pagination.innerHTML = '';
            return;
        }

        dom.emptyState.hidden = true;

        const totalPages = Math.max(1, Math.ceil(total / state.pageSize));
        state.currentPage = Math.min(state.currentPage, totalPages);
        const startIndex = (state.currentPage - 1) * state.pageSize;
        const endIndex = Math.min(startIndex + state.pageSize, total);
        const pageItems = state.filteredReports.slice(startIndex, endIndex);

        dom.tableMeta.textContent = `Showing ${startIndex + 1}-${endIndex} of ${total} filtered reports (from ${allTotal} total)`;

        dom.tableBody.innerHTML = pageItems
            .map((report, index) => buildTableRow(report, state.filteredReports.length - (startIndex + index)))
            .join('');

        renderPagination(totalPages, total);
    }

    function normalizeRequestNumber(value) {
        if (!value) return '';
        // Normalize: remove spaces, convert to uppercase, trim
        // This handles formats like "ZMB - KAN - HSE - 039" or "ZMB-KAN-HSE-039"
        return String(value).trim().replace(/\s+/g, '').replace(/-/g, '-').toUpperCase();
    }

    function findCorrectiveByRequestNumber(requestNumber) {
        if (!requestNumber) return null;
        const normalizedRequest = normalizeRequestNumber(requestNumber);
        if (!normalizedRequest) return null;
        
        // First check in cache by request number (try both normalized formats)
        if (state.correctiveCache.has(normalizedRequest)) {
            const cached = state.correctiveCache.get(normalizedRequest);
            if (cached) return cached;
        }
        
        // Also check with the original normalizeKey for backward compatibility
        const keyNormalized = normalizeKey(requestNumber);
        if (keyNormalized && state.correctiveCache.has(keyNormalized)) {
            const cached = state.correctiveCache.get(keyNormalized);
            if (cached) return cached;
        }
        
        // Check in corrective records
        for (const entry of state.correctiveRecords) {
            const corrective = entry.corrective;
            const report = entry.report;
            
            // Check if REQUEST # matches - try multiple variations
            const possibleRequestNumbers = [
                corrective.requestNumber,
                report?.requestNumber,
                corrective.reportId,
                report?._id,
                report?.id,
                corrective.correctiveActionNumber
            ].filter(Boolean);
            
            for (const possibleRequest of possibleRequestNumbers) {
                const normalizedPossible = normalizeRequestNumber(possibleRequest);
                if (normalizedPossible && normalizedPossible === normalizedRequest) {
                    // Cache it for future lookups
                    cacheCorrective(corrective);
                    // Also cache by normalized request number
                    state.correctiveCache.set(normalizedRequest, corrective);
                    return corrective;
                }
            }
        }
        
        return null;
    }

    function buildTableRow(report, serialNumber) {
        const id = escapeHtml(report._id || '');
        const requestNumber = escapeHtml(pickFirst(report.requestNumber, report._id, 'N/A'));
        const documentId = escapeHtml(
            pickFirst(
                report.step1?.selectedChecklist?.document_id,
                report.selectedChecklist?.document_id,
                'N/A'
            )
        );
        const country = escapeHtml(pickFirst(report.step1?.country, report.country, '—'));
        const project = escapeHtml(pickFirst(report.step1?.project, report.project, '—'));
        const equipment = escapeHtml(
            pickFirst(
                report.step1?.selectedEquipment?.equipmentName,
                report.step1?.selectedEquipment?.equipmentNumber,
                'N/A'
            )
        );
        const createdAt = formatDate(report.createdAt);
        const embeddedCorrective = getEmbeddedCorrective(report);
        const cachedCorrective = getCachedCorrective(report, embeddedCorrective);
        
        // Check if REQUEST # matches any corrective action - use normalized matching
        const reportRequestNumber = pickFirst(report.requestNumber, report._id);
        const matchingCorrective = findCorrectiveByRequestNumber(reportRequestNumber);
        
        // Use the best available corrective action (matching > cached > embedded)
        const bestCorrective = matchingCorrective || cachedCorrective || embeddedCorrective;
        
        // Has corrective if any of these exist
        const hasCorrective = Boolean(bestCorrective);
        const directPdfUrl = bestCorrective?.pdfDownloadUrl || '';
        const dropdownId = `hse-dropdown-${id}`;
        const hasHsePdf = Boolean(report.pdfDownloadUrl);
        
        // Enable PDF option if we have a PDF URL OR if we have a matching corrective (will fetch PDF on click)
        // This ensures the button is enabled even if PDF URL isn't loaded yet
        const hasCorrectivePdf = Boolean(directPdfUrl) || Boolean(matchingCorrective || cachedCorrective);

        return `
            <tr>
                <td>${serialNumber}</td>
                <td>
                    <div class="hse-dropdown">
                        <button class="hse-action-btn" type="button" data-dropdown-toggle="${dropdownId}" aria-label="Open actions menu" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                            <span>Actions</span>
                        </button>
                        <div class="hse-dropdown-menu" id="${dropdownId}" role="menu" aria-labelledby="${dropdownId}-toggle">
                            <button type="button" class="hse-dropdown-item" data-action="details" data-id="${id}" role="menuitem">
                                <i class="fas fa-eye"></i>
                                <span>View Details</span>
                            </button>
                            <button type="button" class="hse-dropdown-item" data-action="view-hse-pdf" data-id="${id}" ${hasHsePdf ? '' : 'disabled'} role="menuitem">
                                <i class="fas fa-file-pdf"></i>
                                <span>View HSE PDF</span>
                            </button>
                            <button type="button" class="hse-dropdown-item" data-action="view-corrective-action" data-id="${id}" ${hasCorrective ? '' : 'disabled'} role="menuitem">
                                <i class="fas fa-eye"></i>
                                <span>View Corrective Action</span>
                            </button>
                            <button type="button" class="hse-dropdown-item" data-action="view-corrective-pdf" data-id="${id}" data-pdf-url="${escapeHtml(directPdfUrl)}" ${hasCorrectivePdf ? '' : 'disabled'} role="menuitem">
                                <i class="fas fa-file-pdf"></i>
                                <span>View Corrective Action PDF</span>
                            </button>
                            <div class="hse-dropdown-divider" role="separator"></div>
                            <button type="button" class="hse-dropdown-item danger" data-action="delete" data-id="${id}" role="menuitem">
                                <i class="fas fa-trash"></i>
                                <span>Delete Report</span>
                            </button>
                        </div>
                    </div>
                </td>
                <td>${requestNumber}</td>
                <td>${documentId}</td>
                <td>${country}</td>
                <td>${project}</td>
                <td>${equipment}</td>
                <td>${createdAt}</td>
            </tr>
        `;
    }

    function renderPagination(totalPages, totalItems) {
        if (totalPages <= 1) {
            dom.pagination.innerHTML = '';
            return;
        }

        const infoText = `Page ${state.currentPage} of ${totalPages}`;
        const prevDisabled = state.currentPage === 1 ? 'disabled' : '';
        const nextDisabled = state.currentPage === totalPages ? 'disabled' : '';

        dom.pagination.innerHTML = `
            <div class="hse-table-meta">${infoText}</div>
            <div class="page-controls">
                <button class="page-btn" ${prevDisabled} data-page="${state.currentPage - 1}"><i class="fas fa-chevron-left"></i></button>
                ${buildPageButtons(totalPages)}
                <button class="page-btn" ${nextDisabled} data-page="${state.currentPage + 1}"><i class="fas fa-chevron-right"></i></button>
            </div>
        `;

        dom.pagination.querySelectorAll('.page-btn').forEach((btn) => {
            btn.addEventListener('click', () => {
                const targetPage = Number(btn.dataset.page);
                if (targetPage && targetPage >= 1 && targetPage <= totalPages) {
                    state.currentPage = targetPage;
                    renderTable();
                }
            });
        });
    }

    function buildPageButtons(totalPages) {
        let buttons = '';
        const maxButtons = 5;
        let start = Math.max(1, state.currentPage - Math.floor(maxButtons / 2));
        let end = Math.min(totalPages, start + maxButtons - 1);
        if (end - start < maxButtons - 1) {
            start = Math.max(1, end - maxButtons + 1);
        }
        for (let page = start; page <= end; page++) {
            const activeClass = page === state.currentPage ? 'active' : '';
            buttons += `<button class="page-btn ${activeClass}" data-page="${page}">${page}</button>`;
        }
        return buttons;
    }

    function refreshCorrectiveRecords() {
        if (!dom.correctiveTableBody) return;
        const derived = state.allReports
            .map((report) => {
                const corrective = getEmbeddedCorrective(report);
                if (!corrective) return null;
                return {
                    ...corrective,
                    reportId: corrective.reportId || report._id || report.id || report.requestNumber,
                    requestNumber: report.requestNumber || report._id || corrective.reportId
                };
            })
            .filter(Boolean);
        setCorrectiveRecords(derived, 'embedded');
    }

    async function loadCorrectiveRecords() {
        if (!dom.correctiveTableBody) return;
        if (!ROUTES.correctiveAll) {
            console.warn('Corrective actions endpoint not configured; using embedded data only.');
            refreshCorrectiveRecords();
            return;
        }

        toggleCorrectiveLoader(true);
        if (dom.correctiveMeta) {
            dom.correctiveMeta.textContent = 'Loading corrective actions...';
        }
        if (dom.correctiveEmptyState) {
            dom.correctiveEmptyState.hidden = true;
        }

        try {
            const response = await fetch(ROUTES.correctiveAll, {
                method: 'GET',
                headers: { 'Accept': 'application/json' }
            });
            if (!response.ok) {
                throw new Error(`Corrective API responded with status ${response.status}`);
            }
            const payload = await response.json();
            const records = Array.isArray(payload?.data)
                ? payload.data
                : Array.isArray(payload)
                    ? payload
                    : [];
            setCorrectiveRecords(records, 'api');
            showToast('success', `Loaded ${state.correctiveRecords.length} corrective actions`);
        } catch (error) {
            console.error('Failed to load corrective actions:', error);
            showToast('info', 'Unable to load corrective actions from API. Showing embedded data.');
            refreshCorrectiveRecords();
        } finally {
            toggleCorrectiveLoader(false);
        }
    }

    function setCorrectiveRecords(records = [], source = 'embedded') {
        const normalized = (Array.isArray(records) ? records : [])
            .map((item) => normalizeCorrectiveAction(item))
            .filter((item) => item && item.reportId);

        state.correctiveSource = source;
        if (source === 'api') {
            state.correctiveCache.clear();
        }
        state.correctiveRecords = normalized
            .map((corrective) => {
                cacheCorrective(corrective);
                
                // Try to find report by reportId first
                let report = findReportById(corrective.reportId);
                
                // If not found, try to find by REQUEST #
                if (!report && corrective.requestNumber) {
                    report = findReportByRequestNumber(corrective.requestNumber);
                }
                
                // Also try matching by REQUEST # from the corrective's reportId if it looks like a REQUEST #
                if (!report && corrective.reportId) {
                    const reportIdAsRequest = normalizeRequestNumber(corrective.reportId);
                    if (reportIdAsRequest && reportIdAsRequest.includes('-')) {
                        // Looks like a REQUEST # format (e.g., "ZMB-KAN-HSE-039")
                        report = findReportByRequestNumber(corrective.reportId);
                    }
                }
                
                return {
                    corrective,
                    report
                };
            })
            .sort((a, b) => {
                const aDate = new Date(a.corrective.updatedAt || a.report?.updatedAt || 0).getTime();
                const bDate = new Date(b.corrective.updatedAt || b.report?.updatedAt || 0).getTime();
                return bDate - aDate;
            });

        renderCorrectiveTable();
        
        // Re-render the HSE reports table to update dropdown buttons with new corrective data
        if (state.activeTab === 'reports' && state.filteredReports.length > 0) {
            renderTable();
        }
    }

    function renderCorrectiveTable() {
        if (!dom.correctiveTableBody || !dom.correctiveMeta || !dom.correctiveEmptyState) return;
        const total = state.correctiveRecords.length;

        if (!total) {
            dom.correctiveTableBody.innerHTML = '';
            dom.correctiveEmptyState.hidden = false;
            dom.correctiveMeta.textContent = state.isLoading
                ? 'Loading corrective actions...'
                : 'No corrective actions available.';
            return;
        }

        dom.correctiveEmptyState.hidden = true;
        dom.correctiveTableBody.innerHTML = state.correctiveRecords
            .map((entry, index) => buildCorrectiveRow(entry, index + 1))
            .join('');
        const sourceLabel = state.correctiveSource === 'api' ? 'corrective service' : 'embedded report cache';
        dom.correctiveMeta.textContent = `Showing ${total} corrective actions (${sourceLabel})`;
    }

    function buildCorrectiveRow({ report, corrective }, index) {
        const statusInfo = getCorrectiveStatus(corrective, report?.status);
        const correctiveNumber = escapeHtml(
            corrective.correctiveActionNumber ||
                `CA-${pickFirst(report?.requestNumber, report?._id, corrective.reportId, 'N/A')}`
        );
        const requestNumber = escapeHtml(
            pickFirst(report?.requestNumber, report?._id, corrective.requestNumber, corrective.reportId, 'N/A')
        );
        const unsafeCount = corrective?.unsafeSummary?.totalUnsafeItems ?? getUnsafeItemCount(report);
        const updatedAt = formatDate(corrective.updatedAt || report?.updatedAt || report?.createdAt);
        const resolvedReportId = pickFirst(report?._id, report?.id, corrective.reportId, corrective.requestNumber, '');
        const reportId = escapeHtml(resolvedReportId);
        const hasPdf = Boolean(corrective.pdfDownloadUrl);
        const btnLabel = hasPdf ? 'View PDF' : 'Fetch PDF';
        const pdfUrl = hasPdf ? sanitizeUrl(corrective.pdfDownloadUrl) : '';
        const buttonDisabled = reportId ? '' : 'disabled';

        return `
            <tr>
                <td>${index}</td>
                <td>${correctiveNumber}</td>
                <td>${requestNumber}</td>
                <td>
                    <span class="status-pill ${statusInfo.className}">
                        <i class="fas fa-circle"></i> ${statusInfo.label}
                    </span>
                </td>
                <td>${unsafeCount}</td>
                <td>${updatedAt}</td>
                <td>
                    <button type="button" class="hse-btn light" data-action="corrective-view-pdf" data-id="${reportId}" data-pdf-url="${pdfUrl || ''}" ${buttonDisabled}>
                        <i class="fas fa-file-pdf"></i> ${btnLabel}
                    </button>
                </td>
            </tr>
        `;
    }

    function updateSummaryCards() {
        if (!dom.totalCount || !dom.completedCount || !dom.draftCount || !dom.attentionCount || !dom.totalMeta) {
            return;
        }
        const total = state.allReports.length;
        const completed = state.allReports.filter((report) => getCorrectiveStatus(getEmbeddedCorrective(report), report.status).key === 'completed').length;
        const drafts = state.allReports.filter((report) => {
            const status = getCorrectiveStatus(getEmbeddedCorrective(report), report.status).key;
            return status === 'draft' || status === 'in_progress';
        }).length;
        const attention = state.allReports.filter((report) => {
            const unsafe = getUnsafeItemCount(report);
            if (unsafe === 0) return false;
            const correctiveStatus = getCorrectiveStatus(getEmbeddedCorrective(report)).key;
            return correctiveStatus !== 'completed';
        }).length;

        dom.totalCount.textContent = total;
        dom.totalMeta.textContent = total ? `Last refresh ${new Date().toLocaleString()}` : 'Awaiting data...';
        dom.completedCount.textContent = completed;
        dom.draftCount.textContent = drafts;
        dom.attentionCount.textContent = attention;
    }

    function toggleTableLoader(isLoading) {
        dom.tableLoader.hidden = !isLoading;
    }

    function toggleCorrectiveLoader(isLoading) {
        if (!dom.correctiveLoader) return;
        dom.correctiveLoader.hidden = !isLoading;
    }

    function toggleError(show, message = '') {
        dom.errorState.hidden = !show;
        if (show) {
            dom.errorMessage.textContent = message || 'Something went wrong.';
        }
    }

    function toggleGlobalLoader(show, message = 'Processing...') {
        if (dom.globalLoader) {
            dom.globalLoader.hidden = !show;
        }
        if (dom.globalLoaderText) {
            dom.globalLoaderText.textContent = message;
        }
        if (document.body && document.body.classList) {
            document.body.classList.toggle('modal-open', show);
        }
    }

    function showToast(type, message) {
        if (!dom.toastContainer) return;
        const toast = document.createElement('div');
        toast.className = `hse-toast ${type}`;
        toast.innerHTML = `<i class="fas fa-info-circle" aria-hidden="true"></i><span>${message}</span>`;
        dom.toastContainer.appendChild(toast);
        setTimeout(() => {
            toast.classList.add('fade-out');
            toast.addEventListener('transitionend', () => toast.remove());
            toast.style.opacity = '0';
        }, 3500);
    }

    async function handleTableAction(event) {
        // Handle dropdown menu item clicks
        const button = event.target.closest('[data-action]');
        if (!button) return;
        
        // Don't process if button is disabled
        if (button.hasAttribute('disabled') || button.disabled) {
            event.preventDefault();
            event.stopPropagation();
            return;
        }
        
        event.preventDefault();
        event.stopPropagation();
        
        // Close dropdown before executing action
        closeAllDropdowns();
        
        const action = button.dataset.action;
        const reportId = button.dataset.id;

        if (!reportId) {
            showToast('error', 'Unable to determine report ID.');
            return;
        }

        try {
            switch (action) {
                case 'details':
                    await openDetailsModal(reportId);
                    break;
                case 'view-hse-pdf':
                    viewHsePdf(reportId);
                    break;
                case 'view-corrective-action':
                    await viewCorrectiveAction(reportId);
                    break;
                case 'view-corrective-pdf':
                    await viewCorrectivePdf(reportId, button.dataset.pdfUrl);
                    break;
                case 'delete':
                    await deleteReport(reportId);
                    break;
                default:
                    break;
            }
        } catch (error) {
            console.error('Error executing table action:', error);
            showToast('error', 'An error occurred while processing your request.');
        }
    }

    function handleCorrectiveTableAction(event) {
        const button = event.target.closest('[data-action]');
        if (!button) return;
        const reportId = button.dataset.id;
        const pdfUrl = button.dataset.pdfUrl;

        if (!reportId) {
            showToast('error', 'Unable to determine report ID for the corrective action.');
            return;
        }

        if (button.dataset.action === 'corrective-view-pdf') {
            viewCorrectivePdf(reportId, pdfUrl);
        }
    }

    function handleGlobalClicks(event) {
        // Check if clicking on a dropdown toggle button
        const toggle = event.target.closest('[data-dropdown-toggle]');
        if (toggle) {
            const menuId = toggle.getAttribute('data-dropdown-toggle');
            if (!menuId) return;
            
            const menu = document.getElementById(menuId);
            if (!menu || !toggle) {
                return;
            }
            
            // Additional null check before accessing classList
            if (!menu.classList || !toggle.classList) {
                console.warn('Dropdown elements not ready:', { menuId, menu, toggle });
                return;
            }
            
            const isOpen = menu.classList.contains('show');
            closeAllDropdowns();
            
            if (!isOpen) {
                menu.classList.add('show');
                toggle.classList.add('active');
                openDropdownMenu = menu;
                openDropdownToggle = toggle;
                
                // Ensure dropdown is visible and positioned correctly
                setTimeout(() => {
                    if (menu && menu.classList && menu.classList.contains('show')) {
                        // Check if dropdown is off-screen and adjust
                        const rect = menu.getBoundingClientRect();
                        const viewportWidth = window.innerWidth;
                        const viewportHeight = window.innerHeight;
                        
                        if (rect.right > viewportWidth) {
                            menu.style.right = '0';
                            menu.style.left = 'auto';
                        }
                        if (rect.bottom > viewportHeight) {
                            menu.style.top = 'auto';
                            menu.style.bottom = 'calc(100% + 8px)';
                        }
                    }
                }, 10);
            }
            
            event.preventDefault();
            event.stopPropagation();
            return;
        }
        
        // Check if clicking on a dropdown menu item - don't close immediately
        const dropdownItem = event.target.closest('.hse-dropdown-item');
        if (dropdownItem && dropdownItem.closest('.hse-dropdown-menu')) {
            // Let handleTableAction handle the click
            return;
        }

        // Close dropdown if clicking outside of any dropdown
        if (!event.target.closest('.hse-dropdown')) {
            closeAllDropdowns();
        }
    }

    function closeAllDropdowns() {
        if (openDropdownMenu) {
            try {
                if (openDropdownMenu.classList) {
                    openDropdownMenu.classList.remove('show');
                    openDropdownMenu.setAttribute('aria-hidden', 'true');
                }
            } catch (e) {
                console.warn('Error closing dropdown menu:', e);
            }
            openDropdownMenu = null;
        }
        if (openDropdownToggle) {
            try {
                if (openDropdownToggle.classList) {
                    openDropdownToggle.classList.remove('active');
                    openDropdownToggle.setAttribute('aria-expanded', 'false');
                }
            } catch (e) {
                console.warn('Error closing dropdown toggle:', e);
            }
            openDropdownToggle = null;
        }
        
        // Also close any other open dropdowns
        document.querySelectorAll('.hse-dropdown-menu.show').forEach(menu => {
            menu.classList.remove('show');
            menu.setAttribute('aria-hidden', 'true');
        });
        document.querySelectorAll('.hse-action-btn.active').forEach(btn => {
            btn.classList.remove('active');
            btn.setAttribute('aria-expanded', 'false');
        });
    }

    function switchTab(targetTab = 'reports', triggerButton = null) {
        if (!dom.tabButtons || !dom.tabButtons.length || !dom.tabPanels || !dom.tabPanels.length) return;
        state.activeTab = targetTab;
        let activeButton = triggerButton;

        dom.tabButtons.forEach((button) => {
            if (!button || !button.classList) return;
            const isActive = button.dataset.hseTab === targetTab;
            button.classList.toggle('active', isActive);
            button.setAttribute('aria-selected', String(isActive));
            if (isActive) {
                activeButton = button;
            }
        });

        dom.tabPanels.forEach((panel) => {
            if (!panel || !panel.classList) return;
            const shouldShow = activeButton ? panel.id === activeButton.dataset.hsePanel : panel.id === 'hseReportsPanel';
            panel.classList.toggle('active', shouldShow);
            panel.setAttribute('aria-hidden', String(!shouldShow));
        });
    }

    async function openDetailsModal(reportId) {
        const report = findReportById(reportId);
        if (!report) {
            showToast('error', 'Report not found.');
            return;
        }

        state.activeReportId = reportId;
        dom.detailsHsePdfBtn.disabled = !report.pdfDownloadUrl;
        dom.detailsCorrectivePdfBtn.disabled = false;

        const summary = deriveSafetySummary(report);
        const corrective = await ensureCorrectiveAction(reportId, { silent: true }) || getEmbeddedCorrective(report);
        dom.detailsContent.innerHTML = buildDetailsMarkup(report, summary, corrective);
        openModal(dom.detailsModal);
    }

    function buildDetailsMarkup(report, summary, corrective) {
        const attachments = Array.isArray(report.attachments) ? report.attachments : [];
        const notes = report.step2?.notes || report.step3?.notes || report.notes;
        const equipment = report.step1?.selectedEquipment || {};
        const correctiveStatus = getCorrectiveStatus(corrective, report.status);

        const attachmentsHtml = attachments.length
            ? attachments
                  .map((file, index) => {
                      const href = sanitizeUrl(file.fileUrl || file.downloadUrl || file.url);
                      if (!href) return `<li><span>${escapeHtml(file.fileName || `Attachment ${index + 1}`)}</span></li>`;
                      return `<li><a href="${href}" target="_blank" rel="noopener">${escapeHtml(file.fileName || `Attachment ${index + 1}`)}</a></li>`;
                  })
                  .join('')
            : '<li>No attachments uploaded.</li>';

        return `
            <div class="details-section">
                <h4>General Information</h4>
                <div class="details-grid">
                    ${detailsCard('Request Number', pickFirst(report.requestNumber, report._id, 'N/A'))}
                    ${detailsCard('Document ID', pickFirst(report.step1?.selectedChecklist?.document_id, 'N/A'))}
                    ${detailsCard('Country', pickFirst(report.step1?.country, '—'))}
                    ${detailsCard('Project', pickFirst(report.step1?.project, '—'))}
                    ${detailsCard('Equipment', pickFirst(equipment.equipmentName, equipment.equipmentNumber, '—'))}
                    ${detailsCard('Status', formatStatus(report.status))}
                    ${detailsCard('Created At', formatDate(report.createdAt), true)}
                    ${detailsCard('Updated At', formatDate(report.updatedAt), true)}
                </div>
            </div>

            <div class="details-section">
                <h4>Safety Summary</h4>
                <div class="safety-summary">
                    ${safetyChip('safe', 'Safe', summary.safe)}
                    ${safetyChip('unsafe', 'Unsafe', summary.unsafe)}
                    ${safetyChip('na', 'N/A', summary.na)}
                </div>
                <div class="details-badges" style="margin-top:12px;">
                    <span class="details-badge">Total items: ${summary.total}</span>
                    <span class="details-badge">Safe %: ${summary.percentSafe}%</span>
                </div>
            </div>

            <div class="details-section">
                <h4>Corrective Action</h4>
                <div class="details-badges" style="margin-bottom:12px;">
                    <span class="details-badge ${correctiveStatus.className}">${correctiveStatus.label}</span>
                    <span class="details-badge">Unsafe items: ${getUnsafeItemCount(report)}</span>
                </div>
                <p style="color: var(--hse-muted); font-size: 14px;">
                    ${corrective ? escapeHtml(corrective.notes || 'Latest corrective action available.') : 'No corrective action has been submitted for this report.'}
                </p>
            </div>

            <div class="details-section">
                <h4>Attachments</h4>
                <ul class="attachments-list">
                    ${attachmentsHtml}
                </ul>
            </div>

            ${
                notes
                    ? `<div class="details-section">
                        <h4>Inspector Notes</h4>
                        <p style="white-space: pre-wrap; color: var(--hse-text);">${escapeHtml(notes)}</p>
                    </div>`
                    : ''
            }
        `;
    }

    function detailsCard(label, value, allowEmpty = false) {
        const safeValue = allowEmpty ? value : value || '—';
        return `
            <div class="details-card">
                <span class="details-label">${escapeHtml(label)}</span>
                <span class="details-value">${escapeHtml(safeValue)}</span>
            </div>
        `;
    }

    function safetyChip(type, label, value) {
        return `
            <div class="safety-chip ${type}">
                <span>${label}</span>
                <strong>${value}</strong>
            </div>
        `;
    }

    function openModal(modal) {
        if (!modal || !modal.classList) return;
        modal.classList.add('active');
        modal.setAttribute('aria-hidden', 'false');
        if (document.body && document.body.classList) {
            document.body.classList.add('modal-open');
        }
    }

    function closeModal(modal) {
        if (!modal || !modal.classList) return;
        modal.classList.remove('active');
        modal.setAttribute('aria-hidden', 'true');
        if (modal === dom.pdfModal && dom.pdfIframe) {
            dom.pdfIframe.src = '';
        }
        if (document.body && document.body.classList) {
            if (!document.querySelector('.hse-modal.active')) {
                document.body.classList.remove('modal-open');
            }
        }
    }

    function viewHsePdf(reportId) {
        const report = findReportById(reportId);
        if (!report || !report.pdfDownloadUrl) {
            showToast('info', 'PDF not available for this report.');
            return;
        }
        openPdfModal(report.pdfDownloadUrl, `HSE Report • ${pickFirst(report.requestNumber, report._id)}`);
    }

    async function viewCorrectiveAction(reportId) {
        if (!dom.correctiveModal || !dom.correctiveContent) {
            showToast('error', 'Corrective action modal not available.');
            return;
        }

        // First, try to find the report to get its REQUEST #
        const report = findReportById(reportId);
        const reportRequestNumber = pickFirst(report?.requestNumber, report?._id, reportId);
        
        // Try to find corrective action by REQUEST # first (using improved matching)
        let corrective = findCorrectiveByRequestNumber(reportRequestNumber);
        
        // If not found by REQUEST #, try by reportId
        if (!corrective) {
            corrective = await ensureCorrectiveAction(reportId, { silent: true });
        }
        
        // If still not found, try embedded corrective
        if (!corrective && report) {
            corrective = getEmbeddedCorrective(report);
        }
        
        if (!corrective) {
            showToast('info', 'Corrective action not found for this report.');
            return;
        }

        dom.correctiveContent.innerHTML = buildCorrectiveDetailsMarkup(reportId, corrective);
        const titleEl = dom.correctiveModal.querySelector('#hseCorrectiveTitle');
        if (titleEl) {
            titleEl.textContent = `Corrective Action • ${pickFirst(corrective.correctiveActionNumber, reportRequestNumber, reportId)}`;
        }
        openModal(dom.correctiveModal);
    }

    async function viewCorrectivePdf(reportId, directUrl = '') {
        // Try to find the report to get its REQUEST #
        const report = findReportById(reportId);
        const reportRequestNumber = pickFirst(report?.requestNumber, report?._id, reportId);
        
        // If direct URL is provided, use it
        if (directUrl && directUrl.trim()) {
            openPdfModal(directUrl, `Corrective Action • ${reportRequestNumber || reportId}`);
            return;
        }

        // First try to find corrective action by REQUEST # (improved matching)
        // This is the key: match by REQUEST # format like "ZMB - KAL - HSE - 036"
        let corrective = findCorrectiveByRequestNumber(reportRequestNumber);
        
        // If found by REQUEST # and has PDF, use it
        if (corrective && corrective.pdfDownloadUrl) {
            openPdfModal(corrective.pdfDownloadUrl, `Corrective Action • ${reportRequestNumber || reportId}`);
            return;
        }
        
        // If not found by REQUEST #, try by reportId
        if (!corrective) {
            corrective = await ensureCorrectiveAction(reportId, { force: true });
        }
        
        // If still not found, try embedded corrective from the report
        if (!corrective && report) {
            corrective = getEmbeddedCorrective(report);
        }
        
        // Also try searching in corrective records by REQUEST # one more time
        if (!corrective && reportRequestNumber) {
            for (const entry of state.correctiveRecords) {
                const entryRequestNumber = pickFirst(
                    entry.corrective?.requestNumber,
                    entry.report?.requestNumber,
                    entry.corrective?.reportId,
                    entry.report?._id
                );
                if (normalizeRequestNumber(entryRequestNumber) === normalizeRequestNumber(reportRequestNumber)) {
                    corrective = entry.corrective;
                    if (corrective && corrective.pdfDownloadUrl) {
                        break;
                    }
                }
            }
        }
        
        if (corrective && corrective.pdfDownloadUrl) {
            openPdfModal(corrective.pdfDownloadUrl, `Corrective Action • ${reportRequestNumber || reportId}`);
            return;
        }
        
        showToast('info', 'Corrective action PDF not available for this report.');
    }

    function openPdfModal(url, title) {
        const proxyUrl = buildPdfProxyUrl(url);
        if (!proxyUrl) {
            showToast('error', 'Invalid PDF URL.');
            return;
        }
        dom.pdfIframe.src = proxyUrl;
        dom.pdfDownload.href = proxyUrl;
        dom.pdfTitle.textContent = title || 'PDF Preview';
        openModal(dom.pdfModal);
    }

    function buildPdfProxyUrl(originalUrl) {
        if (!originalUrl) return null;
        const safeUrl = originalUrl.trim();

        if (!safeUrl) {
            return null;
        }

        if (safeUrl.startsWith('/api/inspections/view-pdf')) {
            return safeUrl;
        }

        return `/api/inspections/view-pdf?path=${encodeURIComponent(safeUrl)}`;
    }

    function formatFileNameFragment(value, fallback = 'document') {
        if (!value) return fallback;
        const cleaned = String(value).trim().replace(/[^a-zA-Z0-9_-]+/g, '_');
        return cleaned || fallback;
    }

    async function ensureCorrectiveAction(reportId, options = {}) {
        const { silent = false, force = false } = options;
        if (!reportId) {
            return null;
        }

        if (!force && state.correctiveCache.has(reportId)) {
            return state.correctiveCache.get(reportId) ?? null;
        }

        try {
            const url = getCorrectiveActionUrl(reportId);
            console.log('📋 Fetching HSE corrective action for reportId:', reportId, 'URL:', url);
            
            const response = await fetch(url, {
                headers: { 'Accept': 'application/json' }
            });
            
            if (!response.ok) {
                // 404 is expected if no corrective action exists yet
                if (response.status === 404) {
                    console.log('ℹ️ No corrective action found for reportId:', reportId);
                    state.correctiveCache.set(reportId, null);
                    return null;
                }
                throw new Error(`Corrective action API responded with ${response.status}`);
            }
            
            const payload = await response.json();
            if (!payload.success || !payload.data) {
                console.log('ℹ️ Corrective action not found for reportId:', reportId);
                state.correctiveCache.set(reportId, null);
                return null;
            }
            
            console.log('✅ Found corrective action for reportId:', reportId, 'Status:', payload.data.status);
            cacheCorrective(payload.data);
            
            // Update the report with corrective action data
            const targetReport = findReportById(reportId);
            if (targetReport) {
                targetReport.correctiveAction = payload.data;
                targetReport.correctiveActionData = payload.data;
                if (state.correctiveSource === 'api') {
                    loadCorrectiveRecords();
                } else {
                    refreshCorrectiveRecords();
                }
            }
            
            return payload.data;
        } catch (error) {
            console.warn('❌ Corrective action fetch failed for reportId:', reportId, error);
            if (!force) {
                state.correctiveCache.set(reportId, null);
            }
            if (!silent) {
                showToast('info', 'Corrective action data not found.');
            }
            return null;
        }
    }

    function buildCorrectiveDetailsMarkup(reportId, corrective) {
        const statusInfo = getCorrectiveStatus(corrective);
        const unsafeItems = corrective?.unsafeSummary?.unsafeItems || [];
        const unsafeList = Array.isArray(unsafeItems) && unsafeItems.length
            ? unsafeItems
                  .map((item, index) => `<li><strong>${index + 1}.</strong> ${escapeHtml(item?.title || item?.name || 'Unsafe item')} <span style="color:var(--hse-muted);">${escapeHtml(item?.status || '')}</span></li>`)
                  .join('')
            : '<li>No unsafe items listed.</li>';
        const pdfLink = corrective?.pdfDownloadUrl
            ? `<a href="${sanitizeUrl(corrective.pdfDownloadUrl)}" class="hse-btn primary" target="_blank" rel="noopener">
                    <i class="fas fa-file-pdf"></i> Download Corrective PDF
               </a>`
            : '<span style="color:var(--hse-muted);">PDF not uploaded yet.</span>';

        return `
            <div class="details-section">
                <div class="details-grid">
                    ${detailsCard('Request Number', pickFirst(corrective.requestNumber, reportId, 'N/A'))}
                    ${detailsCard('Corrective Number', pickFirst(corrective.correctiveActionNumber, 'N/A'))}
                    ${detailsCard('Status', statusInfo.label)}
                    ${detailsCard('Last Updated', formatDate(corrective.updatedAt), true)}
                </div>
            </div>
            <div class="details-section">
                <h4>Unsafe Summary</h4>
                <div class="details-badges" style="margin-bottom:10px;">
                    <span class="details-badge">Unsafe Items: ${corrective?.unsafeSummary?.totalUnsafeItems ?? corrective?.faultyCount ?? 0}</span>
                    <span class="details-badge">Role: ${escapeHtml(corrective.role || '—')}</span>
                </div>
                <ul style="padding-left:18px; margin:0;">
                    ${unsafeList}
                </ul>
            </div>
            <div class="details-section">
                <h4>Notes</h4>
                <p style="white-space: pre-wrap; color: var(--hse-text);">${escapeHtml(corrective.notes || 'No notes added.')}</p>
            </div>
            <div class="details-section">
                <h4>PDF</h4>
                ${pdfLink}
            </div>
        `;
    }

    async function hydrateCorrectiveData(reports = []) {
        if (!Array.isArray(reports) || reports.length === 0) {
            return;
        }

        const candidates = reports
            .map((report) => {
                const reportId = report?._id || report?.id || report?.requestNumber || null;
                return {
                    report,
                    reportId,
                    skip: !reportId || state.correctiveCache.has(reportId),
                };
            })
            .filter((item) => !item.skip);

        if (!candidates.length) {
            console.log('ℹ️ All reports already have corrective action data');
            return;
        }
        
        console.log(`📋 Fetching corrective actions for ${candidates.length} HSE reports...`);
        let updated = 0;
        
        // Fetch corrective actions in parallel (with limit to avoid overwhelming the server)
        const batchSize = 10;
        for (let i = 0; i < candidates.length; i += batchSize) {
            const batch = candidates.slice(i, i + batchSize);
            const promises = batch.map(async ({ report, reportId }) => {
                if (!reportId) return;

                const corrective = await ensureCorrectiveAction(reportId, { silent: true });
                if (corrective !== null) {
                    report.correctiveAction = corrective;
                    report.correctiveActionData = corrective;
                    updated++;
                } else {
                    // Ensure UI reflects lack of corrective action
                    report.correctiveAction = null;
                    report.correctiveActionData = null;
                }
            });
            
            await Promise.all(promises);
        }
        
        if (updated > 0) {
            console.log(`✅ Linked ${updated} corrective actions to HSE reports`);
            applyFilters(true);
            updateSummaryCards();
            renderTable(); // Re-render to show updated statuses
            if (state.correctiveSource === 'api') {
                loadCorrectiveRecords();
            } else {
                refreshCorrectiveRecords();
            }
        }
    }

    async function deleteReport(reportId) {
        const report = findReportById(reportId);
        if (!report) {
            showToast('error', 'Report not found.');
            return;
        }

        const confirmed = window.confirm(`Delete report ${report.requestNumber || reportId}? This cannot be undone.`);
        if (!confirmed) return;

        toggleGlobalLoader(true, 'Deleting HSE report...');

        try {
            const response = await fetch(`${ROUTES.delete}/${encodeURIComponent(report.userId)}/${encodeURIComponent(reportId)}`, {
                method: 'DELETE',
                headers: {
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': CSRF_TOKEN
                }
            });

            if (!response.ok) {
                throw new Error(`Delete API responded with ${response.status}`);
            }

            const payload = await response.json();
            if (!payload.success) {
                throw new Error(payload.error || 'Failed to delete report');
            }

            state.allReports = state.allReports.filter((item) => (item._id || item.id) !== reportId);
            applyFilters(true);
            updateSummaryCards();
            if (state.correctiveSource === 'api') {
                loadCorrectiveRecords();
            } else {
                refreshCorrectiveRecords();
            }
            showToast('success', 'Report deleted successfully.');
        } catch (error) {
            console.error('Delete failed:', error);
            showToast('error', error.message || 'Unable to delete report.');
        } finally {
            toggleGlobalLoader(false);
        }
    }

    function deriveSafetySummary(report) {
        const summary = { safe: 0, unsafe: 0, na: 0, total: 0, percentSafe: 0 };
        const step3 = report.step3 || {};

        const hasStep3Totals =
            typeof step3.totalSafe === 'number' ||
            typeof step3.totalUnsafe === 'number' ||
            typeof step3.totalNA === 'number';

        if (hasStep3Totals) {
            summary.safe = coerceNumber(step3.totalSafe);
            summary.unsafe = coerceNumber(step3.totalUnsafe);
            summary.na = coerceNumber(step3.totalNA);
        }

        if (!hasStep3Totals || summary.safe + summary.unsafe + summary.na === 0) {
            const sections = Array.isArray(report.step2?.sections) ? report.step2.sections : [];
            const selections = report.step2?.selections || {};
            const countInputs = report.step2?.countInputs || {};

            sections.forEach((section) => {
                (section?.subItems || []).forEach((item) => {
                    if (!item?.key) return;
                    const key = item.key;
                    const inputType = normalizeValue(item.inputType);
                    const selection = normalizeValue(selections[key]);
                    const counts = countInputs[key] || {};

                    if (inputType.includes('safe/unsafe')) {
                        summary.safe += coerceNumber(counts.safe);
                        summary.unsafe += coerceNumber(counts.unsafe);
                        if (normalizeValue(counts.notApplicable) === 'true') {
                            summary.na += 1;
                        }
                        return;
                    }

                    if (!selection) return;
                    if (SAFE_VALUES.has(selection)) summary.safe += 1;
                    else if (UNSAFE_VALUES.has(selection)) summary.unsafe += 1;
                    else if (NA_VALUES.has(selection)) summary.na += 1;
                });
            });
        }

        summary.total = summary.safe + summary.unsafe + summary.na;
        summary.percentSafe = summary.total > 0 ? Math.round((summary.safe / summary.total) * 100) : 0;

        return summary;
    }

    function getUnsafeItemCount(report) {
        if (!report) return 0;
        const sections = Array.isArray(report.step2?.sections) ? report.step2.sections : [];
        const selections = report.step2?.selections || {};
        const countInputs = report.step2?.countInputs || {};
        const counted = new Set();

        sections.forEach((section) => {
            (section?.subItems || []).forEach((item) => {
                if (!item?.key || counted.has(item.key)) return;
                const selection = normalizeValue(selections[item.key]);
                const unsafeCount = coerceNumber(countInputs[item.key]?.unsafe);
                if (unsafeCount > 0 || UNSAFE_VALUES.has(selection)) {
                    counted.add(item.key);
                }
            });
        });

        return counted.size;
    }

    function getCorrectiveStatus(correctiveAction, fallbackStatus = 'draft') {
        // If no corrective action exists, show "Not Submitted" or "Pending"
        if (!correctiveAction) {
            return mapStatusDescriptor('none', true);
        }

        // Check backend status field first (matches HSEcorectiveaction.js logic)
        const backendStatus = correctiveAction.status;
        if (backendStatus === 'completed') {
            return mapStatusDescriptor('completed');
        }

        // If PDF exists, consider it completed
        if (correctiveAction.pdfDownloadUrl) {
            return mapStatusDescriptor('completed');
        }

        // Check subItemStatuses to determine if in progress
        const statuses = Object.values(correctiveAction.subItemStatuses || {});
        if (statuses.length > 0) {
            // Check if all items are fixed/no need (completed)
            const isComplete = statuses.every((status) => {
                const normalized = normalizeValue(status);
                return normalized === 'fixed' || normalized === 'no need' || normalized === 'no_need';
            });
            
            if (isComplete) {
                return { key: 'completed', label: 'Completed', className: 'completed' };
            }
            
            // If some items have statuses but not all are complete, it's in progress
            return mapStatusDescriptor('in_progress');
        }

        // If status is 'draft' or has any data but no statuses yet, it's in progress
        if (backendStatus === 'draft' || correctiveAction.unsafeSummary || correctiveAction.faultyCount > 0) {
            return mapStatusDescriptor('in_progress');
        }

        // Default fallback
        return mapStatusDescriptor(backendStatus || fallbackStatus || 'draft');
    }

    function mapStatusDescriptor(status = 'draft', allowEmpty = false) {
        const normalized = normalizeValue(status);
        switch (normalized) {
            case 'completed':
                return { key: 'completed', label: 'Completed', className: 'completed' };
            case 'in_progress':
            case 'progress':
            case 'active':
                return { key: 'in_progress', label: 'In Progress', className: 'draft' };
            case 'pending':
            case 'none':
                return { key: 'pending', label: 'Pending', className: 'pending' };
            case 'draft':
                return { key: 'draft', label: 'Draft', className: 'draft' };
            default:
                return allowEmpty
                    ? { key: 'none', label: 'Not Submitted', className: 'pending' }
                    : { key: 'draft', label: 'Draft', className: 'draft' };
        }
    }

    function getStatusClass(status) {
        return mapStatusDescriptor(status).className;
    }

    function formatStatus(status) {
        return mapStatusDescriptor(status).label;
    }

    function formatDate(value) {
        if (!value) return '—';
        const date = new Date(value);
        if (isNaN(date)) return '—';
        return date.toLocaleString('en-GB', {
            day: '2-digit',
            month: '2-digit',
            year: 'numeric',
            hour: '2-digit',
            minute: '2-digit'
        });
    }

    function pickFirst(...values) {
        for (const value of values) {
            if (value === null || value === undefined) continue;
            const text = typeof value === 'string' || typeof value === 'number' ? String(value).trim() : '';
            if (text) return text;
        }
        return '';
    }

    function escapeHtml(value) {
        const text = value === undefined || value === null ? '' : String(value);
        return text
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#039;');
    }

    function sanitizeUrl(url) {
        if (!url || typeof url !== 'string') return null;
        if (url.startsWith('http://') || url.startsWith('https://') || url.startsWith('/')) {
            return url;
        }
        return null;
    }

    function normalizeKey(value) {
        if (value === null || value === undefined) return '';
        if (typeof value === 'string' || typeof value === 'number') {
            return String(value).trim();
        }
        return '';
    }

    function normalizeValue(value) {
        if (value === null || value === undefined) return '';
        return String(value).trim().toLowerCase();
    }

    function coerceNumber(value) {
        const num = Number(value);
        return Number.isFinite(num) ? num : 0;
    }

    function findReportById(reportId) {
        return state.allReports.find((report) => (report._id || report.id) === reportId);
    }

    function findReportByRequestNumber(requestNumber) {
        if (!requestNumber) return null;
        const normalizedRequest = normalizeRequestNumber(requestNumber);
        if (!normalizedRequest) return null;
        
        return state.allReports.find((report) => {
            const reportRequestNumber = pickFirst(report.requestNumber, report._id, report.id);
            return normalizeRequestNumber(reportRequestNumber) === normalizedRequest;
        });
    }

    function getEmbeddedCorrective(report = {}) {
        return (
            report.correctiveAction ||
            report.correctiveActionData ||
            report.correctiveActionInfo ||
            report.meta?.correctiveAction ||
            null
        );
    }

    function cacheCorrective(corrective) {
        if (!corrective) return;
        const keys = [
            corrective._id,
            corrective.id,
            corrective.reportId,
            corrective.requestNumber,
            corrective.correctiveActionNumber
        ];
        keys.forEach((key) => {
            const normalized = normalizeKey(key);
            if (normalized) {
                state.correctiveCache.set(normalized, corrective);
            }
        });
    }
})();
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/inspection/HSEmodule/HSEreportsALLc.blade.php ENDPATH**/ ?>