<?php $__env->startSection('title', 'HR Admin Dashboard'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
/* CSS Variables for consistent theming */
:root {
    --primary-color: #0055a5;
    --primary-hover: #003f7d;
    --secondary-color: #6c757d;
    --success-color: #28a745;
    --warning-color: #ffc107;
    --danger-color: #dc3545;
    --info-color: #17a2b8;
    --text-primary: #212529;
    --text-secondary: #6c757d;
    --bg-primary: #ffffff;
    --bg-secondary: #f8f9fa;
    --bg-light: #f8fafc;
    --border-color: #dee2e6;
    --border-light: #e2e8f0;
    --shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --shadow-md: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    --radius-sm: 0.25rem;
    --radius-md: 0.375rem;
    --radius-lg: 0.5rem;
    --transition-base: all 0.15s ease-in-out;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}

/* Reset and base styles */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: var(--font-family);
    background-color: var(--bg-light);
    color: var(--text-primary);
}

/* Main Container */
.hr-dashboard-container {
    min-height: 100vh;
    background: var(--bg-light);
}

/* Header Styles */
.header-gradient {
    background: #0055a5;
    padding: 20px 0;
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.3);
}

.header-content {
    width: 100%;
    padding: 0 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 15px;
}

.back-button {
    color: white;
    font-size: 20px;
    text-decoration: none;
    padding: 8px;
    border-radius: 50%;
    transition: var(--transition-base);
}

.back-button:hover {
    background-color: rgba(255, 255, 255, 0.1);
    color: white;
}

.header-title {
    color: white;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
}

.header-subtitle {
    color: rgba(255, 255, 255, 0.9);
    font-size: 16px;
    font-weight: 400;
    margin: 0;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.apply-new-btn {
    background: white;
    color: var(--primary-color);
    border: none;
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-sm);
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 8px;
}

.apply-new-btn:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
    color: var(--primary-color);
    text-decoration: none;
}

.refresh-btn {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.3);
    padding: 12px 20px;
    border-radius: var(--radius-md);
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-sm);
    display: flex;
    align-items: center;
    gap: 8px;
    margin-right: 15px;
}

.refresh-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.refresh-btn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.refresh-btn i {
    transition: transform 0.3s ease;
}

.refresh-btn.loading i {
    animation: spin 1s linear infinite;
}

/* Filter Alert Section */
.filter-alert {
    background: #e3f2fd;
    border: 1px solid #bbdefb;
 
    margin: 0;
    padding: 16px 20px;
    box-shadow: var(--shadow-sm);
}

.alert-content {
    display: flex;
    align-items: center;
    gap: 12px;
    max-width: 1200px;
   
}

.alert-content i {
    color: var(--primary-color);
    flex-shrink: 0;
    font-size: 16px;
}

.alert-content span {
    color: var(--text-primary);
    font-size: 14px;
    font-weight: 500;
    line-height: 1.4;
}

/* Main Content */
.main-content {
    width: 100%;
    padding: 30px 20px;
}

/* Dashboard Grid */
.dashboard-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 24px;
    max-width: 1200px;
    margin: 0 auto;
}

/* Dashboard Cards */
.dashboard-card {
    background: white;
    border-radius: var(--radius-lg);
    padding: 24px;
    box-shadow: var(--shadow-md);
    border: 1px solid var(--border-light);
    transition: var(--transition-base);
    cursor: pointer;
    position: relative;
    overflow: hidden;
    text-decoration: none;
    color: inherit;
    display: block;
}

.dashboard-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
    text-decoration: none;
    color: inherit;
}



.card-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 64px;
    height: 64px;
    background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
    border-radius: var(--radius-lg);
    margin-bottom: 16px;
    color: var(--primary-color);
    font-size: 24px;
}

.card-content h3 {
    font-size: 18px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 12px 0;
}

.card-stats {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.total-count {
    font-size: 28px;
    font-weight: 700;
    color: var(--primary-color);
    line-height: 1;
}

.status-badges {
    display: flex;
    gap: 6px;
    flex-wrap: wrap;
    align-items: center;
}

.pending-count {
    font-size: 10px;
    font-weight: 600;
    color: #92400e;
    background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    padding: 5px 10px;
    border-radius: 20px;
    display: inline-flex;
    align-items: center;
    gap: 4px;
    transition: all 0.2s ease;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    white-space: nowrap;
    border: 1.5px solid #fbbf24;
    box-shadow: 0 2px 4px rgba(251, 191, 36, 0.2);
}

.pending-count:before {
    content: '⏱️';
    font-size: 11px;
}

.approved-count {
    font-size: 10px;
    font-weight: 600;
    color: #065f46;
    background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
    padding: 5px 10px;
    border-radius: 20px;
    display: inline-flex;
    align-items: center;
    gap: 4px;
    transition: all 0.2s ease;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    white-space: nowrap;
    border: 1.5px solid #34d399;
    box-shadow: 0 2px 4px rgba(52, 211, 153, 0.2);
}

.approved-count:before {
    content: '✅';
    font-size: 11px;
}

.rejected-count {
    font-size: 10px;
    font-weight: 600;
    color: #991b1b;
    background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
    padding: 5px 10px;
    border-radius: 20px;
    display: inline-flex;
    align-items: center;
    gap: 4px;
    transition: all 0.2s ease;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    white-space: nowrap;
    border: 1.5px solid #f87171;
    box-shadow: 0 2px 4px rgba(248, 113, 113, 0.2);
}

.rejected-count:before {
    content: '❌';
    font-size: 11px;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .main-content {
        padding: 20px;
    }
    
    .dashboard-grid {
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
        max-width: 1000px;
    }
}

@media (max-width: 992px) {
    .header-gradient {
        padding: 20px 0;
    }
    
    .header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 20px;
    }
    
    .header-right {
        align-self: flex-end;
    }
    
    .header-title {
        font-size: 24px;
    }
    
    .header-subtitle {
        font-size: 14px;
    }
    
    .dashboard-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 20px;
        max-width: 800px;
    }
    
    .dashboard-card {
        padding: 20px;
    }
}

@media (max-width: 768px) {
    .header-gradient {
        padding: 16px 0;
    }
    
    .header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }
    
    .header-right {
        align-self: stretch;
    }
    
    .apply-new-btn {
        justify-content: center;
        width: 100%;
    }
    
    .header-title {
        font-size: 20px;
    }
    
    .header-subtitle {
        font-size: 13px;
    }
    
    .filter-alert {
        padding: 12px 16px;
    }
    
    .alert-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 8px;
    }
    
    .alert-content span {
        font-size: 13px;
    }
    
    .main-content {
        padding: 16px;
    }
    
    .dashboard-grid {
        grid-template-columns: 1fr;
        gap: 20px;
        max-width: 400px;
    }
    
    .dashboard-card {
        padding: 16px;
    }
    
    .card-icon {
        width: 56px;
        height: 56px;
        font-size: 20px;
    }
    
    .card-content h3 {
        font-size: 16px;
    }
    
    .total-count {
        font-size: 24px;
    }
    
    .pending-count,
    .approved-count,
    .rejected-count {
        font-size: 9px;
        padding: 4px 8px;
    }
    
    .status-badges {
        gap: 5px;
    }
}

@media (max-width: 576px) {
    .header-gradient {
        padding: 12px 0;
    }
    
    .header-title {
        font-size: 18px;
    }
    
    .header-subtitle {
        font-size: 12px;
    }
    
    .filter-alert {
        padding: 10px 12px;
    }
    
    .alert-content span {
        font-size: 12px;
    }
    
    .main-content {
        padding: 12px;
    }
    
    .dashboard-card {
        padding: 12px;
    }
    
    .card-icon {
        width: 48px;
        height: 48px;
        font-size: 18px;
    }
    
    .card-content h3 {
        font-size: 15px;
    }
    
    .total-count {
        font-size: 20px;
    }
    
    .pending-count,
    .approved-count,
    .rejected-count {
        font-size: 8px;
        padding: 4px 7px;
        gap: 3px;
    }
    
    .pending-count:before,
    .approved-count:before,
    .rejected-count:before {
        font-size: 9px;
    }
    
    .status-badges {
        gap: 4px;
    }
}

/* Hover Effects */
.dashboard-card:active {
    transform: translateY(-2px);
}

/* Focus States */
.dashboard-card:focus {
    outline: 2px solid rgba(0, 85, 165, 0.5);
    outline-offset: 2px;
}

/* Smooth Animations */
* {
    transition: all 0.2s ease;
}

/* Loading States */
.dashboard-card.loading {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.dashboard-card.loading:hover {
    transform: none;
    box-shadow: var(--shadow-md);
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="hr-dashboard-container">
    <!-- Header -->
    <div class="header-gradient">
        <div class="header-content">
            <div class="header-left">
                <a href="#" class="back-button">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <div>
                    <h1 class="header-title">HR Admin Dashboard</h1>
                    <p class="header-subtitle">Manage and track HR applications efficiently</p>
                </div>
            </div>
            <div class="header-right">
                <button id="refreshBtn" class="refresh-btn" onclick="refreshCounts()">
                    <i class="fas fa-sync-alt"></i>
                    Refresh
                </button>
                <a href="<?php echo e(route('hr.create.application')); ?>" class="apply-new-btn">
                    <i class="fas fa-plus"></i>
                    Apply New
                </a>
            </div>
        </div>
    </div>

    <!-- Filter Alert Section -->
    <div class="filter-alert">
        <div class="alert-content">
            <i class="fas fa-filter"></i>
            <span>Filtered by: Zambia, DRC | IME, Musompo, Kobold, Kalumbila, Kansanshi, Kimiteto, Mimosa</span>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="dashboard-grid">
            <!-- Leave Applications Card -->
            <a href="<?php echo e(route('hr.leave.applications')); ?>" class="dashboard-card" id="leave-card">
                <div class="card-icon">
                    <i class="fas fa-calendar-alt"></i>
                </div>
                <div class="card-content">
                    <h3>Leave Applications</h3>
                    <div class="card-stats">
                        <span class="total-count">Loading...</span>
                        <div class="status-badges">
                            <span class="pending-count" style="display: none;">0 Pending</span>
                            <span class="approved-count" style="display: none;">0 Approved</span>
                            <span class="rejected-count" style="display: none;">0 Rejected</span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Appeal Applications Card -->
            <a href="<?php echo e(route('hr.appeal.applications')); ?>" class="dashboard-card" id="appeal-card">
                <div class="card-icon">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="card-content">
                    <h3>Appeal Applications</h3>
                    <div class="card-stats">
                        <span class="total-count">Loading...</span>
                        <div class="status-badges">
                            <span class="pending-count" style="display: none;">0 Pending</span>
                            <span class="approved-count" style="display: none;">0 Approved</span>
                            <span class="rejected-count" style="display: none;">0 Rejected</span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Funeral Applications Card -->
            <a href="<?php echo e(route('hr.funeral.applications')); ?>" class="dashboard-card" id="funeral-card">
                <div class="card-icon">
                    <i class="fas fa-heart"></i>
                </div>
                <div class="card-content">
                    <h3>Funeral Applications</h3>
                    <div class="card-stats">
                        <span class="total-count">Loading...</span>
                        <div class="status-badges">
                            <span class="pending-count" style="display: none;">0 Pending</span>
                            <span class="approved-count" style="display: none;">0 Approved</span>
                            <span class="rejected-count" style="display: none;">0 Rejected</span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Grievance Applications Card -->
            <a href="<?php echo e(route('hr.grievance.applications')); ?>" class="dashboard-card" id="grievance-card">
                <div class="card-icon">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="card-content">
                    <h3>Grievance Applications</h3>
                    <div class="card-stats">
                        <span class="total-count">Loading...</span>
                        <div class="status-badges">
                            <span class="pending-count" style="display: none;">0 Pending</span>
                            <span class="approved-count" style="display: none;">0 Approved</span>
                            <span class="rejected-count" style="display: none;">0 Rejected</span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Hospital Attendance Card -->
            <a href="<?php echo e(route('hr.hospital.attendance')); ?>" class="dashboard-card" id="hospital-card">
                <div class="card-icon">
                    <i class="fas fa-hospital"></i>
                </div>
                <div class="card-content">
                    <h3>Hospital Attendance</h3>
                    <div class="card-stats">
                        <span class="total-count">Loading...</span>
                        <div class="status-badges">
                            <span class="pending-count" style="display: none;">0 Pending</span>
                            <span class="approved-count" style="display: none;">0 Approved</span>
                            <span class="rejected-count" style="display: none;">0 Rejected</span>
                        </div>
                    </div>
                </div>
            </a>

            <!-- Salary Advance Card -->
            <a href="<?php echo e(route('hr.salary.advance')); ?>" class="dashboard-card" id="salary-card">
                <div class="card-icon">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <div class="card-content">
                    <h3>Salary Advance</h3>
                    <div class="card-stats">
                        <span class="total-count">Loading...</span>
                        <div class="status-badges">
                            <span class="pending-count" style="display: none;">0 Pending</span>
                            <span class="approved-count" style="display: none;">0 Approved</span>
                            <span class="rejected-count" style="display: none;">0 Rejected</span>
                        </div>
                    </div>
                </div>
            </a>

        </div>
    </div>
</div>

<script>
// LocalStorage keys for each application type
const STORAGE_KEYS = {
    leave: 'leaveApplicationsCount',
    appeal: 'appealApplicationsCount',
    grievance: 'grievanceApplicationsCount',
    hospital: 'hospitalAttendanceCount',
    salary: 'salaryAdvanceCount',
    funeral: 'funeralApplicationsCount'
};

// HR MongoDB API configuration (ensure HTTPS endpoints in production)
const HR_API_BASE_URL = <?php echo json_encode(rtrim(env('MONGODB_HR_API_BASE_URL', 'https://api.titandrillingzm.com:6013'), '/')) ?>;
const HR_ADMIN_UID_RAW = <?php echo json_encode(config('services.hr_module.admin_uid'), 15, 512) ?>;
const HR_ADMIN_UID = encodeURIComponent(HR_ADMIN_UID_RAW);
const HR_API_QUERY = ''; // Reserved for future filter query strings

const HR_APPLICATION_PATHS = {
    leave: 'leave_application',
    appeal: 'application_for_appeal',
    grievance: 'grievance_record',
    hospital: 'hospital_attendance_form',
    salary: 'salary_advance_application',
    funeral: 'funeral_grant_form'
};

const MONGODB_API_URLS = {};
const FALLBACK_RELATIVE_API_URLS = {};

Object.entries(HR_APPLICATION_PATHS).forEach(([type, path]) => {
    const querySuffix = HR_API_QUERY ? `?${HR_API_QUERY}` : '';
    MONGODB_API_URLS[type] = `${HR_API_BASE_URL}/hr-applications/${path}/${HR_ADMIN_UID}${querySuffix}`;
    FALLBACK_RELATIVE_API_URLS[type] = `/api/hr-applications/${path}${querySuffix}`;
});

const isRelativeEndpoint = (url) => {
    if (!url) return false;
    return url.startsWith('/') || url.startsWith(window.location.origin);
};

async function fetchApplicationsFromMongo(type) {
    const endpoints = [
        MONGODB_API_URLS[type],
        FALLBACK_RELATIVE_API_URLS[type]
    ].filter(Boolean);

    let lastError = null;

    for (const endpoint of endpoints) {
        try {
            const relative = isRelativeEndpoint(endpoint);
            const response = await fetch(endpoint, { 
                credentials: relative ? 'include' : 'omit',
                headers: { 'Accept': 'application/json' },
                mode: relative ? 'same-origin' : 'cors'
            });
            if (!response.ok) {
                console.warn(`${type}: ${endpoint} responded with status ${response.status}`);
                lastError = new Error(`HTTP error ${response.status}`);
                continue;
            }

            const data = await response.json();
            console.log(`${type}: Successfully fetched data from ${endpoint}`);
            return { data, endpoint };
        } catch (error) {
            console.error(`${type}: Error fetching from ${endpoint}`, error);
            lastError = error;
        }
    }

    throw lastError || new Error('No valid endpoint available');
}

// Application counts
let applicationCounts = {
    leave: { total: 0, pending: 0, approved: 0, rejected: 0 },
    appeal: { total: 0, pending: 0, approved: 0, rejected: 0 },
    grievance: { total: 0, pending: 0, approved: 0, rejected: 0 },
    hospital: { total: 0, pending: 0, approved: 0, rejected: 0 },
    salary: { total: 0, pending: 0, approved: 0, rejected: 0 },
    funeral: { total: 0, pending: 0, approved: 0, rejected: 0 }
};

// Load counts from localStorage first, then fetch if needed
async function loadAllApplicationCounts() {
    const promises = Object.keys(STORAGE_KEYS).map(async (type) => {
        try {
            // Try to load from localStorage first
            const storageKey = STORAGE_KEYS[type];
            const storedData = localStorage.getItem(storageKey);
            
            if (storedData) {
                try {
                    const counts = JSON.parse(storedData);
                    if (counts && typeof counts === 'object' && counts.total !== undefined) {
                        console.log(`${type}: Loaded from localStorage`, counts);
                        applicationCounts[type] = { 
                            total: counts.total || 0, 
                            pending: counts.pending || 0,
                            approved: counts.approved || 0,
                            rejected: counts.rejected || 0
                        };
                        updateCardCount(type, counts);
                        return; // Skip MongoDB fetch if localStorage has data
                    }
                } catch (e) {
                    console.warn(`Error parsing localStorage for ${type}:`, e);
                }
            }
            
            // If no localStorage data, fetch from MongoDB
            console.log(`${type}: No localStorage data, fetching from MongoDB...`);
            const { data: apiPayload, endpoint } = await fetchApplicationsFromMongo(type);

            const applications = Array.isArray(apiPayload?.data)
                ? apiPayload.data
                : Array.isArray(apiPayload)
                    ? apiPayload
                    : Array.isArray(apiPayload?.applications)
                        ? apiPayload.applications
                        : [];

            if (applications) {
                const total = applications.length;
                const pending = applications.filter(app => {
                    if (!app || typeof app !== 'object') return false;
                    const status = (app.status || '').toLowerCase();
                    return !status || status === 'pending';
                }).length;
                
                const approved = applications.filter(app => {
                    if (!app || typeof app !== 'object') return false;
                    const status = (app.status || '').toLowerCase();
                    return status === 'approved';
                }).length;
                
                const rejected = applications.filter(app => {
                    if (!app || typeof app !== 'object') return false;
                    const status = (app.status || '').toLowerCase();
                    return status === 'rejected';
                }).length;
                
                applicationCounts[type] = { total, pending, approved, rejected };
                updateCardCount(type, { total, pending, approved, rejected });
                console.log(`${type}: ${total} total, ${pending} pending, ${approved} approved, ${rejected} rejected (source: ${endpoint})`);
            } else {
                applicationCounts[type] = { total: 0, pending: 0, approved: 0, rejected: 0 };
                updateCardCount(type, { total: 0, pending: 0, approved: 0, rejected: 0 });
                console.warn(`${type}: No data returned from API`);
            }
        } catch (error) {
            console.error(`Error loading ${type} applications:`, error);
            applicationCounts[type] = { total: 0, pending: 0, approved: 0, rejected: 0 };
            updateCardCount(type, { total: 0, pending: 0, approved: 0, rejected: 0 });
        }
    });
    
    await Promise.all(promises);
    console.log('All application counts loaded:', applicationCounts);
}

// Listen for postMessage updates from child windows
window.addEventListener('message', function(event) {
    if (event.data && event.data.type && event.data.counts) {
        const typeMap = {
            'leaveApplicationsUpdate': 'leave',
            'appealApplicationsUpdate': 'appeal',
            'grievanceApplicationsUpdate': 'grievance',
            'hospitalAttendanceUpdate': 'hospital',
            'salaryAdvanceUpdate': 'salary',
            'funeralApplicationsUpdate': 'funeral'
        };
        
        const type = typeMap[event.data.type];
        if (type && event.data.counts) {
            console.log(`Received update from ${type} page:`, event.data.counts);
            applicationCounts[type] = {
                total: event.data.counts.total || 0,
                pending: event.data.counts.pending || 0,
                approved: event.data.counts.approved || 0,
                rejected: event.data.counts.rejected || 0
            };
            updateCardCount(type, event.data.counts);
        }
    }
});

// Update individual card count
function updateCardCount(type, counts) {
    const cardSelectors = {
        leave: '#leave-card',
        appeal: '#appeal-card',
        grievance: '#grievance-card',
        hospital: '#hospital-card',
        salary: '#salary-card',
        funeral: '#funeral-card'
    };
    
    const card = document.querySelector(cardSelectors[type]);
    if (card) {
        const totalCountElement = card.querySelector('.total-count');
        const pendingCountElement = card.querySelector('.pending-count');
        const approvedCountElement = card.querySelector('.approved-count');
        const rejectedCountElement = card.querySelector('.rejected-count');
        
        if (totalCountElement) {
            totalCountElement.textContent = `${counts.total || 0} Total`;
        }
        
        if (pendingCountElement) {
            if (counts.pending > 0) {
                pendingCountElement.textContent = `${counts.pending} Pending`;
                pendingCountElement.style.display = 'inline-block';
            } else {
                pendingCountElement.style.display = 'none';
            }
        }
        
        if (approvedCountElement) {
            if (counts.approved > 0) {
                approvedCountElement.textContent = `${counts.approved} Approved`;
                approvedCountElement.style.display = 'inline-block';
            } else {
                approvedCountElement.style.display = 'none';
            }
        }
        
        if (rejectedCountElement) {
            if (counts.rejected > 0) {
                rejectedCountElement.textContent = `${counts.rejected} Rejected`;
                rejectedCountElement.style.display = 'inline-block';
            } else {
                rejectedCountElement.style.display = 'none';
            }
        }
    }
}

// Initialize dashboard
document.addEventListener('DOMContentLoaded', function() {
    console.log('HR Admin Dashboard loaded successfully');
    loadAllApplicationCounts();
});

// Refresh counts function
async function refreshCounts() {
    const refreshBtn = document.getElementById('refreshBtn');
    refreshBtn.disabled = true;
    refreshBtn.classList.add('loading');
    
    try {
        await loadAllApplicationCounts();
        showNotification('Application counts refreshed successfully!', 'success');
    } catch (error) {
        console.error('Error refreshing counts:', error);
        showNotification('Failed to refresh counts. Please try again.', 'error');
    } finally {
        refreshBtn.disabled = false;
        refreshBtn.classList.remove('loading');
    }
}

// Notification system
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `hr-notification hr-notification-${type}`;
    notification.textContent = message;
    
    notification.style.cssText = `
        position: fixed;
        top: 80px;
        right: 20px;
        padding: 12px 20px;
        border-radius: 8px;
        color: white;
        font-weight: 500;
        font-size: 14px;
        z-index: 10001;
        opacity: 0;
        transform: translateX(100%);
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        font-family: 'Inter', sans-serif;
    `;
    
    if (type === 'success') {
        notification.style.background = 'linear-gradient(135deg, #10b981 0%, #059669 100%)';
    } else if (type === 'error') {
        notification.style.background = 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)';
    } else if (type === 'warning') {
        notification.style.background = 'linear-gradient(135deg, #f59e0b 0%, #d97706 100%)';
    } else {
        notification.style.background = 'linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%)';
    }
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.style.opacity = '1';
        notification.style.transform = 'translateX(0)';
    }, 100);
    
    setTimeout(() => {
        notification.style.opacity = '0';
        notification.style.transform = 'translateX(100%)';
        setTimeout(() => {
            if (notification.parentNode) {
                document.body.removeChild(notification);
            }
        }, 300);
    }, 3000);
}
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/hr/hr-admin-dashboard.blade.php ENDPATH**/ ?>