<?php $__env->startSection('title', 'Equipment Map View'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    :root {
        --td-primary: #0055a5;
        --td-accent: #ffd205;
        --td-surface: #f7f9fc;
        --td-text: #1e293b;
        --td-muted: #64748b;
        --td-border: #e2e8f0;
    }

    body {
        background: #f1f5f9;
    }

    .map-page {
        padding: 32px;
        font-family: 'Jost', 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
    }

    .map-header {
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        justify-content: space-between;
        gap: 16px;
        margin-bottom: 24px;
    }

    .map-header h1 {
        margin: 0;
        font-size: 32px;
        font-weight: 600;
        color: var(--td-text);
    }

    .map-actions {
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
    }

    .td-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 12px 20px;
        font-size: 14px;
        font-weight: 500;
        border-radius: 6px;
        border: none;
        cursor: pointer;
        text-decoration: none;
        transition: all 0.2s ease;
        box-shadow: 0 1px 3px rgba(15, 23, 42, 0.12);
    }

    .td-btn--primary {
        background: var(--td-primary);
        color: #fff;
    }

    .td-btn--secondary {
        background: var(--td-accent);
        color: #000;
    }

    .td-btn:disabled {
        opacity: 0.6;
        cursor: not-allowed;
    }

    .map-meta {
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
        margin-bottom: 24px;
    }

    .meta-card {
        min-width: 150px;
        padding: 16px 20px;
        border: 1px solid var(--td-border);
        background: #fff;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(15, 23, 42, 0.06);
        display: flex;
        flex-direction: column;
        gap: 4px;
    }

    .meta-card span {
        font-size: 13px;
        font-weight: 500;
        color: var(--td-muted);
    }

    .meta-card strong {
        font-size: 24px;
        font-weight: 600;
        color: var(--td-text);
    }

    .map-layout {
        display: grid;
        grid-template-columns: minmax(0, 1fr) 320px;
        gap: 24px;
        align-items: stretch;
    }

    .map-canvas {
        position: relative;
        min-height: 520px;
        border-radius: 12px;
        overflow: hidden;
        border: 1px solid var(--td-border);
        box-shadow: 0 10px 30px rgba(15, 23, 42, 0.08);
    }

    #equipment-map {
        width: 100%;
        height: 100%;
        min-height: 520px;
    }

    .map-sidebar {
        background: #fff;
        border: 1px solid var(--td-border);
        border-radius: 12px;
        padding: 24px;
        display: flex;
        flex-direction: column;
        gap: 20px;
        box-shadow: 0 10px 30px rgba(15, 23, 42, 0.06);
    }

    .sidebar-section h2 {
        font-size: 18px;
        margin: 0 0 12px;
        font-weight: 600;
        color: var(--td-text);
    }

    .legend-list {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .legend-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 10px 12px;
        border-radius: 8px;
        border: 1px solid transparent;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .legend-item.is-active {
        border-color: var(--td-primary);
        background-color: rgba(0, 85, 165, 0.08);
    }

    .legend-swatch {
        width: 14px;
        height: 14px;
        border-radius: 4px;
        flex-shrink: 0;
    }

    .legend-text {
        display: flex;
        flex-direction: column;
        gap: 2px;
    }

    .legend-text strong {
        font-size: 14px;
        color: var(--td-text);
    }

    .legend-text span {
        font-size: 12px;
        color: var(--td-muted);
    }

    .equipment-list {
        max-height: 280px;
        overflow-y: auto;
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .equipment-chip {
        padding: 10px 12px;
        border-radius: 8px;
        border: 1px solid var(--td-border);
        background: var(--td-surface);
    }

    .equipment-chip strong {
        display: block;
        font-size: 14px;
        color: var(--td-text);
        margin-bottom: 2px;
    }

    .equipment-chip span {
        display: block;
        font-size: 12px;
        color: var(--td-muted);
    }

    .map-notice {
        position: absolute;
        top: 16px;
        right: 16px;
        background: rgba(15, 23, 42, 0.85);
        color: #fff;
        padding: 12px 16px;
        border-radius: 8px;
        font-size: 13px;
        display: none;
        max-width: 260px;
    }

    .map-notice.is-visible {
        display: block;
    }

    .empty-state {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        padding: 60px 20px;
        border: 1px dashed var(--td-border);
        border-radius: 12px;
        background: #fff;
        color: var(--td-muted);
    }

    .empty-state strong {
        font-size: 20px;
        margin-bottom: 12px;
        color: var(--td-text);
    }

    .loading-overlay {
        position: absolute;
        inset: 0;
        background: rgba(255, 255, 255, 0.8);
        backdrop-filter: blur(2px);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 12px;
        font-size: 14px;
        font-weight: 500;
        color: var(--td-primary);
        z-index: 10;
    }

    .loading-overlay::after {
        content: "";
        width: 16px;
        height: 16px;
        border: 2px solid rgba(0, 85, 165, 0.2);
        border-top-color: var(--td-primary);
        border-radius: 50%;
        animation: spin 0.9s linear infinite;
    }

    @keyframes spin {
        to {
            transform: rotate(360deg);
        }
    }

    @media (max-width: 1024px) {
        .map-layout {
            grid-template-columns: 1fr;
        }

        .map-sidebar {
            order: -1;
        }
    }

    @media (max-width: 640px) {
        .map-page {
            padding: 20px 16px;
        }

        .map-header h1 {
            font-size: 26px;
        }

        .td-btn {
            width: 100%;
        }

        .map-meta {
            flex-direction: column;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="map-page">
    <div class="map-header">
        <h1>Equipment Map Overview</h1>
        <div class="map-actions">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="td-btn td-btn--secondary">Back to Dashboard</a>
            <button type="button" id="refreshMap" class="td-btn td-btn--primary">Refresh Map</button>
        </div>
    </div>

    <div class="map-meta">
        <div class="meta-card">
            <span>Total Equipments</span>
            <strong id="totalEquipmentCount">0</strong>
        </div>
        <div class="meta-card">
            <span>Visible on Map</span>
            <strong id="visibleEquipmentCount">0</strong>
        </div>
        <div class="meta-card">
            <span>Last Synced</span>
            <strong id="lastSyncedLabel">--</strong>
        </div>
    </div>

    <div class="map-layout">
        <div class="map-canvas">
            <div id="equipment-map"></div>
            <div class="loading-overlay" id="mapLoading" hidden>Loading equipment...</div>
            <div class="map-notice" id="mapNotice"></div>
        </div>
        <aside class="map-sidebar">
            <section class="sidebar-section">
                <h2>Status Filter</h2>
                <div class="legend-list" id="statusLegend"></div>
            </section>
            <section class="sidebar-section">
                <h2>Visible Equipments</h2>
                <div class="equipment-list" id="equipmentList"></div>
            </section>
        </aside>
    </div>

    <div class="empty-state" id="mapEmptyState" hidden>
        <strong>No equipment locations to display</strong>
        <span>Once equipment records include verified coordinates they will appear here with the latest status.</span>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php if($googleMapsKey): ?>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e($googleMapsKey); ?>&libraries=geometry"></script>
<?php endif; ?>
<script>
(() => {
    const MAP_ENDPOINT = <?php echo json_encode(route('api.equipment.locations'), 15, 512) ?>;
    const MAP_HAS_KEY = <?php echo json_encode(!empty($googleMapsKey), 15, 512) ?>;
    const DEFAULT_POSITION = { lat: -13.133897, lng: 27.849332 };
    const STATUS_COLORS = {
        'Available': '#00B894',
        'Maintenance Required': '#FFD205',
        'Breakdown': '#E74C3C',
        'In Maintenance': '#E67E22',
        'Deploy': '#0055A5',
        'Idle': '#545d6b',
        'Unknown': '#9ca3af'
    };

    const state = {
        map: null,
        markers: [],
        equipment: [],
        activeStatuses: new Set(),
        infoWindow: null
    };

    const elements = {
        mapContainer: document.getElementById('equipment-map'),
        loading: document.getElementById('mapLoading'),
        notice: document.getElementById('mapNotice'),
        emptyState: document.getElementById('mapEmptyState'),
        legend: document.getElementById('statusLegend'),
        equipmentList: document.getElementById('equipmentList'),
        totalCount: document.getElementById('totalEquipmentCount'),
        visibleCount: document.getElementById('visibleEquipmentCount'),
        lastSyncedLabel: document.getElementById('lastSyncedLabel'),
        refreshBtn: document.getElementById('refreshMap')
    };

    if (!elements.mapContainer) {
        return;
    }

    if (!MAP_HAS_KEY || typeof google === 'undefined' || !google.maps) {
        elements.mapContainer.innerHTML = '';
        elements.mapContainer.style.minHeight = '220px';
        elements.mapContainer.style.display = 'flex';
        elements.mapContainer.style.alignItems = 'center';
        elements.mapContainer.style.justifyContent = 'center';
        elements.mapContainer.style.background = '#fff8e1';
        elements.mapContainer.style.border = '1px solid var(--td-border)';
        elements.mapContainer.innerHTML = '<div style="text-align:center;color:#b45309;font-weight:500;">Google Maps could not be loaded. Please verify the API key.</div>';
        elements.loading?.setAttribute('hidden', 'hidden');
        return;
    }

    function initMap() {
        state.map = new google.maps.Map(elements.mapContainer, {
            center: DEFAULT_POSITION,
            zoom: 6,
            mapTypeControl: false,
            streetViewControl: false,
            fullscreenControl: true,
            styles: [
                { elementType: 'geometry', stylers: [{ color: '#f5f5f5' }] },
                { elementType: 'labels.icon', stylers: [{ visibility: 'off' }] },
                { elementType: 'labels.text.fill', stylers: [{ color: '#1f2937' }] },
                { featureType: 'administrative', elementType: 'geometry.stroke', stylers: [{ color: '#cbd5f5' }] },
                { featureType: 'poi.park', elementType: 'geometry', stylers: [{ color: '#d2f4e4' }] },
                { featureType: 'road', elementType: 'geometry', stylers: [{ color: '#ffffff' }] },
                { featureType: 'road', elementType: 'labels.text.fill', stylers: [{ color: '#6b7280' }] },
                { featureType: 'water', elementType: 'geometry', stylers: [{ color: '#c7d2fe' }] }
            ]
        });

        state.infoWindow = new google.maps.InfoWindow();
        fetchEquipment();
        bindEvents();
    }

    function bindEvents() {
        if (elements.refreshBtn) {
            elements.refreshBtn.addEventListener('click', () => {
                fetchEquipment(true);
            });
        }
    }

    function toggleLoading(isLoading) {
        if (!elements.loading) return;
        if (isLoading) {
            elements.loading.removeAttribute('hidden');
        } else {
            elements.loading.setAttribute('hidden', 'hidden');
        }
    }

    function showNotice(message, tone = 'info') {
        if (!elements.notice) return;
        elements.notice.textContent = message;
        elements.notice.classList.add('is-visible');
        elements.notice.style.background = tone === 'error' ? 'rgba(220, 38, 38, 0.85)' : 'rgba(15, 23, 42, 0.85)';
        setTimeout(() => elements.notice.classList.remove('is-visible'), 3200);
    }

    async function fetchEquipment(force = false) {
        try {
            toggleLoading(true);
            showEmptyState(false);
            const response = await fetch(MAP_ENDPOINT + (force ? ('?t=' + Date.now()) : ''));
            const payload = await response.json();

            if (!payload.success) {
                throw new Error(payload.message || 'Failed to load equipment');
            }

            state.equipment = Array.isArray(payload.data) ? payload.data : [];
            elements.totalCount.textContent = state.equipment.length;
            elements.lastSyncedLabel.textContent = new Date().toLocaleString();
            buildLegend();
            renderMarkers();
        } catch (error) {
            console.error('Equipment map error:', error);
            showNotice('Unable to load equipment locations right now.', 'error');
            state.equipment = [];
            renderMarkers();
        } finally {
            toggleLoading(false);
        }
    }

    function buildLegend() {
        if (!elements.legend) return;

        const statuses = new Map();
        state.equipment.forEach(item => {
            const status = item.status || 'Unknown';
            statuses.set(status, (statuses.get(status) || 0) + 1);
        });

        if (statuses.size === 0) {
            elements.legend.innerHTML = '<div style="font-size:12px;color:var(--td-muted);">No status data available.</div>';
            return;
        }

        if (state.activeStatuses.size === 0) {
            statuses.forEach((_count, status) => state.activeStatuses.add(status));
        }

        elements.legend.innerHTML = '';

        statuses.forEach((count, status) => {
            const legend = document.createElement('button');
            legend.type = 'button';
            legend.className = 'legend-item' + (state.activeStatuses.has(status) ? ' is-active' : '');
            legend.dataset.status = status;

            const swatch = document.createElement('span');
            swatch.className = 'legend-swatch';
            swatch.style.background = STATUS_COLORS[status] || STATUS_COLORS.Unknown;

            const text = document.createElement('div');
            text.className = 'legend-text';
            text.innerHTML = `<strong>${status}</strong><span>${count} equipment</span>`;

            legend.appendChild(swatch);
            legend.appendChild(text);

            legend.addEventListener('click', () => {
                if (state.activeStatuses.has(status) && state.activeStatuses.size === 1) {
                    return;
                }

                if (state.activeStatuses.has(status)) {
                    state.activeStatuses.delete(status);
                    legend.classList.remove('is-active');
                } else {
                    state.activeStatuses.add(status);
                    legend.classList.add('is-active');
                }

                renderMarkers();
            });

            elements.legend.appendChild(legend);
        });
    }

    function renderMarkers() {
        if (!state.map) return;

        state.markers.forEach(marker => marker.setMap(null));
        state.markers = [];

        const visibleEquipment = state.equipment.filter(item => state.activeStatuses.has(item.status || 'Unknown'));

        if (visibleEquipment.length === 0) {
            showEmptyState(true);
            elements.visibleCount.textContent = '0';
            updateEquipmentList([]);
            return;
        }

        showEmptyState(false);
        elements.visibleCount.textContent = visibleEquipment.length;
        updateEquipmentList(visibleEquipment);

        const bounds = new google.maps.LatLngBounds();

        visibleEquipment.forEach(item => {
            const position = {
                lat: parseFloat(item.latitude),
                lng: parseFloat(item.longitude)
            };

            if (!isFinite(position.lat) || !isFinite(position.lng)) {
                return;
            }

            const marker = new google.maps.Marker({
                position,
                map: state.map,
                title: item.name,
                icon: {
                    path: google.maps.SymbolPath.CIRCLE,
                    fillColor: STATUS_COLORS[item.status] || STATUS_COLORS.Unknown,
                    fillOpacity: 0.9,
                    strokeColor: '#ffffff',
                    strokeWeight: 2,
                    scale: 10
                }
            });

            marker.addListener('click', () => {
                const infoContent = `
                    <div style="min-width:220px">
                        <h3 style="margin:0 0 4px;font-size:16px;color:#1f2937;">${item.name}</h3>
                        <p style="margin:0 0 4px;font-size:13px;color:#4b5563;">Status: <strong style="color:${STATUS_COLORS[item.status] || STATUS_COLORS.Unknown}">${item.status || 'Unknown'}</strong></p>
                        <p style="margin:0 0 4px;font-size:13px;color:#4b5563;">Country: <strong>${item.country || 'N/A'}</strong></p>
                        ${item.category ? `<p style="margin:0 0 4px;font-size:13px;color:#4b5563;">Category: <strong>${item.category}</strong></p>` : ''}
                        ${item.address ? `<p style="margin:0;font-size:12px;color:#64748b;">${item.address}</p>` : ''}
                        ${item.lastUpdated ? `<p style="margin:4px 0 0;font-size:11px;color:#94a3b8;">Updated: ${formatDate(item.lastUpdated)}</p>` : ''}
                    </div>`;

                state.infoWindow.setContent(infoContent);
                state.infoWindow.open({ map: state.map, anchor: marker });
            });

            state.markers.push(marker);
            bounds.extend(position);
        });

        if (!bounds.isEmpty()) {
            state.map.fitBounds(bounds, 30);
        } else {
            state.map.setCenter(DEFAULT_POSITION);
            state.map.setZoom(6);
        }
    }

    function updateEquipmentList(equipment) {
        if (!elements.equipmentList) return;

        if (!equipment.length) {
            elements.equipmentList.innerHTML = '<div style="font-size:12px;color:var(--td-muted);">No equipment matches the current filters.</div>';
            return;
        }

        const fragment = document.createDocumentFragment();

        equipment.slice(0, 40).forEach(item => {
            const chip = document.createElement('div');
            chip.className = 'equipment-chip';
            chip.innerHTML = `
                <strong>${item.name}</strong>
                <span>Status: ${item.status || 'Unknown'}</span>
                <span>Country: ${item.country || 'N/A'}</span>
            `;
            fragment.appendChild(chip);
        });

        elements.equipmentList.innerHTML = '';
        elements.equipmentList.appendChild(fragment);
    }

    function showEmptyState(show) {
        if (!elements.emptyState) return;
        elements.emptyState.hidden = !show;
    }

    function formatDate(value) {
        if (!value) return '--';
        const date = new Date(value);
        if (Number.isNaN(date.getTime())) {
            return value;
        }
        return date.toLocaleString();
    }

    window.addEventListener('load', initMap, { once: true });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/dashboard/MapViewIns.blade.php ENDPATH**/ ?>