

<?php $__env->startSection('title', 'Page Not Found'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5" role="main" aria-label="404 Error Page">
    <div class="row justify-content-center">
        <div class="col-md-6 text-center">
            <h1 class="display-1 text-muted" aria-label="Error 404">404</h1>
            <h2 class="mb-4">Page Not Found</h2>
            <p class="lead mb-4" role="status" aria-live="polite">
                The page you are looking for could not be found.
            </p>
            <a href="<?php echo e(route('dashboard')); ?>" 
               class="btn btn-primary" 
               role="button"
               aria-label="Go to Dashboard"
               title="Return to the main dashboard">
                <i class="fas fa-home me-2" aria-hidden="true"></i>Go to Dashboard
            </a>
        </div>
    </div>
</div>

<style>
/* CSS Variables for better maintainability */
:root {
    --primary-color: #0d6efd;
    --primary-hover: #0b5ed7;
    --text-primary: #212529;
    --text-secondary: #495057;
    --text-muted: #6c757d;
    --text-light: #adb5bd;
    --bg-primary: #ffffff;
    --bg-secondary: #f8f9fa;
    --border-color: #dee2e6;
    --shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --shadow-md: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    --shadow-lg: 0 1rem 3rem rgba(0, 0, 0, 0.175);
    --radius-sm: 6px;
    --radius-md: 8px;
    --radius-lg: 12px;
    --transition-base: all 0.3s ease;
    --transition-slow: all 0.5s ease;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    --z-index-modal: 1055;
    --z-index-notification: 9999;
}

/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* Base styles */
.container {
    font-family: var(--font-family);
}

.display-1 {
    color: var(--text-muted);
    font-weight: 700;
    transition: var(--transition-base);
}

h2 {
    color: var(--text-secondary);
    font-weight: 600;
    transition: var(--transition-base);
}

.lead {
    color: var(--text-muted);
    font-weight: 400;
    transition: var(--transition-base);
}

.btn {
    font-family: var(--font-family);
    transition: var(--transition-base);
}

.btn:focus {
    outline: 2px solid var(--primary-color);
    outline-offset: 2px;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

/* ===== ENHANCED RESPONSIVE DESIGN ===== */
@media (max-width: 1400px) {
    .container {
        padding: 20px;
    }
    
    .display-1 {
        font-size: 5.5rem;
    }
    
    h2 {
        font-size: 1.75rem;
    }
    
    .lead {
        font-size: 1.1rem;
    }
}

@media (max-width: 1200px) {
    .container {
        padding: 18px;
    }
    
    .display-1 {
        font-size: 5rem;
    }
    
    h2 {
        font-size: 1.6rem;
    }
    
    .lead {
        font-size: 1.05rem;
    }
}

@media (max-width: 992px) {
    .container {
        padding: 16px;
    }
    
    .row {
        margin: 0;
    }
    
    .col-md-6 {
        padding: 0 15px;
    }
    
    .display-1 {
        font-size: 4.5rem;
        margin-bottom: 1rem;
    }
    
    h2 {
        font-size: 1.5rem;
        margin-bottom: 1.5rem;
    }
    
    .lead {
        font-size: 1rem;
        margin-bottom: 2rem;
        line-height: 1.6;
    }
    
    .btn {
        padding: 12px 20px;
        font-size: 15px;
        min-height: 48px;
        border-radius: var(--radius-sm);
    }
}

@media (max-width: 768px) {
    .container {
        padding: 12px;
        margin-top: 2rem !important;
    }
    
    .col-md-6 {
        padding: 0 10px;
    }
    
    .display-1 {
        font-size: 3.5rem;
        margin-bottom: 0.8rem;
        color: var(--text-muted);
    }
    
    h2 {
        font-size: 1.3rem;
        margin-bottom: 1.2rem;
        color: var(--text-secondary);
    }
    
    .lead {
        font-size: 0.95rem;
        margin-bottom: 1.8rem;
        line-height: 1.5;
        color: var(--text-muted);
    }
    
    .btn {
        padding: 14px 24px;
        font-size: 16px;
        min-height: 52px;
        border-radius: var(--radius-md);
        font-weight: 600;
        width: 100%;
        max-width: 280px;
    }
    
    .btn i {
        margin-right: 8px;
    }
}

@media (max-width: 576px) {
    .container {
        padding: 8px;
        margin-top: 1.5rem !important;
    }
    
    .col-md-6 {
        padding: 0 8px;
    }
    
    .display-1 {
        font-size: 3rem;
        margin-bottom: 0.6rem;
        color: var(--text-muted);
    }
    
    h2 {
        font-size: 1.2rem;
        margin-bottom: 1rem;
        color: var(--text-secondary);
    }
    
    .lead {
        font-size: 0.9rem;
        margin-bottom: 1.5rem;
        line-height: 1.4;
        color: var(--text-muted);
        padding: 0 10px;
    }
    
    .btn {
        padding: 16px 20px;
        font-size: 15px;
        min-height: 56px;
        border-radius: var(--radius-md);
        font-weight: 600;
        width: 100%;
        max-width: 260px;
    }
    
    .btn i {
        margin-right: 6px;
    }
}

@media (max-width: 480px) {
    .container {
        padding: 6px;
        margin-top: 1rem !important;
    }
    
    .col-md-6 {
        padding: 0 6px;
    }
    
    .display-1 {
        font-size: 2.5rem;
        margin-bottom: 0.5rem;
        color: var(--text-muted);
    }
    
    h2 {
        font-size: 1.1rem;
        margin-bottom: 0.8rem;
        color: var(--text-secondary);
    }
    
    .lead {
        font-size: 0.85rem;
        margin-bottom: 1.2rem;
        line-height: 1.3;
        color: var(--text-muted);
        padding: 0 8px;
    }
    
    .btn {
        padding: 18px 16px;
        font-size: 14px;
        min-height: 60px;
        border-radius: var(--radius-md);
        font-weight: 700;
        width: 100%;
        max-width: 240px;
    }
    
    .btn i {
        margin-right: 5px;
    }
}

@media (max-width: 360px) {
    .container {
        padding: 4px;
        margin-top: 0.5rem !important;
    }
    
    .col-md-6 {
        padding: 0 4px;
    }
    
    .display-1 {
        font-size: 2rem;
        margin-bottom: 0.4rem;
        color: var(--text-muted);
    }
    
    h2 {
        font-size: 1rem;
        margin-bottom: 0.6rem;
        color: var(--text-secondary);
    }
    
    .lead {
        font-size: 0.8rem;
        margin-bottom: 1rem;
        line-height: 1.2;
        color: var(--text-muted);
        padding: 0 6px;
    }
    
    .btn {
        padding: 20px 12px;
        font-size: 13px;
        min-height: 64px;
        border-radius: var(--radius-md);
        font-weight: 700;
        width: 100%;
        max-width: 220px;
    }
    
    .btn i {
        margin-right: 4px;
    }
}

/* Additional mobile enhancements */
@media (max-width: 768px) {
    .text-center {
        text-align: center !important;
    }
    
    .justify-content-center {
        justify-content: center !important;
    }
    
    .mt-5 {
        margin-top: 2rem !important;
    }
}

/* ===== ACCESSIBILITY ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
}

/* ===== PRINT STYLES ===== */
@media print {
    .btn {
        display: none;
    }
    
    .display-1 {
        color: #000 !important;
    }
    
    h2 {
        color: #000 !important;
    }
    
    .lead {
        color: #000 !important;
    }
}
</style>

<script>
// Optimized 404 Error Page Functionality
(function() {
    'use strict';
    
    // Configuration object
    const CONFIG = {
        selectors: {
            container: '.container',
            display1: '.display-1',
            heading: 'h2',
            lead: '.lead',
            button: '.btn'
        },
        messages: {
            error: '404 Error',
            notFound: 'Page Not Found',
            description: 'The page you are looking for could not be found.'
        },
        timing: {
            animationDelay: 300,
            fadeInDelay: 100
        }
    };
    
    // Cache DOM elements
    let elements = {};
    
    function initElements() {
        elements = {
            container: document.querySelector(CONFIG.selectors.container),
            display1: document.querySelector(CONFIG.selectors.display1),
            heading: document.querySelector(CONFIG.selectors.heading),
            lead: document.querySelector(CONFIG.selectors.lead),
            button: document.querySelector(CONFIG.selectors.button)
        };
    }
    
    // Add fade-in animation
    function addFadeInAnimation() {
        if (!elements.container) return;
        
        elements.container.style.opacity = '0';
        elements.container.style.transform = 'translateY(20px)';
        elements.container.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        
        setTimeout(() => {
            elements.container.style.opacity = '1';
            elements.container.style.transform = 'translateY(0)';
        }, CONFIG.timing.fadeInDelay);
    }
    
    // Add click tracking for analytics
    function addClickTracking() {
        if (!elements.button) return;
        
        elements.button.addEventListener('click', function() {
            // Track 404 page button click
            if (typeof gtag !== 'undefined') {
                gtag('event', 'click', {
                    'event_category': '404',
                    'event_label': 'Go to Dashboard',
                    'value': 1
                });
            }
        });
    }
    
    // Add keyboard navigation
    function addKeyboardNavigation() {
        if (!elements.button) return;
        
        elements.button.addEventListener('keydown', function(e) {
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                this.click();
            }
        });
    }
    
    // Add error reporting functionality
    function addErrorReporting() {
        // Log 404 error for debugging
        console.warn('404 Error: Page not found -', window.location.href);
        
        // Send error report if analytics is available
        if (typeof gtag !== 'undefined') {
            gtag('event', 'exception', {
                'description': '404 Page Not Found',
                'fatal': false
            });
        }
    }
    
    // Initialize all functionality
    function init() {
        initElements();
        addFadeInAnimation();
        addClickTracking();
        addKeyboardNavigation();
        addErrorReporting();
    }
    
    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/errors/404.blade.php ENDPATH**/ ?>